C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine taupsemb(utxfine,utxfine2,ntfine,
     1                    usemb,utaupq,unum,udenom,
     2                    unumsum,udenomsum,
     3                    ltsemb,nt,jpdelay,
     4                    iypointer,locate,live,
     5                    npqlive,npoint,jx,nx,mx,jy,ny,my,  
     6                    anorm,nlive,lerr,cputim,waltim,
     7                    istart,iend,eps2)
c___________________________________________________________________
c     calculate semblance usemb(tau,theta,phi) from utxfine(t,x,y)
c
c     semblance(m,n)={[sum(u(m+j,n)]**2}/{nlive*sum[u(m+j,n)**2]}
c                       j                        j     
c
c     where (-ltsemb < j < +ltsemb) is the index over a time window.
c
c     author: K. J. Marfurt (May 3, 1994).
c___________________________________________________________________
c     utxfine     = input (t,x,y) data.
c     usemb   = output (tau,theta,phi) data.                         
c___________________________________________________________________
      real      utxfine(0:nt,0:ntfine-1,-mx:nx+mx,-my:+my)
      real      utxfine2(0:nt,0:ntfine-1,-mx:+mx,-my:+my)
      real      unum(0:nt,npqlive),udenom(0:nt,npqlive)
      real      unumsum(0:nt,npqlive),udenomsum(0:nt,npqlive)
      real      usemb(0:nt,npqlive)
      real      utaupq(-2:nt+3,npqlive)
      integer   iypointer(-my:ny+my)
      logical   live(-mx:nx+mx,-my:+my)
      integer   locate(2,npoint)
c
      integer   jpdelay(npqlive,npoint,2)
      parameter (lunroll=4) 
      integer   ixa(lunroll),iya(lunroll),kxa(lunroll)
      integer   jsa(lunroll),jea(lunroll)
      integer   jdelay_finea(lunroll),jdelay_sampa(lunroll)

      real      cputim(*),waltim(*)
c_________________________________________________________________
c     transform coordinates from (t,x,y) to (tau,p,q) domain.
c     form semblance at position centered about x=jx*dx, y=jy*dy.
c_________________________________________________________________
c___________________________________________________________________
c     initialize.                                    
c___________________________________________________________________
      call vclr(usemb,1,(nt+1)*npqlive)
      call vclr(utaupq,1,(nt+1+5)*npqlive)
      nlive=0
      do 10000 jpoint=1,npoint
       ix=jx+locate(1,jpoint)
       iy=iypointer(jy+locate(2,jpoint))
       if(live(ix,iy)) then
          nlive=nlive+1
       endif
10000 continue
      if(nlive .eq. 0) then
         anorm=0.
         return
      else
         anorm=1./nlive
      endif
c__________________________________________________________________
c     BEGIN SINGLE TIME SAMPLE SEMBLANCE CALCULATION.
c__________________________________________________________________
c___________________________________________________________________
c     loop over all live p and q values.                        
c___________________________________________________________________
      call timstr(v1,w1)
      do 60000 jpq=1,npqlive
       do 16000 jsamp=max(istart-ltsemb,0),min(iend+ltsemb,nt)
        udenom(jsamp,jpq)=0.
16000  continue
c___________________________________________________________________
c      collect traces comprising the computational star.
c___________________________________________________________________
c___________________________________________________________________
c      loop unrolling version.
c___________________________________________________________________
       nloop=npoint/lunroll
       do 33000 jloop=1,nloop
        jsmax=0
        jemin=nt 
        jpoint0=(jloop-1)*lunroll
        do 32000 ka=1,lunroll 
         jpoint=jpoint0+ka     
         kxa(ka)=locate(1,jpoint)
         ixa(ka)=jx+kxa(ka)
         iya(ka)=iypointer(jy+locate(2,jpoint))
         jdelay_sampa(ka)=jpdelay(jpq,jpoint,1)
         jdelay_finea(ka)=jpdelay(jpq,jpoint,2)
         jsa(ka)=max(istart-ltsemb,0-jdelay_sampa(ka),0)
         jea(ka)=min(iend+ltsemb,nt-(jdelay_sampa(ka)+1),nt)
         jsmax=max(jsmax,jsa(ka))
         jemin=min(jemin,jea(ka))
32000   continue
        do 32100 jsamp=jsmax,jemin
         utaupq(jsamp,jpq)=utaupq(jsamp,jpq)
     1 +utxfine(jsamp+jdelay_sampa(1),jdelay_finea(1),ixa(1),iya(1))
     2 +utxfine(jsamp+jdelay_sampa(2),jdelay_finea(2),ixa(2),iya(2))
     3 +utxfine(jsamp+jdelay_sampa(3),jdelay_finea(3),ixa(3),iya(3))
     4 +utxfine(jsamp+jdelay_sampa(4),jdelay_finea(4),ixa(4),iya(4))
         udenom(jsamp,jpq)=udenom(jsamp,jpq)
     1 +utxfine2(jsamp+jdelay_sampa(1),jdelay_finea(1),kxa(1),iya(1))
     2 +utxfine2(jsamp+jdelay_sampa(2),jdelay_finea(2),kxa(2),iya(2))
     3 +utxfine2(jsamp+jdelay_sampa(3),jdelay_finea(3),kxa(3),iya(3))
     4 +utxfine2(jsamp+jdelay_sampa(4),jdelay_finea(4),kxa(4),iya(4))
32100   continue
c___________________________________________________________________
c       cleanup of time edges.             
c___________________________________________________________________
        do 32600 ka=1,lunroll
         do 32200 jsamp=jsa(ka),jsmax-1
          utaupq(jsamp,jpq)=utaupq(jsamp,jpq)
     1      +utxfine(jsamp+jdelay_sampa(ka),jdelay_finea(ka),
     2                                             ixa(ka),iya(ka))
          udenom(jsamp,jpq)=udenom(jsamp,jpq)
     1      +utxfine2(jsamp+jdelay_sampa(ka),jdelay_finea(ka),
     2                                             kxa(ka),iya(ka))
32200    continue
         do 32300 jsamp=jemin+1,jea(ka)
          utaupq(jsamp,jpq)=utaupq(jsamp,jpq)
     1      +utxfine(jsamp+jdelay_sampa(ka),jdelay_finea(ka),
     2                                             ixa(ka),iya(ka))
          udenom(jsamp,jpq)=udenom(jsamp,jpq)
     1      +utxfine2(jsamp+jdelay_sampa(ka),jdelay_finea(ka),
     2                                             kxa(ka),iya(ka))
32300    continue
32600   continue
33000  continue
c___________________________________________________________________
c      cleanup of leftover grid points.
c___________________________________________________________________
       do 36000 jpoint=lunroll*nloop+1,npoint
        kx=locate(1,jpoint)
        ix=jx+kx
        iy=iypointer(jy+locate(2,jpoint))
        jdelay_samp=jpdelay(jpq,jpoint,1)
        jdelay_fine=jpdelay(jpq,jpoint,2)
        if(live(ix,iy)) then
           js=max(istart-ltsemb,0-jdelay_samp,0)
           je=min(iend+ltsemb,nt-(jdelay_samp+1),nt)
           do 35000 jsamp=js,je
            utaupq(jsamp,jpq)=utaupq(jsamp,jpq)
     1             +utxfine(jsamp+jdelay_samp,jdelay_fine,ix,iy)
            udenom(jsamp,jpq)=udenom(jsamp,jpq)
     1             +utxfine2(jsamp+jdelay_samp,jdelay_fine,kx,iy)
35000      continue
        endif
36000  continue
c__________________________________________________________________
c      square the numerator.
c__________________________________________________________________
       do 55000 jsamp=max(istart-ltsemb,0),min(iend+ltsemb,nt)
        unum(jsamp,jpq)=utaupq(jsamp,jpq)**2
55000  continue
60000 continue
      call timend(cputim(4),v1,v2,waltim(4),w1,w2)
c__________________________________________________________________
c     END OF SINGLE TIME SAMPLE SEMBLANCE CALCULATION.
c     BEGIN TIME INTEGRATION CALCULATION.
c     (make loop over jpq the inner loop to allow vectorization.
c__________________________________________________________________
      call timstr(v1,w1)
c__________________________________________________________________
c     initialize the time integration gate.
c__________________________________________________________________
      jsamp=max(istart,ltsemb)
      do 62000 jpq=1,npqlive
       unumsum(jsamp,jpq)=eps2
       udenomsum(jsamp,jpq)=eps2     
       do 61000 jgate=-ltsemb,+ltsemb
        unumsum(jsamp,jpq)=
     1         unumsum(jsamp,jpq)+unum(jsamp+jgate,jpq)
        udenomsum(jsamp,jpq)=
     1         udenomsum(jsamp,jpq)+udenom(jsamp+jgate,jpq)
C
61000  continue
       unumsum(jsamp,jpq)=max(unumsum(jsamp,jpq),eps2)
       udenomsum(jsamp,jpq)=max(udenomsum(jsamp,jpq),eps2)
       usemb(jsamp,jpq)=
     1             unumsum(jsamp,jpq)/udenomsum(jsamp,jpq)
62000 continue
c__________________________________________________________________
c     calculate running sums in t by adding/dropping terms to/from
c     the previous sum.
c__________________________________________________________________
      do 69000 jsamp=max(istart+1,ltsemb+1),min(iend,nt-ltsemb)
       do 68000 jpq=1,npqlive
        unumsum(jsamp,jpq)=unumsum(jsamp-1,jpq)+
     1        (unum(jsamp+ltsemb,jpq)-unum(jsamp-ltsemb-1,jpq))
        udenomsum(jsamp,jpq)=udenomsum(jsamp-1,jpq)+
     1        (udenom(jsamp+ltsemb,jpq)-udenom(jsamp-ltsemb-1,jpq))
        unumsum(jsamp,jpq)=max(unumsum(jsamp,jpq),eps2)
        udenomsum(jsamp,jpq)=max(udenomsum(jsamp,jpq),eps2)
        usemb(jsamp,jpq)=
     1              unumsum(jsamp,jpq)/udenomsum(jsamp,jpq)
68000  continue
69000 continue
c__________________________________________________________________
c     use first (last) complete semblance calculation at the 
c     top (bottom) of the window.
c__________________________________________________________________
      do 74000 jsamp=istart,ltsemb-1
       do 73000 jpq=1,npqlive
        usemb(jsamp,jpq)=usemb(ltsemb,jpq)
73000  continue
74000 continue
      do 76000 jsamp=nt-ltsemb+1,iend
       do 75000 jpq=1,npqlive
        usemb(jsamp,jpq)=usemb(nt-ltsemb,jpq)
75000  continue
76000 continue
      call timend(cputim(5),v1,v2,waltim(5),w1,w2)
c
      return
      end
