C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine wrgather(uout,utxfine,trheader,
     1                    tracebuf,ibuffer2,
     2                    luout,nx,iy,jy,ny,
     3                    my,nt_orig,kximin,kximax,kyimin,kyimax,
     4                    istart,iend,lenhed,hbegin,nbytes_out,
     5                    scale,l_DphInd,ifmt_DphInd,ln_DphInd,
     6                    mx,ntfine,reject)
c
      integer   hbegin
      integer   trheader(lenhed,0:nx,-my:my)         
      integer   ibuffer2(lenhed)
      real      uout(istart:iend,0:nx,kximin:kximax,kyimin:kyimax)
      real      utxfine(0:nt_orig,0:ntfine-1,-mx:nx+mx)                     
      real      tracebuf(-lenhed:nt_orig)
      logical   reject
c
      if(scale .ne. 0.) then
         unscale=1./scale
      else
         unscale=1.
      endif
      if(jy .eq. 0) then
c_______________________________________________________________________
c        first input record. write out only interpolated records that 
c        fall within the interior of the original survey.
c_______________________________________________________________________
         kystart=0          
         kyend=kyimax
      elseif(jy .eq. ny) then
c_______________________________________________________________________
c        last input record. write out only interpolated records that 
c        fall within the interior of the original survey.
c_______________________________________________________________________
         kystart=kyimin
         kyend=0          
      else
c_______________________________________________________________________
c        internal input record. all interpolated records fall within
c        the interior of the original survey.
c_______________________________________________________________________
         kystart=kyimin
         kyend=kyimax
      endif
      do 90000 kyi=kystart,kyend
c_______________________________________________________________________
c     first original trace. write out only interpolated traces that fall
c     within the interior of the original survey.
c_______________________________________________________________________
      jx=0
      do 39000 kxi=0,kximax
       do 32000 k=1,lenhed
        ibuffer2(k)=trheader(k,jx,iy)
32000  continue
       if(reject) then
          do 33500 jt=0,istart-1
           tracebuf(jt)=utxfine(jt,0,jx)*unscale
33500     continue
          do 34000 jt=istart,iend
           tracebuf(jt)=(utxfine(jt,0,jx)-uout(jt,jx,kxi,kyi))*unscale
34000     continue
          do 34500 jt=iend+1,nt_orig
           tracebuf(jt)=utxfine(jt,0,jx)*unscale
34500     continue
       else
          do 34600 jt=0,istart-1
           tracebuf(jt)=0.
34600     continue
          do 35000 jt=istart,iend 
           tracebuf(jt)=uout(jt,jx,kxi,kyi)*unscale
35000     continue
          do 35500 jt=iend+1,nt_orig
           tracebuf(jt)=0.
35500     continue
       endif
       call wrtape(luout,tracebuf(-lenhed),nbytes_out)
39000 continue
c_______________________________________________________________________
c     interior traces. write out all interpolated traces.
c_______________________________________________________________________
      do 50000 jx=1,nx-1
       do 49000 kxi=kximin,kximax
c_______________________________________________________________________
c       copy the trace header into the buffer.
c_______________________________________________________________________
        do 42000 k=1,lenhed
         ibuffer2(k)=trheader(k,jx,iy)
42000   continue
        if(reject) then
           do 43500 jt=0,istart-1
            tracebuf(jt)=utxfine(jt,0,jx)*unscale
43500      continue
           do 44000 jt=istart,iend
            tracebuf(jt)=(utxfine(jt,0,jx)-uout(jt,jx,kxi,kyi))*unscale
44000      continue
           do 44500 jt=iend+1,nt_orig
            tracebuf(jt)=utxfine(jt,0,jx)*unscale
44500      continue
        else
           do 44600 jt=0,istart-1
            tracebuf(jt)=0.
44600      continue
           do 45000 jt=istart,iend
            tracebuf(jt)=uout(jt,jx,kxi,kyi)*unscale
45000      continue
           do 45500 jt=iend+1,nt_orig
            tracebuf(jt)=0.
45500      continue
        endif
        call wrtape(luout,tracebuf(-lenhed),nbytes_out)
49000  continue
50000 continue
c_______________________________________________________________________
c     last original trace. write out only interpolated traces that fall
c     within the interior of the original survey.
c_______________________________________________________________________
      jx=nx
      do 69000 kxi=kximin,0
       do 62000 k=1,lenhed
        ibuffer2(k)=trheader(k,jx,iy)
62000  continue
        if(reject) then
           do 63500 jt=0,istart-1
            tracebuf(jt)=utxfine(jt,0,jx)*unscale
63500      continue
           do 64000 jt=istart,iend
            tracebuf(jt)=(utxfine(jt,0,jx)-uout(jt,jx,kxi,kyi))*unscale
64000      continue
           do 64500 jt=iend+1,nt_orig
            tracebuf(jt)=utxfine(jt,0,jx)*unscale
64500      continue
        else
           do 64600 jt=0,istart-1
            tracebuf(jt)=0.
64600      continue
           do 65000 jt=istart,iend
            tracebuf(jt)=uout(jt,jx,kxi,kyi)*unscale
65000      continue
           do 65500 jt=iend+1,nt_orig
            tracebuf(jt)=0.
65500      continue
        endif
        call wrtape(luout,tracebuf(-lenhed),nbytes_out)
69000 continue
c
90000 continue
c
      return
      end 
