C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      program TAPER
c__________________________________________________________________________
c     TAPER -- apply a linear or other tapers to data according to 
c              a user defined trace index.
c                                                            
c
c     originally designed to allow greater flexibility in blending restart
c     of prestack migrated data when different pieces of the line were
c     shot using differnt parameters (group spacing, direction, etc).
c
c     Kurt J. Marfurt (5/25/94)                             
c
c__________________________________________________________________________
#include <localsys.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h>
#include <f77/pid.h>
c
      parameter (maxs=0 000 002)
      dimension s(maxs)
      pointer   (pntrs,s)
c
      integer   hbegin
      parameter (i2fact=8/szsmpd,lenhed=lntrhd/i2fact,hbegin=1-lenhed)
c
      integer*2   sheader (SZLNHD)
      integer     argis,savelu
 
      character   name * 5, ntap * 100, otap * 100
      character*6 trhd_keyword
 
      logical     verbose,query
      logical     blackman,hamming,linear                   
      logical     left_mute,right_mute,inside_mute,outside_mute
 
      data  name/'TAPER'/, nbytes/0/, lbytes/0/
c-------------------------------------------------------------------
c     If '-?' flag is used in command line, execute query
c     loop and end program.
c-------------------------------------------------------------------
      query = ( argis ( '-?' ) .gt. 0 )
      if ( query ) then
         call help(ler)
         stop
      end if
c-------------------------------------------------------------------
c     open printout file
c-------------------------------------------------------------------
#include <f77/open.h>
      call argstr('-N',ntap,' ',' ')
      call argstr('-O',otap,' ',' ' )
c-------------------------------------------
c     Open input and output files
c-------------------------------------------
      call getln(luin,ntap,'r',0)
      call getln(luout,otap,'w',1)
c----------------------------------------------------
c     Read line header and save parameters
c----------------------------------------------------
      lbytes=0
      call rtape(luin,sheader,lbytes)
      if(lbytes .eq. 0) then
         write(LERR,*)'TAPER: no header read on unit ',luin
         write(LERR,*)'FATAL'
         stop
      endif
      call hlhprt(sheader,lbytes,name,5,lerr)
      call saver(sheader,'NumSmp',nsamp,LINEHEADER)
      call saver(sheader,'SmpInt',nsi,LINEHEADER)
      call saver(sheader,'NumTrc',ntr,LINEHEADER)
      call saver(sheader,'NumRec',nrec,LINEHEADER)
      call saver(sheader,'Format',iform,LINEHEADER)
c---------------------------------------------------------------------------
c     Read program input parameters from command line argument flags
c---------------------------------------------------------------------------
      call cmdln(startup,endup,startdown,enddown,nstartup,nendup,
     1           nstartdown,nenddown,lerr,
     2           trhd_keyword,hamming,blackman,linear,verbose,
     3           left_mute,right_mute,inside_mute,outside_mute)
c---------------------------------------------------------------------------
c     print out parameters
c---------------------------------------------------------------------------
      write(lerr,*) ' Values read from command line'
      write(lerr,'(a40,a20)') 'keyword index:',trhd_keyword 
      write(lerr,'(a40,f20.5)') 'startup',startup,'endup',endup,
     1                          'startdown',startdown,'enddown',enddown
      write(lerr,'(a40,i14)') 'nstartup',nstartup,'nendup',nendup,
     1                       'nstartdown',nstartdown,'nenddown',nenddown
      write(lerr,'(a40,l20)') 'left_mute?',left_mute
      write(lerr,'(a40,l20)') 'right_mute?',right_mute
      write(lerr,'(a40,l20)') 'inside mute?',inside_mute
      write(lerr,'(a40,l20)') 'outside mute?',outside_mute
      write(lerr,'(a40,l20)') 'blackman taper?',blackman     
      write(lerr,'(a40,l20)') 'hamming taper?',hamming      
      write(lerr,'(a40,l20)') 'linear taper?',linear       
      write(lerr,'(a40,l20)') 'verbose output?',verbose    
c----------------------------------------------------
c     print out header parameters
c----------------------------------------------------
      write(lerr,*) ' Values read from input data set lineheader'
      write(lerr,'(a40,i14)')'Number of Samples/Trace',nsamp
      write(lerr,'(a40,i14)')'Sample Interval',nsi
      write(lerr,'(a40,i14)')'Traces per Record',ntr
      write(lerr,'(a40,i14)')'Records per Line',nrec
      write(lerr,'(a40,i14)')'Format of Data',iform 
c
      call savhlh(sheader,lbytes,lbyout)
      call wrtape(luout,sheader,lbyout)
c______________________________________________________________________
c     pull out indices to important trace header words.
c______________________________________________________________________
      ireturn=savelu('StaCor',ifmt,l_stacor,length,TRACEHEADER)
      ireturn=savelu(trhd_keyword,ifmt,l_keyword_index,
     1                 length,TRACEHEADER)
      if(ireturn .eq. 0) then
         write(lerr,*) 'bad keyword string following -h on command line'
         write(lerr,*) 'trhd_keyword = "'//trhd_keyword//'"'
         write(lerr,*) 'keyword not found by savelu routine'
         write(lerr,*) 'examine command line and try again'
         call exitfu(661)
      endif
c______________________________________________________________________
c     calculate memory requirements
c______________________________________________________________________
      write(lerr,'(///,80a1)') ('_',i=1,80)
      write(lerr,'(A)')'storage map of major arrays'
      write(lerr,'(80a1)') ('_',i=1,80)
C
      l_free=1
      write(lerr,'(a20,3a10)')'variable name','begin','end','length'
      call mapmem('tracebuf',l_tracebuf,l_free,nsamp+lenhed,lerr) 
      call mapmem('upramp',l_upramp,l_free,nendup-nstartup+1,lerr)
      call mapmem('downramp',l_downramp,l_free,
     1             nenddown-nstartdown+1,lerr)
C_______________________________________________________________________
C     allocate dynamic memory.
C_______________________________________________________________________
      lens=l_free-1
      write(lerr,'(a20,10x,i10)') 'total vector length',lens
      write(lerr,'(//,a)') 'allocate dynamic memory for TAPER: '
      write(lerr,*) 1.e-6*lens,' Mwords'
      write(lerr,*) 1.e-6*lens*szsmpd,' Mbytes'
      write(ler,'(//,a)') 'allocate dynamic memory for TAPER: '
      write(ler,*) 1.e-6*lens,' Mwords'
      write(ler,*) 1.e-6*lens*szsmpd,' Mbytes'
      call galloc(pntrs,lens*szsmpd,ierrcd,0)
      if(ierrcd .ne. 0 ) then
         write(lerr,*)'galloc memory allocation error from main'
         write(lerr,*)'ierrcd = ',ierrcd
         write(lerr,*)
         write(lerr,*)'probable cause: too much memory requested!'
         write(lerr,*)
         write(lerr,*)'program TAPER aborted'
         call exitfu(101)
      endif
c---------------------------------------------------------------------
c     calculate the weights for up and down tapers.               
c---------------------------------------------------------------------
      call getwgt(s(l_upramp),startup,endup,nstartup,nendup,
     1            linear,hamming,blackman,lerr,verbose,.true.)
      call getwgt(s(l_downramp),startdown,enddown,nstartdown,nenddown,
     1            linear,hamming,blackman,lerr,verbose,.false.)
      do 10000 jrec=1,nrec
       call tapersub(s(l_tracebuf),s(l_tracebuf),luin,luout,lerr,       
     1               s(l_upramp),s(l_downramp),
     2               jrec,ntr,nsamp,nbytes,hbegin,
     3               l_keyword_index,l_StaCor,trhd_keyword,verbose,
     4               startup,endup,startdown,enddown,
     5               nstartup,nendup,nstartdown,nenddown,
     6               left_mute,right_mute,inside_mute,outside_mute)
10000 continue
c-------------------------------------------
c     close files and end program
c-------------------------------------------
      call lbclos(luin)
      call lbclos(luout)
      write(lerr,*)'Normal completion of routine TAPER'
      close(lerr)  
      write(ler,*)'Normal completion of routine TAPER'
c
      call exitfu(0)
      end
      subroutine help(ler)
c-------------------------------------------
c     online help
c-------------------------------------------
      write(LER,*)
     1 '***************************************************************'
      write(LER,*)
     1 'Run this program by typing: taper and the following arguments'
      write(LER,*)
     1 ' -N[ntap]    (no default)      : Input data file name'
         write(LER,*)
     1 ' -O[otap]    (no default)      : Output data file name'
      write(LER,*)
     1 ' -h[trhd_keyword] (no default) : trace header keyword upon'
     2            //' whose trace header value the taper acts'
      write(LER,*)
     1 ' -startup[startup] (no upgoing ramp) : start of upgoing ramp' 
      write(LER,*)
     1 ' -endup[endup] (no upgoing ramp)     : end   of upgoing ramp' 
      write(LER,*)
     1 ' -startdown[startdown] (no downgoing ramp) :'
     2                   //' start of downgoing ramp' 
      write(LER,*)
     1 ' -enddown[enddown] (no downgoing ramp)   :'
     2                   //' end   of downgoing ramp' 
      write(LER,*)
     1 ' -L (default)  if present, weight taper with linear taper'         
      write(LER,*)
     1 ' -H            if present, weight taper with hamming taper'         
      write(LER,*)
     1 ' -B            if present, weight taper with blackman taper'         
      write(LER,*)
     1 ' -V            if present, output verbose information'             
      write(LER,*)
     : 'USAGE:  ' 
      write(LER,*)
     : 'taper -N[ntap] -O[otap] -startup[] -endup[]'
     2             //' -startdown[] -enddown[] -h[] -[L,H,B,V]'
      write(LER,*)
     1 '***************************************************************'
      return
      end
      subroutine cmdln(startup,endup,startdown,enddown,
     1                 nstartup,nendup,nstartdown,nenddown,lerr,
     2                 trhd_keyword,hamming,blackman,linear,verbose,
     3                 left_mute,right_mute,inside_mute,outside_mute)
c_____________________________________________________________________
c     process command line arguments.
c_____________________________________________________________________
      integer       argis
      logical       linear,blackman,hamming,verbose
      logical       left_mute,right_mute,inside_mute,outside_mute
      character*(*) trhd_keyword
c
      call argr4('-startup',startup,-99999.,-99999.)                 
      call argr4('-endup',endup,-99999.,-99999.)                 
      call argr4('-startdown',startdown,-99999.,-99999.)                 
      call argr4('-enddown',enddown,-99999.,-99999.)                 
      call argstr('-h',trhd_keyword,'NULL','NULL') 
      linear=(argis('-L') .gt. 0)
      hamming=(argis('-H') .gt. 0)
      blackman=(argis('-B') .gt. 0)
      verbose=(argis('-V') .gt. 0)
c_____________________________________________________________________
c     check for conflicting command line arguments:
c_____________________________________________________________________
      ierror=0
      icount=0
      if(linear) icount=icount+1
      if(hamming) icount=icount+1
      if(blackman) icount=icount+1
      if(icount .eq. 0) then
         linear=.true.
      elseif(icount .gt. 1) then
         write(lerr,*) 'error in cmdln!'
         write(lerr,*) 'conflicting taper options!'
         write(lerr,*) 'must enter only ONE of -L, -H or -B commands'
         write(lerr,*) 'linear   (-L)..........',linear                 
         write(lerr,*) 'hamming  (-H)..........',hamming                
         write(lerr,*) 'blackman (-B)..........',blackman               
         ierror=ierror+1
      endif
c_____________________________________________________________________
c     check for consistency of taper points:           
c_____________________________________________________________________
      if(startdown .le. enddown) then
         nstartdown=nint(startdown)
         nenddown=nint(enddown)
      else
         write(lerr,*) 'error in cmdln!'
         write(lerr,*) 'startdown must be less than or equal'//
     1                 ' to enddown!'
         write(lerr,*) 'startdown...............',startdown
         write(lerr,*) 'enddown...............',enddown
         ierror=ierror+1
      endif
c
      if(startup .le. endup) then
         nstartup=nint(startup)
         nendup=nint(endup)
      else
         write(lerr,*) 'error in cmdln!'
         write(lerr,*) 'startup must be less than or equal to endup!'
         write(lerr,*) 'startup...............',startup
         write(lerr,*) 'endup...............',endup
         ierror=ierror+1
      endif
c_____________________________________________________________________
c     check mute zones.
c_____________________________________________________________________
      inside_mute=.false.
      outside_mute=.false.
      left_mute=.false.
      right_mute=.false.
      if(startdown .eq. -99999.) then
         left_mute=.true.
      elseif(startup .eq. -99999.) then
         right_mute=.true.
      elseif(startdown .lt. endup) then
         inside_mute=.true.
      else
         outside_mute=.true.
      endif
c
      if(ierror .ne. 0) then
         write(lerr,*) 'routine TAPER aborted due to ',ierror,
     1                 ' command line errors!'
         call exitfu(666)
      endif

      return
      end
