C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine tapersub(buffer2,u,luin,luout,lerr,
     1                    upramp,downramp,
     2                    jrec,ntr,nsamp,nbytes,hbegin,
     3                    l_keyword_index,l_StaCor,trhd_keyword,verbose,
     4                    startup,endup,startdown,enddown,
     5                    nstartup,nendup,nstartdown,nenddown,
     6                    left_mute,right_mute,inside_mute,outside_mute)
c
      integer       hbegin
c
      integer*2     buffer2(*)       
c
      real          u(hbegin:nsamp)
      real          upramp(nstartup:nendup)
      real          downramp(nstartdown:nenddown)
c
      character*(*) trhd_keyword
c
      logical       left_mute,right_mute,inside_mute,outside_mute
      logical       verbose
      logical       dead
c

      if(verbose) then
         write(lerr,'(5a12)') 'jrec','jtr',trhd_keyword,'dead','wgt'         
      endif
c
      do 20000 jtr=1,ntr           
       nbytes=0
       call rtape(luin,u(hbegin),nbytes)
       if(nbytes .eq. 0) then
          write(lerr,*)'End of file on input:'
          write(lerr,*)'rec= ',jrec,'  trace= ',jtr
          return      
       endif
       dead=(buffer2(l_StaCor) .eq. 30000)             
       jindex=buffer2(l_keyword_index)
       if(dead) then
c_____________________________________________________________________
c         dead trace!
c_____________________________________________________________________
          jindex=0
          wgt=0.
c_____________________________________________________________________
c         __
c      __/
c_____________________________________________________________________
       elseif(left_mute) then
          if(jindex .lt. nstartup) then
             wgt=0.
          elseif(jindex .le. nendup) then
             wgt=upramp(jindex)
          else
             wgt=1.
          endif
       elseif(right_mute) then
c_____________________________________________________________________
c      __
c        \__
c_____________________________________________________________________
          if(jindex .lt. nstartdown) then
             wgt=1.
          elseif(jindex .le. nenddown) then
             wgt=downramp(jindex)
          else
             wgt=0.
          endif
       elseif(inside_mute) then
c_____________________________________________________________________
c      startdown < enddown < startup < endup
c       _   _
c        \_/
c_____________________________________________________________________
          if(jindex .lt. startdown) then
             wgt=1.
          elseif(jindex .le. nenddown) then
             wgt=downramp(jindex)
          elseif(jindex .lt. nstartup) then
             wgt=0.
          elseif(jindex .le. nendup) then
             wgt=upramp(jindex)
          else
             wgt=1.
          endif
       elseif(outside_mute) then
c_____________________________________________________________________
c      startup < endup < startdown < enddown 
c         _
c       _/ \_
c_____________________________________________________________________
c_____________________________________________________________________
          if(jindex .lt. nstartup) then
             wgt=0.
          elseif(jindex .le. nendup) then
             wgt=upramp(jindex)
          elseif(jindex .lt. nstartdown) then
             wgt=1.
          elseif(jindex .le. nenddown) then
             wgt=downramp(jindex)
          else
             wgt=0.
          endif
       endif
c
       if(verbose) then
          write(lerr,'(3i12,l12,f12.5)') jrec,jtr,jindex,dead,wgt
       endif
c
       do 10000 jsamp=1,nsamp
        u(jsamp)=wgt*u(jsamp)
10000  continue
c
       call wrtape(luout,u(hbegin),nbytes)
20000 continue
c
      return
      end
