C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c ----- declare variables -----
c
c
c Tease	  October 1995  James M. Gridley
c special thanks to Don Adams (now with Exxon) who
c completed the basic analysis as a summer intern project
c TEsting the Amplitudes of SEismic
c
c ----- get machine dependent parameters -----
c
#include <save_defs.h> 
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
c
c ----- dimension standard USP variables -----

      integer     itr ( SZLNHD )
     
      integer     nsamp, nsi, ntrc, ntrco, nrec, nreco,  obytes
      integer     luin, luout, lbytes, nbytes, lbyout
      integer     irs, ire, ns, ne, argis, itime, iword1
      integer     icounter

      real        tri ( SZSMPM ), cept, y(SZSMPM)
      real        ampx,wt,pcnt, ampl(10000), offset(10000,3)
      real        coef(3),GG(3,10000),aer(10000),covmat(3,3)
      real        ci(10000)
      real        mmax,mmin,norm

      character   ntap*255, ptap*255, otap*255, hdrwd*6, name*6, mtype*2

      logical     verbos, nb, track, pos, negi, maa, head, graph

c dimension program specific variables

      integer     index(2*SZSMPM,2), count, nseg, NumPicks
      integer     RecNum, l_RecNum, ln_RecNum, ifmt_RecNum
      integer     l_DstSgn, ln_DstSgn, ifmt_DstSgn
      integer     static, l_StaCor, ln_StaCor, ifmt_StaCor
      integer     length, SeisSize, PickSize, length2
      integer     lupick, abort, errcd1, errcd2, errcd3, errcd4, errcd5
      integer     errcd6, errcd7, trcnum, dstsgn

      real        dt_units
      real	  mute_output, mute_coefs
      real        TraceBuffer, TimeBuffer

      pointer     (wkadr1, mute_output(200000))
      pointer     (wkadr2, mute_coefs(200000))
      pointer     (wkadr3, traces(200000))
      pointer     (wkadr4, times(200000))
      pointer     (wkadr5, records(200000))
      pointer     (wkadr6, TraceBuffer(200000))
      pointer     (wkadr7, TimeBuffer(200000))

      character   ONword*6, OFFword*6,  mnemonic*6

      logical     NoExtrap


c Variable Definitions
c
c ----- Integer -----
c
c     index() : contains segment information (seq.rec,npicks) 
c     count : counter for traces() and times() arrays
c     nseg : number of segments in the pick file
c     mul : pick file time units override
c     spinit : initial shot point override
c     spincr : shot point increment override
c     ramp : length of mute ramp in ms
c
c ----- Real -----
c
c     traces() : pick file entries
c     times() : pick file entries 
c     dist : trace distance 
c
c ----- Character -----
c
c     ptap : pick file name
c     mtype : type of mute requested
c

c Initialize variables

      data lbytes/0/
      data nbytes/0/
      data name/'TEASE'/
      data abort/0/
      data luout/6/
      data ONword/'VPick1'/
      data OFFword/'VPick2'/
      data NoExtrap/.false./
      data pos/.false./
      data negi/.false./
      data maa/.false./
      data head/.false./
      data graph/.false./

      icounter=0

c give command line help if requested

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif

c open printout file

#include <f77/open.h>

c get command line input parameters

      call cmdln (ntap,ptap,otap,ns,ne,irs,ire,nb,hdrwd,head,
     : graph,iwin,itm,track,pos,negi,maa,itwd,verbos,mnemonic )

c open input and output datasets

      
      
         length = 6
      if ( otap(1:length) .ne. '-99999' ) then
         length = lenth(otap)
         open(luout, file=otap(1:length), status='unknown')
c         open(luout, file=otap(1:length), status='unknown', err=990 )
      endif

      call getln(luin , ntap,'r', 0)

c  read line header of input save certain parameters

      call rtape(luin,itr,lbytes)
      if(lbytes.eq.0)then
         write(LERR,*)'TEASE: no header read from unit ',luin
         write(LERR,*)'FATAL'
         write(LER,*)'TEASE: no header read from unit ',luin
         write(LER,*)'FATAL'
         stop
      endif

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
 
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
 
      call savelu(hdrwd,ifmt_hdrwd,l_hdrwd,ln_hdrwd,TRACEHEADER)

      if (itwd .gt. 0) then
         l_hdrwd = itwd
      endif

      call hlhprt (itr, lbyte, name, 6, LERR)

c assign floating point delta T variable used in mute application.  This will
c be in units of milliseconds for millisecond data and microseconds for 
c microsecond data.  It is assumed [and required] that the pick file conform
c to the same convention.  If muting microsecond data then the pick file must
c contain microsecond picks.

      dt_units = float(nsi)

c ensure that command line values are compatible with data set

      call cmdchk(ns,ne,irs,ire,ntrc,nrec)

c modify line header to reflect actual number of traces output

      nreco = ire - irs + 1
      ntrco = ne - ns + 1

      call savew(itr, 'NumRec', nreco, LINHED)
      call savew(itr, 'NumTrc', ntrco  , LINHED)

c number output bytes

      obytes = SZTRHD + nsamp * SZSMPD

c save out hlh and line header

      call savhlh(itr,lbytes,lbyout)

c verbose output of all pertinent information before processing begins

      call verbal (nsamp,dt_units,ntrc,nrec, ntap, ns, ne, 
     : ire,irs,otap, ptap,nb,hdrwd,iwin,itm,track,pos,negi,maa,itwd,
     :     mnemonic,graph)

c open pick file
      length2 = lenth(ptap)
      IF (ptap(1:length2) .ne. '-99999') THEN

         lupick = 27
         open ( lupick, file=ptap(1:length2), status='old',
     :  err=990 )
c Determine Size Requirements and allocate memory

         call PickCount ( lupick, NumPicks )
	
         SeisSize = nsamp * SZSMPD
         PickSize = NumPicks * SZSMPD

         call galloc (wkadr1, SeisSize, errcd1, abort)
         call galloc (wkadr2, SeisSize, errcd2, abort)
         call galloc (wkadr3, PickSize, errcd3, abort)
         call galloc (wkadr4, PickSize, errcd4, abort)
         call galloc (wkadr5, PickSize, errcd5, abort)
         call galloc (wkadr6, PickSize, errcd6, abort)
         call galloc (wkadr7, PickSize, errcd7, abort)

         if ( errcd1 .ne. 0 .or. 
     :        errcd2 .ne. 0 .or. 
     :        errcd3 .ne. 0 .or. 
     :        errcd4 .ne. 0 .or.
     :        errcd5 .ne. 0 .or.
     :        errcd6 .ne. 0 .or.
     :        errcd7 .ne. 0 )then
            write(LERR,*)' '
            write(LERR,*)'Unable to allocate workspace:'
            write(LERR,*) 1*SeisSize+5*PickSize,'  bytes'
            write(LERR,*)' '
         else
            write(LERR,*)' '
            write(LERR,*)'Allocating workspace:'
            write(LERR,*) 1*SeisSize+5*PickSize,'  bytes'
            write(LERR,*)' '
         endif
         
c read and qc pick file
         mtype='on'

         call ReadPick (lupick,index,records,traces,times,count, 
     :        nseg,-9999,-9999,-9999,mtype,hdrwd,nsi,verbos )

c sort the picks based on increasing record [or trace if appropriate] index

         call PickSort ( index, traces, times, TraceBuffer, TimeBuffer, 
     :        count, nseg, ntrc, mtype )

c linear interpolation of picks

         do i=1,count-1
            slope= (times(i+1)-times(i))/(traces(i+1)-traces(i))
            cept=times(i+1)-slope*traces(i+1)
            if (i .eq. 1) then 
               traces(1)=1 
            endif
            do j=traces(i),traces(i+1)
               y(j)=slope*j + cept
            enddo
         enddo

c ending loop with pickfile option
      ENDIF
c============================================================
c BEGIN PROCESSING
c skip to start record

      call recskp(1,irs-1,luin,ntrc,itr)

c============================================================
      DO JJ = irs, ire
 
c skip to start trace

         call trcskp(JJ,1,ns-1,luin,ntrc,itr)

         do 1001 kk=ns,ne
            nbytes = 0
            call rtape( luin, itr, nbytes)
            if(nbytes .eq. 0) then
               write(LERR,*)'End of file on input:'
               write(LERR,*)'  rec= ',jj,'  trace= ',kk
               go to 999
            endif
            call vmov (itr(ITHWP1), 1, tri, 1, nsamp)
            
            call saver2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1           recnum , TRACEHEADER)
            call saver2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1           trcnum , TRACEHEADER)
            call saver2(itr,ifmt_DsTSgn,l_DstSgn, ln_DstSgn,
     1           dstsgn , TRACEHEADER)
            
            if (hdrwd .ne. 'RecNum') then
               call saver2(itr,ifmt_hdrwd,l_hdrwd, ln_hdrwd,
     1              iword1 , TRACEHEADER)
            endif

            call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1           static , TRACEHEADER)
c======================================================================
c  figure out sample corresponding to time
               if (head) then
                  itm=iword1
               endif

               it = itm/nsi + 1
               iwin2 = int((iwin/nsi + 1)/2)
               iwins=iwin/nsi
c============================================================
c  get amplitude for:
c  fixed time, no window, no pick file
               
       IF (iwins .eq. 0 .and. ptap(1:length2) .eq. '-99999') THEN
               ampx = tri(it)
               itime = (it-1)*nsi

            ELSEIF (iwins .ne. 0 .and. ptap(1:length2)
     :              .eq. '-99999')THEN
               ampx=tri(it-iwin2-1)
               itime = (it-1)*nsi
               do ii=it-iwin2,it+iwin2+1	
                  if (pos) then
                     ampx=max(ampx,tri(ii))
                  elseif (negi) then
                     ampx=min(ampx,tri(ii))

	
                  elseif (maa) then

                   
                        if(abs(tri(ii)) .gt. abs(ampx)) then
                           ampx = tri(ii)
                        endif
                 

c                     if(abs(tri(ii)) .gt. abs(ampx)) then
c			if(abs(tri(ii)) .gt. ampx .and.
c     : tri(ii) .lt. ampx)  then
c                     ampx=tri(ii)
c			else
c                     ampx=max(abs(ampx),abs(tri(ii)))
c	 		endif

                  endif

               enddo
c
c Now Deal with XSD picks

            ELSEIF (iwins .eq. 0 .and. ptap(1:length2)
     :              .ne. '-99999')THEN
               itime=int(y(kk))
               itmp=itime/nsi
               ampx=tri(itmp)
               
            ELSEIF (iwins .ne. 0 .and. ptap(1:length2)
     :              .ne. '-99999')THEN
               itime=int(y(kk))
               itmp=itime/nsi
               ampx=tri(itmp-iwin2-1)
               
               do ii=itmp-iwin2,itmp+iwin2 + 1	
                  if (pos) then
                     ampx=max(ampx,tri(ii))
                  elseif (negi) then
                     ampx=min(ampx,tri(ii))
	
                  elseif (maa) then
c                     if (abs(tri(ii)) .gt. abs(ampx) ) then
c			if(abs(tri(ii)) .gt. ampx .and.
c     : tri(ii) .lt. ampx)  then
c                     ampx=tri(ii)
c			else
c                     ampx=max(abs(ampx),abs(tri(ii)))
c	 		endif
                   
                        if(abs(tri(ii)) .gt. abs(ampx)) then
                           ampx = tri(ii)
                        endif
                     
                  endif
               enddo
            ENDIF
c======================================================================
c Do the TEASE

	icounter=icounter+1
	wt=0.
	pcnt=0.05

	offset(icounter,1)=1.
	offset(icounter,2)=dstsgn
	offset(icounter,3)=dstsgn*dstsgn
	ampl(icounter)= ampx
	
c======================================================================
	

 100        format(i6,4x,i6,9x,e15.5,5x,i5)
 102        format(i6,4x,i6,9x,e15.5,5x,i5,5x,i5)
 103        format(i6,4x,e15.5)
 
 
            if(verbos)write(LERR,*)'ri ',recnum,' trace ',trcnum
 1001    continue
 
c---------------------
c  between records put
c  null line
         if (JJ .ne. ire .AND. ntrc .gt. 1 .AND. .not. nb) then
            write(luout,101)
 101        format()
            write(LERR,*)'Inserting null line at JJ/KK= ',jj,
     1           kk
         endif
 
c----------------------
c  skip to end of record
         call trcskp(jj,ne+1,ntrc,luin,ntrc,itr)
c----------------------
 
 1000    continue
c-----
c     close data files
c-----
 999     continue
      enddo

c======================================================================
c Do the TEASE
	call maxv(ampl,1,mmax,lc,icounter)
	call minv(ampl,1,mmin,lc,icounter)
	
	do i=1,icounter
	aer(i)=abs((mmax-mmin)*pcnt)
	ampl(i)=ampl(i)/aer(i)
	offset(i,1)=offset(i,1)/aer(i)
	offset(i,2)=offset(i,2)/aer(i)
	offset(i,3)=offset(i,3)/aer(i)
	enddo
c======================================================================
	call inverse(icounter,offset,GG)
	call crv(icounter,GG,ampl,coef)
	call cov(GG,covmat,icounter)
c======================================================================
c write the output
	vtmp=0.
	norm=abs(coef(1))

c         write (luout,222) vtmp,(coef(1))/norm
c data

	write(luout,*)'"Data'
        do i=1,icounter
        write(luout,222)offset(i,2)*aer(i),ampl(i)*aer(i)/norm
        enddo
        write(6,223)


c model curve
	write(luout,*)'"Model Curve'
	do i=1,icounter
	x=offset(i,2)*aer(i)
	z=(coef(1)+coef(2)*x+coef(3)*(x*x))/norm
	write(luout,222)x,z
	enddo
	
	write(6,223)

222	format(3x,f9.2,3x,e12.5)
223	format(/)

c======================================================================
c Do the Confidence interval courtesy of Don Adams

	call confintvl(ci,coef,aer,offset,ampl,icounter)
c======================================================================
c write the output

	write(luout,*)'"+ C.I.'
	do i=1,icounter
	x=offset(i,2)*aer(i)
	z=((coef(1)+coef(2)*x+coef(3)*(x*x))+ci(i))/norm
	write(luout,222)x,z
	enddo

	write(6,223)

	write(luout,*)'"- C.I.'
	do i=1,icounter
	x=offset(i,2)*aer(i)
	z=((coef(1)+coef(2)*x+coef(3)*(x*x))-ci(i))/norm
	write(luout,222)x,z
	enddo

c======================================================================
 
      write(LERR,*)'end of tease, processed',nrec,' record(s)',
     :     ' with ',ntrc, ' traces'
 
      call lbclos ( luin )
      close (luout)

      write(LER,*) 'TEASE: Normal Completion'
      write(LERR,*) 'TEASE: Normal Completion'
	goto 44
 
990   write(LERR,*) ' '
      write(LERR,*) 'TEASE: error opening pick file'
      write(LERR,*) '        check spelling/existence'
      write(LERR,*) 'FATAL'
      write(LER,*) ' '
      write(LER,*) 'TEASE: error opening pick file'
      write(LER,*) '        check spelling/existence'
      write(LER,*) 'FATAL'

44    end
c=====================================================================
      subroutine cmdln (ntap,ptap,otap,ns,ne,irs,ire,nb,hdrwd,head,
     : graph,iwin,itm,track,pos,negi,maa,itwd,verbos,mnemonic )

#include <f77/iounit.h>

      integer     ns, ne, irs, ire,itm
      integer     argis,iwin


      character   ntap*(*), ptap*(*), mnemonic*(*), hdrwd*(*), otap*(*)

      logical     verbos, track, pos, nb, negi, maa,head, graph


      head=(argis('-head') .gt. 0)
      call argstr( '-hw', hdrwd, 'RecNum', 'RecNum' )
      nb =   (argis('-nb') .gt. 0)
      call argi4 ( '-ne', ne ,   0  ,  0    )
      call argi4 ( '-ns', ns ,   0  ,  0    )
      call argi4 ( '-re', ire ,   0  ,  0    )
      call argi4 ( '-rs', irs ,   0  ,  0    )
      maa=(argis('-maa') .gt. 0)
      pos=(argis('-max') .gt. 0)
      negi=(argis('-min') .gt. 0)
      call argstr( '-N', ntap, ' ', ' ' )
      call argstr( '-O', otap, '-99999', '-99999' )
      call argstr( '-P', ptap, '-99999', '-99999' )
      call argi4 ( '-t', itm,   0  ,  0    )
      verbos =   (argis('-V') .gt. 0)
      call argi4 ( '-w',iwin, 0, 0 )
      graph =   (argis('-x') .gt. 0)

	if (iwin .eq. 0) then
		track=.false.
		else
		track=.true.
	endif
      return
      end
c=====================================================================
      subroutine verbal (nsamp,dt_units,ntrc,nrec, ntap, ns, ne, 
     : ire,irs,otap, ptap,nb,hdrwd,iwin,itm,track,pos,negi,maa,itwd,
     :     mnemonic,graph)

#include <f77/iounit.h>
 
      integer     nsamp, ntrc, nrec, iwin, itm, ns, ne, irs, ire

      real        dt_units

      character   ntap*(*),  ptap*(*), otap*(*)
      character   mnemonic*(*)

      logical     nb, track, pos, negi, maa, graph
 
      write(LERR,*)' '
      write(LERR,*)' Input Line Header Parameters'
      write(LERR,*)' '
      length = lenth(ntap)
      if (length .gt. 0) then
        write(LERR,*) ' input data set name   =  ', ntap(1:length)
      else
        write(LERR,*) ' input data set        =  stdin'
      endif
      write(LERR,*) ' samples/trace         =  ', nsamp
      write(LERR,*) ' sample interval       =  ', dt_units
      write(LERR,*) ' traces per record     =  ', ntrc
      write(LERR,*) ' records per line      =  ', nrec
      write(LERR,*)' '
      write(LERR,*)' Command Line Parameters '
      write(LERR,*)' '
      length = lenth(ntap)
      if (length .gt. 0) then
        write(LERR,*) ' Input data set name  =  ', ntap(1:length)
      else
        write(LERR,*) ' Input data set       =  stdin'
      endif
      if ( otap(1:6) .ne. '-99999' ) then
         length = lenth(otap)
         write(LERR,*) ' Output data set name  =  ', otap(1:length)
      else
         write(LERR,*)' Output directed to stdout'
      endif
      length = lenth(ptap)
      if (length .gt. 0) then
        write(LERR,*) ' XSD pick file name    =  ', ptap(1:length)
      else
        write(LERR,*) ' XSD pick file         =  pipe'
      endif
      write(LERR,*) 'time of amplitude      =  ', itm
      if (itwd .gt. 0 ) then 
      write(LERR,*) ' Trace header word     =  ', itwd
      else
      write(LERR,*) ' Trace header mnemonic =  ', mnemonic
      endif
      if (track) then
                write(LERR,*) ' Length of tracking window= ',iwin
      endif
      if (pos) then
                write(LERR,*) ' Tracking positive amplitudes'
      else
                write(LERR,*) ' Tracking negative amplitudes'
      endif
      write(LERR,*) ' Start/End traces   =  ', ns,ne
      write(LERR,*) ' Start/End records  =  ', irs,ire
      write(LERR,*)' '
      write(LERR,*)' '
	if (graph) then
      write(LERR,*) ' '
      write(LERR,*) ' Output in xgraph format'
      write(LERR,*)' '
	endif
 
      return
      end
c---------------------------------------
c  online help section
c---------------------------------------
      subroutine help
#include <f77/iounit.h>
 
        write(LER,*)' '
        write(LER,*)'      COMMAND LINE ARGUMENTS FOR TEASE'
        write(LER,*)' '
        write(LER,*)'_Input___________Description___________(default)__'
        write(LER,*)'--------------------------------------------------'
        write(LER,*)'I/O Options: '
        write(LER,*)'-N[ntap]   -- input data set name          (stdin)'
        write(LER,*)'-O[otap]   -- output data set name        (stdout)'
        write(LER,*)'-P[ptap]   -- XSD Picks data set name   (optional)'
        write(LER,*)'--------------------------------------------------'
        write(LER,*)'Design window: (if -P[ptap] is not used)'
        write(LER,*)'-t[itm] -- time of amplitude retrieval      (none)'
        write(LER,*)'             (if -P[ptap] is not used)'
        write(LER,*)'-w[iwn] -- length of tracking window           (0)'
        write(LER,*)'           (if itw=0 retrieve values at itm)      '
        write(LER,*)'--------------------------------------------------'
        write(LER,*)'Output Format:'
        write(LER,*)'-hw[hdrwrd] -- Trace header word output (RecNum)'
        write(LER,*)'------------------------------------------------- '
        write(LER,*)'Trace/record limitation:'
        write(LER,*)'-ns[nst]   -- start process trc #       (first tr)'
        write(LER,*)'-ne[ned]   -- end process trc #          (last tr)'
        write(LER,*)'-rs[nrst]  -- start process rec #      (first rec)'
        write(LER,*)'-re[nred]  -- end process rec  #        (last rec)'
        write(LER,*)'--------------------------------------------------'
        write(LER,*)'Program Options:'
        write(LER,*)'-max Retrieve Maximum positive amplitudes         '
        write(LER,*)'-min Retrieve Minimum negative amplitudes         '
        write(LER,*)'-maa Retrieve Maximum absolute amplitudes         '
        write(LER,*)' '
        write(LER,*)'-head   use values in -hwxxxxx as retrieval time '
        write(LER,*)'        (-t[])  must use this option with -hwxxxxx'
        write(LER,*)' '
        write(LER,*)'-nb  No separation of output records'
        write(LER,*)' '
        write(LER,*)'-x   Output data in xgraph format'
        write(LER,*)'-V   verbos printout'
        write(LER,*)' '
        write(LER,*)'=================================================='
        write(LER,*)'Usage:'
        write(LER,*)'tease -N[] -O[] -P[] -ns[] -ne[] -rs[] -re[] -t[]'
        write(LER,*)'       -w[] -hw[]  [-max, -min, -maa, -nb, -head, '
        write(LER,*)'       -x, -V ]'
        write(LER,*)'=================================================='
        write(LER,*)' '
        write(LER,*)' '
 
      return
      end
c=====================================================================
c All the subroutines written by Don Adams and James Gridley
c October 1995
c=====================================================================
c******************************************************************************
c       
	subroutine inverse(n,offset,GG)
c******************************************************************************
c       
c	Subroutine to calculate the matrix to be multiplied with amplitude
c	matrix in order to produce the coefficients of the second order
c	polynomial
c       
c******************************************************************************
c       
c	Local Variables
c       offsetT(3,1..n)= transpose of the offset array
c       prodoff(3,3) = product of the transpose-offset and offset
c       invoff(3,3) = the inverse of prodoff
c       
c	Main Variables
c       offset(1..n,3) = array of x offsets input into the program 
c	offset(1..n,1) = 1
c	offset(1..n,2) = x
c	offset(1..n,3) = x^2
c       n = true maximum number of elements in the array
c       GG(3,1..n) = an array containing the matrix to be multiplied with the 
c	amplitude matrix
c 	where coeff = (((offsetToffset)-1)offsetT)amp;
c       T = transpose; -1 = inverse
c       
c******************************************************************************
c       
	real offset(10000,3),GG(3,10000),offsetT(3,10000),prodoff(3,3)
	real invoff(3,3)
	integer n
c       
c       Set local variables to zero
c	
	do 800, i=1,3
	   do 810, j=1,10000
	      offsetT(i,j)=0.0d0
 810	   continue
	   do 820, j=1,3
	      prodoff(i,j)=0.0d0
	      invoff(i,j)=0.0d0
 820	   continue
 800	continue          
c       
	call Mattrans(offset,10000,3,offsetT,10000)
	call Matmult(offsetT,3,10000,offset,10000,3,prodoff,10000)
	call Matinv(prodoff,3,3,invoff)
	call Matmult(invoff,3,3,offsetT,3,10000,GG,10000)
	return
	end
c       
c******************************************************************************
c       
	subroutine crv(n,GG,amp,coeff)
c******************************************************************************
c       
c	Subroutine to calculate the coefficients of the second order polynomial
c	which best fits the data
c       
c******************************************************************************
c       
c	Main Variables
c       amp(1..n) = array of maximum amplitudes at each x offset
c       n = true maximum number of elements in the array
c       coeff(1..3) = array of coefficients of the parabolic equation fit to the data
c	coeff(1) = c
c	coeff(2) = b
c	coeff(3) = a
c	where amp=ax^2+bx+c
c       GG(3,1..n) = an array containing the matrix to be multiplied with the 
c	amplitude matrix
c 	where coeff = (((offsetToffset)-1)offsetT)amp;
c       T = transpose; -1 = inverse
c       
c******************************************************************************
c       
	real amp(10000), coeff(3), GG(3,10000)
	integer n
	call Matmult(GG,3,n,amp,n,1,coeff,10000)
	return
	end
c       
c******************************************************************************
c       
        subroutine cov(GG,covmat,n)
c       
c******************************************************************************
c       
c	Subroutine to calculate the covariance matrix for the coefficient
c	matrix
c       
c******************************************************************************
c       
c	Local Variables
c       GGT(n,3) = transpose of GG
c       
c	Main Variables
c       GG(3,1..n) = an array containing the matrix to be multiplied with the 
c	amplitude matrix
c 	where coeff = (((offsetToffset)-1)offsetT)amp;
c       T = transpose; -1 = inverse
c       covmat(3,3) = covarance matrix for the coefficient matrix
c       n = true maximum number of elements in the array
c       
c******************************************************************************
c       
	real GG(3,10000), covmat(3,3), GGT(10000,3)
	integer n
c       
c       Set local variables to zero
c       
	do 900, i=1,3
	   do 910,j=1,10000
	      GGT(j,i)=0.0d0
 910	   continue
 900	continue
c       
	call Mattrans(GG,3,10000,GGT,10000)
	call Matmult(GG,3,10000,GGT,10000,3,covmat,10000)
	return
	end
c       
c******************************************************************************
c       
c**************************************************************************
c       
        subroutine confintvl(ci,coeff,aer,offset,amp,n)
c       
c**************************************************************************
c       
c       Subroutine to calculate the confidence interval for the best fit
c       polynomial at 99.9% confidence.
c       
c       Based on the equations for the confidence interval of a first-order
c       polynomial fit to noisy data. The equation was extended to work with
c       a second order polynomial.
c       
c       Reference
c       Miller, I., and J. E. Freund, 1985, Probability and statistics for 
c       Engineers, Third Edition, Prentice-Hall Inc. Englewood Cliffs, NJ
c       p. 290 - 331.
c       
c**************************************************************************
c       
c       Main Variables
c       
c       ci = array of 80% confidence interval for the data
c       coeff(1..3) = array of coefficents of the second-order polynomial equation
c       fit to the data
c       coeff(1) = c
c       coeff(2) = b
c       coeff(3) = a
c       where amp=ax^2+bx+c
c       aer = array of assumed data errors
c       offset(1..n,1..3) = array of x offsets input into the program
c       offset(1..n,1) = 1
c       offset(1..n,2) = x
c       offset(1..n,3) = x^2
c       amp(1..n) = array of amplitude at each offset
c       n = number of data points
c       
c       Local Variables
c       
c       mean = mean value of x
c       Se = Standard Error
c       Sxx = Sum of squares in x
c       talpha = value of the student t distribution for 99.9% confidence interval
c       sumx = the sum of the x offsets squared
c       sum2x = the sum of the squared x offsets
c       
c***************************************************************************
c       
	integer n, i
	real coeff(3),offset(10000,3),aer(10000),amp(10000),ci(10000)
	real mean,Se,Sxx,talpha,sumx,sum2x,D,M,nr
c       
c       Set Local Variables to zero
c       
	mean = 0.0d0
	Se = 0.0d0
	Sxx = 0.0d0
	sumx = 0.0d0
	sum2x = 0.0d0
	D = 0.0d0
	M = 0.0d0
	nr = 1.0d0/real(n)
	if (n-3 .le. 1) talpha=636.619d0
	if (n-3 .eq. 2) talpha=31.598d0
	if (n-3 .eq. 3) talpha=12.924d0
	if (n-3 .eq. 4) talpha=8.610d0
	if (n-3 .eq. 5) talpha=6.869d0
	if (n-3 .eq. 6) talpha=5.959d0
	if (n-3 .eq. 7) talpha=5.408d0
	if (n-3 .eq. 8) talpha=5.041d0
	if (n-3 .eq. 9) talpha=4.781d0
	if (n-3 .eq. 10) talpha=4.587d0
	if (n-3 .eq. 11) talpha=4.437d0
	if (n-3 .eq. 12) talpha=4.318d0
	if (n-3 .eq. 13) talpha=4.221d0
	if (n-3 .eq. 14) talpha=4.140d0
	if (n-3 .eq. 15) talpha=4.073d0
	if (n-3 .eq. 16) talpha=4.015d0
	if (n-3 .eq. 17) talpha=3.965d0
	if (n-3 .eq. 18) talpha=3.922d0
	if (n-3 .eq. 19) talpha=3.883d0
	if (n-3 .eq. 20) talpha=3.850d0
	if (n-3 .eq. 21) talpha=3.819d0
	if (n-3 .eq. 22) talpha=3.792d0
	if (n-3 .eq. 23) talpha=3.76710
	if (n-3 .eq. 24) talpha=3.745d0
	if (n-3 .eq. 25) talpha=3.725d0
	if (n-3 .eq. 26) talpha=3.707d0
	if (n-3 .eq. 27) talpha=3.690d0
	if (n-3 .eq. 28) talpha=3.674d0
	if (n-3 .eq. 29) talpha=3.659d0
	if ((n-3 .ge. 30) .and. (n-3 .lt. 35.5)) talpha=3.646d0
	if ((n-3 .ge. 35.5) .and. (n-3 .lt. 50.5)) talpha=3.551d0
	if ((n-3 .ge. 50.5) .and. (n-3 .lt. 90.5)) talpha=3.460d0
	if ((n-3 .ge. 90.5) .and. (n-3 .le. 239.5)) talpha=3.373d0
	if (n-3 .gt. 239.5) talpha=3.291d0
c       
c       Find the mean value of x
c       
	do 1000, i=1, n
	   sumx = sumx + offset(i,2)*aer(i)
 1000	continue
	mean = sumx/real(n)
	sumx = sumx**2.0
c       
c       Calculate Sxx
c       
	do 1010, i=1, n
	   sum2x = sum2x + ((offset(i,2)*aer(i))**2.0)
 1010	continue
	Sxx = (real(n)*sum2x)-sumx
c       
c       Calculate the standard error of the estimate
c
	do 1020, i=1, n
	   D = offset(i,2)*aer(i)
	   M = amp(i)*aer(i)
	   Se = Se + (M-(coeff(1)+coeff(2)*D+coeff(3)*(D**2)))**2.0
 1020	continue
	Se = (Se/(real(n)-3.0d0))**0.5
c       
c       Calculate the confidence intervals
c       
	do 1030, i=1, n
	   D = offset(i,2)*aer(i)
	   ci(i)=talpha*Se*((nr+((real(n)*((D-mean)**2))/Sxx))**0.5d0)
 1030	continue
	return
	end
c       
c***************************************************************************
c       
	subroutine mattrans(x,n,m,xt,maxdim)
c==============================================================
c       Subroutine MATTRANS to calculate the transpose of a matix
c       and return both the original and transposed matrices.
c       
c	Written by James M. Gridley
c	Fall 1989
c	University of Texas at El Paso
c       
c-------------------------------------------------------------
c       
c       Where
c       
c	x = Matrix of (n x m) to be transposed.
c       
c	n = Number of rows of matrix x.
c       
c	m = Number of columnss of matrix x.
c       
c  maxdim = Dimension of matrix x in original program.
c       
c       xt = Matrix of (m x n) transposed from matrix x (n x m).
c       
c==============================================================
	
	real xt(m,n),x(n,m)
	integer j,n,m,i
	
	do 300 i=1,n
	  do 310 j=1,m
	     xt(j,i)=x(i,j)
 310	  continue
 300	continue 
	return
	end
c******************************************************************************
	subroutine matmult(x,n1,m1,y,n2,m2,z,maxdim)
c================================================================
c       Subroutine MATMULT to multiply two matrices and return the 
c       three matrices to the calling program.
c       
c	Written by James Gridley
c  	Fall 1989
c	University of Texas at El Paso
c       
c---------------------------------------------------------------
c       
c       Where
c	
c	x = Matrix (n1 x m2) to be multiplied, with original
c       dimension in calling program of maxdim.
c       
c	y = Matrix (n2 x m2) to be multiplied, with original
c       dimension in calling program of maxdim.
c       
c	z = Matrix (n1 x m2) which is the product of matrices
c       x and y.  Its dimension is that of the matrices
c       x and y in the original calling program.
c       
c================================================================
	dimension z(n1,m2),x(n1,m1)
	dimension y(n2,m2)
	real tmp
	integer i,j,k,n1,m1,n2,m2
	tmp=0.
	do 430 i=1,n1
	   do 420 j=1,m2
	      tmp=0.
	      do 410 k=1,m1
		 tmp=x(i,k)*y(k,j)+tmp
 410	      continue
	      z(i,j)=tmp 
 420	   continue
 430	continue
	return
	end
c******************************************************************************
	subroutine matinv(a,n,np,z)
c============================================================
c       Subroutine MATINV to calculate the inverse of a matrix
c       using LU decomposition.
c       
c       Created by James M. Gridley 
c       Fall 1989
c       University of Texas at El Paso
c       
c       Modified from Numerical Recipes
c       
c       -----------------------------------------------------------
c       
c       Where
c       
c       a= Matrix (n x n) to be inverted and 
c       originally dimensioned in the main
c       program as a(np,np).
c       
c       n= Lenth of matrix a. Only one number is
c       needed since the matrix must be square.
c       
c       np= Dimension of a in original calling
c       program. MAXDIM
c       
c       z= Inverted matrix solution (n x n)	
c       with dimensions (np,np) as in the 
c       original calling program.
c       
c       
c------------------------------------------------------------
c       
c	Subroutine MATINV will call the following routines
c       
c       LUDCMP(A,n,np,indx,d)
c       
c       LUBKSB(A,n,np,indx,y(1,j),j,z)
c       
c------------------------------------------------------------
c       
c	SAMPLE CALL:
c       
c       CALL MATINV(a,3,100,z)
c       
c------------------------------------------------------------
c       
c       NOTE:
c 	The subroutine will return the original matrix a
c	upon return from the inversion process.
c       
c       Note: arrays y, indx, and temp are variable dimension arrays with the
c       dimension np. These arrays have a fixed dimension here in order to
c       avoid a compiler problem.
c============================================================
	
	integer n,np
	dimension a(np,np),y(3,3),indx(3),z(np,np),temp(3,3)
	
 	do 512 i=1,n
	   do 511 j=1,n
	      y(i,j)=0.
	      temp(i,j)=a(i,j)
 511	   continue
	   y(i,i)=1.
 512	continue
	
	call ludcmp(temp,n,np,indx,d)
	
	do 513 j=1,n
	   call lubksb(temp,n,np,indx,y(1,j),j,z)
 513	continue
	return
	end
c==========================================================
	subroutine ludcmp(a,n,np,indx,d)
	
c       
c       Subroutine to do the LU decomposition of matrix a
c       
c       Note: array vv is a variable dimension array with the
c       dimension np. This array has a fixed dimension in order to
c       avoid a compiler problem.
c       
	parameter (tiny=1.0E-20)
	dimension a(np,np),indx(n),vv(3)
	d=1.
	do 612 i=1,n
	   aamax=0.
	   do 611 j=1,n
	      if (abs(a(i,j)) .GT. aamax) aamax=abs(a(i,j))
 611	   continue
	   if (aamax .eq. 0.) write(LERR,*) 'Singular Matrix'
	   if (aamax .eq. 0.) write(LER,*) 'Singular Matrix'
	   vv(i)=1./aamax
 612	continue
	do 619 j=1,n
	   do 614 i=1,j-1
	      sum=a(i,j)
	      do 613 k=1,i-1
		 sum=sum-a(i,k)*a(k,j)
 613	      continue
	      a(i,j)=sum
 614	   continue
	   aamax=0.
	   do 616 i=j,n
	      sum=a(i,j)
	      do 615 k=1,j-1
		 sum=sum-a(i,k)*a(k,j)
 615	      continue
	      a(i,j)=sum
	      dum=vv(i)*abs(sum)
	      if (dum .ge. aamax) then
		 imax=i
		 aamax=dum
	      endif
 616	   continue
	   if (j .ne. imax) then
	      do 617 k=1,n
		 dum=a(imax,k)
		 a(imax,k)=a(j,k)
		 a(j,k)=dum
 617	      continue
	      d=-d
	      vv(imax)=vv(j)
	   endif
	   indx(j)=imax
	   if(a(j,j) .eq. 0.) a(j,j)=tiny
	   if (j .ne. n) then
	      dum=1./a(j,j)
	      do 618 i=j+1,n
		 a(i,j)=a(i,j)*dum
 618	      continue
	   endif
 619	continue
	return
	end
c========================================================
	subroutine lubksb(a,n,np,indx,b,jj,z)
	
c       
c       Subroutine to back-substitute from the LU decomposition
	dimension a(np,np),indx(n),b(n),z(np,np)
	ii=0
	do 712 i=1,n
	   ll=indx(i)
	   sum=b(ll)
	   b(ll)=b(i)
	   if (ii .ne. 0) then
	      do 711 j=ii,i-1
		 sum=sum-a(i,j)*b(j)
 711	      continue
	   else if (sum .ne. 0.) then
	      ii=i
	   endif
	   b(i)=sum
 712	continue
	do 714 i=n,1,-1
	   sum=b(i)
	   if (i .lt. n) then
	      do 713 j=i+1,n
	sum=sum-a(i,j)*b(j)
 713	continue
	endif
	b(i)=sum/a(i,i)
	z(i,jj)=b(i)
 714	continue
	return
	end
