C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c ---- ---- ---- tfdnoise ---- ---- ---- ---- ---- ---- ---- ---- ----
c
c routine to balance out isolated outlyer spikes from seismic data
c using tf transform implimented using stft running windows with
c a user defined trace aperture.  If the amplitude in any subband
c passes a threshold value then the median of the subband is found
c for all traces in the aperture [for that sample position] and the
c value at the operator trace is replace my the median
c
c ---- ---- ---- ---- ----  ---- ---- ---- ---- ---- ---- ---- ---- ----

c     Program Changes:
c
c March 12, 2003: - bug fix....Larry Adorjan [Kelman] found a bug in the GetThreshold
c                   routine that would result in garbage being used for the median 
c                   calculation in a case where the min subband was greater than 
c                   one.  This has been fixed.  Good thing for the FreeUSP community
c                   of programmers.
c Garossino
c
c Jan 24, 2001 : - bug fix...found that -ist sample was coming out zero.  Fixed the
c                  indexing in the inverse_stft.F routine to start at ist+1 for nsamp-1
c Garossino
c
c Jan 15, 2001 : - add ability to limit onset of median derivation AND threshold 
c Garossino        detection by a horizon time stored in any valid USP trace 
c                  header slot.  An additional bias was added as well for flexibility.
c                  Requested by Marty and Deedee Albertin.
c
c                  I also finally found and fixed the bug in the start time logic as
c                  well as added a policeman to stop the program if the user tries to
c                  use too small a window of data.  That is does not allow enough 
c                  data in the window to accomodate the stft sample window roll off
c                  on the top and bottom of the zone of interest.
c
c Nov 2, 2000 : - corrected unpacking logic to put all frequency estimates in the
c Garossino       proper order for filtering.  The initial subband comes from
c                 the real part of the first estimate.  The last subband similarly
c                 from the real part of the last estimate.  We now have N/2+1 subbands
c                 instead of N/2.
c
c               - added -minsb[] and -maxsb[] command line control to help speed things
c                 up when you know the noise is subbanded.
c
c               - added -roll option to allow the median search window to roll into and
c                 out of records.  This helps with the edge effect when -twin[] is
c                 large.  The trade-off is that glitches near the edges of records
c                 may not be as well attenuated.
c
c               - was getting a ieee underflow error associated with the mathadv library
c                 routines.  When I copied the source into this directory and compiled
c                 inline the problem went away.  I am using that solution for now and 
c                 will get with Joe Wade to see what is up with the mathadv libary.
c
c -------------
c      - original written: August 2000 [P.G.A. Garossino]
c      - reference  US patent US05850622 - Vassiliou, Garossino

      implicit none

c get machine dependent parameters 

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h> 

c dimension standard USP variables 

      integer     itr( 2*SZLNHD )
     
      integer     nsamp, ntrc, nrec, nsi, iform
      integer     luin, luout
      integer     lbytes, nbytes, lbyout, obytes
      integer     irs, ire, ns, ne, ist, iend, argis
      integer     JJ, KK, jerr

      real        tri( 2*SZLNHD )
      real        UnitSc

      character   ntap*255, otap*255, name*8

      logical     verbos

c Program Specific _ dynamic memory variables

      integer errcd1, errcd2, errcd3, errcd4, errcd5, errcd6, errcd7
      integer errcd8, errcd9, abort
      integer Headers, StartSample
      integer hdrsize, tfsize, ctrisize, recsize, wrksize, startsize

      real Amplitude, out_Amplitude, Phase
      real Workspace, Record, MedSearch

      complex  ctri

      pointer ( mem_ctri, ctri(2) )
      pointer ( mem_Headers, Headers(2) )
      pointer ( mem_Amplitude, Amplitude(2) )
      pointer ( mem_out_Amplitude, out_Amplitude(2) )
      pointer ( mem_Phase, Phase(2) )
      pointer ( mem_Workspace, Workspace(2) )
      pointer ( mem_Record, Record(2) )
      pointer ( mem_MedSearch, MedSearch(2) )
      pointer ( mem_StartSample, StartSample(2) )

c Program Specific _ static memory variables

      integer nwin_samp, nwin_trace
      integer ifmt_StaCor,l_StaCor,ln_StaCor
      integer nu, ordfft, nwin_samp2, nf
      integer i, ia, nf2, tr_index, hdr_index
      integer ifmt_HdrWrd,l_HdrWrd,ln_HdrWrd,HdrWrd
      integer ifmt_IstWrd,l_IstWrd,ln_IstWrd,IstWrd
      integer last_HdrWrd, min_sub_band, max_sub_band

      real threshold, threshold_multiplier, global_threshold
      real sigma, sigma2, pi, spi, r_IstWrd, bias
      real  w( SZLNHD )

      character c_HdrWrd*6, c_IstWrd*6

      logical new_rec, roll

c ieee exception handling.....uncomment if needed and add fieee.F to the Makefile
c      integer killit, ieeer, ieee_handler
c      external function killit
c      ieeer = ieee_handler ( 'set', 'all', killit)

c Initialize variables

      data abort/0/
      data name/"TFDNOISE"/
      data new_rec/.false./

c give command line help if requested

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif

c open printout file

#include <f77/open.h>

c get command line input parameters

      call cmdln ( ntap, otap, ns, ne, irs, ire, ist, iend, 
     :     name, nwin_samp, nwin_trace, threshold_multiplier, 
     :     global_threshold, c_HdrWrd, min_sub_band, max_sub_band,
     :     roll, c_IstWrd, bias, verbos )

      threshold = global_threshold

c open input and output files

      call getln ( luin , ntap,'r', 0 )
      call getln ( luout, otap,'w', 1 )

c  read input line header and save certain parameters

      call rtape(luin,itr,lbytes)
      if(lbytes.eq.0)then
         write(LER,*)'TFDNOISE: no line header on input dataset',ntap
         write(LER,*)'FATAL'
         stop
      endif

c get global parameters from line header

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'UnitSc', UnitSc, LINHED)

      if (UnitSc .eq. 0.0) then
         write(LERR,*)'********************************************'
         write(LERR,*)'WARNING: sample unit scaler in LH = ',UnitSc
         write(LERR,*)'         will set to .001 (millisec default)'
         write(LERR,*)'********************************************'
         UnitSc = .001
         call savew(itr, 'UnitSc', UnitSc, LINHED)
      endif

c define Trace Header pointers

      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu(c_HdrWrd,ifmt_HdrWrd,l_HdrWrd,ln_HdrWrd,TRACEHEADER)
      if ( c_IstWrd .ne. ' ' ) 
     :     call savelu(c_IstWrd,ifmt_IstWrd,l_IstWrd,ln_IstWrd,
     :     TRACEHEADER)

c print historical line header to printout file 

      call hlhprt (itr, lbytes, name, 8, LERR)

c check user supplied boundary conditions and set defaults

      if ( irs .eq. 0 ) irs = 1
      if ( ire .eq. 0 .or. ire .gt. nrec ) ire = nrec

      if ( ns .eq. 0 ) ns = 1
      if ( ne .eq. 0 .or. ne .gt. ntrc ) ne = ntrc

c in USP time zero is sample 1

      ist = nint ( float(ist) / float(nsi) ) + 1 
      iend = nint ( float(iend) / float(nsi) ) + 1

      if ( ist .eq. 0 ) ist = 1
      if ( iend .le. ist .or. iend .gt. nsamp ) iend = nsamp

c update historical line header for the current command line entries and
c write to output file

      call savhlh  ( itr, lbytes, lbyout )
      call wrtape ( luout, itr, lbyout )

c define output trace length in bytes

      obytes = SZTRHD + SZSMPD * nsamp 

c I am using a minimum sampling window size of 32 as that is the smallest window
c I have found that allows a decent inverse.  Window sizes smaller than 32 result
c in a lot of lost energy on the inverse due to the effects of the Gaussian.

      if ( nwin_samp .lt. 32 ) nwin_samp = 32

c Policeman: make sure that the amount of data under consideration allows for
c            enough data to do the transform.  If not, warn the user and bail.

      if ( nsamp .lt. (2*nwin_samp+1) .or.
     :     (iend - ist +1 ) .lt. (2*nwin_samp+1) ) then
         write(LERR,*)' '
         write(LERR,*)' The requested processing window is smaller than'
         write(LERR,*)' the minimum required for the time frequency '
         write(LERR,*)' transform to be formed [',(2*nwin_samp+1),']'
         write(LERR,*)' Decrease -ist[] or increase -iend[] or both'
         write(LERR,*)'FATAL' 
         write(LER,*)' '
         write(LER,*)'TFDNOISE: '
         write(LER,*)' The requested processing window is smaller than '
         write(LER,*)' the minimum required for the time frequency '
         write(LER,*)' transform to be formed [',(2*nwin_samp+1),']'
         write(LER,*)' Decrease -ist[] or increase -iend[] or both'
         write(LER,*)'FATAL' 
         write(LER,*)' '
         stop
      endif

c determine next power of 2 for window and number of frequencies to generate

      nu = ordfft ( nwin_samp )
      nwin_samp2 = 2 ** nu
      nf = nwin_samp2 / 2

c check application subband constraints

      if ( max_sub_band .eq. 0 ) max_sub_band = nf +  1
      if ( max_sub_band .gt. ( nf + 1 ) ) max_sub_band = nf + 1

c setup the Gaussian sampling window

      sigma = float(nwin_samp) / ( 2. * 3. )
      sigma2 = 2. * sigma**2
      pi = acos(-1.)
      nf2 = nf + 1
      spi = 1. / ( sqrt(2. * pi) * sigma )

      do i = 1, nwin_samp2
         ia = i - nf2
         w ( i ) = spi * exp ( - ( float(ia) )**2 / sigma2 )
      enddo
         
c verbose output of all pertinent information before processing begins

      call verbal( ntap, otap, nsamp, ntrc, nrec, nsi, iform, UnitSc, 
     :     irs, ire, ns, ne, ist, iend, nwin_samp, nwin_trace, 
     :     threshold_multiplier, global_threshold, nf, c_HdrWrd, 
     :     min_sub_band, max_sub_band, roll, c_IstWrd, bias, verbos)

c dynamic memory allocation:  

      hdrsize = ITRWRD * ntrc
      ctrisize = (nf+1) * 4 
      tfsize = ntrc * nsamp * (nf+1)
      recsize = ntrc * nsamp
      wrksize = max0(nsamp,nwin_trace) * 2
      startsize = ntrc

      call galloc ( mem_Headers , hdrsize * SZSMPD, errcd1, abort )
      call galloc ( mem_ctri , ctrisize * SZSMPD, errcd2, abort )
      call galloc ( mem_Amplitude, tfsize * SZSMPD, errcd3, abort )
      call galloc ( mem_out_Amplitude, tfsize * SZSMPD, errcd4, abort )
      call galloc ( mem_Phase, tfsize * SZSMPD, errcd5, abort )
      call galloc ( mem_Workspace, wrksize * SZSMPD, errcd6, abort )
      call galloc ( mem_Record, recsize * SZSMPD, errcd7, abort )
      call galloc ( mem_MedSearch, recsize * SZSMPD, errcd8, abort )
      call galloc ( mem_StartSample, recsize * SZSMPD, errcd9, abort )
    
      if ( errcd1 .ne. 0 .or. 
     :     errcd2. ne. 0 .or. 
     :     errcd3. ne. 0 .or. 
     :     errcd4. ne. 0 .or. 
     :     errcd5. ne. 0 .or. 
     :     errcd6. ne. 0 .or. 
     :     errcd7. ne. 0 .or. 
     :     errcd8. ne. 0 .or. 
     :     errcd9. ne. 0 ) then
         write(LERR,*)' '
         write(LERR,*)' Unable to allocate workspace:'
         write(LERR,*) ctrisize * SZSMPD, ' bytes '
         write(LERR,*) 3 * tfsize * SZSMPD, ' bytes '
         write(LERR,*) hdrsize * SZSMPD, ' bytes '
         write(LERR,*) 2 * recsize * SZSMPD, ' bytes '
         write(LERR,*) wrksize * SZSMPD, ' bytes '
         write(LERR,*) startsize * SZSMPD, ' bytes '
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)' TFDNOISE: Unable to allocate workspace:'
         write(LER,*) ctrisize * SZSMPD, ' bytes '
         write(LER,*) 3 * tfsize * SZSMPD, ' bytes '
         write(LER,*) hdrsize * SZSMPD, ' bytes '
         write(LER,*) wrksize * SZSMPD, ' bytes '
         write(LER,*) 2 * recsize * SZSMPD, ' bytes '
         write(LER,*) startsize * SZSMPD, ' bytes '
         write(LER,*)' '
         goto 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) ctrisize * SZSMPD, ' bytes '
         write(LERR,*) 3 * tfsize * SZSMPD, ' bytes '
         write(LERR,*) hdrsize * SZSMPD, ' bytes '
         write(LERR,*) wrksize * SZSMPD, ' bytes '
         write(LERR,*) 2 * recsize * SZSMPD, ' bytes '
         write(LERR,*) startsize * SZSMPD, ' bytes '
         write(LERR,*)' '
      endif

c initialize memory

      call vclr (Headers, 1, hdrsize)
      call vclr (ctri, 1, ctrisize)
      call vclr (Amplitude, 1, tfsize)
      call vclr (out_Amplitude, 1, tfsize)
      call vclr (Phase, 1, tfsize)
      call vclr (Workspace, 1, wrksize)
      call vclr (Record, 1, recsize)
      call vclr (MedSearch, 1, recsize)

c BEGIN PROCESSING 

c pass down to start record

      call recrw ( 1, irs-1, luin, ntrc, itr, luout, nbytes )

      DO JJ = irs, ire
 
c pass down to start trace

         call trcrw ( JJ, 1, ns-1, luin, ntrc, itr, luout, nbytes )

c initialize StartSample[] memory for this record

         do i = 1, ntrc
            StartSample(i) = ist
         enddo

c initialize input trace and header array indices

         tr_index = 1 - nsamp
         hdr_index = 1 - ITRWRD
         new_rec = .false.

         DO KK = ns, ne

            tr_index = tr_index + nsamp
            hdr_index = hdr_index + ITRWRD

c read a trace

            nbytes = 0
            call rtape( luin, itr, nbytes)

c if end of data encountered (nbytes=0) then bail out

            if(nbytes .eq. 0) then
               write(LERR,*)'Premature EOF on input at:'
               write(LERR,*)'sequential rec= ',JJ,'  trace= ',KK
               go to 999
            endif

            call vmov ( itr(ITHWP1), 1, Record(tr_index), 1, nsamp )
            call vmov ( itr, 1, Headers(hdr_index), 1, ITRWRD )

c watch record indexing so that a new threshold is only calculated when
c a new record is encountered.  This prevents seams within a record caused
c by multiple thresholds when using utop to reduce memory requirements.
c Of course if using a global threshold this is not required as a single 
c user defined threshold will be used for the entire dataset.

            if ( KK .eq. ns .and. global_threshold .eq. 0.0 ) then

               call saver2( itr, ifmt_HdrWrd, l_HdrWrd, ln_HdrWrd, 
     :              HdrWrd, TRACEHEADER )

               if ( JJ .eq. 1 ) then
                  last_HdrWrd = HdrWrd
                  new_rec = .true.
               else
                  if ( HdrWrd .ne. last_HdrWrd ) then
                     new_rec = .true.
                     last_HdrWrd = HdrWrd
                  endif
               endif

            endif

c pick up any user defined start analysis and processing limits in a 
c format independant fashion from the trace header

            if ( c_IstWrd .ne. ' ' ) then

c  float or fake float

               if ( ifmt_IstWrd .eq. SAVE_FLOAT_DEF .or. 
     :              ifmt_IstWrd .eq. SAVE_FKFLT_DEF ) then 
                  call saver2( itr, ifmt_IstWrd, l_IstWrd, ln_IstWrd, 
     :                 r_IstWrd, TRACEHEADER )
                  StartSample(KK) = 
     :                 nint( ( r_IstWrd + bias ) / float(nsi) ) + 1
               endif

c  short int or long int

               if ( ifmt_IstWrd .eq. SAVE_SHORT_DEF .or. 
     :              ifmt_IstWrd .eq. SAVE_LONG_DEF ) then
                  call saver2( itr, ifmt_IstWrd, l_IstWrd, ln_IstWrd, 
     :                 IstWrd, TRACEHEADER )
                  StartSample(KK) = 
     :                 nint( ( float(IstWrd) + bias ) / float(nsi) ) + 1
               endif

            endif

         ENDDO

c echo user defined start time if requested

         if ( verbos .and. c_IstWrd .ne. ' ' ) then

            write(LERR,*) ' '
            write(LERR,*) ' Trace Header Start Requested '
            write(LERR,*) ' '
            write(LERR,*) ' Trace        Units '
            write(LERR,*) ' ------       ----- '
            write(LERR,*) ' '
            do i = ns, ne
               write(LERR,*) i, 
     :              float(StartSample(i)) * float(nsi) + bias 
            enddo
         endif
         
C input record is now loaded, generate forward t-f spectrum over the 
c interval requested. 

         call forward_stft ( Headers, Record, Amplitude, Phase, 
     :        tri, Workspace, nsamp, ist, iend, nf, 
     :        nwin_samp, w, ctri, ntrc, ns, ne, 
     :        ifmt_StaCor, l_StaCor, ln_StaCor, verbos )

c auto determine threshold if necessary.  If using a global threshold
c this step will never get executed

         if ( new_rec ) then

            call GetThreshold( MedSearch, Amplitude, nsamp, ntrc, nf, 
     :           ist, iend, ns, ne, min_sub_band, max_sub_band, 
     :           StartSample, threshold )

            threshold = threshold * threshold_multiplier

         endif

         write(LERR,*)' Record = ',JJ,' ',c_HdrWrd,' = ',HdrWrd, 
     :        ' threshold = ',threshold

c filter the data over zone requested

         call TF_Filter ( Amplitude, nsamp, ntrc, nf, out_Amplitude, 
     :        nwin_trace, threshold, ns, ne, ist, iend, min_sub_band,
     :        max_sub_band, roll, workspace, wrksize, StartSample )

c construct inverse TF transform of filtered record

         call inverse_stft ( out_Amplitude, Phase, nsamp, nf, ntrc, 
     :        ns, ne, ist, iend, nwin_samp, ctri, Headers, Record, tri, 
     :        Workspace, w, ifmt_StaCor, l_StaCor, ln_StaCor, verbos )

c output filtered record

         tr_index = 1 - nsamp
         hdr_index = 1 - ITRWRD

         DO KK = ns, ne

            hdr_index = hdr_index + ITRWRD
            tr_index = tr_index + nsamp

            call vmov ( Headers(hdr_index), 1, itr, 1, ITRWRD )
            call vmov ( Record(tr_index), 1, itr(ITHWP1), 1, nsamp )

c output this trace

            call wrtape ( luout, itr, obytes )
               
         ENDDO
         
c pass to end of record

         call trcrw ( JJ, ne+1, ntrc, luin, ntrc, itr, luout, 
     :        nbytes )

      ENDDO

c pass to the end of the dataset

         call recrw ( ire+1, nrec, luin, ntrc, itr, luout, nbytes )

c close data files 

      call lbclos ( luin )
      call lbclos ( luout )

      write(LERR,*)' '
      write(LERR,*)'TFDNOISE: Normal Termination'
      write(LER,*)'TFDNOISE: Normal Termination'
      stop

 999  continue

      call lbclos ( luin )
      call lbclos ( luout )

      write(LERR,*)' '
      write(LERR,*)'TFDNOISE: ABNORMAL Termination'
      write(LER,*)'TFDNOISE: ABNORMAL Termination'
      stop
      end

c -----------------  Subroutine -----------------------

      subroutine help()

      implicit none

c provide terse online help [detailed help goes in man page]

#include <f77/iounit.h>

      write(LER,*)' '
      write(LER,*)'===================================================='
      write(LER,*)' '
      write(LER,*)' Command Line Arguments for tfdnoise:Time-Frequency'
      write(LER,*)' noise suppression'
      write(LER,*)' '
      write(LER,*)' For a more detailed description of these parameters'
      write(LER,*)' see the online man page using uman or see the man'
      write(LER,*)' page listing on the USP website.'
      write(LER,*)' '
      write(LER,*)'Input..........................................(def)'
      write(LER,*)' '
      write(LER,*)'-N[]    -- input data set                    (stdin)'
      write(LER,*)'-O[]    -- output data set                  (stdout)'
      write(LER,*)'-s[]    -- process start time (ms)               (1)'
      write(LER,*)'-e[]    -- process end time (ms)       (last sample)'
      write(LER,*)'-ns[]   -- process start trace                   (1)'
      write(LER,*)'-ne[]   -- process end trace            (last trace)'
      write(LER,*)'-rs[]   -- process start record                  (1)'
      write(LER,*)'-re[]   -- process end record          (last record)'
      write(LER,*)'-swin[] -- number of samples in analysis window (32)'
      write(LER,*)'-twin[] -- number of traces in analysis window   (5)'
      write(LER,*)'-tmult[]-- threshold multiplier                (1.0)'
      write(LER,*)'-hw[]   -- threshold update mnemonic        (RecNum)'
      write(LER,*)'-hwt[]  -- process start header mnemonic  (not used)'
      write(LER,*)'-bias[] -- process start time bias             (0.0)'
      write(LER,*)'-minsb[]-- start application sub band            (1)'
      write(LER,*)'-maxsb[]-- end application sub band       (swin/2+1)'
      write(LER,*)'-threshold -- global threshold   (auto thresholding)'
      write(LER,*)'-roll   -- median search window rolls off record'
      write(LER,*)' '
      write(LER,*)'-V      -- verbos printout'
      write(LER,*)' '
      write(LER,*)'Usage:'
      write(LER,*)'    tfdnoise -N[] -O[] -s[] -e[] -ns[] -ne[] -rs[]'
      write(LER,*)'            -re[] -swin[] -twin[] -tmult[] -hw[] '
      write(LER,*)'            [ -hwt[] -bias[] -minsb[] -maxsb[] '
      write(LER,*)'            -roll -threshold[] -V]'
      write(LER,*)' '
      write(LER,*)'===================================================='
      
      return
      end

c -----------------  Subroutine -----------------------

c pick up command line arguments 

      subroutine cmdln ( ntap, otap, ns, ne, irs, ire, ist, iend, 
     :     name, nwin_samp, nwin_trace, threshold_multiplier, 
     :     global_threshold, c_HdrWrd, min_sub_band, max_sub_band, 
     :     roll, c_IstWrd, bias, verbos )

      implicit none

#include <f77/iounit.h>

      integer ist, iend, ns, ne, irs, ire, argis, nwin_samp
      integer nwin_trace, min_sub_band, max_sub_band

      real threshold_multiplier, global_threshold, bias

      character  ntap*(*), otap*(*), name*(*), c_HdrWrd*6
      character c_IstWrd*6

      logical    roll, verbos

      call argr4 ( '-bias', bias, 0.0, 0.0 )

      call argi4 ( '-e', iend, 0, 0 )

      call argi4 ( '-maxsb', max_sub_band, 0, 0 )
      call argi4 ( '-minsb', min_sub_band, 1, 1 )

      call argstr ( '-hwt', c_IstWrd, ' ', ' ' ) 
      call argstr ( '-hw', c_HdrWrd, 'RecNum', 'RecNum' ) 

      call argi4 ( '-ne', ne, 0, 0 )
      call argi4 ( '-ns', ns, 0, 0 )
      call argstr ( '-N', ntap, ' ', ' ' ) 

      call argstr ( '-O', otap, ' ', ' ' ) 

      roll = (argis('-roll') .gt. 0)
      call argi4 ( '-re', ire, 0, 0 )
      call argi4 ( '-rs', irs, 0, 0 )

      call argi4 ( '-swin', nwin_samp, 32, 32 )
      call argi4 ( '-s', ist, 0, 0 )

      call argr4 ( '-threshold', global_threshold, 0.0, 0.0 )
      call argr4 ( '-tmult', threshold_multiplier, 1.0, 1.0 )
      call argi4 ( '-twin', nwin_trace, 5, 5 )

      verbos = (argis('-V') .gt. 0)

c check for extraneous arguments and abort if found to
c catch all manner of user typo's

      call xtrarg ( name, ler, .FALSE., .FALSE. )
      call xtrarg ( name, lerr, .FALSE., .TRUE. )

           
      return
      end

c -----------------  Subroutine -----------------------

c verbal printout of pertinent program particulars


      subroutine verbal ( ntap, otap, nsamp, ntrc, nrec, nsi, iform,
     :     UnitSc, irs, ire, ns, ne, ist, iend, nwin_samp, nwin_trace, 
     :     threshold_multiplier, global_threshold, nf, c_HdrWrd, 
     :     min_sub_band, max_sub_band, roll, c_IstWrd, bias, verbos )

      implicit none

#include <f77/iounit.h>

      integer nsamp, ntrc, nrec, nsi, iform, irs, ire, ns, ne, ist, iend
      integer nwin_samp, nwin_trace, nf
      integer min_sub_band, max_sub_band

      real UnitSc, threshold_multiplier, global_threshold, bias

      character  ntap*(*), otap*(*), c_HdrWrd*6, c_IstWrd*6

      logical roll, verbos

      write(LERR,*)' '
      write(LERR,*)' Input Line Header Parameters'
      write(LERR,*)' '
      write(LERR,*) ' input data set name   =  ', ntap
      write(LERR,*) ' samples per trace     =  ', nsamp
      write(LERR,*) ' traces per record     =  ', ntrc
      write(LERR,*) ' number of records     =  ', nrec
      write(LERR,*) ' data format           =  ', iform
      write(LERR,*) ' sample interval       =  ', nsi
      write(LERR,*)' '
      write(LERR,*)' '
      write(LERR,*)' Command Line Parameters '
      write(LERR,*)' '
      write(LERR,*) ' output data set name             =  ', otap
      write(LERR,*) ' processing start record          =  ', irs 
      write(LERR,*) ' processing end record            =  ', irs 
      write(LERR,*) ' processing start trace           =  ', ns
      write(LERR,*) ' processing end trace             =  ', ne
      write(LERR,*) ' processing sample start          = ', ist
      write(LERR,*) ' processing sample end            = ', iend
      write(LERR,*)' '
      write(LERR,*)' Transform Parameters '
      write(LERR,*)' '
      write(LERR,*) ' sample window size           = ', nwin_samp
      write(LERR,*) ' number of subbands           =  ', nf+1
      write(LERR,*)' '
      write(LERR,*)' Filter Parameters '
      write(LERR,*)' '
      write(LERR,*) ' trace window size           = ', nwin_trace

      if ( global_threshold .eq. 0.0 ) then
         write(LERR,*) ' threshold multiplier        =  ', 
     :        threshold_multiplier
         write(LERR,*) ' threshold update mnemonic   = ', c_HdrWrd
      else
         write(LERR,*) ' global threshold            =  ', 
     :        global_threshold
      endif

      write(LERR,*)' '
      if ( roll ) then
         write(LERR,*)' median search window rolls off record'
      else
         write(LERR,*)' median search window held static at'
         write(LERR,*)' record edges'
      endif
      write(LERR,*)' Start filtering subband         = ',min_sub_band
      write(LERR,*)' End filtering subband           = ',max_sub_band
      write(LERR,*)' '
      if ( c_IstWrd .ne. ' ' ) then
         write(LERR,*)' median search constrained by user start time'
         write(LERR,*)' taken from the USP trace header entry ',c_IstWrd
         write(LERR,*)' additional bias added         =', bias
      endif
      write(LERR,*)' '
      if ( verbos )  write(LERR,*) ' verbose printout requested'

      write(LERR,*)' '
      write(LERR,*)'========================================== '
      write(LERR,*)' '

      return
      end





