C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine AutoDetect ( stft_record, nsampo, nf, lustats, RecWrd,
     :     TrcWrd, mean, range, ratio, subband, statstap, lestats,
     :     Max_ratio, Min_ratio, Max_mean, Min_mean, 
     :     Max_range, Min_range, step_size, ist, iend )

#include <f77/iounit.h>
#include <f77/lhdrsz.h>

c declare variables passed from calling routine

      integer nsampo, nf, RecWrd, TrcWrd, lustats
      integer lestats, step_size, ist, iend

      real stft_record(nsampo,nf)
      real mean, range, ratio, subband
      real Max_ratio, Min_ratio, Max_mean, Min_mean
      real Max_range, Min_range

      character statstap*(*)

c declare local variables

      integer i, j, start, finish

      real min(SZLNHD), max(SZLNHD), sum

c set examination limits

      start = ist + nf 
      finish = iend + nf - 1

c auto detect sub-band to use

      do i = 1,nf
         max(i) = 0.0
         min(i) = 1.e30
      enddo

      do i = start, finish, step_size
         do j = 1, nf

            if ( stft_record(i - nf + 1,j) .gt. max(j) ) max(j) = 
     :           stft_record(i - nf + 1,j)
            if ( stft_record(i - nf + 1,j) .lt. min(j) ) min(j) =
     :           stft_record(i - nf + 1,j)

         enddo
      enddo            

      range = 0.0
      sum = 0.0
      mean = 0.0

      subband = 1.0

      do i = 1, nf

c   find max and min global

         sum = sum +  max(i) - min(i)

         if ( ( max(i) - min(i) ) .gt. range ) then 
            range = ( max(i) - min(i) )
            subband = float(i)
         endif
      enddo

      mean = sum / float(nf)
      ratio = range / mean

#ifdef SUNSYSTEM
      open(unit=lustats,file=statstap(1:lestats),status='unknown',
     :     fileopt='eof',err=999)
#else 
#ifdef CRAYSYSTEM
      open(unit=lustats,file=statstap(1:lestats),status='unknown',
     :     position='append',err=999)
#else
      open(unit=lustats,file=statstap(1:lestats),status='unknown',
     :     access='append',err=999)
#endif
#endif

c determine plotting limits for xsd display

      if ( mean .lt. Min_mean ) Min_mean = mean
      if ( mean .gt. Max_mean ) Max_mean = mean
      if ( range .lt. Min_range ) Min_range = range
      if ( range .gt. Max_range ) Max_range = range
      if ( ratio .lt. Min_ratio ) Min_ratio = ratio
      if ( ratio .gt. Max_ratio ) Max_ratio = ratio
        
      write(lustats,'(2i10,1x,4(e10.4,2x))') RecWrd, TrcWrd, mean, 
     :     range, ratio, subband

      close(lustats)
      
      return

 999  continue
      write(LERR,*) ' ' 
      write(LERR,*) ' TFSKILL: error opening statistics file: '
      write(LERR,*) '         check read/write permissions'
      write(LERR,*) '         and rerun'
      write(LERR,*) ' FATAL'        
      write(LER,*) ' ' 
      write(LER,*) ' TFSKILL: error opening statistics  file: '
      write(LER,*) '         check read/write permissions'
      write(LER,*) '         and rerun'
      write(LER,*) ' FATAL' 
      stop

      end

