C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine ReadPicks ( lupick, xsd_record, Trace, MinLimit,
     :     MaxLimit, ntrco, delta, min, Nfunc ) 

#include <f77/iounit.h>
#include <f77/lhdrsz.h>

c declare variable passed from calling routine

      integer lupick, xsd_record, ntrco

      real Trace(SZLNHD), MinLimit(SZLNHD), MaxLimit(SZLNHD)
      real delta, min

c declare local variables

      integer num_Maxpicks, num_Minpicks
      integer nrec, ntrc, nsmp, nsegments, maxpicks

      real temp_trace(2*SZLNHD), temp_limit(2*SZLNHD)

      real recunit, trcunit, smpunit, recoff, trcoff, smpoff 
      real record

c initialize variables

      Nfunc = ntrco
      call vclr (temp_trace, 1, 2*SZLNHD)
      call vclr (temp_limit, 1, 2*SZLNHD)

c read past pickfile header and pick up number of segments in pickfile

c read pick file header assuming new XSD format.

      read ( lupick, 100, err = 911 , end = 911 ) recunit, trcunit,
     :     smpunit, nrec, ntrc, nsmp, recoff, trcoff, smpoff, nsegments,
     :     maxpicks

 100  format ( 6x, f12.6, 1x, f12.6, 1x, f12.6, 1x, i5, 1x, i5, 1x, i5,
     :     7x, f12.6, 1x, f12.6, 1x, f12.6, 8x, i5, 1x, i5 )
      
      if ( nsegments .ne. 2 ) then
         write(LERR,*)' '
         write(LERR,*)' should have 2 segments in pickfile'
         write(LERR,*)' you have ',nsegments,'.  Check '
         write(LERR,*)' pickfile integrity and try again.'
         write(LERR,*)'FATAL'
         write(LER,*)'TFSKILL: '
         write(LER,*)' should have 2 segments in pickfile'
         write(LER,*)' you have ',nsegments,'.  Check '
         write(LER,*)' pickfile integrity and try again.'
         write(LER,*)'FATAL'
         stop
      endif

      write(LERR,*)' Limiting Function Limits'
      write(LERR,*)' ------------------------'
      write(LERR,*)' '
c read 1st segment header to determine number of picks in segment

      read(lupick,'(15x,26x,15x,9x,i5)',err=911)num_Minpicks

c read picks

      do i = 1, num_Minpicks
         read(lupick,*) record, temp_trace(i), temp_limit(i)
      enddo

c echo picks read to printout file

      write(LERR,*)' Minimum Limits'
      write(LERR,*)' --------------'
      do i = 1, num_Minpicks
         temp_limit(i) = min + delta * temp_limit(i)
         write(LERR,*)' Trace ',temp_trace(i),' Value ',
     :        temp_limit(i)
      enddo

c sort picks

      call hsort2 (num_MinPicks, temp_trace, temp_limit)

c read 2nd segment header to determine number of picks in segment

      read(lupick,'(15x,26x,15x,9x,i5)',err=911)num_Maxpicks

      do i = 1, num_Maxpicks
         read(lupick,*) record, temp_trace(num_Minpicks + i), 
     :        temp_limit(num_Minpicks + i)
      enddo

c echo picks read to printout file

      write(LERR,*)' '
      write(LERR,*)' Maximum Limits'
      write(LERR,*)' --------------'
      do i = num_Minpicks+1, num_Minpicks+num_Maxpicks
         temp_limit(i) = min + delta * temp_limit(i)
         write(LERR,*)' Trace ',temp_trace(i),
     :        ' Value ', temp_limit(i)
      enddo

c sort picks

      call hsort2 (num_Maxpicks, temp_trace(num_Minpicks+1), 
     :     temp_limit(num_Minpicks+1))

c interpolate / extrapolate to fill out a pick for every trace

      do i = 1, ntrco

         Trace(i) = float(i)

c min pick

         if ( i .le. nint(temp_trace(1) ) ) then
            MinLimit(i) = temp_limit(1)
         elseif ( i .ge. nint(temp_trace(num_Minpicks) )) then
            MinLimit(i) = temp_limit(num_Minpicks)
         else

            do j = 2, num_Minpicks
               if ( i .le. nint(temp_trace(j)) ) then
                  MinLimit(i) = temp_limit(j-1) + 
     :                 ( temp_limit(j) - temp_limit(j-1))* 
     :                 (float(i) - temp_trace(j-1))/ 
     :                 (temp_trace(j) - temp_trace(j-1))
                  goto 10
               endif
            enddo
         endif

c max pick     
 10      if ( i .le. nint(temp_trace(num_Minpicks+1))) then
            MaxLimit(i) = temp_limit(num_Minpicks+1)
         elseif ( i .ge. 
     :           nint(temp_trace(num_Maxpicks+num_Minpicks)))then
            MaxLimit(i) = temp_limit(num_Maxpicks+num_Minpicks)
         else
            do j = num_Minpicks + 2, num_Maxpicks+num_Minpicks
               if ( i .le. nint( temp_trace(j) ) ) then
                  MaxLimit(i) = temp_limit(j-1) + 
     :                 ( temp_limit(j) - temp_limit(j-1)) * 
     :                 (float(i) - temp_trace(j-1))/
     :                 (temp_trace(j) - temp_trace(j-1))
                  goto   20
               endif
            enddo
            
 20         continue
         endif
         
      enddo
      write(LERR,*) ' '
      write(LERR,*) ' Processed Limiting Function '
      write(LERR,*) ' '
      write(LERR,*) ' Index      Minimum       Maximum'
      write(LERR,*) ' -----      -------       -------'
      do i = 1, Nfunc
         write(LERR,*) Trace(i), MinLimit(i), MaxLimit(i)
      enddo
      return

 911  continue
      write(LERR,*)'TFSKILL: Empty XSD pick file '
      write(LERR,*)'FATAL'
      write(LER,*)'TFSKILL: Error reading XSD pick file '
      write(LER,*)'FATAL'
      stop
      end
