C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine ZoneKill ( tri, nsamp, nf, nsampo, 
     :     stft_Record, use_ratio, use_range, ist, iend,
     :     Subband, MeanMean, MeanStdDev, 
     :     MeanRange, RangeStdDev, 
     :     MeanRatio, RatioStdDev, 
     :     DesiredStdDevMultiplier )

c subroutine to kill off anomalous zones within a trace based
c on time-frequency spectral statistics

c declare variables passed from calling routine

      integer nsamp, nf, nsampo, ist, iend

      real tri(nsamp), stft_Record( nsampo, nf) 
      real Subband, MeanMean, MeanStdDev, MeanRange, RangeStdDev
      real MeanRatio, RatioStdDev, DesiredStdDevMultiplier 

      logical use_ratio, use_range

c declare local variables

      integer band

      real limit, range, ratio, min

c initialize variables

      band = ifix ( Subband )

c determine spike sensitivity limit

      if ( use_range ) then

         limit = MeanRange + DesiredStdDevMultiplier * RangeStdDev

         if ( ( MeanMean - DesiredStdDevMultiplier * RangeStdDev )
     :        .gt. 0. ) then
            min = MeanMean - DesiredStdDevMultiplier * RangeStdDev 
         else
            min = 0.0
         endif
        
      elseif ( use_ratio ) then

         limit = MeanRatio + DesiredStdDevMultiplier * RatioStdDev

         if ( ( MeanMean - DesiredStdDevMultiplier * RangeStdDev )
     :        .gt. 0. ) then
            min = MeanMean - DesiredStdDevMultiplier * RangeStdDev 
         else
            min = 0.0
         endif
        
      else

         limit = MeanMean + DesiredStdDevMultiplier * MeanStdDev

      endif
      
c kill off spike amplitudes if detected

      do i = ist, iend-nf

         if ( use_range ) then

            range = stft_record(i,band) - min
            if ( range .gt. limit .and. range .gt. 0.0 ) then
               tri(i+nf) = 0.0
            endif

         elseif ( use_ratio ) then

            range = stft_record(i,band) - min
            ratio = range / MeanMean

            if ( ratio .gt. limit .and. ratio .gt. 0.0 ) then
               tri(i+nf) = 0.0
            endif

         else
            
            if ( stft_record(i, band) .gt. limit ) then
               tri(i+nf) = 0.0
            endif
 
         endif

      enddo

      return
      end
