C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c -----------------  Subroutine -----------------------

c verbal printout of pertinent program particulars


      subroutine verbal ( ntap, otap, nsamp, nsi, ntrc, nrec, iform, 
     :     ist, iend, irs, ire, ns, ne, ntrco, nreco, nsampo, nwin, 
     :     statstap, functap, use_ratio, use_range, c_RecWrd, c_TrcWrc, 
     :     killtap, qc, velocity, step_size, xsdtap, picktap, delta,
     :     min, user_multiplier, zone, DesiredRunningCount, 
     :     DesiredStdDevMultiplier, verbos )

#include <f77/iounit.h>

      integer nsamp, nsampo, ntrc, ntrco, nrec, nreco, iform
      integer ist, iend, irs, ire, ns, ne, nsi, nwin
      integer step_size, DesiredRunningCount

      real velocity, delta, min, user_multiplier
      real DesiredStdDevMultiplier

      character  ntap*(*), otap*(*), statstap*(*), xsdtap*(*)
      character functap*(*), c_RecWrd*6, c_TrcWrc*6, killtap*(*)
      character picktap*(*)

      logical    use_ratio, use_range, qc, zone, verbos

c local variables

      integer length

      write(LERR,*)' '
      write(LERR,*)' Input Line Header Parameters'
      write(LERR,*)' '
      length = lenth(ntap)
      if (length .gt. 0) then
        write(LERR,*) ' input data set name   =  ', ntap(1:length)
      else
        write(LERR,*) ' input data set        =  stdin'
      endif
      write(LERR,*) ' samples per trace     =  ', nsamp
      write(LERR,*) ' traces per record     =  ', ntrc
      write(LERR,*) ' number of records     =  ', nrec
      write(LERR,*) ' data format           =  ', iform
      write(LERR,*) ' sample interval       =  ', nsi
      write(LERR,*)' '
      write(LERR,*)' '
      write(LERR,*)' Command Line Parameters '
      write(LERR,*)' '
      if ( qc ) then 

         write(LERR,*)' Running in Quality Control Mode'
         write(LERR,*)' '
         length = lenth(xsdtap)
         write(LERR,*) ' XSD dataset file name      =  ', 
     :        xsdtap(1:length)
         write(LERR,*) ' XSD dataset multiplier     = ',user_multiplier
      else
         length = lenth(otap)
         if (length .gt. 0) then
           write(LERR,*) ' output data set name  =  ',
     :		otap(1:length)
         else
           write(LERR,*) ' output data set       =  stdout'
         endif
         write(LERR,*)' Running in Process Mode'

         if ( picktap .ne. ' ' ) then
            length = lenth(picktap)
            write(LERR,*) ' Limiting function file = ',picktap(1:length)
            length = lenth(xsdtap)
            write(LERR,*) ' XSD dataset file name      =  ', 
     :           xsdtap(1:length)
            write(LERR,*) ' XSD dataset sample interval =  ',delta 
            write(LERR,*) ' XSD dataset minimum value =  ',min 
            write(LERR,*) ' XSD dataset maximum value =  ',
     :           min + float(nsampo) * delta
            
         else    
            length = lenth(functap)
            write(LERR,*) ' Limiting function file = ',functap(1:length)
         endif

         length = lenth(killtap)
         write(LERR,*) ' Kill statistics file = ', killtap(1:length)
         write(LERR,*)' '
      endif
      length = lenth(statstap)
      write(LERR,*) ' Statistics file name      =  ', 
     :     statstap(1:length)
      write(LERR,*) ' start record          =  ', irs
      write(LERR,*) ' end record            =  ', ire 
      write(LERR,*) ' start trace           =  ', ns
      write(LERR,*) ' end trace             =  ', ne
      if ( velocity .eq. 100000. ) then
         write(LERR,*) ' processing sample start = ', ist
         write(LERR,*) ' processing sample end   = ', iend
      else
         write(LERR,*) ' processing sample start = ', ist
         write(LERR,*) ' start window velocity = ', velocity
      endif
      write(LERR,*) ' header record index mnemonic = ',c_RecWrd
      write(LERR,*) ' header trace index mnemonic = ',c_TrcWrc
      write(LERR,*)' '
      write(LERR,*)' Transform Parameters '
      write(LERR,*)' '
      write(LERR,*) ' window size for STFT = ', nwin
      write(LERR,*) ' window step size = ',step_size
      write(LERR,*) ' samples per trace     =  ', nsampo
      write(LERR,*) ' traces per record     =  ', ntrco
      write(LERR,*) ' number of records     =  ', nreco

      if ( verbos )  write(LERR,*) ' verbose printout requested'
      if ( use_ratio ) then
         write(LERR,*) ' input limiting function based on ratio of '
         write(LERR,*) ' maximum spectral range to mean spectral '
         write(LERR,*) ' amplitude'
      elseif ( use_range ) then
         write(LERR,*) ' input limiting function based on maximum '
         write(LERR,*) ' spectral amplitude range'
      else
         write(LERR,*) ' input limiting function based on mean'
         write(LERR,*) ' spectral amplitude'
      endif

      if ( zone ) then
         write(LERR,*) ' '
         write(LERR,*) ' killing zones within traces'
         write(LERR,*) ' '
         write(LERR,*) ' running mean over ', DesiredRunningCount, 
     ;        ' traces'
         write(LERR,*) ' standard deviation multiplier = ',
     :        DesiredStdDevMultiplier
         write(LERR,*) ' '
      endif

      write(LERR,*)' '
      write(LERR,*)'========================================== '
      write(LERR,*)' '

      return
      end
