C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine fft2dee (rdata,nsamp,ntrc,nt,nt2,nx,cdata)

c  routine to do 2-d fft

c  input

c      rdata  -  matrix of real input data
c      nsamp  -  # samps in rdata
c       ntrc  -  # traces in rdata
c         nt  -  power of 2 time samples
c         nx  -  power of 2 # traces
c     revers  -  reverse transform

c output

c      cdata  -  matrix of complex transformed values
#include <f77/iounit.h>
#include <f77/lhdrsz.h>


      	integer	 nt, nx, nsamp, ntrc

      	real 	 rdata(nt2 ,nx)
        complex  cdata(nt  ,nx)
        complex  workc(2*SZLNHD)


c------------
c  	.. Fourier transform:  (y,x) --> (ky,kx)

            do     j = 1, ntrc
               do     i = 1, nsamp
                      workc(i) = cmplx (rdata(i,j), 0.0)
               enddo
                call  cfft  (workc, nt, +1)
                call cfftsc (workc, nt)
               do  i = 1, nt
                   cdata (i,j) = workc(i)
               enddo
           enddo

           do  i = 1, nt
               do  j = 1, nx
                   workc(j) = cdata(i,j)
               enddo
               call cfft   (workc, nx, +1)
               call cfftsc (workc, nx)
               do  j = 1, nx
                   cdata (i, j) = workc (j)
               enddo
           enddo


       do  kx = 1, nx

           if (kx .gt. nx/2) then
               kxout = kx - nx/2
           else
               kxout = nx/2 + kx
           endif

           ix = kxout

           do  kt = 1, nt

               if (kt .gt. nt/2) then
                   ktout = kt - nt/2
               else
                   ktout = nt/2 + kt
               endif

               iamp   = nt  - ktout + 1
               iphase = nt2 - ktout + 1

               rdata(iamp, ix  ) = cabs ( cdata(kt,kx) )

               if (rdata(iamp, ix  ) .eq. 0.) then
                   rdata(iphase, ix  ) = 0.
               else
                   rdata(iphase, ix  ) =
     1             atan2 ( aimag(cdata(kt,kx)),
     2                      real(cdata(kt,kx))  )
               endif
           enddo
       enddo


      return
      end
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
