C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine verbal ( ntap, otap, nsamp, ntrc, nrec, dt, dx, dy, dz, 
     :     dkx, dky, reverse, complex, square, hole, zero, verbos ) 

#include <f77/iounit.h>

      integer     nsamp, ntrc, nrec,square,hole

      real        dt, dx, dy, dz, dkx, dky

      character   ntap*(*), otap*(*)

      logical     reverse, complex, zero, verbos 
 
      write(LERR,*)' '
      write(LERR,*)' Input Line Header Parameters'
      write(LERR,*)' '
      write(LERR,*) ' input data set name   =  ', ntap
      write(LERR,*) ' samples/trace         =  ', nsamp
      write(LERR,*) ' traces per record     =  ', ntrc
      write(LERR,*) ' records per line      =  ', nrec
      write(LERR,*)' '
      write(LERR,*)' Command Line Parameters '
      write(LERR,*)' '
      write(LERR,*) ' output data set name  =  ', otap
      write(LERR,*) ' Cross-line spacing    =  ', dy
      write(LERR,*) ' In-line spacing       =  ', dx
      write(LERR,*) ' In-line thread spacing       =  ', dkx
      write(LERR,*) ' Cross-line thread spacing       =  ', dky
      write(LERR,*) ' Dimension of averaging zone       =  ', square
      write(LERR,*) ' Dimension of replaced zone       =  ', hole
      if ( abs(dz) .lt. 1.e-30 ) then
         write(LERR,*) ' Sample Interval       =  ', dt, 'Seconds'
      else
         write(LERR,*) ' Sample Interval       =  ', dz, 'M or FT'
      endif
      if ( complex ) then
         write(LERR,*)' Complex averaging performed'
      else
         write(LERR,*)' Real averaging performed'
      endif
      if (.not.  reverse ) then
         write(LERR,*)' Forward transform performed'
      else
         write(LERR,*)' Inverse transform performed'
      endif
      if (.not.  zero ) then
         write(LERR,*)' averaging performed'
      else
         write(LERR,*)' data in holes zeroed'
      endif
      write(LERR,*)' '
      if (verbos) write(LERR,*)' Verbos printout requested'
      write(LERR,*)' '
 
      return
      end
