C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine  lfit ( x, y, ndata, sig, mwt, a, b, siga, sigb,
     1                    chi2, q)

#include <f77/iounit.h>

c  routine to linearly fit data with  y = a*x + b

c  input:
c          x,y  -  ndata input points
c          sig  -  ndata std deviations
c          mwt  -  =0 no std deviations available

c output:
c          a,b  -  coefficients of straight line
c   siga, sigb  -  deviations of a & b
c        chi2   -  chi-square
c           q   -  goodness-of-fit probability (chi-sq or better)

      real    x(*), y(*), sig(*)

      sx = 0.               !  initialize sums
      sy = 0.
      st2= 0.
      b  = 0.

      if (mwt .ne. 0) then  ! accumulate sums

         ss = 0.
         do  11  i = 1, ndata
             wt = 1./(sig(i) **2)
             ss = ss + wt
             sx = sx + x(i) * wt
             sy = sy + y(i) * wt
11       continue

      else                  !  without weights

         do  12  i = 1, ndata
             sx = sx + x(i)
             sy = sy + y(i)
12       continue
         ss = float(ndata)

      endif

      sxoss = sx/ss

      if (mwt .ne. 0) then

         do  13  i = 1, ndata
             t = (x(i) - sxoss)/sig(i)
             st2 = st2 + t*t
             b = b + t * y(i)/sig(i)
13       continue

      else

         do  14  i = 1, ndata
             t = x(i) - sxoss
             st2 = st2 + t*t
             b = b + t * y(i)
14       continue

      endif
      
      b = b/st2           !  solve for a & b, and for sigma (a & b)
      a = (sy - sx * b)/ss
      siga = sqrt( (1. + sx*sx/(ss*st2))/ss)
      sigb = sqrt( 1./st2)
      chi2 = 0.           !  calculate chi-squre

      if (ndata .lt. 3) then
         siga = 0.
         sigb = 0.
         chi2 = 0.
         q    = 1.
         return
      endif

      if (mwt .eq. 0) then

          do  15  i = 1, ndata
              chi2 = chi2 + (y(i) - a - b*x(i)) **2
15        continue
          q = 1.
          sigdat = sqrt( chi2/float(ndata-2))
          siga   = siga * sigdat
          sigb   = sigb * sigdat

      else

          do  16  i = 1, ndata
              chi2 = chi2 + ((y(i) - a - b*x(i))/sig(i)) **2
16        continue

      endif

      return
      end
      
