C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************C
C
C     PROGRAM MODULE  convert real seismic traces to complex frequency
C
C**********************************************************************C
C
C timfreq READS SEISMIC TRACE DATA FROM AN INPUT FILE,
C does complex fft on each trace, and
C WRITES THE RESULTS TO AN OUTPUT FILE
C
C SUBROUTINE CALLS: RTAPE, HLH, WRTAPE, SAVE
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      INTEGER     ITR ( 2*SZLNHD )
      INTEGER     LHED( 2*SZLNHD )
      INTEGER     NSAMP, NSI, NTRC, NREC, IFORM
      INTEGER     LUIN , LUOUT, LBYTES, NBYTES,obytes
      integer     argis, ordfft
      real        radeg, thresh
      REAL        xtr ( 8*SZLNHD ), work (8*SZLNHD )
      REAL        amp ( 8*SZLNHD ), phz  (8*SZLNHD )
      COMPLEX     ctr ( 4*SZLNHD )
      CHARACTER   NAME * 7,  ntap * 256, otap * 256
#include <f77/pid.h>
      logical     verbos,query,wrap,pack,phztrnd,first,mute,RI
 
      EQUIVALENCE ( ITR(  1), LHED(1) )

      DATA     NAME /'TIMFREQ'/
      DATA     LUIN / 1 /, LUOUT  / 2 /, LBYTES / 0 /, NBYTES / 0 /
      DATA     obytes / 0 /
      DATA     verbos /.false./, first/.true./
      DATA     radeg/57.29578/


c---------------------------------
c  get online help if necessary
c---------------------------------
      query = (argis('-?') .gt. 0 .or. argis('-h') .gt. 0)
      if( query ) then
          call help ()
          stop
      endif

c---------------------------------
c  open printout files
c---------------------------------
#include <f77/open.h>

c---------------------------------------------------------------
c  read program parameters from command line
c---------------------------------------------------------------
      call cmdln(ntap,otap,ist,iend,nst,ned,nrst,nred,verbos,
     1           wrap,pack,phztrnd,thresh,mute,RI)

C**********************************************************************C
C     open logical units
C     READ AND UPDATE LINE HEADER,
C     WRITE LINE HEADER, SAVE KEY PARAMETERS.
C**********************************************************************C

      call getln( luin, ntap, 'r', 0)
      call getln(luout, otap, 'w', 1)

      lbytes=0
      CALL RTAPE ( LUIN, ITR, LBYTES           )
      if(lbytes .eq. 0) then
         write(LERR,*)'TIMFREQ: no header read on unit ',luin
         write(LERR,*)'for data set name ',ntap
         write(LERR,*)'FATAL'
         write(LERR,*)'check existence of this file'
         stop
      endif

#include <f77/saveh.h>
      call savelu('MutVel',ifmt_MutVel,l_MutVel,ln_MutVel, LINEHEADER)
      call savelu('WatVel',ifmt_WatVel,l_WatVel,ln_WatVel, LINEHEADER)
 
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('VPick1',ifmt_VPick1,l_VPick1,ln_VPick1,TRACEHEADER)

      CALL HLHprt ( ITR , LBYTES, NAME, 7, LERR        )

c---------------------------------------
c  check key values for reasonableness
c---------------------------------------
      call cmdchk(nst,ned,nrst,nred,ntrc,nrec)
      if(nsamp .gt. 2*SZLNHD) nsamp=2*SZLNHD
      ntr=ned-nst+1
      nrecc=nred-nrst+1

C**********************************************************************C
C     CHECK CARD DEFAULTS, SET PARAMETERS, and print out values
C**********************************************************************C
      dt = float (nsi) * unitsc

      iend=iend/nsi + .5
      ist0 = ist
      ist=ist/nsi
      if(ist .le. 1) ist=1
      if(iend .eq. 0) iend=nsamp
      if(iend .gt. nsamp) iend=nsamp
      nsampo=iend-ist+1
c------------------------------
c  find power of 2, nsampo

      nu = ordfft (nsampo)
      n2 = 2 ** nu
      fnyq = .5 / dt

      nf = n2/2 + 1
      df = fnyq / float(nf-1)
      ndf = 1000*df

      if (pack) then
          n22 = 2*nf
          nap = n22 / 2
          ntr2 = ntr
      else
          n22 =  nf
          ntr2 = 2*ntr
      endif

      obytes = SZTRHD + SZSMPD * n22
c------------------------------

c     if( verbos ) then
        write(LERR,*)
        write(LERR,*)' Line header values after default check '
        write(LERR,*)
        write(LERR,*) ' Input Samples/Trace =  ', nsamp
        write(LERR,*) ' # of Samples/Trace  =  ', nsampo
        write(LERR,*) ' power of 2 samples  =  ', n2,n22
        write(LERR,*) ' Sample Interval     =  ', nsi  
        write(LERR,*) ' Input traces/rec    =  ', ntrc
        write(LERR,*) ' Output traces/rec   =  ', ntr2
        write(LERR,*) ' Traces per Record   =  ', ntr 
        write(LERR,*) ' Input Records/Line  =  ', nrec
        write(LERR,*) ' Records per Line    =  ', nrecc
        write(LERR,*) ' Format of Data      =  ', iform
        write(LERR,*) ' Pack Reals & Imag in each trace= ',pack
        write(LERR,*) ' Pack Reals & Imag into trc pairs= ',RI
        write(LERR,*) ' Frequency interval (Hz)        = ',df
        write(LERR,*) ' Output number bytes =  ', obytes
        if (wrap)
     1  write(LERR,*)' leave phase wrapped'
        if (mute)
     1  write(LERR,*)' Detect onset mute & store in hdr word VPick1'
c     endif

c------------------------------
c  save key line header values
c  we will twice the number out traces/rec:
c  tr1 = real values; tr2 = imag values, ...
c------------------------------
       call savew( itr, 'NumTrc', ntr2 , LINHED)
       call savew( itr, 'NumRec', nrecc, LINHED)
       call savew( itr, 'NumSmp', n22  , LINHED)
       call savew( itr, 'IndAdj', nsi  , LINHED)
       call savew( itr, 'SmpInt', ndf  , LINHED)
       call savew( itr, 'OrNSMP',nsamp , LINHED)
       call savhlh( itr, lbytes, lbyout)

      CALL WRTAPE ( LUOUT, ITR, LBYout )

C**********************************************************************C
C     get seismoc traces, fft, output complex data
C**********************************************************************C
c------------------------------------------
c  skip to just before desired record
c------------------------------------------
      call recskp(1,nrst-1,luin,ntrc,itr)

      DO 100 JJ = NRST, NRED

c-------------------------------
c  skip to desired trace
c-------------------------------
             call trcskp(jj,1,nst-1,luin,ntrc,itr)

             DO 99 KK = NST, NED
 
                   nbytes = 0
                   CALL RTAPE  ( LUIN , ITR, NBYTES         )
                   if(nbytes .eq. 0) then
                      write(LERR,*)'End of file on input:'
                      write(LERR,*)'  rec= ',jj,'  trace= ',kk
                      go to 999
                   endif
                   call vmov (lhed(ITHWP1), 1, xtr, 1, nsamp)
                   call saver2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                         istatic, TRACEHEADER)

                   IF (istatic .ne. 30000) THEN

                        if (mute) then
                           call detmut (xtr, imute, nsamp)
                           call savew2(lhed,ifmt_VPick1,l_VPick1,
     1                                 ln_VPick1, imute, TRACEHEADER)
                        endif

                        call vmov   (xtr(ist),1,work,1,nsampo)
                        call vclr   (ctr, 1, n2)
                        call rfftb  (work,ctr,n2,1)
                        call rfftsc (ctr,n2,3,1)

                           if (.not. RI) then
                              call cvabs  (ctr, 2, amp,  1, n2)
                           else
                              do  i = 1, nf
                                  xr = real  ( ctr (i) )
                                  amp (i) = xr
                              enddo
                           endif

                           if (.not. pack) then
                              call vmov  (amp, 1, lhed(ITHWP1), 1, n22)
                              call wrtape(luout,itr,obytes)
                           endif

                           do  i = 1, nf
                               xr = real  ( ctr (i) )
                               xi = aimag ( ctr (i) )
                               if (RI) then
                                  phz (i) = xi
                               else
                                  if (xr .eq. 0.) then
                                     phz (i) = 0.
                                  else
                                     phz (i) = atan2 ( xi , xr )
                                  endif
                               endif
                           enddo

                           if (.not. RI) then
                              call vsmul  (phz, 1, radeg, phz, 1, nf)
                           endif
                           if (.not.wrap) call drum (nf, phz)
                           if (phztrnd) then
                               call limits (work, l1, l2, n22, thresh)
                               call trend (phz, l1, l2, n22, first)
                           endif

                           if (.not. pack) then
                              call vmov (phz, 1, lhed(ITHWP1), 1, n22)
                              call wrtape(luout,itr,obytes)
                           endif


                           if (pack) then
                              do  i = 1, nap
                                  xtr (nap-i+1) = amp (i)
                                  xtr (nap+i  ) = phz (i)
                              enddo
                              call vmov  (xtr, 1, lhed(ITHWP1), 1, n22)
                              call wrtape(luout,lhed,obytes)
                           endif

                   ELSE

                        if (pack) then
                           call wrtape(luout,itr,obytes)
                        else
                           call wrtape(luout,itr,obytes)
                           call wrtape(luout,itr,obytes)
                        endif

                   ENDIF


   99        CONTINUE

c--------------------------------------------------
c  skip to the end of current record: trace # ntrc
c--------------------------------------------------
             call trcskp(jj,kk+1,ntrc,luin,ntrc,itr)

  100 CONTINUE
                        if(verbos) then
                           write(LERR,*)'Output Record ',itr(106)
                        endif

  999 continue
        call lbclos(luin)
        call lbclos(luout)
      END

c--------------------------------
c  online help routine
c--------------------------------
      subroutine help
#include <f77/iounit.h>
        write(LER,*)' '
        write(LER,*)'Command Line Arguments for TIMFREQ: '
        write(LER,*)'convert seismic traces to frequency (fft)'
        write(LER,*)' '
        write(LER,*)'Input...................................... (def)'
        write(LER,*)' '
        write(LER,*)'-N[ntap]   -- input data set name'
        write(LER,*)'-O[otap]   -- output data set name'
        write(LER,*)'-s[ist]    -- start time                   (0 ms)'
        write(LER,*)'-e[iend]   -- end time                (last samp)'
        write(LER,*)'-ns[nst]   -- start trace number       (first tr)'
        write(LER,*)'-ne[ned]   -- end trace number          (last tr)'
        write(LER,*)'-rs[nrst]  -- start record            (first rec)'
        write(LER,*)'-re[nred]  -- end record               (last rec)'
        write(LER,*)'-RT        -- remove linear phase trend (-AP) (N)'
        write(LER,*)'-t[thr]    -- fraction of max ampl           (.0)'
        write(LER,*)'-W         -- leave phase wrapped'
        write(LER,*)'-P         -- pack complex values into each trace'
        write(LER,*)'-RI        -- pack real & imag into trc pairs'
        write(LER,*)'           -- (def is to pack amp & phz in deg)'
        write(LER,*)'-M         -- detect onset mute & store in VPick1'
        write(LER,*)'-V         -- verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)'      timfreq -N[] -O[] -s[] -e[] -ns[] -ne[]'
        write(LER,*)'              -rs[] -re[] [-t[] -RT -P -RI -W'
        write(LER,*)'              -M -V]'
        write(LER,*)' '
      return
      end

      subroutine cmdln(ntap,otap,ist,iend,nst,ned,nrst,nred,
     1                  verbos,wrap,pack,phztrnd,thresh,mute,RI)
c-----
c     get command arguments
c
c     ntap  - C*100     input file name
c     otap  - C*100     output file name
c      ist  - I         start time 
c     iend  - I         end time 
c      nst  - I         start trace
c      ned  - I         end trace
c     nrst  - I         start record
c     nred  - I         end record
c     wrap  - L         leave phase wrapped
c     pack  - L         pack real & imag into one trace
c     verbos- L         verbose output or not
c-----
#include <f77/iounit.h>
      character ntap*(*), otap*(*)
      real      thresh
      integer   argis,ist,iend,nst,ned,nrst,nred
      logical   verbos, wrap, pack, phztrnd, mute, RI

           call argstr('-N',ntap,' ',' ')
           call argstr('-O',otap,' ',' ')
           call argi4('-s',ist,1,1) 
           call argi4('-e',iend,0,0) 
           call argi4('-ns',nst,0,0)
           call argi4('-ne',ned,0,0)
           call argi4('-rs',nrst,1,1)
           call argi4('-re',nred,0,0)
           call argr4 ('-t',thresh, .0, .0)
           phztrnd= ( argis( '-RT' ) .gt. 0 )
           wrap   = ( argis( '-W' ) .gt. 0 )
           pack   = ( argis( '-P' ) .gt. 0 )
           RI     = ( argis( '-RI' ) .gt. 0 )
           mute   = ( argis( '-M' ) .gt. 0 )
           verbos = ( argis( '-V' ) .gt. 0 )

      if (RI) then
          wrap = .true.
          phztrnd = .false.
      endif

c-----
      return
      end

      subroutine drum (lphz, phz)
      real      phz(*)
      integer   lphz
      pi = 180.

      pj = 0.
      do  40 i = 2, lphz

          if (abs(phz(i)+pj-phz(i-1))-pi) 40,40,10

10        if (phz(i)+pj-phz(i-1)) 20,40,30

20        pj = pj +  2*pi
          go to 40

30        pj = pj -  2*pi

40        phz(i) = phz(i) + pj

      return
      end

