C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine Calculate_Average_Trace (Record, Headers, Space,
     :     nsamp, ntrc, ist, iend,
     :     iwin_sample, JJ, nsi, velocity,
     :     Average_Val, A_Dev,
     :     Number_Windows,itrc)

c calculate average of Record for each window
c
c
c     James M. Gridley
c     USP Team Tulsa, OK
c     Spring 1997
c
c
#include <save_defs.h> 
#include <f77/lhdrsz.h>

c variables passed from calling routine

      integer nsamp, ntrc, ist, iend 
      integer Headers(ITRWRD*ntrc)
      integer DstSgn, StaCor, trc_counter
      
      real Record(nsamp, ntrc), Space(nsamp,ntrc)
      real Average_Val(nsamp)
      real A_Dev(nsamp) 
    
      integer iAvg_Win_Count(SZLNHD)
     
      
c     initialize variables
      


      do i = 1, nsamp
      
         iAvg_Win_Count(i)=0
         Average_Val(i) = 0.0
         A_Dev(i)=0.0
       
         do j = 1, ntrc
            Space(i,j) = 0.0
         enddo
      enddo
   

c     process data
      
      hdr_index = 0
      
c      DO j = 1, ntrc

      j = itrc
  
         do k = 1, Number_Windows - 1   
      
            iwin_start= iwin_sample * (k-1) + ist  
           
            do m = iwin_start, iwin_start + iwin_sample - 1    
                  
               
                  Average_Val(k)=Average_Val(k) +  
     :                 abs(Record(m,j))

                  A_Dev(k) = A_Dev(k) +
     :                 (Record(m,j))
              
            enddo           
         enddo
           
c     Pick up the end of the data
         
         if (Number_Windows*iwin_samples .le. nsamp) then
            
            do m = nsamp-iwin_sample, nsamp

               Average_Val(Number_Windows) = 
     :              Average_Val(Number_Windows) +
     :              abs(Record(m,j))

               A_Dev(Number_Windows) = 
     :              A_Dev(Number_Windows) +
     :              (Record(m,j))

         
         enddo
      endif
c      enddo         

            Average_Val(Number_Windows) = 
     :           Average_Val(Number_Windows)/(iwin_sample+1)

            A_Dev(Number_Windows) = 
     :           A_Dev(Number_Windows)/(iwin_sample+1)

         do k = 1, Number_Windows - 1    
          
            Average_Val(k)=Average_Val(k)/iwin_sample
            A_Dev(k) = A_Dev(k)/iwin_sample
c            write(6,*) k,Average_Val(k)
         enddo

      return
      end








