C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C ******************************************************************** C
C |
C |                                                                    |
C | TP SURVEY                                                          |
C |                                                                    |
C ******************************************************************** C


      subroutine vestba (nsamp,ntrc,nspad,nw,nlive,ncmplx,domega,
     1                   numtp,istpr,vel,xoff,weight,taper,data,dist,
     2                   data2d)
 
#include <f77/iounit.h>
c#include <f77/lhdrsz.h>

      real          xoff(*), weight(*),taper(*),dist(*)
      COMPLEX       DATA2D(*), DATAC1(10000), c0, sum
      complex       slnt(10000), sslnt(10000), dslnt(10000)
 
      REAL          WORK(2*10000)
      REAL          DATA(*), p(10000)
      real          tp,tp2,v2,vel,arg,scalr,pi
 
      data PI/3.14159265/

      c0 = cmplx (0.,0.)
      v2 = vel*vel
      scalr = 1.
      delf = .25 * domega/pi
      if (nlive .gt. 0) scalr = 1./float(nlive)
 
C +--------------------------------------+
c |  fft data and transpose into data2d array
C +--------------------------------------+
      do  101  nx = 1, ntrc

          p(nx) = dist(nx) / 1000.

          istrc = (nx-1) * nsamp
          call vclr (work,1,nspad)
          call vmov (data(istrc+1),1,work,1,nsamp)
          call rfftb (work,datac1,nspad,1)
          call rfftsc (datac1,nspad,3,-1)

          jxw = nx - ntrc
          do  121  jw = 1, nw

              jxw = jxw + ntrc
              data2d (jxw) = datac1 (jw) * weight (nx)

              if (istpr .ne. 0 .and. jw .ge. istpr) then

                  kjw = jw - istpr + 1
                  data2d (jxw) = data2d (jxw) * taper(kjw)

              endif

121       continue

101   continue

c---------------------------------------------
c initialize slant arrays & do tp slant stack

      do  201  jp = 1, numtp

          xoff2nx = xoff(jp) * xoff(jp) / v2

          do  202  nx = 1, ntrc

              tp  = p(nx)
              tp2 = tp * tp
              slnt (nx) = cmplx (1.0,0.0)
              arg = -domega * (sqrt (tp2 + xoff2nx) - tp)
              dslnt (nx) = cmplx (cos (arg), sin (arg))

202       continue

          jxw = 1 - ntrc

          do  203  jw = 1, nw

              call cvmov (slnt,2,sslnt,2,ntrc)

              do  777  ix = 1, ntrc
                  slnt (ix) = sslnt (ix) * dslnt (ix)
777           continue

              jxw = jxw + ntrc
c             call cdotpr (data2d (jxw),2,slnt,2,datac1(jw),ntrc)
              sum = cmplx(0.,0.)
              do  15  ii = 1, ntrc
                   sum = sum + data2d(jxw+ii-1) * slnt(ii)
15            continue
              datac1(jw) = sum * float(jw) * delf

203       continue

          call rfftsc (datac1,nspad,-3,0)
          call rfftb (datac1,work,nspad,-1)
          istrc = (jp-1) * nsamp
          call vmul (scalr,0,work,1,data(istrc+1),1,nsamp)


201   continue

      return
      end
