C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************

C
C     PROGRAM MODULE  transp
C
C**********************************************************************C
C
C TRANSP READS SEISMIC TRACE DATA FROM AN INPUT FILE,
C treating each record like a matrix it does a transpose replacing time
C with range and writes the results to otap
C
C SUBROUTINE CALLS: RTAPE, HLH, WRTAPE, SAVE
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      INTEGER     ITR ( 2*SZLNHD )
      INTEGER     LHED( 2*SZLNHD )
      INTEGER     NSAMP, NSI, NTRC, NREC, IFORM
      INTEGER     LUIN , LBYTES, NBYTES,obytes
      integer     argis
      INTEGER     itrh
      REAL        xtr(2*SZLNHD),work
      pointer     (wkaddi, itrh(1))
      pointer     (wkaddr, work(1))
      CHARACTER   NAME * 6, ntap * 256, otap * 256
#include <f77/pid.h>
      logical     verbos,query,heap,heapi
 
c     EQUIVALENCE ( ITR(129), xtr (1) )
      EQUIVALENCE ( ITR(  1), LHED(1) )
      DATA NAME     /'TRANSP'/
      DATA LUIN / 1 /, LBYTES / 0 /, NBYTES / 0 /

c---------------------------------
c  get online help if necessary
c---------------------------------
      query = (argis('-?').gt.0 .or. argis('-h').gt.0)
      if ( query ) then
           call help ()
           stop
      endif

c------------------------------------
c  open printout file
c------------------------------------
#include <f77/open.h>

C**********************************************************************C
C     READ PROGRAM PARAMETERS FROM COMMAND LINE ARGUMENT STRING
C**********************************************************************C
      call cmdln (ntap,otap,ist,iend,ntr,nrst,nred,verbos)

C**********************************************************************C
C     READ AND UPDATE LINE HEADER,
C     WRITE LINE HEADER, SAVE KEY PARAMETERS.
C**********************************************************************C
      call getln ( luin, ntap, 'r', 0 )
      call getln (luout, otap, 'w', 1 )

      lbytes = 0
      CALL RTAPE ( LUIN, ITR, LBYTES           )
      if(lbytes .eq. 0) then
         write(LERR,*)'TRANSP: no header read on unit ',ntap
         write(LERR,*)'FATAL'
         write(LERR,*)'Check existence of file & rerun'
         stop
      endif
      CALL HLHprt ( ITR , LBYTES, NAME, 6, LERR        )

c---------------------------------
c  save key header values
#include <f77/saveh.h>
      if(nsamp .gt. 2*SZLNHD) nsamp=2*SZLNHD
c----------------------------------
c  check default values
      if(ntr .eq. 0) ntr=ntrc
      if(nrst .eq. 0) nrst=1
      if(nred .eq. 0) nred=nrec
      nrecc=nred-nrst+1
      ist=ist/nsi
      iend=iend/nsi
      if(ist .lt. 1) ist=1
      if(iend .lt. 1) iend=nsamp
      nsampo=iend-ist+1
c------------------------------------------------------
c  save headers: exchange # traces/rec & # samples/rec
       call savew( itr, 'NumSmp', ntr   , LINHED)
       call savew( itr, 'NumTrc', nsampo, LINHED)
       call savew( itr, 'NumRec', nrecc , LINHED)

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

c----------------------------------------------------------------
c  change output bytes to reflect change from time to # traces
      obytes = SZSMPD * (ntr + ITRWRD)

c---------------------------------
c  verbos printout
c     if(verbos) then
        write(LERR,*)
        write(LERR,*)' Values read from input data set line header'
        write(LERR,*)
        write(LERR,*) ' # of Samples/Trace =  ', nsamp
        write(LERR,*) ' Sample Interval    =  ', nsi  
        write(LERR,*) ' Traces per Record  =  ', ntr 
        write(LERR,*) ' Records per Line   =  ', nrec
        write(LERR,*) ' Output records     =  ', nrecc
        write(LERR,*) ' Format of Data     =  ', iform
        write(LERR,*) ' Output # samples   =  ',ntr
        write(LERR,*) ' Output # traces    =  ',nsampo
c     endif

c-----------------------------------------------
c  adjust historical line header & write header
      call savhlh ( itr, lbytes, lbyout )
 
      call wrtape(luout,itr,lbyout)

c------------------------------------------------
c  skip to start record
      call recskp(1,nrst-1,luin,ntrc,itr)

c---------------------------------------------------
c  malloc only space we're going to use
      heapi = .true.
      heap  = .true.

      call galloc (wkaddi, ntrc*ITRWRD*SZSMPD, errcodi, aborti)
      call galloc (wkaddr, ntrc*nsamp*SZSMPD, errcod, abort)
      if (errcodi .ne. 0) heapi = .false.
      if (errcod  .ne. 0) heap  = .false.
      if (.not. heap .OR. .not. heapi) then
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) ntrc*ITRWRD*SZSMPD,'  bytes'
         write(LERR,*) ntrc*nsamp*SZSMPD,'  bytes'
         write(LER ,*)'Unable to allocate workspace:'
         write(LER ,*) ntrc*ITRWRD*SZSMPD,'  bytes'
         write(LER ,*) ntrc*nsamp*SZSMPD,'  bytes'
         go to 999
      endif
c---------------------------------------------------

C**********************************************************************C
C
C     READ RECORD, DO TRANSPOSE, WRITE OUTPUT RECORD
C
C**********************************************************************C
 
      DO 100 JJ = NRST, NRED

c----------------------
c  read record & store
c----------------------
           DO 99 KK = 1, NTR
                 nbytes = 0
                 CALL RTAPE  ( LUIN , ITR, NBYTES         )
                 if(nbytes .eq. 0) then
                    write(LERR,*)'WARNING'
                    write(LERR,*)'End of file on input:'
                    write(LERR,*)'  rec= ',jj,'  trace= ',kk
                    go to 59
                 endif
c----
c   mark dead trace locations but unflag as dead on forward transp
c   detect previously dead trace and re-flag as dead on reverse transp
c----
                 call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                       istatic, TRACEHEADER)

                 if (istatic .eq. 30000) then
                     call savew2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                           -30000 , TRACEHEADER)
                 elseif (istatic .eq. -30000) then
                     call savew2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                           30000  , TRACEHEADER)
                 endif

                 istrc = (kk-1) * nsampo
                 call vmov (itr(ITRWRD+ist),1, work(istrc+1),1,nsampo)
c-------------------
c  save tr headers
                 ishdr = (kk-1) * ITRWRD
                 call vmov (itr, 1, itrh(ishdr+1), 1, ITRWRD)
 
   99      CONTINUE

   59      ntro = kk-1

           if (verbos)
     1     write(LERR,*)'read ',ntro,' traces from record ',jj
c-------------------
c   do transpose
c-------------------
           DO 199 KK = 1, NSAMPO

                 do 52  ii = 1, ntro
                        istrc = (ii-1)*nsampo + kk
                        xtr (ii) = work (istrc)
   52            continue
c--------------------
c  get back headers
                 if (kk .le. ntro) then
                     ishdr = (kk-1) * ITRWRD
                     call vmov (itrh(ishdr+1), 1, itr, 1, ITRWRD)
                 endif
                 call savew2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                       kk, TRACEHEADER)

                 call vmov (xtr, 1, itr(ITHWP1), 1, ntr)
                 CALL WRTAPE  ( LUOUT , ITR, OBYTES         )
 
  199      CONTINUE

           if(verbos) then
              write(LERR,*) 'Transposed Record=  ',jj
           endif

  100 CONTINUE

  999 continue
       call lbclos(luin)
       call lbclos(luout)
      END

c------------------------------
c  online help section
c------------------------------
      subroutine  help
#include <f77/iounit.h>

        write(LER,*)' '
        write(LER,*)'Command Line Arguments for TRANSP: transpose data'
        write(LER,*)' '
        write(LER,*)'Input....................................... (def)'
        write(LER,*)' '
        write(LER,*)'-N[ntap]   -- input data set'
        write(LER,*)'-O[otap]   -- output data set'
        write(LER,*)'-s[ist]    -- start time (ms)         (first samp)'
        write(LER,*)'-e[iend]   -- end time (ms)            (last samp)'
        write(LER,*)'-nt[ntr]   -- traces/record override       (input)'
        write(LER,*)'-rs[nrst]  -- start record                 (first)'
        write(LER,*)'-re[nred]  -- end record                    (last)'
        write(LER,*)'-V         -- verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)'        transp -N[] -O[] -s[] -e[] -nt[] '
        write(LER,*)'               -rs[] -re[] -V'
        write(LER,*)' '

      return
      end

c-----
c     get command arguments
c
c     ntap  - C*100  input file name
c     otap  - C*100  output file name
c     ist   - I      start sample
c    iend   - I      stop sample
c    nrst   - I      start record
c    nred   - I      stop end record
c     ntr   - I      override # traces/rec
c    verbos - L      verbose output or not
c-----
      subroutine cmdln (ntap,otap,ist,iend,ntr,nrst,nred,verbos)
#include <f77/iounit.h>
      character  ntap*(*), otap*(*)
      integer    argis,ist,iend,nrst,nred,ntr
      logical    verbos

          call argstr('-N',ntap,' ',' ') 
          call argstr('-O',otap,' ',' ') 
          call argi4('-s',ist,1,1)
          call argi4('-e',iend,0,0)
          call argi4('-nt',ntr,0,0)
          call argi4('-rs',nrst,1,1)
          call argi4('-re',nred,0,0)
          verbos = (argis('-V') .gt. 0)

      return
      end
