C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C
C	Name:		CMDHLH
C
C	Purpose:	to put entire command line in a form that HLHPRT can
C			print
C
C	Usage:		CMDHLH(ITR,LBYTIN,LBYTOT)
C
C	Notes:		length of each line hardcoded to 50.
C
C	Author:		Chester A. Jacewicz ... on Cray
C
C	Revised:	12 July 1988 ... initial release
C                       07Nov90 ... upped CLINE to 512 for trched
C				
C..............................................................................
C
        SUBROUTINE CMDHLH(ITR,LBYTIN,LBYTOT)
C
#include <f77/sisdef.h>

c       IMPLICIT NONE
C
        CHARACTER * 512 CLINE,TEXT
C
        EXTERNAL CMDLIN,lenth,STFHLH
C
        INTEGER IFIRST,ISTART,ITR,KLEFT,KNOW,KSTUFF
        INTEGER LBYTIN,LBYTOT,LENCMD,LINP,LMAX,lenth,LUNDMP
C
        DATA LMAX/50/
        DATA LUNDMP/99/
C
        CALL CMDLIN(CLINE,LENCMD)
C
C	get length of command line
C
        LENCMD=lenth(CLINE)
        IFIRST=1
        LINP=LBYTIN
        KLEFT=LENCMD
C
100	CONTINUE
C
        KNOW=MIN(KLEFT,LMAX)
C
        IF(IFIRST.EQ.1) THEN
C
        ISTART=1
C
        ELSE
C
C	insert blank
C
        ISTART=2
        KNOW=MIN(KNOW,LMAX-1)
        ENDIF
C
        TEXT=' '
        TEXT(ISTART:ISTART+KNOW-1)=
     *  CLINE(LENCMD-KLEFT+1:LENCMD-KLEFT+1+KNOW-1)
        IFIRST=2
C
C	update header length
C	Set to a multiple of 8
C
        KSTUFF=KNOW+HLHINT-MOD(KNOW,HLHINT)
        CALL STFHLH(ITR,LINP,LBYTOT,TEXT,KSTUFF)
        LINP=LBYTOT
C
        KLEFT=KLEFT-KNOW
	IF(KLEFT.GT.0) GOTO 100
        IF(KLEFT.LT.0) WRITE(LUNDMP,*)'Problem in CMDHLH'
C
        RETURN
        END
