C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C
C	Name:		CMDLIN
C
C	Purpose:	to return full UNIX command line
C
C	Usage:		Outputs:	OUTBUF 		Character buffer
C					LENLIN		Length of command line
C
C	Notes:		Modelled on savhlh of Paul Gutowski
C
C	Author:		Chester A. Jacewicz ... on Cray
C
C	Revised:	11 July 1988 ... initial release on Cray
C			24 August 1988	check LEN(OUTBUF)
C			30-Aug88	call to BLANK
C			14-Nov-88	add routine's name to output
C			01Mar89		Change ARGC to IARGCC
C					Change ARGV to SARGVV
C			03Apr89		Changed back
C				
C.............................................................................
C
        SUBROUTINE CMDLIN(OUTBUF,LENLIN)
C
c       IMPLICIT NONE
C
#include <f77/iounit.h>

        CHARACTER * 256 sargvv
        CHARACTER * (*) OUTBUF
        CHARACTER*9 PGMNME
        CHARACTER *256  TBUF
C
        EXTERNAL iargcc,sargvv,BLANK,lenth
C
        INTEGER iargcc,lenth,LUNERR
        INTEGER I,IDO,K,L
        INTEGER LENLIN,LMAX,NMARG
C
        DATA PGMNME/'CMDLIN:  '/
        LUNERR = LERR
C
C	Extract all arguments from the command line
C
        LMAX=LEN(OUTBUF)
        WRITE(LUNERR,*)PGMNME//'LEN(OUTBUF):',LMAX
        NMARG=iargcc()
        K=1
C       OUTBUF=" "
        CALL BLANK(OUTBUF)
C
        DO 100 I=0,NMARG-1
                IF(I.GT.0) THEN 
                        IF(K.LE.LMAX) OUTBUF(K:K)=' '
                        K=K+1
                        ENDIF
C
                TBUF=sargvv(I)
                L=lenth(TBUF)
C
        DO 200 IDO=1,L
C       OUTBUF(K:K+L-1)=TBUF(1:L)
        IF(K.LE.LMAX) OUTBUF(K:K)=TBUF(IDO:IDO)
        K=K+1
200        CONTINUE
C
100     CONTINUE
C
        LENLIN=K
C
        RETURN
        END
