C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine GetCharacter ( tri, nsampo, WorkSpace, 
     :     MedianCharacter, MemoryInSamples, counter )

#include <f77/lhdrsz.h>
#include <f77/iounit.h>

c variables passed by calling routine

      integer nsampo, MemoryInSamples, counter

      real tri(nsampo), WorkSpace(nsampo) 
      real MedianCharacter(MemoryInSamples)

c local variables

      integer NumPeakValues, index

      real PeakValues(SZLNHD), PeakMedianAmp, PeakMaxAbsAmp 

c initialize variables

      call vclr ( PeakValues, 1, nsampo )
      call vclr(WorkSpace, 1, nsampo)

      call vabs ( tri, 1, WorkSpace, 1, nsampo )
      call GetPeakValues ( WorkSpace, nsampo, PeakValues,
     :     NumPeakValues )
      
      call maxv ( PeakValues, 1, PeakMaxAbsAmp, index, 
     :     NumPeakValues )
      call median ( NumPeakValues, PeakValues, 
     :     PeakMedianAmp )

      if ( PeakMaxAbsAmp .le. 0.0 ) 
     :     write(LER,*)' GetChar error: numerator <= 0.0', PeakMaxAbsAmp
      if ( PeakMedianAmp .le. 0.0 ) 
     :     write(LER,*)' GetChar error: denominator <= 0.0', 
     :     PeakMedianAmp
      MedianCharacter(counter) = 
     :     20.0 * alog10 ( PeakMaxAbsAmp / PeakMedianAmp )

      return
      end
