C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine GetSpectralSum(tri, N, SpectralSum, MemoryInSamples, 
     :     SpecMinFreq, SpecMaxFreq, NyquistFrequency, counter)

#include <f77/lhdrsz.h>

c variables passed from calling routine

      integer  N, counter, MemoryInSamples

      real SpectralSum(MemoryInSamples), tri(N), SpecMinFreq
      real SpecMaxFreq, NyquistFrequency

c local variables

      integer Npower2, ordfft, nu, start, end

      real work(8*SZLNHD), amp ( 8*SZLNHD ), sumamp, df

      complex  ctr ( 4*SZLNHD )

c initialize variables

      SpectralSum(counter) = 0.0
      sumamp = 0.0
      nu = ordfft (N)
      Npower2 = 2 ** nu
      df = NyquistFrequency / float (Npower2/2 - 1)

      start = SpecMinFreq / df
      if (start .eq. 0 ) start = 1
      end = SpecMaxFreq / df
      if ( end .gt. Npower2) end = Npower2

      call vclr ( work, 1, 8*SZLNHD)
      call vmov   (tri, 1, work, 1, N)
      call vclr   (ctr, 1, Npower2)
      call rfftb  (work, ctr, Npower2, 1)
      call rfftsc (ctr, Npower2, 2, 1)
      call cvabs  (ctr, 2, amp,  1, Npower2)

c sum amplitude 

      do i = start, end
         sumamp = sumamp + amp(i)
      enddo
      
      SpectralSum(counter) = sumamp

      return
      end
