C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine cmdln ( ntap, otap, ist, iend, irs, ire, ns, ne, 
     :     QC, MinAmp, MaxAmp, MinFreq, MaxFreq, MinChar, MaxChar, 
     :     MinDecay, MaxDecay, MinFreqAboveMute, MaxFreqAboveMute,
     :     MinAmpRatio,  MaxAmpRatio, MinSpectralSum, 
     :     MaxSpectralSum, SpecMinFreq, SpecMaxFreq, Tzero, 
     :     Velocity, MinOffset, verbos )

#include <f77/iounit.h>

      integer  argis, ist, iend,  irs, ire, ns ,ne
      integer  MinOffset

      real  MinAmp, MaxAmp, MinFreq, MaxFreq, MinChar, MaxChar
      real  MinDecay, MaxDecay, Tzero, Velocity
      real  MinFreqAboveMute, MaxFreqAboveMute
      real  MinAmpRatio,  MaxAmpRatio, MinSpectralSum, MaxSpectralSum
      real  SpecMinFreq, SpecMaxFreq

      character   ntap*255, otap*255

      logical     verbos, QC
      
      call argi4  ( '-e', iend, 0 , 0 )

      call argr4  ( '-fmax', SpecMaxFreq, 15.0 , 15.0 )
      call argr4  ( '-fmin', SpecMinFreq, 5.0 , 5.0 )

      call argr4  ( '-maxar', MaxAmpRatio, 0.0 , 0.0 )
      call argr4  ( '-maxa', MaxAmp, 0.0 , 0.0 )
      call argr4  ( '-maxc', MaxChar, 0.0 , 0.0 )
      call argr4  ( '-maxd', MaxDecay, 0.0 , 0.0 )
      call argr4  ( '-maxfam', MaxFreqAboveMute, 0.0 , 0.0 )
      call argr4  ( '-maxf', MaxFreq, 0.0 , 0.0 )
      call argr4  ( '-maxs', MaxSpectralSum, 0.0 , 0.0 )
      call argi4  ( '-md', MinOffset, 0 , 0 )
      call argr4  ( '-minar', MinAmpRatio, 0.0 , 0.0 )
      call argr4  ( '-mina', MinAmp, 0.0 , 0.0 )
      call argr4  ( '-minc', MinChar, 0.0 , 0.0 )
      call argr4  ( '-mind', MinDecay, 0.0 , 0.0 )
      call argr4  ( '-minfam', MinFreqAboveMute, 0.0 , 0.0 )
      call argr4  ( '-minf', MinFreq, 0.0 , 0.0 )
      call argr4  ( '-mins', MinSpectralSum, 0.0 , 0.0 )
      
      call argi4  ( '-ne', ne, 0 , 0 )
      call argi4  ( '-ns', ns, 1 , 1 )
      call argstr ( '-N', ntap, ' ', ' ' )
      
      call argstr ( '-O', otap, ' ', ' ' )
      
      QC = ( argis ( '-qc' ) .gt. 0 )

      call argi4  ( '-re', ire  , 0 , 0 )
      call argi4  ( '-rs', irs  , 1 , 1 )
      
      call argi4  ( '-s',ist, 0  ,  0 )
      
      call argr4  ( '-t0', Tzero, 0.0 , 0.0 )

      verbos = ( argis ( '-V' ) .gt. 0 )
      call argr4  ( '-v', Velocity, 100000.0 , 100000.0 )

      if ( .not. QC ) then
         
         if ( abs(MaxAmp) .lt. 1.e-30 .and.
     :        abs(MaxAmpRatio) .lt. 1.e-30 .and.
     :        abs(MaxFreq) .lt. 1.e-30 .and.
     :        abs(MaxFreqAboveMute) .lt. 1.e-30 .and.
     :        abs(MaxChar) .lt. 1.e-30 .and.
     :        abs(MaxDecay) .lt. 1.e-30 .and.
     :        abs(MaxSpectralSum) .lt. 1.e-30 .and.
     :        abs(MinAmp) .lt. 1.e-30 .and.
     :        abs(MinAmpRatio) .lt. 1.e-30 .and.
     :        abs(MinFreq) .lt. 1.e-30 .and.
     :        abs(MinFreqAboveMute) .lt. 1.e-30 .and.
     :        abs(MinChar) .lt. 1.e-30 .and.
     :        abs(MinDecay) .lt. 1.e-30 .and.
     :        abs(MinSpectralSum) .lt. 1.e-30 ) then
            write(lerr, * ) ' '
            write(lerr, * ) 'TRSTAT: If you are trying to '
            write(lerr, * ) '        process your data for'
            write(lerr, * ) '        real you need to supply'
            write(lerr, * ) '        at least one set of '
            write(lerr, * ) '        min and max rejection criteria'
            write(lerr, * ) '        on the command line'
            write(lerr, * ) 'FATAL'
            write(ler, * ) ' '
            write(ler, * ) 'TRSTAT: If you are trying to '
            write(ler, * ) '        process your data for'
            write(ler, * ) '        real you need to supply'
            write(ler, * ) '        at least one set of '
            write(ler, * ) '        min and max rejection criteria'
            write(ler, * ) '        on the command line'
            write(ler, * ) 'FATAL'
            stop
         endif


c need both max and min defined for character

         if ( (abs(MaxChar) .gt. 1.e-30 .or.
     :        abs(MinChar) .gt. 1.e-30) .and.
     :        (abs(MaxChar) .lt. 1.e-30 .or.
     :        abs(MinChar) .lt. 1.e-30) ) then
            write(lerr, * ) ' '
            write(lerr, * ) 'TRSTAT: For character based editting'
            write(lerr, * ) '        you need to include BOTH -maxc '
            write(lerr, * ) '        and -minc'
            write(lerr, * ) 'FATAL'
            write(ler, * ) ' '
            write(ler, * ) ' '
            write(ler, * ) 'TRSTAT: For character based editting'
            write(ler, * ) '        you need to include BOTH -maxc '
            write(ler, * ) '        and -minc'
            write(ler, * ) 'FATAL'
            stop
         endif

      endif

      return
      end

