C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine mint6a(uirreg,ueql,
     1                  w,leftzeta,idiv,ndiv,   
     2                  ITRWRD,nirreg,nbuf,minsamp,maxsamp,stderr)                 
c
      integer   leftzeta(minsamp:maxsamp),idiv(minsamp:maxsamp)
c
      real      uirreg(-ITRWRD:nbuf)         
      real      ueql(minsamp:maxsamp)
      real      w(-2:+3,0:ndiv)    
      integer   stderr
c_____________________________________________________________________
c     convolve 6 point interpolation operator with data.
c     loop unrolling version.
c_____________________________________________________________________
c_____________________________________________________________________
c      pad to allow for interpolation operator edges.
c      warning: this will destroy other data in these edges  (such
c      as header words).
c_____________________________________________________________________
      if(nirreg+3 .gt. nbuf .or. -1 .lt. -ITRWRD) then
         write(stderr,*) 'error in routine minterp6'
         write(stderr,*) 'insufficient buffer space at beginning '//
     1              ' or end of input array uirreg'
         write(stderr,*) '-ITRWRD = ',-ITRWRD,' must be .lt. ',-1
         write(stderr,*) 'nbuf  = ',nbuf ,' must be .gt. ',nirreg+3
         close(lerr)
         call exitfu(666)
      endif
       uirreg(-2)=uirreg(0)
       uirreg(-1)=uirreg(0)
       uirreg(nirreg+1)=uirreg(nirreg)
       uirreg(nirreg+2)=uirreg(nirreg)
       uirreg(nirreg+3)=uirreg(nirreg)
c_____________________________________________________________________
c     loop over output sample locations
c_____________________________________________________________________
      do 40000 k=minsamp,maxsamp     
       kl=leftzeta(k)
       if(kl .lt. 0) then
c_____________________________________________________________________
c         output sample not spanned by twt. set it to zero.
c_____________________________________________________________________
          ueql(k)=0.
       else
c_____________________________________________________________________
c          interpolate.
c_____________________________________________________________________
          jdiv=idiv(k)
          ueql(k)=uirreg(kl-2)*w(-2,jdiv) 
     1               +uirreg(kl-1)*w(-1,jdiv) 
     2               +uirreg(kl  )*w( 0,jdiv) 
     3               +uirreg(kl+1)*w(+1,jdiv) 
     4               +uirreg(kl+2)*w(+2,jdiv) 
     5               +uirreg(kl+3)*w(+3,jdiv) 
       endif
40000 continue
c
      return   
      end
