C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine rdtwt(twt_grid,twt_interp,lefttwt,idiv,
     1                 xgrid,ITRWRD,nz,nxgrid,dteql,ndiv,
     2                 firstcrp,lastcrp,minsamp,maxsamp,
     3                 ifmt_SrPtXC,l_SrPtXC,ln_SrPtXC,TRACEHEADER,
     4                 dcrp,lerr,lutwt)
c
      integer   firstcrp,lastcrp,leftcrp,rightcrp
      real      twt_grid(-ITRWRD:nz,nxgrid)               
      real      twt_interp(0:nz)
      real      xgrid(nxgrid)
c
      integer   lefttwt(minsamp:maxsamp,firstcrp:lastcrp)
      integer   idiv(minsamp:maxsamp,firstcrp:lastcrp)
c_______________________________________________________________________
c     read in the two way travel time cross section calculated on an
c     irregular grid.                      
c     calculate points needed for interpolation to a regular time grid.
c_______________________________________________________________________
      do 10000 jxgrid=1,nxgrid     
       nbyptr=0
       call rtape(lutwt,twt_grid(-ITRWRD,jxgrid),nbyptr)
       call saver2(twt_grid(-ITRWRD,jxgrid),
     1         ifmt_SrPtXC,l_SrPtXC,ln_SrPtXC,jval,TRACEHEADER)
       xgrid(jxgrid)=jval
10000 continue
      leftcrp=xgrid(1)/dcrp   
      rightcrp=xgrid(nxgrid)/dcrp+.99999
      if(firstcrp .le. leftcrp) then
c_______________________________________________________________________
c        set all twt_interp for crps lieing to the left of xgrid(1) to be 
c        equal to the twt_grid(jz,1).
c_______________________________________________________________________
         call tau2t(twt_grid(0,1),nz,dteql,minsamp,maxsamp,
     1              lefttwt(minsamp,firstcrp),idiv(minsamp,firstcrp),
     2              ndiv,lerr)
         do 32000 jcrp=firstcrp+1,leftcrp
          do 31000 jt=minsamp,maxsamp
           lefttwt(jt,jcrp)=lefttwt(jt,firstcrp)
           idiv(jt,jcrp)=idiv(jt,firstcrp)
31000     continue
32000    continue
      endif

      if(lastcrp .ge. rightcrp) then
c_______________________________________________________________________
c        set all twt_interp for crps lieing to the right of xgrid(nxgrid)
c        to be equal to the twt_grid(jz,nxgrid)
c_______________________________________________________________________
         call tau2t(twt_grid(0,nxgrid),nz,dteql,minsamp,maxsamp,
     1              lefttwt(minsamp,lastcrp),idiv(minsamp,lastcrp),
     2              ndiv,lerr)
         do 34000 jcrp=rightcrp,lastcrp-1
          do 33000 jt=minsamp,maxsamp
           lefttwt(jt,jcrp)=lefttwt(jt,firstcrp)
           idiv(jt,jcrp)=idiv(jt,firstcrp)
33000     continue
34000    continue
      endif
c_______________________________________________________________________
c     interpolate twt from the original velocity file gridded at dxgrid
c     to the input seismic crps data gridded at dcrp.
c_______________________________________________________________________
      write(lerr,'(//,a)') 'interpolation from velocity grid to '
     1                    //'seismic crp grid'
      write(lerr,'(a5,3a15,2a10)') 'jcrp','xgrid(jxgrid-1)','xcrp',
     1                 'xgrid(jxgrid)','w1','w2'
      do 50000 jxgrid=2,nxgrid
       jcrp1=xgrid(jxgrid-1)/dcrp+1
       jcrp2=xgrid(jxgrid)/dcrp
       jcrp1=max(jcrp1,firstcrp)
       jcrp2=min(jcrp2,lastcrp)
       do 40000 jcrp=jcrp1,jcrp2      
        xcrp=jcrp*dcrp
        w2=(xcrp-xgrid(jxgrid-1))/(xgrid(jxgrid)-xgrid(jxgrid-1))
        w1=1.-w2
        write(lerr,'(i5,3f15.3,2f10.3)') jcrp,xgrid(jxgrid-1),xcrp,
     1                 xgrid(jxgrid),w1,w2
        do 35000 jz=0,nz                     
         twt_interp(jz)=w1*twt_grid(jz,jxgrid-1)+w2*twt_grid(jz,jxgrid)
35000   continue
        call tau2t(twt_interp(0),nz,dteql,minsamp,maxsamp,
     1             lefttwt(minsamp,jcrp),idiv(minsamp,jcrp),
     2             ndiv,lerr)
40000  continue
50000 continue

C
      return
      end 
