C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C******************************************************************
C                                                                 
C     SUBROUTINE - DOSTAK            ENTRY POINT - DOSTAK        
C                                                               
C     LANGUAGE - FORTRAN 77                                    
C     SYSTEM(S) - SUN, CRAY2                                         
C     AUTHOR - Richard Crider                                
C     DATE WRITTEN - January 28, 1991
C                                                          
C                AMOCO PRODUCTION CO. PROPRIETARY
C                 TO BE MAINTAINED IN CONFIDENCE
C                                                        
C     ABSTRACT - Do angle stacking as a function of velocity and
C                offset.
C                                                            
C     USAGE                                                 
C                                                          
C          CALL DOSTAK(NS,VCOEF, DATA, ANGLES, STAK, DX,
C                       ANGMN, ANGMX, NANG, ntr, dt, LIVEBF,
C                       TIMVEC, VRMS, mode emerg,app_mute,vtmax,
C                       ierr, errparms,vsrms,vism,vit)
C                                                       
C               NS    =  NUMBER OF SAMPLES PER TRACE.              
C            VCOEF    =  RMS VELOCITY COEFFICIENTS
C              DATA   =  TRACE DATA
C             ANGLES  =  Returned ANGLES MATRIX
C              STAK   =  Returned angle staks
C              DX     =  TRACE DISTANCES
C            ANGMN    =  MINIMUM ANGLE VECTOR
C            ANGMX    =  MAXIMUM ANGLE VECTOR
C             NANG    =  NUMBER OF ANGLE STACKS
C              NTR    =  NUMBER OF TRACES PER RECORD
C             dt      =  sample interval, in seconds.
C          LIVEBF     =  counter buffer for live samples in each stak.
C           TIMVEC    =  Vector containing time (in sec) for each
C                        sample.
C            VRMS     =  RMS Velocity vector, 1 value for each
C                        sample.
C            MODE     =  Solution type
C                        0 = Straight Ray
C                        1 = Curved Ray
C                        2 = Perturbed Curved Ray
C           EMERG     =  Angle type   
C                        0 = Incident     
C                        1 = Emergence 
C           app_mute  =  Output type
C                        .false. = angle-dependent stacks
C                        .true.  = angle-dependent mute 
C            VTMAX    =  Valid last time for velocity vector  
C             IERR    =  Error flag to be returned by crvray(creray)
C          ERRPARMS   =  V2,V1,T2,T1, error time for error r  
C                        returned by crvray(creray)     
C            vsrms    =  Smoothed rms function
C            vism     =  Smooth interval velocities
C             vit     =  Inteval velocities from vrms
C                                                      
C     ERROR/RETURN CODES - ierr                 
C                          1 = error in crvray 
C                                              
C***************************************************************
      subroutine angmat (ns, vcoef, data, angles, gainmat, dx,
     *                   ntr, dt, timvec, vrms, mode,
     *                   emerg, vtmax, ierr, errparms, vsrms, vism,
     *                   vit, gain)
C                                                            
C       DATA DECLARATIONS                                   
      real    data(*), gainmat(*), angles(*), vcoef(*)
      real    timvec(*), vrms(*),vsrms(*),vism(*),vit(*)
      real    dx(*), errparms(*)
      integer emerg,ierr
      logical gain
C
      call sizefloat(jsz)
      ier = 0
      iget =jsz*ntr
      do i=1,ntr
       if(dx(i).eq.0.0)dx(i)=0.0005
      end do
      const = 57.295
      delt = dt/2.
      iws=1
      iwe=ns
      ierr = 0
c +=================================================+
c |  crvray and creray build the "angles" matrix    |
c +=================================================+

       if(emerg.eq.0)then
        call crvray(ntr,angles,timvec,dx,vrms,vcoef,
     :  delt,ns,mode,vtmax,ierr,errparms,vsrms,vism,vit,const)
        if(ierr.ne.0)return
       else
        call creray(ntr,angles,timvec,dx,vrms,vcoef,
     :  delt,ns,mode,vtmax,ierr,errparms,vsrms,vism,vit,const)
        if(ierr.ne.0)return
       endif

      rmsin = 0
      do  i = 1, ntr*ns
          d = data (i)
          rmsin = rmsin + d*d
      enddo
      rmsin = sqrt( rmsin/float(ntr*ns) )

      call gainap (ns, ntr, delt, dx, angles, gainmat, vism, vsrms)

      if ( gain ) then
         do  i = 1, ntr*ns
             data (i) = gainmat (i)
         enddo
      else
         rmsout = 0
         do  i = 1, ntr*ns
             d = data (i)
             d = d * gainmat (i)
             data (i) = d
             rmsout = rmsout + d*d
         enddo
         rmsout = sqrt( rmsout/float(ntr*ns) )
         fac = rmsin / rmsout
         do  i = 1, ntr*ns
             data (i) = data (i) * fac
         enddo
   
      endif

      return
      end
