C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine findpeak(c,amp,
     1                    k,ifl,ifh,df,f_peak,amp_peak)
c
      real      amp(ifl:ifh)
      real      f_peak,amp_peak
      real      c(2,ifl:ifh)
c_________________________________________________________________
c     interpolate the position of the 'peak' value of function a, 
c     by running a parabola throught 3 points centered at point 'k'.
c
c     eqn of the parabola has the form:
c
c     amp(t)=a*(t-f0)**2+b
c
c     where f and f0 are measured relative to k 
c     such that:
c
c     amp(+df)=a*(df**2-2*df*f0+f0**2)+b
c     amp(  0)=a*(                 f0**2)+b
c     amp(-df)=a*(df**2+2*df*f0+f0**2)+b
c
c     damp=amp(+df)-amp(-df)=-4*a*df*f0
c
c     d2amp=amp(+df)-2.*amp(0)+amp(-df)=2*a*df**2
c
c     giving:
c
c     f_peak=-.5*df*damp/d2amp
c
c     a=-(amp(+df)-amp(-df))/(4*df*f0)
c     b=amp(0)-a*f0**2 
c     
c_________________________________________________________________
      if(k .eq. ifl .or. k .eq. ifh) then
         f_peak=k*df
         amp_peak=amp(k)
      else
c_________________________________________________________________
c        calculate amp_peak, the value of the peak amplitude,
c        and f_peak, the frequency at which it occurs.
c_________________________________________________________________
         damp=amp(k+1)-amp(k-1)
         d2amp=amp(k+1)-2.*amp(k)+amp(k-1)
         if(d2amp .eq. 0.) then
            f0=0.
         else
            f0=-.5*damp/d2amp
         endif
c
         a=-damp/(4*f0)
         b=amp(k)-a*(-f0)**2 
c
         f_peak=(k+f0)*df
         amp_peak=b   
      endif
C
      return
      end


