C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine ltaper(dwgt,uwgt,ataper,ifl,ifh,lerr)
      real   dwgt(ifl:ifh),uwgt(ifl:ifh)
c_______________________________________________________
c     generate a linear taper that varies from 
c     1 at jf=0 to ataper at jf=ifh.
c_______________________________________________________
      write(lerr,*) 'taper to bias us towards the '//
     1              'first peak'
      write(lerr,'(3a15)') 'frequency','dwgt','uwgt'
      slope=(1.-ataper)/ifh           
      do jf=ifl,ifh
       dwgt(jf)=1.-jf*slope
       uwgt(jf)=1.-(ifh-jf)*slope
      write(lerr,'(i15,2f12.3)') jf,dwgt(jf),uwgt(jf)
      end do
c
      return
      end
