      program tune3d  
c====================================================================
c     3-D tuning cube analysis. 
c     (based on D1 spectral decomposition concept).  
c====================================================================
c     Original D1 Algorithm (7/95):  James M. Gridley &  Greg A. Partyka
c                                    Amoco EPTG, Tulsa, OK, USA
c
c     Peak frequency concept (1/96):  A. Kurt Toellestrup & Charlie. V. Mims
c                                     Amoco OBU, New Orleans, LA, USA
c
c     Vectorization/Interpolation (4/96):   Kurt J. Marfurt
c                                     Amoco EPTG, Tulsa, OK, USA
c
c     Linking to program swak (6/97)
c
c     ratio attribute (10/98)         Kurt J. Marfurt
c                                     Amoco EPTG, Tulsa, OK, USA
c______________________________________________________________________
c
c     AUTHORIZATION FOR USE BY NON AMOCO EMPLOYEES
c
c     This Software is owend by AMOCO Production Company. Non-Amoco users
c     require from AMOCO a license to use this Software and any related
c     documentation. This license may be terminated by AMOCO. Upon termination,
c     the originals and all copies or reproductions of the Software, including
c     any instruction manuals or program docmentation relating thereto, must be
c     returned to AMOCO. You may \fInot\fR sub-license, rent, assign or
c     transfer any rights to use the Software. If any copy of the Software
c     or any documentation is made for backup purposes, it must be marked:
c
C |               copyright 2001, Amoco Production Company             |
C |                           All Rights Reserved                      |
C |                   an affiliate of BP America Inc.                  |
c 
c     AMOCO does not warrent, guarantee, or make any representations regarding
c     the use of, or results of the use of, the Software in terms of
c     correctness, accuracy, reliability, currentness, or otherwise. The
c     results and performance of the Software is assumed by you.
c
c     No oral or written information or advise given by AMOCO or its employees
c     shall create or in any way increase the scope of any warranty relating
c     to the use of, or results of using the Software and you may NOT rely on
c     any such information or advise.
c
c     Amoco will NOT be responsible or liable for any loss, destruction of
c     property, lost profits or other damages whatsoever, including any direct,
c     indirect, incidental, consequential or punitive damages of any nature
c     which may be caused by or result from your use of the Software, even if
c     AMOCO has been advised of the possibility of such damages.
c
c     All warrantees, including all implied warranties of merchantability and
c     fitness for a particular purpose, are disclaimed.
c
c______________________________________________________________________
c
c     declare variables
c
#include     <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#ifdef CRAYSYSTEM
      parameter (maxchar=14)
#else
      parameter (maxchar=32)
#endif
      parameter (maxs=0 000 002)
      dimension s(maxs)
      pointer   (pntrs,s)

      parameter   (pi=3.1415926,twopi=2.*pi)
c
      integer     sheader(SZLNHD)
      real        cputim(20),waltim(20)
#include <f77/pid.h>
      parameter (undefined=+99999.)
c
      character*256  file_in,file_out
      character*256  file_scale
      character*256  file_f_peak,file_amp_peak,file_f_mean
      character*256  file_f_trough,file_amp_trough,file_amp_mean
      character*7    name
      logical        verbose,flowmaker,query,IKP
      logical        wrf_peak,wramp_peak,wrf_mean
      logical        wrf_trough,wramp_trough,wramp_mean
      logical        calc_peak,calc_mean,calc_trough
      logical        normalize,green
      logical        eof
      logical        frequencies
      character*9    host,blank9
      integer        pipe(12)
      integer        argis
      data           name/'TUNE3D'/
      data           host/'         '/
      data           blank9/'         '/
      data           pipe/1,2,3,4,5,6,7,8,9,10,11,12/

c_______________________________________________________________
c     check to see if we are running under IKP.
c_______________________________________________________________
      call ikpchk(host)
      if(host .ne. blank9) then
         IKP=.true.
      else
         IKP=.false.
      endif

c_______________________________________________________________
c     initialize timing arrays.
c_______________________________________________________________
      call vclr(cputim,1,20)
      call vclr(waltim,1,20)
      call timstr(vtot,wtot)
      call timstr(v1,w1)
c_______________________________________________________________
c     read program parameters from command line card image file
c_______________________________________________________________
      query=(argis( '-?' ) .gt. 0 )
      if(query) then
         call help(ler)
c        call exit(0)
	 stop 0
      endif
c_______________________________________________________________
c     open printout files
c_______________________________________________________________
#include <f77/open.h>
c_______________________________________________________________
c     get i/o data set names
c_______________________________________________________________
      call argstr('-N',file_in, ' ', ' ')
      call argstr('-S',file_scale,' ', ' ')
      call argstr('-f_peak',file_f_peak, ' ', ' ')
      call argstr('-f_trough',file_f_trough, ' ', ' ')
      call argstr('-f_mean',file_f_mean, ' ', ' ')
      call argstr('-amp_peak',file_amp_peak, ' ', ' ')
      call argstr('-amp_trough',file_amp_trough, ' ', ' ')
      call argstr('-amp_mean',file_amp_mean, ' ', ' ')
      call argr4('-ataper',ataper,.5,.5)
      call argr4('-thmin',thmin,10.,10.)
      call argr4('-thmax',thmax,100.,100.)
      call argr4('-dth',dth,10.,10.)
      green=(argis('-G') .gt. 0)
      verbose=(argis('-V') .gt. 0)
      normalize=(argis('-normalize') .gt. 0)
      ithl=nint(thmin/dth)
      ithh=nint(thmax/dth)
c_______________________________________________________________
c     If -flowmaker is specified, then we know we are running
c     from flowmaker.  We expect to see either a -f_peak or -amp_peak
c     option.  Whichever is specified will default to stdout.  If
c     "-O fn" shows up, then the results will go to "fn" instead.
c_______________________________________________________________
      flowmaker=(argis('-flowmaker') .gt. 0)
      call argstr('-O',file_out, ' ', ' ')
c_______________________________________________________________
c     get logical unit numbers for input and output
c_______________________________________________________________
      call getln(luin,file_in,'r', 0)
      if(file_scale .ne. ' ') then
         call lbopen(luscale,file_scale,'r')
      else
         if (IKP) then
            call sisfdfit(luscale,pipe(12))
         endif
      endif
c_______________________________________________________________
c     see which files are requested from the command line.
c     open them up.
c     initialize a logical variable for those that are to be
c     written out.
c_______________________________________________________________
      if(file_f_peak .ne. ' ') then
         wrf_peak=.true.
         if (flowmaker) then
            if (file_out .ne. ' ') then
               call lbopen(luf_peak,file_out,'w')
            else
               luf_peak = 1
            endif
         else
            call lbopen(luf_peak,file_f_peak,'w')
         endif
      else
         if (IKP) then
            wrf_peak = (pipcnt(pipe(3),1) .gt. 0)
            if (wrf_peak) call sisfdfit(luf_peak,pipe(3))
         else
            wrf_peak=.false.
         endif
      endif
      if(file_f_trough .ne. ' ') then
         wrf_trough=.true.
         call lbopen(luf_trough,file_f_trough,'w')
      else
         if (IKP) then
            wrf_trough = (pipcnt(pipe(8),1) .gt. 0)
            if (wrf_trough) call sisfdfit(luf_trough,pipe(8))
         else
            wrf_trough=.false.
         endif
      endif
      if(file_amp_trough .ne. ' ') then
         wramp_trough=.true.
         call lbopen(luamp_trough,file_amp_trough,'w')
      else
         if (IKP) then
            wramp_trough = (pipcnt(pipe(9),1) .gt. 0)
            if (wramp_trough) call sisfdfit(luamp_trough,pipe(9))
         else
            wramp_trough=.false.
         endif
      endif
      if(file_amp_mean .ne. ' ') then
         wramp_mean=.true.
         call lbopen(luamp_mean,file_amp_mean,'w')
      else
         if (IKP) then
            wramp_mean = (pipcnt(pipe(10),1) .gt. 0)
            if (wramp_mean) call sisfdfit(luamp_mean,pipe(10))
         else
            wramp_mean=.false.
         endif
      endif

      if(file_amp_peak .ne. ' ') then
         wramp_peak=.true.
         if (flowmaker) then
            if (file_out .ne. ' ') then
               call lbopen(luamp_peak,file_out,'w')
            else
               luamp_peak = 1
            endif
         else
            call lbopen(luamp_peak,file_amp_peak,'w')
         endif
      else
         if (IKP) then
            wramp_peak = (pipcnt(pipe(4),1) .gt. 0)
            if (wramp_peak) call sisfdfit(luamp_peak,pipe(4))
         else
            wramp_peak=.false.
         endif
      endif
      if(file_f_mean .ne. ' ') then
         wrf_mean=.true.
         call lbopen(luf_mean,file_f_mean,'w')
      else
         if (IKP) then
            wrf_mean = (pipcnt(pipe(5),1) .gt. 0)
            if (wrf_mean) call sisfdfit(luf_mean,pipe(5))
         else
            wrf_mean=.false.
         endif
      endif
c_______________________________________________________________________
c     initialize logical variables to drive the calculations.
c_______________________________________________________________________
      calc_peak=wrf_peak .or. wramp_peak .or. wrf_mean
      calc_trough=wrf_trough .or. wramp_trough .or. wramp_mean
      calc_mean=(wramp_mean .or. wrf_mean .or. normalize)
c_______________________________________________________________________
c     read in the seismic line header.
c_______________________________________________________________________
      lbytes=0
      call rtape(luin,sheader,lbytes)
      if(lbytes .eq. 0) then
         write(lerr,*)'TUNE3D: no header read from unit ',luin
         write(ler,*)'TUNE3D: no header read from unit ',luin
         call exitfu(1666)
      endif
c_______________________________________________________________________
c     pull relevent values from line header.
c_______________________________________________________________________
      call saver(sheader,'NumSmp',nsamp_in,LINEHEADER)
      call saver(sheader,'SmpInt',nsi,LINEHEADER)
      call saver(sheader,'NumRec',nrec_in,LINEHEADER)
      call saver(sheader,'NumTrc',ntr,LINEHEADER)
      call saver(sheader,'TmMsFS',tstart_orig,LINEHEADER)
      call saver(sheader,'TmMsSl',jtstart_orig,LINEHEADER)
      call saver(sheader,'TmSlIn',jtslice_orig,LINEHEADER)
      call saver(sheader,'Dz1000',dzh,LINEHEADER)
      call saver(sheader,'T_Unit',junits,LINEHEADER)
c_______________________________________________________________________
c     read in the line header from wavelet scale file generated in
c     program swak.
c_______________________________________________________________________
      lbytes=0
      call rtape(luscale,sheader,lbytes)
      if(lbytes .eq. 0) then
         write(lerr,*)'TUNE3D: no header read from unit ',luscale
         write(ler,*)'TUNE3D: no header read from unit ',luscale
         call exitfu(1666)
      endif
c_______________________________________________________________________
c     pull relevent values from line header.
c_______________________________________________________________________
      call saver(sheader,'TmMsFS',tstart,LINEHEADER)
      call saver(sheader,'TmMsSl',jtstart,LINEHEADER)
      call saver(sheader,'TmSlIn',jtslice,LINEHEADER)
      call saver(sheader,'NumSmp',nsamp_out,LINEHEADER)
      call saver(sheader,'MnGrEl',ifl,LINEHEADER)
      call saver(sheader,'MxGrEl',ifh,LINEHEADER)
      call saver(sheader,'MutVel',df,LINEHEADER)
      call saver(sheader,'OrNREC',nwindow,LINEHEADER)
      call saver(sheader,'OrNTRC',nptaper,LINEHEADER)
      tskip=jtslice
      tend=tstart+(nsamp_out-1)*tskip
      fmin=ifl*df
      fmax=ifh*df
      twindow=nwindow
      ptaper=nptaper
c
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      nx=ntr-1
      if(junits .eq. 1) then
c_______________________________________________________________________
c        input data are in microseconds.
c_______________________________________________________________________
         dtmsec=.001*nsi
      else
c_______________________________________________________________________
c        input data are in milliseconds.
c_______________________________________________________________________
         dtmsec=nsi
      endif
      dt=.001*dtmsec
c
      tend_orig=tstart_orig+(nsamp_in-1)*dtmsec
      istart=nint((tstart-tstart_orig)/dtmsec)
      iend=nint((tend-tstart_orig)/dtmsec)
      istart=max(0,istart)
      iend=min(nsamp_in-1,iend)
      iskip=nint(tskip/dtmsec)
      iskip=max(iskip,1)
      nsamp_out=(iend-istart+1)/iskip
c_______________________________________________________________________
c     sample spectrum with equal frequencies.
c_______________________________________________________________________
      frequencies=.true.
      dfp=df
      hw_outer=twindow/2.
      ttaper=hw_outer*.01*ptaper
      hw_inner=hw_outer-ttaper
      lenw_outer=hw_outer/dtmsec
      lenw_inner=hw_inner/dtmsec+.9999
      if(lenw_outer .lt. 1) then
         write(lerr,*) 'error in tune3d!'
         write(lerr,*) 'operator window is less than 3 samples!'
         write(lerr,*) 'twindow read from line header as ',twindow 
         write(lerr,*) 'dtmsec = ',dtmsec
         close(lerr)
         call exitfu(1666)
      endif
      ncomponent=ifh-ifl+1
      nbytes_in=(ITRWRD+nsamp_in)*szsmpd
      nbytes_out=(ITRWRD+nsamp_out)*szsmpd
      nsi_out=tskip
      nrec_out=nrec_in*ntr         
      call hlhprt (sheader,lbytes,name,len(name),lerr)
c
      write(lerr,*)
      write(lerr,'(//,a)') 'INPUT FILE DESCRIPTION'
      write(lerr,'(a,t40,a)') '3-D seismic cube',file_in
      write(lerr,'(//,a)') 'OUTPUT  DESCRIPTION'
      if(wrf_peak) write(lerr,'(a,t40,i5,a)') 
     1         '3-D f_peak frequency',luf_peak,file_f_peak
      if(wrf_mean) write(lerr,'(a,t40,i5,a)') 
     1  '3-D mean frequency',luf_mean,file_f_mean
      if(wrf_trough) write(lerr,'(a,t40,i5,a)') 
     1         '3-D trough frequency',luf_trough,file_f_trough
      if(wramp_peak) write(lerr,'(a,t40,i5,a)') 
     1  '3-D amplitude at peak frequency',luamp_peak,file_amp_peak
      if(wramp_trough) write(lerr,'(a,t40,i5,a)') 
     1  '3-D amplitude at trough frequency',luamp_trough,file_amp_trough
      if(wramp_mean) write(lerr,'(a,t40,i5,a)') 
     1  '3-D mean amplitude',luamp_mean,file_amp_mean
      write(lerr,'(a,t40,i5)') 'number of input samples',nsamp_in
      write(lerr,'(a,t40,i5)') 'number of input traces',ntr  
      write(lerr,'(a,t40,i5)') 'number of input records',nrec_in 
      write(lerr,'(a,t40,i8)') 'number of output records',nrec_out
      write(lerr,'(a,t40,f12.6)') 'sample interval (msec)',dtmsec
      write(lerr,'(a,t40,f12.6)') 'sample interval (sec)',dt
      write(lerr,'(a,t40,f12.6)') 'original start time (msec)',
     1                             tstart_orig
      write(lerr,'(a,t40,f12.6)') 'original end time (msec)',
     1                             tend_orig
      write(lerr,'(a,t40,f12.6)') 'output start time (msec)',
     1                             tstart
      write(lerr,'(a,t40,f12.6)') 'output end time (msec)',
     1                             tend
      write(lerr,'(a,t40,f12.6)') 'skip time (msec)',tskip   
      write(lerr,'(a,t40,f12.6)') 'operator window (msec)',twindow
      write(lerr,'(a,t40,f12.6)') 'window taper (%)', ptaper
      write(lerr,'(a,t40,f12.6)') 'window taper (msec)', ttaper
      write(lerr,'(a,t40,i5)') 'half inner window (samples)',
     1                          lenw_inner
      write(lerr,'(a,t40,i5)') 'half outer window (samples)',
     1                          lenw_outer
      write(lerr,'(a,t40,i5)') 'start time (samples)',istart
      write(lerr,'(a,t40,i5)') 'end time (samples)',iend  
      write(lerr,'(a,t40,i5)') 'skip time (samples)',iskip 
      write(lerr,'(a,t40,i5)') 'output samples per trace',nsamp_out
      write(lerr,'(a,t40,i5)') 'input bytes per trace',nbytes_in
      write(lerr,'(a,t40,i5)') 'output bytes per trace',nbytes_out
      write(lerr,*) ('_',i=1,80)
      write(lerr,*) 'Equal frequency increment mode'
      write(lerr,*) ('_',i=1,80)
      write(lerr,'(a,t40,f12.6)') 'minimum frequency (Hz)',fmin  
      write(lerr,'(a,t40,f12.6)') 'maximum frequency (Hz)',fmax  
      write(lerr,'(a,t40,f12.6)') 'frequency increment (Hz)',df
      write(lerr,'(a,t40,i5)') 'ifl',ifl,'ifh',ifh
      write(lerr,'(a,t40,f12.6)') 'minimum thickness (ms)',thmin  
      write(lerr,'(a,t40,f12.6)') 'maximum thickness (ms)',thmax  
      write(lerr,'(a,t40,f12.6)') 'thickness increment (ms)',dth
      write(lerr,'(a,t40,i5)') 'ithl',ithl,'ithh',ithh
      write(lerr,'(a,t40,f12.6)') 'amplitude taper at fmax ',
     1         ataper
      write(lerr,'(a,t40,i5)') 
     1           'number of output spectral components',ncomponent
      write(lerr,'(a,t40,l5)') 'calc_peak',calc_peak,
     1  'calc_mean',calc_mean,'calc_trough',calc_trough
c
      write(lerr,'(a,t40,l5)') 'compare to greens fcn?',green
      write(lerr,'(a,t40,l5)') 'normalize results?',normalize
      write(lerr,'(a,t40,l5)') 'verbose output?',verbose     
      write(lerr,*)' '
      nf=(ifh-ifl+1)
      lenu=iend-istart+1+2*lenw_outer
      lenamp=(iend-istart+1)*nf
      lenout=(iend-istart+1)*(nx+1)
      lentable=2*(iend-istart+1+2*lenw_outer)*(ifh-ifl+1)
      lenbuf=ITRWRD+max(nsamp_in,nsamp_out)
      lenscale=(iend-istart+1)*nf
      nth=(ithh-ithl+1)
      nmodel=nth*nf
c______________________________________________________________________
c     calculate memory requirements
c______________________________________________________________________
      write(lerr,'(///,80a1)') ('_',i=1,80)
      write(lerr,'(A)')'storage map of major arrays'
      write(lerr,'(80a1)') ('_',i=1,80)
C
      l_free=1
c____________________________________________________________________
      write(lerr,'(a20,3a10)')'variable name','begin','end','length'
      call mapmem('uin',l_uin,l_free,lenu*(nx+1),lerr)
      call mapmem('live',l_live,l_free,nx+1,lerr)
      call mapmem('uexp',l_uexp,l_free,2*lenu,lerr)
      call mapmem('cspec',l_cspec,l_free,2*(iend-istart+1)*nf,lerr)
      call mapmem('amp',l_amp,l_free,lenamp,lerr)
      call mapmem('f_peak',l_f_peak,l_free,lenout,lerr)
      call mapmem('amp_peak',l_amp_peak,l_free,lenout,lerr)
      call mapmem('f_mean',l_f_mean,l_free,lenout,lerr)
      call mapmem('f_trough',l_f_trough,l_free,lenout,lerr)
      call mapmem('amp_trough',l_amp_trough,l_free,lenout,lerr)
      call mapmem('amp_mean',l_amp_mean,l_free,lenout,lerr)
      call mapmem('tabledexp',l_tabledexp,l_free,lentable,lerr)
      call mapmem('tracebuf',l_tracebuf,l_free,lenbuf,lerr)
      call mapmem('trheader',l_trheader,l_free,(nx+1)*ITRWRD,lerr)
      call mapmem('omega',l_omega,l_free,ifh-ifl+1,lerr)           
      call mapmem('dwgt',l_dwgt,l_free,ifh-ifl+1,lerr)           
      call mapmem('uwgt',l_uwgt,l_free,ifh-ifl+1,lerr)           
      call mapmem('twgt',l_wgt,l_free,2*lenw_outer+1,lerr)           
      call mapmem('scale',l_scale,l_free,lenscale,lerr)           
      call mapmem('rho',l_rho,l_free,nth,lerr)           
      call mapmem('amodel',l_amodel,l_free,2*nmodel,lerr)           
C_______________________________________________________________________
C     allocate dynamic memory.
C_______________________________________________________________________
      lens=l_free-1
      write(lerr,'(a20,10x,i10)') 'total vector length',lens
      write(ler,'(a20,10x,i10)') 'allocate ',lens,' words of memory'
      call galloc(pntrs,lens*szsmpd,ierrcd,0)
      if(ierrcd .ne. 0 ) then
         write(lerr,*)'galloc memory allocation error from main'
         write(lerr,*)'ierrcd = ',ierrcd
         write(lerr,*)
         write(lerr,*)'probable cause: too much memory requested!'
         write(lerr,*)'go check your seismic headers and command'//
     1                ' line arguments!'
         write(lerr,*)'memory can be decreased by using the -M option'
         write(lerr,*)
         write(lerr,*)'program TUNE3D aborted'
         close(lerr)
c        call exit(101)
	 stop 101
      endif
c_______________________________________________________________________
c     calculate decomposition frequencies.                          
c_______________________________________________________________________
      call getomega(s(l_omega),ifh,ifl,dp,df,
     1              frequencies,verbose,lerr)
c_______________________________________________________________________
c     calculate the temporal taper weights.            
c_______________________________________________________________________
      call gttapr(s(l_twgt),-hw_outer,-hw_inner,+hw_inner,+hw_outer,
     1            dtmsec,-lenw_outer,+lenw_outer)
      call ltaper(s(l_dwgt),s(l_uwgt),ataper,ifl,ifh,lerr)
C_______________________________________________________________________
c     precompute exponential (sin/cos) tables.                      
C_______________________________________________________________________
      call gettable(s(l_tabledexp),s(l_omega),
     1              ifh,ifl,istart,iend,lenw_outer,dt,
     2              verbose,lerr)
c_______________________________________________________________________
c     modify line header to reflect actual number of traces output
c
c     store (ifl,ifh) in header words (MnGrEl,MxGrEl)
c     store (df) in header word MutVel           
c_______________________________________________________________________
      call savhlh(sheader,lbytes,lbyout)
      call savew(sheader,'OrNTRC',ntr,LINEHEADER)
      call savew(sheader,'NumRec',nrec_out,LINEHEADER)
      call savew(sheader,'NumTrc',ifh-ifl+1,LINEHEADER)
      call savew(sheader,'NumSmp',nsamp_out,LINEHEADER)
      call savew(sheader,'SmpInt',nsi_out,LINEHEADER)
      call savew(sheader,'NumCmp',ncomponent,LINEHEADER)
      jtstart=nint(tstart)
      jtend=nint(tend)
      jtslice=nint(iskip*dtmsec)
      call savew(sheader,'TmMsFS',tstart,LINEHEADER)
      call savew(sheader,'TmMsSl',jtstart,LINEHEADER)
      call savew(sheader,'TmSlIn',jtslice,LINEHEADER)
      call savew(sheader,'NumSmp',nsamp_out,LINEHEADER)
      call savew(sheader,'MnGrEl',ifl,LINEHEADER)
      call savew(sheader,'MxGrEl',ifh,LINEHEADER)
      call savew(sheader,'MutVel',df,LINEHEADER)
c_______________________________________________________________________
c     write out line header for any 3-D extracted attributes cubes
c_______________________________________________________________________
      call savew(sheader,'NumCmp',1,LINEHEADER)
      call savew(sheader,'NumRec',nrec_in,LINEHEADER)
      call savew(sheader,'NumTrc',ntr,LINEHEADER)
      if(wrf_peak) call wrtape(luf_peak,sheader,lbyout)
      if(wramp_peak) call wrtape(luamp_peak,sheader,lbyout)
      if(wrf_mean) call wrtape(luf_mean,sheader,lbyout)
      if(wrf_trough) call wrtape(luf_trough,sheader,lbyout)
      if(wramp_trough) call wrtape(luamp_trough,sheader,lbyout)
      if(wramp_mean) call wrtape(luamp_mean,sheader,lbyout)
c_______________________________________________________________________
c     calculate the green's function thin bed model response.
c_______________________________________________________________________
      call getmodel(s(l_amodel),ifl,ifh,df,ithl,ithh,dth,lerr)
c_______________________________________________________________________
c     read in the inverse of the wavelet amplitude estimation made by 
c     program swak.
c_______________________________________________________________________
      call rdscale(s(l_scale),s(l_tracebuf),
     1             luscale,istart,iend,iskip,ifl,ifh,
     2             ITRWRD,TRACEHEADER)
      call lbclos(luscale)

      call timend(cputim(1),v1,v2,waltim(1),w1,w2)
      minlive=.1*(nx+1)
      call timstr(v0,w0)
      do 90000 jrec=1,nrec_in
       if(jrec .gt. 1) then
          write(ler,'(a,i5,a,i5,a,i5,a,i5,a,i5,a)')
     1    'tune3d: process record ',jrec,' of ',nrec_in,
     2    ' time to completion: ',nhour,' hr',
     3      nmin,' min',nsec,' sec'
       endif
c__________________________________________________________________
c      initialize output arrays.
c__________________________________________________________________
       call init(s(l_f_peak),s(l_amp_peak),s(l_f_mean),
     1           s(l_f_trough),s(l_amp_trough),s(l_amp_mean),
     2           istart,iend,iskip,nx)
c__________________________________________________________________
c       read in a gather.
c__________________________________________________________________
        call rdgather(s(l_uin),s(l_trheader),
     1                s(l_tracebuf),s(l_tracebuf),nx,nlive,    
     2                istart,iend,lenw_outer,nsamp_in,
     3                s(l_live),luin,eof,ITRWRD,TRACEHEADER,
     4                ifmt_StaCor,l_StaCor,ln_StaCor)
        if(eof) then
           write(lerr,*)'End of file on input:'
           write(lerr,*)'  rec= ',jrec
           go to 90001
        endif
c__________________________________________________________________
c        decompose the data for each frequency.
c__________________________________________________________________
         call process(s(l_uin),s(l_amp),s(l_dwgt),s(l_uwgt),
     1                s(l_f_peak),s(l_amp_peak),s(l_f_mean),
     2                s(l_f_trough),s(l_amp_trough),s(l_amp_mean),
     3                s(l_uexp),s(l_cspec),s(l_scale),df,
     4                s(l_tabledexp),s(l_twgt),s(l_live),
     4                s(l_amodel),s(l_rho),ithl,ithh,dth,
     5                ifl,ifh,nx,istart,iend,iskip,
     6                lenw_inner,lenw_outer,
     7                calc_peak,calc_trough,calc_mean,
     9                normalize,lerr,cputim,waltim,green)
80001  continue
       if(wrf_peak) then
           call wrgather(s(l_f_peak),s(l_trheader),
     1                   s(l_tracebuf),s(l_tracebuf),
     2                   luf_peak,istart,iend,iskip,nx,
     3                   ITRWRD,nbytes_out)
       endif
       if(wramp_peak) then
           call wrgather(s(l_amp_peak),s(l_trheader),
     1                   s(l_tracebuf),s(l_tracebuf),
     2                   luamp_peak,istart,iend,iskip,nx,
     3                   ITRWRD,nbytes_out)
       endif
       if(wrf_mean) then
           call wrgather(s(l_f_mean),s(l_trheader),
     1                   s(l_tracebuf),s(l_tracebuf),
     2                   luf_mean,istart,iend,iskip,nx,
     3                   ITRWRD,nbytes_out)
       endif
       if(wrf_trough) then
           call wrgather(s(l_f_trough),s(l_trheader),
     1                   s(l_tracebuf),s(l_tracebuf),
     2                   luf_trough,istart,iend,iskip,nx,
     3                   ITRWRD,nbytes_out)
       endif
       if(wramp_trough) then
          call wrgather(s(l_amp_trough),s(l_trheader),
     1                   s(l_tracebuf),s(l_tracebuf),
     2                   luamp_trough,istart,iend,iskip,nx,
     3                   ITRWRD,nbytes_out)
       endif
       if(wramp_mean) then
           call wrgather(s(l_amp_mean),s(l_trheader),
     1                   s(l_tracebuf),s(l_tracebuf),
     2                   luamp_mean,istart,iend,iskip,nx,
     3                   ITRWRD,nbytes_out)
       endif


c_____________________________________________________________
c      calculate average wall time for completely
c      filled lines.
c_____________________________________________________________
       call timstr(vcurr,wcurr)
       time_per_line=(wcurr-w0)/jrec
c_____________________________________________________________
c      predict wall time to completion.
c_____________________________________________________________
       time_left=(nrec_in-jrec)*time_per_line
       nhour=time_left/3600.
       nmin=(time_left-3600.*nhour)/60.
       nsec=time_left-3600.*nhour-60.*nmin
90000 continue
90001 continue
c_____________________________________________________________   
c     write out timing statistics.
c_____________________________________________________________   
      call timend(cputim(20),vtot,v2,waltim(20),wtot,w2)
      write(lerr,'(A30,2A15,/)') 'routine','cpu time','wall time'
      write(lerr,'(A30,2f15.3)')
     1         'read input',cputim(1),waltim(1),
     2         'cross multiply',cputim(4),waltim(4),
     3         'initialize sum',cputim(5),waltim(5),
     4         'running sum',cputim(6),waltim(6),
     5         'taper windows',cputim(7),waltim(7),
     6         'calc amplitude',cputim(8),waltim(8),
     4         'compare',cputim(9),waltim(9),
     4         'write output',cputim(12),waltim(12),
     c         'total',cputim(20),waltim(20)
c_____________________________________________________________   
c     close all open data files.
c_____________________________________________________________   
      call lbclos(luin)
      if(wrf_peak) call lbclos(luf_peak)
      if(wramp_peak) call lbclos(luamp_peak)
      if(wrf_trough) call lbclos(luf_trough)
      if(wramp_trough) call lbclos(luamp_trough)
      if(wramp_mean) call lbclos(luamp_mean)
      if(wrf_mean) call lbclos(luf_mean)
c
      write(ler,*)'normal completetion. routine TUNE3D'           
      write(lerr,*)'normal completetion. routine TUNE3D'           
      close(lerr)
c     call exit(0)
      stop 0
      end
      subroutine help(ler)

      write(ler,*)
     1'**************************************************************'
      write(ler,*)'3-D Seismic Tuning cube (D1 spectral decomp)'
      write(ler,*)'Non AMOCO users require a license from AMOCO'
      write(ler,*)'to use this software and any documentation' 
      write(ler,*)
     1'**************************************************************'
      write(ler,*)'execute tune3d by typing tune3d and list of'
     1                   //' program parameters.'
      write(ler,*)
     1'note that each parameter is proceeded by -a where "a" is '
      write(ler,*)
     1'a character(s) corresponding to some parameter.'
      write(ler,*)
     1'users enter the following parameters, or use the default values'
      write(ler,*)' '
      write(ler,*)
     1' -N [file_in]  (stdin)       : input seismic file name'          
      write(ler,*)
     1' -S [file_scale](no default)  : input statistic wavelet ampl est' 
     2   //' from program swak'
      write(ler,*)' -f_peak [file_f_peak] (Optional) : ' //
     1     'output peak frequency file name'          
      write(ler,*)' -f_mean [file_f_mean] (Optional) : ' //
     1     'output mean frequency file name'          
      write(ler,*)' -f_trough [file_f_trough] (Optional) : ' //
     1     'output frequency at minimum trough file name'          
      write(ler,*)' -amp_peak [file_amp_peak] (Optional) : ' //
     1     'output amplitude at peak frequency file name'          
      write(ler,*)' -amp_trough [file_amp_trough] (Optional) : ' //
     1     'output amplitude at minimum trough file name'          
      write(ler,*)' -amp_mean [file_amp_mean] (Optional) : ' //
     1     'output mean amplitude file name'          
      write(ler,*)' '
      write(LER,*)'------------------------------------------------'
      write(LER,*)'Other Program Options:'
      write(LER,*)'-normalize -- normalize amp_peak and amp_trough'
     1             //' by amp_mean'
      write(LER,*)'-V         -- verbose printout'
      write(LER,*)' '
      write(ler,*)
      write(LER,*)'=================================================='
      write(LER,*)'Usage:'
      write(ler,*)'tune3d -N[file_in] -S[file_scale] '
      write(ler,*)'       -f_peak[file_f_peak] '
      write(ler,*)'       -f_trough[file_f_trough] '
      write(ler,*)'       -f_mean[file_f_mean] ' 
      write(ler,*)'       -amp_peak[file_amp_peak] '
      write(ler,*)'       -amp_trough[file_amp_trough] '
      write(ler,*)'       -amp_mean[file_amp_mean] '
      write(LER,*)'       -V -normalize '
      write(LER,*)'=================================================='

      write(ler,*)' '
      write(ler,*)

      return
      end
