C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine trapf (nsamp, nt, nf, dt, df, tri, fwt, work,
     1                  amp, phz)

#include <f77/iounit.h>

      real    fwt (*), tri (*), amp (*), phz (*)
      real    wkr, wki
      complex work (*)

      do i = 1, nt
         work (i) = cmplx (0.,0.)
      enddo

      call rfftf  (tri, work, nt)
      call rfftsc (work, nt, 3, 1)

c     call cvabs  (work, 2, amp, 1, nf)
c     call cvphas (work, 2, phz, 1, nf)
      do  i = 1, nf

          wkr = real  ( work(i) )
          wki = aimag ( work(i) )
          if (wkr .eq. 0.0 .AND. wki .eq. 0.0) then
             phz (i) = 0.0
             amp (i) = 0.0
          else
             phz (i) = atan2 ( wki, wkr )
             amp (i) = sqrt ( wkr*wkr + wki*wki )
          endif
      enddo

      do  i = 1, nf

          amp (i) = amp (i) * fwt (i)
      enddo

      do i = 1, nt
         work (i) = cmplx (0.,0.)
      enddo

      call cvmexp (phz, 1, amp, 1, work, 2, nf)
      call rfftsc (work, nt, -3, 0)
      call rffti  (work, tri, nt)

      return
      end
