/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include "ufh.h"
#include "x_tab.h"
#include <sys/types.h>
#include <sys/time.h>
#include <string.h>
#include <stdio.h>

/*
**	debugging stuff
*/

TPackage traceback()
{
    VMRegisters* r;
    int i;
    int printItem();
    FILE* tb;

    tb = stderr;
    r = (VMRegisters*) VM.callerVM;
    fprintf(tb, "Execution stack traceback:\n");
    while(r->callerVM != 0) {
	fprintf(tb, "  %s(", r->funcptr->name);
	for(i = 0; i < r->nargs; i++) {
	    printItem(tb, r->argptr[i]);
	    if(i < (r->nargs - 1))
		fprintf(tb, ", ");
	}
	fprintf(tb, ")\n");
	r = (VMRegisters*) r->callerVM;
    }
    return newTP();
}

static TPackage memorysize()
{
    caddr_t sbrk();
    long p = (long) sbrk(0);
    return dTPackage((double) p);
}

TPackage internals()
{
    extern int nextTemp;

    if(nArgs() != 1)
	execerror("internals: bad argument count (%d)", nArgs());
    switch((int)asDouble(nthArg(1))) {
      case 0:
	return memorysize();
      case 1:
	return dTPackage((double)nextTemp);
      default:
	execerror("internals: unknown request selector value (%g)",
		  asDouble(nthArg(1)));
    }
}
