/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include "ufh.h" 
#include "functions.h"
#include "x_tab.h"
#include  <math.h>
#include <fcntl.h>

static struct  {       /* Constants */
        char   *name;
        double cval;
} consts[] = {
       {"pi",    	3.14159265358979323846},
       {"enatural",     2.71828182845904523636},
       {"rad2deg",	57.29577951308232087860},  /* deg/radian */
       {0,       0}
};
typedef struct  {        /* Built-ins */
        char		*name;
        TPackage	(*func)();
} btab;

static btab builtins[] = {

        "sin",		TPSin,
        "cos",		TPCos,
        "atan",		TPAtan,
        "log", 		TPLog,
        "log10", 	TPLog10,
        "exp", 		TPExp,
        "sqrt", 	TPSqrt,
        "int", 		TPInteger,
        "nint", 	TPNInteger,
        "abs", 		TPAbs,

	"strtonum",	TPStrToNum,
	"floattostr",	TPDNumToStr,
	"inttostr",	TPINumToStr,
	"flatten",	TPFlattened,

	"time",		clocktime,
	"random",	urandom,
	"internals",	internals,
	"exit",		bltin_exit,
	"size",		object_size,
	"strlen",	object_size,
	"length",	object_size,

	"nargs",	fArg,
	"ntharg",	fArg,

	"print",	TPPrint,
	"popen",	TPPopen,
	"pclose",	TPPclose,
	"fopen",	TPFopen,
	"fclose",	TPFclose,
	"fflush",	TPFflush,
	"fprint",	TPFprint,

	"gettokenline",	TPGetTokenLine,
	"scanf",	TPScanf,

	"traceback",	traceback,

	"output",	TPOutputSISChunk,

	"fvector",	fVector,
	"sequence",	TPSequence,
	"max",		TPMax,
	"min",		TPMin,
	"sum",		TPSum,

	"isdouble",	TPisDoubleP,
	"isstring",	TPisStringP,
	"isnothing",	TPisNothing,
	"isarray",	TPisArrayP,
	"isfvector",	TPisfVectorP,

        0,     0
};

static struct {         /* Keywords */
	char    *name;
	int     kval;
} keywords[] = {
	"func",		FUNC,
	"return",	RETURN_T,
	"if",		IF_T,
	"else",     	ELSE_T,
	"while",    	WHILE_T,
	"for",		FOR_T,
	"read",		READ,
	"auto",		AUTO,
	0,          0,
};

void init()  /* install constants and built-ins in table */
{
    long i;
    long offset;
    Symbol *s;

    for (i = 0; keywords[i].name; i++) {
	s = installlc(keywords[i].name);
	s->ttype = keywords[i].kval;
    }
    
    for (i = 0; consts[i].name; i++) {
	s = installlc(consts[i].name);
	s->ttype = VAR;
	s->spk.u.val = consts[i].cval;
	s->spk.type = Double;
    }

    s = installlc("hardware");
    s->ttype = VAR;

/* think broader
#ifdef SUNSYSTEM
    s->spk = cTPackage("sun");
#else
    s->spk = cTPackage("cray");
#endif
*/
#ifdef SUNSYSTEM
    s->spk = cTPackage("sun");
#endif
#ifdef HPUXSYSTEM
    s->spk = cTPackage("hp");
#endif
#ifdef AIXSYSTEM
    s->spk = cTPackage("ibm");
#endif
#ifdef CONVEXSYSTEM
    s->spk = cTPackage("convex");
#endif
#ifdef CRAYSYSTEM
    s->spk = cTPackage("cray");
#endif

    s = installlc("nothing");
    s->ttype = VAR;
    s->spk.type = Nothing;

#ifdef CONVEXSYSTEM
    fcntl(fileno(stdin),F_SETFL,O_LARGEFILE);
#endif
    s = installlc("stdin");
    s->ttype = VAR;
    s->spk.type = FileStar;
    s->spk.u.fstar = stdin;

#ifdef CONVEXSYSTEM
    fcntl(fileno(stdout),F_SETFL,O_LARGEFILE);
#endif
    s = installlc("stdout");
    s->ttype = VAR;
    s->spk.type = FileStar;
    s->spk.u.fstar = stdout;
    
    s = installlc("stderr");
    s->ttype = VAR;
    s->spk.type = FileStar;
    s->spk.u.fstar = stderr;
    
    for (i = 0; builtins[i].name; i++) {
	s = installlc(builtins[i].name);
	s->ttype = BLTIN;
	s->spk.u.ptr = builtins[i].func;
	s->spk.type = InstP;
    }

}
