/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>
#include <ctype.h>
#include <signal.h>
#include <setjmp.h>
#include <ctype.h>
#include <stdarg.h>

#include "ufh.h"

char    *progname	= "";
int     lineno		= 1;
char    *infile		= "";

char*	LastPushedVar 	= 0;

UfhStateType UfhState = Idle;

static char* UfhStateName(s)
UfhStateType s;
{
    switch( s ) {
      case Idle: return "idle";
      case Compiling: return "compiling a script";
      case Executing: return "executing a compiled script";
      default:
	execerror("UfhStateName: impossible state value");
    }
    return 0;
}

void execerror(char *f, ...)
{
    va_list ap;
    va_start(ap,f);

    fprintf(stderr, "\n");
    fprintf(stderr, "%s:\n        ", progname);
    vfprintf(stderr, f, ap);
    fprintf(stderr, "\n");

    va_end(ap);

    fprintf(stderr, "Program was %s", UfhStateName(UfhState));
    if (infile) {
	fprintf(stderr, " in file \"%s\"", infile);
	fprintf(stderr, " near line %d", lineno);
    }
    fprintf(stderr, "\n");
    if(UfhState == Executing) {
	fprintf(stderr, "\tFunction: \"%s\"", currentFunction()->name);
	if(LastPushedVar != 0)
	    fprintf(stderr, "   Last variable seen: \"%s\".",
		    LastPushedVar);
	fprintf(stderr, "\n");
    }
    exitprocandexit(1);
}

void yyerror(s)     /* report compile-time error */ 
char *s;
{
	execerror("%s", s);
}


char *emalloc(n)        /* check return from malloc */
        unsigned n;
{
        char *p, *malloc();

        p = malloc(n);
        if (p == 0)
                execerror("emalloc: asked for %d; out of memory", n);
        return p;
}



void exitproconly()
{
    endSISOutput();
}

void exitprocandexit(exitarg)
int exitarg;
{
    exitproconly();
    exit(exitarg);
}
