/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
**	home for more built-in functions
*/
#include "ufh.h"
#include <sys/types.h>
#include <sys/time.h>
#include <string.h>
#include <stdio.h>

TPackage object_size()
{
    TPackage q;
    double s;

    q = nthArg(1);
    switch(q.type) {
      case SISChunkP:
      case TPackageP:
      case FloatP:
      case OFloatP:
	s = q.size;
	break;
      case CharP:
	s = strlen(q.u.str);
	break;
      default:
	s = 1.0;
	break;
    }
    return dTPackage(s);
}

TPackage fArg()
{
    int i;

    if(nArgs() < 1)
	return dTPackage((double) prevVM->nargs);
    i = asDouble(nthArg(1));
    if(i > 0)
	return deepCopyTP(prevVM->argptr[i - 1]);
    if(i < 0)
	execerror("fArg: negative argument: %d", i);
    return cTPackage(prevVM->funcptr->name);
}

TPackage bltin_exit()
{
    exitprocandexit((int)(asDouble(nthArg(1)) + 0.5));
    return dTPackage(0.0);
}

TPackage clocktime()
{
    struct timeval tv;
    struct timezone tz;

    gettimeofday(&tv, &tz);
    return dTPackage((double)(tv.tv_sec + 1.0e-6 * tv.tv_usec));
}

TPackage urandom()
{
#if defined( CRAYSYSTEM ) || defined( SOLARIS )
    int rand();
    void srand();
    static int sinit = 0;
    double uppervalue = 1.0 / 32767.001;

    if(sinit == 0) {
	srand((unsigned) time(0));
	++sinit;
    }
    return dTPackage(uppervalue * rand());
#else
#ifdef __hpux
    fprintf(stderr,"Error: ");
    fprintf(stderr,"random function unavailable on this architecture\n");
    exit(1);
#else
    long random();
    void srandom();
    static int sinit = 0;
    double uppervalue = 1.0 / 2147483647.001;

    if(sinit == 0) {
	++sinit;
	srandom(time(0));
    }
    return dTPackage(uppervalue * (double) random());
#endif
#endif
}

static int perimeterlength(a, fptr)
TPackage a;
int* fptr;
{
    int len = 0;
    int i;

    if(a.type == Double)
	return 1;
    switch(a.type) {
      case CharP:
	*fptr = 0;
	len = 1;
	break;
      case TPackageP:
      case OTPackageP:
      case TPSingleP:
	for(i = 0; i < a.size; i++)
	    len += perimeterlength(a.u.tpa[i], fptr);
	break;
      case FloatP:
      case OFloatP:
	len += a.size;
	break;
      default:
	execerror("flatten: perimeterlength not smart enough for %s",
		  typeName(a));
    }
    return len;
}

static void perimeterelements(rptr, nptr, a)
TPackage* rptr;
int* nptr;
TPackage a;
{
    int i;

    switch(a.type) {
      case Double:
	if(rptr->type == FloatP)
	    rptr->u.series[(*nptr)++] = a.u.val;
	else
	    rptr->u.tpa[(*nptr)++] = a;
	break;
      case FloatP:
      case OFloatP:
	for(i = 0; i < a.size; i++) {
	    if(rptr->type == FloatP)
		rptr->u.series[(*nptr)++] = a.u.series[i];
	    else
		rptr->u.tpa[(*nptr)++] = dTPackage(a.u.series[i]);
	}
	break;
      case CharP:
	rptr->u.tpa[(*nptr)++] = deepCopyTP(a);
	break;
      case TPackageP:
      case OTPackageP:
      case TPSingleP:
	for(i = 0; i < a.size; i++)
	    perimeterelements(rptr, nptr, a.u.tpa[i]);
	break;
      default:
	execerror("flatten: perimeterelements not smart enough for %s",
		  typeName(a));
    }
}

TPackage TPFlattened()
{
    int length;
    int arg;
    int allfloats;
    TPackage r;
    int i;

    length = 0;
    allfloats = 1;
    for(i = 1; i <= nArgs(); i++)
	length += perimeterlength(nthArg(i), &allfloats);
    if(length == 0)
	return newTP();

    if(allfloats != 0) {
	r.type = FloatP;
	r.size = length;
	r.u.series = (float*) emalloc(length * sizeof(float));
    } else {
	r. type = TPackageP;
	r.size = length;
	r.u.tpa = (TPackage*) emalloc(length * sizeof(TPackage));
    }

    length = 0;
    for(i = 1; i <= nArgs(); i++)
	perimeterelements(&r, &length, nthArg(i));
    return r;
}

