C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c -----------------  Main Routine -----------------------

c     Program Changes
c
c
c
c     original written: Paul G.A. Garossino, Mar 31, 2000
c
c
c     March 11, 2003:  added logic to check for valid ILwrd,DIwrd 
c                      prior to running savelu.
c     Garossino
c
c     September 23, 2002 : added logic to skip allocation for and reading of -M[] 
c                          dataset when the -R flag is set on the command line.
c     Garossino
c 
c     August 21, 2002 : added -R option to go from header to time series
c                       also allowing multiple -hw[] entries on the 
c                       command line in this case.  The total number of
c                       -hw[] entries defines the number of samples
c                       per trace in the output.
c     Garossino            

c     Program Description:

c
c      read in a USP dataset and map the trace data to a
c      user defined header location.  Useful for things like
c      smoothing a water bottom then sticking the smoothed 
c      water bottom in the header for use in muting etc. 
c

c get machine dependent parameters 

      implicit none

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h> 

c dimension standard USP variables 

      integer itr ( SZLNHD )

      integer nsamp, nsi, ntrc, nrec, obytes
      integer luin , luout, lbytes, nbytes, lbyout
      integer irs, ire, ns, ne, argis, jerr

      real tri(SZLNHD), unitsc

      character ntap*255, otap*255, name*7

      logical verbos

c Program Specific _ dynamic memory variables

      integer RecordSize, ecd1, abort

      real array

      pointer (m_array, array(2))

c Program Specific _ static memory variables

      integer ifmt_HdrWrd(100),l_HdrWrd(100),ln_HdrWrd(100), HdrWrd
      integer ifmt_LIwrd,l_LIwrd,ln_LIwrd, LIwrd
      integer ifmt_DIwrd,l_DIwrd,ln_DIwrd, DIwrd
      integer JJ, KK, luin2, index, nsampr, ntrcr, nrecr
      integer ntrco, nreco, ndim, LI_offset, DI_offset
      integer pipe, length, lenth, nsampo, i, ll

      real null, r_HdrWrd

      character rtap*255, c_LIwrd*6, c_DIwrd*6
      character*6 c_HdrWrd(100)

      logical  reverse

c Initialize variables

      data abort/0/
      data name/"USP2HDR"/
      data pipe/3/

c give command line help if requested

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif

      call vclr ( tri, 1, SZLNHD )

c open printout file

#include <f77/open.h>

c get command line input parameters

      call cmdln ( ntap, otap, rtap, irs, ire, ns, ne, c_HdrWrd, 
     :     c_LIwrd, c_DIwrd, LI_offset, DI_offset, null, name, 
     :     reverse, nsampo, verbos )

c open input and output files

      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)

c
c ----- open horizon dataset -----
c

      if (rtap .ne. ' ') then

         call getln(luin2,rtap,'r',-1)

      elseif ( .not. reverse ) then

         write(LERR,*)'usp2hdr assumed to be running inside IKP'

         call sisfdfit (luin2, pipe)

      endif

      if  (luin2 .lt. 0 .and. .not. reverse )   then

         write(LERR,*)'Fatal: horizon file ',rtap,' not found.'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'USP2HDR:'
         length = lenth(rtap)
	 if (length .gt. 0) then
           write(LER,*)' horizon file ',rtap(1:length),' not found.'
         else
           write(LER,*)' horizon file not specified'
         endif
         write(LER,*)'FATAL'
         write(LER,*)' '
         stop

      endif

c read input horizon dataset header
      if ( .not. reverse ) then
         call rtape(luin2, itr, lbytes)

         if(lbytes.eq.0)then
            write(LERR,*)' no line header on input file',rtap
            write(LERR,*)'FATAL'
            write(LER,*)'USP2HDR: '
            write(LER,*)' no line header on input file',rtap
            write(LER,*)'FATAL'
            stop
         endif

         call saver(itr, 'NumSmp', nsampr, LINHED)
         call saver(itr, 'NumTrc', ntrcr , LINHED)
         call saver(itr, 'NumRec', nrecr , LINHED)
      endif

c  read input line header and save certain parameters

      call rtape(luin,itr,lbytes)
      if(lbytes.eq.0)then
         write(LERR,*)' no line header on input file',ntap
         write(LERR,*)'FATAL'
         write(LER,*)'USP2HDR: '
         write(LER,*)' no line header on input file',ntap
         write(LER,*)'FATAL'
         stop
      endif

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)

      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif

c print HLH to printout file 

      call hlhprt (itr, lbytes, name, 7, LERR)

c check user supplied boundary conditions and set defaults

      if ( irs .eq. 0 ) irs = 1
      if ( ire .eq. 0 .or. ire .gt. nrec ) ire = nrec
      if ( ns .eq. 0 ) ns = 1
      if ( ne .eq. 0 .or. ne .gt. ntrc ) ne = ntrc

      nreco = ire - irs + 1
      ntrco = ne - ns + 1

c modify line header to reflect actual record configuration output
c NOTE: in this case the trace and sample limits are used to 
c       limit processing only.   All data within the selected record
c       range are actually passed.

      call savew(itr, 'NumRec', nreco, LINHED)
      call savew(itr, 'NumTrc', ntrco, LINHED)

c number output bytes

      if ( .not. reverse ) then

         obytes = SZTRHD + SZSMPD * nsamp 

      else

         obytes = SZTRHD + SZSMPD * nsampo
         call savew(itr, 'NumSmp', nsampo, LINHED)

      endif

c add current command line to hlh and output line header

      call savhlh  ( itr, lbytes, lbyout )
      call wrtape ( luout, itr, lbyout )

c set up pointers to header mnemonics

      do i = 1, nsampo
         call savelu ( c_HdrWrd(i), ifmt_HdrWrd(i), l_HdrWrd(i), 
     :        ln_HdrWrd(i), TRACEHEADER )
      enddo

      if ( .not. reverse .and. c_LIwrd .ne. ' ' .and. 
     :	c_DIwrd .ne. ' ' ) then
         call savelu ( c_LIwrd, ifmt_LIwrd, l_LIwrd, ln_LIwrd, 
     :        TRACEHEADER )
         call savelu ( c_DIwrd, ifmt_DIwrd, l_DIwrd, ln_DIwrd, 
     :        TRACEHEADER )
      endif
c verbose output of all pertinent information before processing begins

      call verbal( ntap, otap, rtap, nsi, nrec, ntrc, nsamp,  
     :     irs, ire, ns, ne, c_HdrWrd, c_LIwrd, c_DIwrd, 
     :     LI_offset, DI_offset, null, reverse, nsampo, verbos )

c dynamic memory allocation [if required]: 

      if ( .not. reverse ) then

         ndim = max(nrecr, ntrcr)
         
         RecordSize = ndim * nsampr 

         call galloc (m_array, RecordSize * SZSMPD, ecd1, abort)
    
         if ( ecd1 .ne. 0 )then
            write(LERR,*)' '
            write(LERR,*)'Unable to allocate workspace:'
            write(LERR,*) RecordSize * SZSMPD, '  bytes'
            write(LERR,*)' '
            write(LER,*)' '
            write(LER,*)'Unable to allocate workspace:'
            write(LER,*) RecordSize * SZSMPD, '  bytes'
            write(LER,*)' '
            go to 999
         else
            write(LERR,*)' '
            write(LERR,*)'Allocating workspace:'
            write(LERR,*) RecordSize * SZSMPD, '  bytes'
            write(LERR,*)' '
         endif

c initialize memory
         

         call vclr ( array, 1, RecordSize )

c read mapping array information into array[]

         index = 1 - nsampr 

         do JJ = 1, nrecr

            do KK = 1, ntrcr

               index = index + nsampr

               nbytes = 0
               call rtape(luin2, itr, nbytes )

c if end of data encountered (nbytes=0) then bail out

               if(nbytes .eq. 0) then
                  write(LERR,*)'Premature EOF on input at:'
                  write(LERR,*)'  rec= ',JJ,'  trace= ',KK
                  write(LERR,*)'  on dataset ',rtap
                  go to 999
               endif
            
               call vmov ( itr(ITHWP1), 1, array(index), 1, nsampr )
            enddo
         enddo

c debug

c      call look2d ( array, nsampr,ndim )

c debug


      endif

c BEGIN PROCESSING 

c skip to start record

      call recskp ( 1, irs-1, luin, ntrc, itr )

      DO JJ = irs, ire

c skip to start trace
         
         call trcskp ( JJ, 1, ns-1, luin, ntrc, itr )
         
         DO KK = ns, ne


            IF ( .not. reverse) THEN

               nbytes = 0
               call rtape( luin, itr, nbytes)

c if end of data encountered (nbytes=0) then bail out

               if(nbytes .eq. 0) then
                  write(LERR,*)'Premature EOF on input at:'
                  write(LERR,*)'  rec= ',JJ,'  trace= ',KK
                  go to 999
               endif

c read indexing info if needed otherwise use rec,trc sequential indexing

               if ( c_LIwrd .ne. ' ' ) then

                  call saver2 ( itr, ifmt_LIwrd, l_LIwrd, ln_LIwrd, 
     :                 LIwrd, TRACEHEADER )
               else
               
                  LIwrd = JJ
               
               endif

               if ( c_DIwrd .ne. ' ' ) then

                  call saver2 ( itr, ifmt_DIwrd, l_DIwrd, ln_DIwrd, 
     :                 DIwrd, TRACEHEADER )
               else
               
                  DIwrd = KK

               endif

c add in user supplied offset information.  This is required in the case where the 
c indexing in the data does not start from 1 as is often the case.  Here what we do is
c subtract the offset and add one.  So if the user supplies the offset for LI 1, DI 1
c we can make sure to stay in sync with the map dataset.  This effectively reduces the
c data indexing to the map sequential indexing

               LIwrd = LIwrd - LI_offset + 1
               DIwrd = DIwrd - DI_offset + 1

               index = (LIwrd - 1 ) * nsampr + DIwrd

c determine that index is within range of map data

               if ( index .lt. 1 .or. index .gt. RecordSize ) then
                  r_HdrWrd = null
               else
                  r_HdrWrd = array(index)
               endif

c load map value to output header mnemonic

               if ( ifmt_HdrWrd(1) .eq. SAVE_FLOAT_DEF  .or.
     :              ifmt_HdrWrd(1) .eq. SAVE_FKFLT_DEF ) then
                  
                  call savew2 ( itr, ifmt_HdrWrd(1), l_HdrWrd(1),
     :                  ln_HdrWrd(1), r_HdrWrd, TRACEHEADER )

               else

                  HdrWrd = nint(array(index))
                  call savew2 ( itr, ifmt_HdrWrd(1), l_HdrWrd(1), 
     :                 ln_HdrWrd(1), HdrWrd, TRACEHEADER )

               endif

               call wrtape (luout, itr, obytes)

            ELSE

                nbytes = 0
               call rtape( luin, itr, nbytes)

c if end of data encountered (nbytes=0) then bail out

               if(nbytes .eq. 0) then
                  write(LERR,*)'Premature EOF on input at:'
                  write(LERR,*)'  rec= ',JJ,'  trace= ',KK
                  go to 999
               endif

               do ll = 1, nsampo
                  
                  if ( ifmt_HdrWrd(ll) .eq. SAVE_FLOAT_DEF  .or.
     :                 ifmt_HdrWrd(ll) .eq. SAVE_FKFLT_DEF ) then
                  
                     call saver2 ( itr, ifmt_HdrWrd(ll), l_HdrWrd(ll),  
     :                    ln_HdrWrd(ll), tri(ll), TRACEHEADER )
                     
                  else
                  
                     call saver2 ( itr, ifmt_HdrWrd(ll), l_HdrWrd(ll), 
     :                    ln_HdrWrd(ll), HdrWrd, TRACEHEADER )
                     tri(ll) = float(HdrWrd)
                     
                  endif

               enddo

               call vmov ( tri, 1, itr(ITHWP1), 1, nsampo )
               call wrtape (luout, itr, obytes)

            ENDIF 

         ENDDO

      ENDDO

c close data files 

      call lbclos ( luin )
      call lbclos ( luout )
      call lbclos ( luin2 )
      write(LERR,*)'Normal Termination'
      write(LER,*)'USP2HDR: Normal Termination'
      stop

 999  continue

      call lbclos ( luin )
      call lbclos ( luout )
      call lbclos ( luin2 )
      write(LERR,*)'Abnormal Termination'
      write(LER,*)'USP2HDR: Abnormal Termination'

      stop
      end
