C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine verbal ( ntap, otap, rtap, nsi, nrec, ntrc, nsamp, 
     :     irs, ire, ns, ne, c_HdrWrd, c_LIwrd, c_DIwrd, 
     :     LI_offset, DI_offset, null, reverse, nsampo, verbos )     

      implicit none

#include <f77/iounit.h>

c declare variables passed from calling routine

      integer nsi, nrec, ntrc, nsamp, nsampo
      integer irs, ire, ns, ne, LI_offset, DI_offset 

      real null
      
      character ntap*(*), otap*(*), rtap*(*)
      character c_DIwrd*6, c_LIwrd*6
      character*6 c_HdrWrd(100)

      logical reverse, verbos

c local variables

      integer length, lenth, i

      write(LERR,*)' '
      write(LERR,*)' Input Line Header Parameters'
      write(LERR,*)' '
      length = lenth(ntap)
      if (length .gt. 0) then
        write(LERR,*) ' input data set name   =  ', ntap(1:length)
      else
        write(LERR,*) ' input data set        =  stdin'
      endif
      write(LERR,*) ' samples per trace     =  ', nsamp
      write(LERR,*) ' traces per record     =  ', ntrc
      write(LERR,*) ' number of records     =  ', nrec
      write(LERR,*) ' sample interval       =  ', nsi
      write(LERR,*)' '
      write(LERR,*)' '
      write(LERR,*)' Command Line Parameters '
      write(LERR,*)' '
      length = lenth(rtap)
      if (length .gt. 0) then
        write(LERR,*) ' input mapping file    =  ', rtap(1:length)
      else
        write(LERR,*) ' input mapping file    =  pipe'
      endif
      length = lenth(otap)
      if (length .gt. 0) then
        write(LERR,*) ' output data set name    =  ', otap(1:length)
      else
        write(LERR,*) ' output data set         =  stdout'
      endif
      write(LERR,*) ' start record            =  ', irs 
      write(LERR,*) ' end record              =  ', ire 
      write(LERR,*) ' start trace             =  ', ns 
      write(LERR,*) ' end trace               =  ', ne 

      if ( .not. reverse ) then
         write(LERR,*) ' output mnemonic         =  ', c_HdrWrd(1)
      else

         write(LERR,*) ' reverse flag is set'
         write(LERR,*) ' Number of headers used = ',nsampo

         do i = 1,nsampo
            write(LERR,*) ' output mnemonic ',i,'          =  ', 
     :           c_HdrWrd(i)
         enddo
         
      endif

      if ( c_LIwrd .ne. ' ' ) then
         write(LERR,*) ' '
         write(LERR,*) ' record indexing based on mnemonic ', c_LIwrd
         write(LERR,*) ' '
      else
         write(LERR,*) ' '
         write(LERR,*) ' sequential record indexing used '
         write(LERR,*) ' '
      endif

      if ( c_DIwrd .ne. ' ' ) then
         write(LERR,*) ' '
         write(LERR,*) ' record indexing based on mnemonic ', c_DIwrd
         write(LERR,*) ' '
      else
         write(LERR,*) ' '
         write(LERR,*) ' sequential record indexing used '
         write(LERR,*) ' '
      endif
      write(LERR,*)' '

      write(LERR,*) ' record index offset         =  ', LI_offset
      write(LERR,*) ' trace index offset          =  ', DI_offset
      write(LERR,*) ' null value                  =  ', null

      if ( verbos )  write(LERR,*) ' verbose printout requested'
      write(LERR,*)' '
      write(LERR,*)'========================================== '
      write(LERR,*)' '

      return
      end
