/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <localsys.h>
#include <save.h>
#include <io_defs.h>
#include <cu_defs.h>
#include <size_defs.h>
#include <header.h>
#include <errno.h>
#include <strings.h>

int verbose;
FILE *prtfile;

void map_error(from,to)
char *from,*to;
{
if (verbose != 0)
fprintf(prtfile,"Invalid mapping: %s=%s\n",to,from);
fprintf(stderr,"Invalid mapping: %s=%s\n",to,from);
exit(1);
}

int main(argc,argv)
int argc;
char **argv;
{
	FILE *output;
	int i,trcknt,mapknt;
	char **from,**to,*value;
	char *lbracket,*rbracket;
	int offset;
	char prtfilename[32];
	char hostname[9],comment[80];
	int numsmp,smpint,numtrc;
	short  cdpfold;
	int line_hdr_indx,trace_hdr_indx;
	int indx,bytes,help,databytes;
	int native_trace_data;
#if ( BYTE_ORDER == LITTLE_ENDIAN )
	char native[8];
	int format,index,length;
	int native_line_header, native_trace_header;
#endif
	char ntap[256],otap[256],map_file[256];
	char *def_map_file;
	char *header,*buffer;
	int count;
	int luin;
	short sval;
	int lval;
	float rval;
	float unitscaler;
	char *chval;
	int TrcNumSmp_format, TrcNumSmp_index, TrcNumSmp_length;
	int TrcIdCode_format, TrcIdCode_index, TrcIdCode_length;
	int RecNum_format, RecNum_index, RecNum_length;
	int TrcNum_format, TrcNum_index, TrcNum_length;
	int SrPtXC_format, SrPtXC_index, SrPtXC_length;
	int SrPtYC_format, SrPtYC_index, SrPtYC_length;
	int RcPtXC_format, RcPtXC_index, RcPtXC_length;
	int RcPtYC_format, RcPtYC_index, RcPtYC_length;
	int DphInd_format, DphInd_index, DphInd_length;
	int PrRcNm_format, PrRcNm_index, PrRcNm_length;
	int PrTrNm_format, PrTrNm_index, PrTrNm_length;
	int SrcDepth_format, SrcDepth_index, SrcDepth_length;
	int FieldRecNum_format, FieldRecNum_index, FieldRecNum_length;
	int FieldTrcNum_format, FieldTrcNum_index, FieldTrcNum_length;
	int LineTrcNum_format, LineTrcNum_index, LineTrcNum_length;
	int TrcSmpInt_format, TrcSmpInt_index, TrcSmpInt_length;
	int CdpNum_format, CdpNum_index, CdpNum_length;
	int CdpTrcNum_format, CdpTrcNum_index, CdpTrcNum_length;
	typedef struct {
		char *tag;
		int hdrtype;
		int format;
		int index;
		int length;
		} save_struct;

	save_struct *hdr_map,*line_hdr_map,*trace_hdr_map;
	save_struct **segy_line_hdr_map,**segy_trace_hdr_map;

	short fmtcode,unitsflg;
	char jobnum[8];
	int linetrcnum;
	int segy_prrcnm, segy_prtrnm;
	short trid, trcnumsmp, segysmpint;
	int cdpnum, cdptrcnum;
	int hlhknt;
	char **hlh;
	int read_map_file();

	help = C_ARGIS("-?",&argc,argv);
	help += C_ARGIS("-h",&argc,argv);
	if (help > 0) {
	  fprintf(stderr,"\nUsage: usp2segy -N[] -O[] -m mapping -M map_file");
	  fprintf(stderr,"\n\t-native [line | trace | data| all] ");
	  fprintf(stderr," -h -'?' -V level\n\n");
	  fprintf(stderr,"       -N[input]   -- input data set (default=stdin)\n");
	  fprintf(stderr,"       -O[output]  -- output data set (default=stdout)\n");
	  fprintf(stderr,"       -map segy_header_mnemonic = usp_header_mnemonic|constant]\n");
	  fprintf(stderr,"                   -- map header info\n");
	  fprintf(stderr,"       -M          -- mapping file containing entries of form\n");
	  fprintf(stderr,"                      segy_header_mnemonic = [usp_header_mnemonic|constant]\n");
	  fprintf(stderr,"       -native [line | trace | data | all]\n");
	  fprintf(stderr,"                   -- native format flags\n");
	  fprintf(stderr,"       -V          -- verbose mode\n\n");
	  fprintf(stderr,"       -h -?       -- display this help screen\n\n");
	  exit(1);
	  }

	C_ARGI4("-V",&verbose,1,0,&argc,argv);

	if (verbose > 0) {
	  sprintf(prtfilename,"USP2SEGY.%d",getpid());

	  if (C_IN_IKP() != 0) {
	    if (gethostname(hostname,9) == 0) {
	      hostname[8] = '\0';
	      strcat(prtfilename,".");
	      strcat(prtfilename,hostname);
	      }
	    }

	  prtfile = fopen(prtfilename,"w");
	  if (prtfile == NULL) prtfile = stderr;
	  setbuf(prtfile,NULL);
	  fprintf(prtfile,"USP2SEGY:\n");
	  }

	from = (char **) malloc(150*sizeof(char *));
	to = (char **) malloc(150*sizeof(char *));
	indx=-1;
	def_map_file = getenv("USP2SEGY_DEFAULT_MAP");
	if (def_map_file != NULL) {
	  if (verbose != 0)
	    fprintf(prtfile," Using default mappings from %s\n",def_map_file);
	  indx = read_map_file(def_map_file,indx,to,from);
	  }
	else {
	  fprintf(stderr,"WARNING: USP2SEGY_DEFAULT_MAP was not set - no default mapping will be used\n");
	  fprintf(prtfile,"WARNING: USP2SEGY_DEFAULT_MAP was not set - no default mapping will be used\n");
	  }

	C_ARGSTR("-M",map_file,"","",&argc,argv);
	indx = read_map_file(map_file,indx,to,from);

	do {	/* each call to ARGSTR gives us a new pointer */
	  value = C_ARGSTR("-map",NULL,"EOF=EOF","EOF=EOF",&argc,argv);
	  indx++;
	  to[indx] = value;
	  from[indx] = (char *)strchr(to[indx],'=')+1;
	  to[indx][from[indx]-to[indx]-1] = '\0';
/*
   if we find an override, put it in the map at the location of the 
   previous specification
*/
	  for (i=0; i<indx-1; i++) {
	    if (strcmp(to[i],to[indx]) == 0) {
		fprintf(stderr,"USP2SEGY: Duplicate specifications for mnemonic %s;\n          %s=%s overrides previous entry of %s=%s\n",to[indx],to[indx],from[indx],to[i],from[i]);
		if (verbose != 0) fprintf(prtfile," USP2SEGY: Duplicate specifications for mnemonic %s;\n          %s=%s overrides previous entry of %s=%s\n",to[indx],to[indx],from[indx],to[i],from[i]);
		from[i] = from[indx];
		to[i] = to[indx];
	  	indx--;
		break;
		}
	     }
	  } while (strcmp(from[indx],"EOF") != 0);

	mapknt = indx;	/* we don't want to count the EOF entry */

	if (verbose == 1) {
	  fprintf(prtfile," Mapping Array:\n");
	  for(i=0;i<mapknt;i++) {
	    fprintf(prtfile,"      %s=%s\n",to[i],from[i]);
	    }
	  fprintf(prtfile,"\n");
	  }

	C_ARGSTR("-N",ntap," "," ",&argc,argv);
	if (strcmp(ntap," ") == 0) {
	  if (verbose == 1) fprintf(prtfile," input file = stdin\n");
	  luin = 0;
	  }
	else {
	  if (verbose == 1) fprintf(prtfile," input file = %s\n",ntap);
	  C_LBOPEN(&luin,ntap,"r");
	  }

	C_ARGSTR("-O",otap," "," ",&argc,argv);
	if (verbose == 1) fprintf(prtfile," output file = ");
	if (strcmp(otap," ") == 0) {
	  if (verbose == 1) fprintf(prtfile,"stdout\n");
	  output = stdout;
	  }
	else {
	  if (verbose == 1) fprintf(prtfile,"%s\n",otap);
	  output = fopen(otap,"w");
	  if (output == NULL) {
	    fprintf(stderr,"%s: error opening output data file (%s)\n",
		argv[0],otap);
	    exit(1);
	    }
	  }

        native_trace_data = 0;
#if ( BYTE_ORDER == LITTLE_ENDIAN )
	native_line_header = 0;
	native_trace_header = 0;
	for(i=0; i<3; i++) {
	  C_ARGSTR("-native",native,"all"," ",&argc,argv);
	  if (strcmp(native,"line") == 0) {
	    native_line_header = 1;
	    }
	  if (strcmp(native,"trace") == 0) {
	    native_trace_header = 1;
	    }
	  if (strcmp(native,"data") == 0) {
	    native_trace_data = 1;
	    }
	  if (strcmp(native,"all") == 0) {
	    native_line_header = 1;
	    native_trace_header = 1;
	    native_trace_data = 1;
	    }
	  }

	if (verbose != 0) {
	  if (native_line_header == 1) fprintf(prtfile,
		"\n Line Header is to be written in native machine format\n");
	  if (native_trace_header == 1) fprintf(prtfile,
		" Trace Header is to be written in native machine format\n");
	  if (native_trace_data == 1) fprintf(prtfile,
		" Trace Data is to be written in native machine format\n");
	  }
#endif

/*
need to check return codes ; we should also realloc after looking up indices
*/
	hdr_map       = (save_struct *) malloc(mapknt * sizeof(save_struct));
	line_hdr_map  = (save_struct *) malloc(mapknt * sizeof(save_struct));
	trace_hdr_map = (save_struct *) malloc(mapknt * sizeof(save_struct));
	segy_line_hdr_map  = (save_struct **) malloc(mapknt * sizeof(save_struct *));
	segy_trace_hdr_map = (save_struct **) malloc(mapknt * sizeof(save_struct *));

	if ((buffer = (char *)malloc(SZLNHD)) == NULL) {
	  fprintf(stderr,
	    "%s ERROR: failure mallocing %d bytes of memory for USP line header\n",
		argv[0],SZLNHD);
	  if (verbose != 0) fprintf(prtfile,
	    "%s ERROR: failure mallocing %d bytes of memory for USP line header\n",
		argv[0],SZLNHD);
	  exit(1);
	  }
	else
	  memset(buffer,0,SZLNHD);

	if ((header = (char *)malloc(SEGYEBCDICHEADERBYTES)) == NULL) {
	  fprintf(stderr,
	    "%s ERROR: failure mallocing %d bytes of memory for SEGY EBCDIC header\n",
		argv[0],SEGYEBCDICHEADERBYTES);
	  if (verbose != 0) fprintf(prtfile,
	    "%s ERROR: failure mallocing %d bytes of memory for SEGY EBCDIC header\n",
		argv[0],SEGYEBCDICHEADERBYTES);
	  exit(1);
	  }

	bytes = 0;
	C_RTAPE(luin,buffer,&bytes);
	if (bytes == 0) {
	  fprintf(stderr,"%s: error reading USP line header\n", argv[0]);
	  exit(1);
	  }
	
	hlhknt = gethlh(buffer,&hlh);
	if (verbose != 0) {
	  fprintf(prtfile,"\n HLH:\n");
	  for (i=0;i<hlhknt; i++) {
	    fprintf(prtfile,"   %3d %s\n",i+1,*(hlh+i));
	    }
	  fprintf(prtfile,"\n");
	  }
/*
 * need to translate the HLH to EBCDIC here (only 40 lines * 80 chars)
 */
	count = 3200;
	memset(header,(int) ' ',count);
	for(indx=1,i=hlhknt-40;indx<=40;indx++,i++) {
	  sprintf(comment,"C%2d ",indx);
	  if (i>=0) strncat(comment,*(hlh+i),80-strlen(comment));
	  memcpy(header+((indx-1)*80),comment,strlen(comment));
	  }
	  
	F_ASCEBC(header,header,&count);
	bytes = fwrite(header,1,SEGYEBCDICHEADERBYTES,output);
	free(header);

	get_hw_val(buffer, "NumSmp", LINEHEADER, &numsmp);
	get_hw_val(buffer, "SmpInt", LINEHEADER, &smpint);
	get_hw_val(buffer, "UnitSc", LINEHEADER, &unitscaler);

	if (unitscaler == 0.) {
	  unitscaler = .001;
	  segysmpint = 1000*smpint;
	  }
	else if (unitscaler == 0.000001) {
	  segysmpint = smpint;
	  }
	else {
	  segysmpint = (int)(smpint * (int)(1000000 * unitscaler));
	  }

	if (verbose >= 2) {
	  get_hw_val(buffer, "JobNum", LINEHEADER, jobnum);
	  get_hw_val(buffer, "NumTrc", LINEHEADER, &numtrc);
	  get_hw_val(buffer, "CDPFld", LINEHEADER, &cdpfold);
	  get_hw_val(buffer, "Format", LINEHEADER, &fmtcode);
	  get_hw_val(buffer, "UnitFl", LINEHEADER, &unitsflg);

	  fprintf(prtfile,"\n\n");
	  fprintf(prtfile,"job identification number        = ");
	  for (i=0; i<8; i++) {fprintf(prtfile,"%c",jobnum[i]);}
	  fprintf(prtfile,"\n");
	  fprintf(prtfile,"data traces per record           = %ld\n",numtrc);
	  fprintf(prtfile,"sample interval in ms. = %ld\n",smpint);
	  fprintf(prtfile,"unit scaler value = %f\n",unitscaler);
	  fprintf(prtfile,"sample interval in seconds = %f\n",smpint*unitscaler);
	  fprintf(prtfile,"samples/trace                    = %ld\n",numsmp);
	  fprintf(prtfile,"data sample format code          = %d\n",fmtcode);
	  fprintf(prtfile,"CDP fold                         = %d\n",cdpfold);
	  fprintf(prtfile,"units flag = %d\n",unitsflg);
	  fprintf(prtfile,"\n\n");
	  }

	if ((header = (char *)malloc(SEGYLINEHEADERBYTES)) == NULL) {
	  fprintf(stderr,"%s: failure mallocing %d bytes of memory\n",
		argv[0],SEGYLINEHEADERBYTES);
	  exit(1);
	  }
	memset(header,0,SEGYLINEHEADERBYTES);

	put_hw_val(header, "SmpInt", SEGYLINEHEADER, segysmpint);

	if (verbose != 0) fprintf(prtfile,"map count = %d\n",mapknt);

	line_hdr_indx = 0;
	trace_hdr_indx = 0;
/*
   This block of code looks up the indexes for all entries in both
   the from (USP) and to (SEGY) entries in the summary map. If a
   SEGY mapping is found, but the USP mnemonic check fails, we will
   assume it is a constant and proceed.
*/

	for (indx=0;indx<mapknt;indx++) {
	  hdr_map[indx].tag = to[indx];
	  if (verbose >= 2) fprintf(prtfile,"look up to entry %s\n",to[indx]);
	  if (strncmp(to[indx],"Spare",5) == 0) {
	    if ((lbracket=(char *)strchr(to[indx],'[')) != NULL) {
	      *lbracket='\0';
	      lbracket+=1;
	      if ((rbracket = (char *) strrchr(lbracket,']')) == NULL) {
		fprintf(stderr,"Invalid indexing - %s\n",to[indx]);
		exit(100);
		}
	      else {
	        *rbracket='\0';
		offset = atoi(lbracket);
		}
	      }
	    }
	  else
	    offset = -1;

	  hdr_map[indx].hdrtype = C_SAVCHK(hdr_map[indx].tag,
		&hdr_map[indx].format, &hdr_map[indx].index,
		&hdr_map[indx].length,SEGYLINEHEADER);
	  if (hdr_map[indx].hdrtype == SEGYLINEHEADER) {
	    line_hdr_map[line_hdr_indx].tag = from[indx];
	    line_hdr_map[line_hdr_indx].hdrtype =
		  C_SAVCHK(line_hdr_map[line_hdr_indx].tag,
			&line_hdr_map[line_hdr_indx].format,
			&line_hdr_map[line_hdr_indx].index,
			&line_hdr_map[line_hdr_indx].length, LINEHEADER);
	    if (line_hdr_map[line_hdr_indx].hdrtype != LINEHEADER) {
/*
   the "to" entry was not a USP LINEHEADER entry, assume a constant
   we go ahead and set the type so that we'll know how to translate the ascii
*/
	      if (verbose >= 2) fprintf(prtfile,
		  "from entry %s not found; assume constant\n",from[indx]);
	      switch(hdr_map[indx].format) {
		case (SAVE_DUMMY_DEF):
		case (SAVE_INT_DEF):
		    sval = atoi(from[indx]);
		    if ((sval == 0) && (errno != 0)) {
			fprintf(stderr,"Invalid constant specification %s=%s\n",
				to[indx],
				from[indx]);
			exit(100);
			}
		    break;
		case (SAVE_SHORT_DEF):
		    lval = atol(from[indx]);
		    if ((lval == 0) && (errno != 0)) {
			fprintf(stderr,"Invalid constant specification %s=%s\n",
				to[indx],
				from[indx]);
			exit(100);
			}
		    break;
		case (SAVE_FLOAT_DEF):
		    rval = atof(from[indx]);
		    if ((rval == 0.) && (errno != 0)) {
			fprintf(stderr,"Invalid constant specification %s=%s\n",
				to[indx],
				from[indx]);
			exit(100);
			}
		    break;
		}
	      line_hdr_map[line_hdr_indx].format  = hdr_map[indx].format;
	      line_hdr_map[line_hdr_indx].index   = indx;
	      line_hdr_map[line_hdr_indx].length  = -1;
	      }
	    segy_line_hdr_map[line_hdr_indx++] = &hdr_map[indx]; 

	    if (verbose >= 2) {
		fprintf(prtfile,"line header %d mapping: from %s to %s\n",
			line_hdr_indx,from[indx],to[indx]);
		if (offset >= 0) fprintf(prtfile,"[%d]",offset);
		fprintf(prtfile,"\n");
		}
/*
	this is for SpareBin specifications
*/
	    if (offset >= 0) {
		hdr_map[indx].index += offset;
		hdr_map[indx].length = 1;
		}
	    }
	  else {
	    hdr_map[indx].tag = to[indx];
	    if (strncmp(to[indx],"Spare",5) == 0) {
	      if ((lbracket=(char *)strchr(to[indx],'[')) != NULL) {
	        *lbracket='\0';
	        lbracket+=1;
	        if ((rbracket = (char *) strrchr(lbracket,']')) == NULL) {
		  fprintf(stderr,"Invalid indexing - %s\n",to[indx]);
		  exit(100);
		  }
	        else {
	          *rbracket='\0';
		  offset = atoi(lbracket);
		  }
	        }
	      }
	    else
	      offset = -1;
	    hdr_map[indx].hdrtype = C_SAVCHK(hdr_map[indx].tag,
		&hdr_map[indx].format, &hdr_map[indx].index,
		&hdr_map[indx].length,SEGYTRACEHEADER);
	    if (hdr_map[indx].hdrtype == SEGYTRACEHEADER) {
	      trace_hdr_map[trace_hdr_indx].tag = from[indx];
	      trace_hdr_map[trace_hdr_indx].hdrtype = 
		C_SAVCHK(trace_hdr_map[trace_hdr_indx].tag,
		  &trace_hdr_map[trace_hdr_indx].format,
		  &trace_hdr_map[trace_hdr_indx].index,
		  &trace_hdr_map[trace_hdr_indx].length, TRACEHEADER);
	      if (trace_hdr_map[trace_hdr_indx].hdrtype != TRACEHEADER) {
/*
   the "to" entry was not a USP TRACEHEADER entry, assume a constant
   we go ahead and set the type so that we'll know how to translate the ascii
*/
		if (verbose >= 2) fprintf(prtfile,
		  "from entry %s not found; assume constant\n",from[indx]);
	        switch(hdr_map[indx].format) {
		  case (SAVE_DUMMY_DEF):
		  case (SAVE_INT_DEF):
		    sval = atoi(from[indx]);
		    if ((sval == 0) && (errno != 0)) {
			fprintf(stderr,"Invalid constant specification %s=%s\n",
				to[indx],
				from[indx]);
			exit(100);
			}
		    break;
		  case (SAVE_SHORT_DEF):
		    lval = atol(from[indx]);
		    if ((lval == 0) && (errno != 0)) {
			fprintf(stderr,"Invalid constant specification %s=%s\n",
				to[indx],
				from[indx]);
			exit(100);
			}
		    break;
		  case (SAVE_FLOAT_DEF):
		    rval = atof(from[indx]);
		    if ((rval == 0.) && (errno != 0)) {
			fprintf(stderr,"Invalid constant specification %s=%s\n",
				to[indx],
				from[indx]);
			exit(100);
			}
		    break;
		  }
		trace_hdr_map[trace_hdr_indx].format  = hdr_map[indx].format;
		trace_hdr_map[trace_hdr_indx].index   = indx;
		trace_hdr_map[trace_hdr_indx].length  = -1;
		}
	      segy_trace_hdr_map[trace_hdr_indx++] = &hdr_map[indx];

	      if (verbose >= 2) {
		fprintf(prtfile,"trace header %d mapping: from %s to %s",
			trace_hdr_indx,from[indx],to[indx]);
		if (offset >= 0) fprintf(prtfile,"[%d]",offset);
		fprintf(prtfile,"\n");
		}
/*
	this is for SpareBin specifications
*/
	    if (offset >= 0) {
		hdr_map[indx].index += offset;
		hdr_map[indx].length = 1;
		}
	      }
	    else {
		map_error(from[indx],to[indx]);
	      }
	    }
	  }

	if (verbose != 0) {
	  fprintf(prtfile,"number of line header entries = %d\n",line_hdr_indx);
	  for (indx=0;indx<line_hdr_indx;indx++) {
	    if (line_hdr_map[indx].length >= 1) 
	     fprintf(prtfile,"%3d from USP: tag=%12s format=%d index=%3d length=%2d\t",
	      indx, line_hdr_map[indx].tag, line_hdr_map[indx].format,
	      line_hdr_map[indx].index, line_hdr_map[indx].length);
	    else
	     fprintf(prtfile,"%3d constant: value=%12s\t",
	      indx, line_hdr_map[indx].tag);
	    fprintf(prtfile,"\n     to SEGY: tag=%12s format=%d index=%3d length=%2d\n",
	      segy_line_hdr_map[indx]->tag, segy_line_hdr_map[indx]->format,
	      segy_line_hdr_map[indx]->index, segy_line_hdr_map[indx]->length);
	    }
	  fprintf(prtfile,"\nnumber of trace header entries = %d\n",
		trace_hdr_indx);
	  for (indx=0;indx<trace_hdr_indx;indx++) {
	    if (trace_hdr_map[indx].length >= 1) 
	     fprintf(prtfile,"%3d from USP: tag=%12s format=%d index=%3d length=%2d\t",
	      indx, trace_hdr_map[indx].tag, trace_hdr_map[indx].format,
	      trace_hdr_map[indx].index, trace_hdr_map[indx].length);
	    else
	     fprintf(prtfile,"%3d constant: value=%12s\t",
	      indx, trace_hdr_map[indx].tag);
	    fprintf(prtfile,"\n     to SEGY: tag=%12s format=%d index=%3d length=%2d\n",
	      segy_trace_hdr_map[indx]->tag, segy_trace_hdr_map[indx]->format,
	      segy_trace_hdr_map[indx]->index, segy_trace_hdr_map[indx]->length);
	    }
	  }
/*
	Now we actually do the moving of data into the SEGY header
*/
	for (indx=0;indx<line_hdr_indx;indx++) {
	    switch( line_hdr_map[indx].format ) {
		case (SAVE_DUMMY_DEF):
		  if (line_hdr_map[indx].length != -1) 
		    get_indexed_hw_val(buffer,line_hdr_map[indx].format,
			line_hdr_map[indx].index,line_hdr_map[indx].length,
			LINEHEADER,&sval);
		  else {
		    sval = atoi(trace_hdr_map[indx].tag);
		    if ((sval == 0) && (errno != 0)) {
			fprintf(stderr,"Invalid constant specification %s=%s\n",
				segy_line_hdr_map[indx]->tag,
				line_hdr_map[indx].tag);
			}
		    }
		  put_indexed_hw_val(header,segy_line_hdr_map[indx]->format,
			segy_line_hdr_map[indx]->index,
			segy_line_hdr_map[indx]->length,
			SEGYLINEHEADER,sval);
		  break;
		case (SAVE_CHAR_DEF):
		  if (line_hdr_map[indx].length != -1) 
		    get_indexed_hw_val(buffer,line_hdr_map[indx].format,
			line_hdr_map[indx].index,line_hdr_map[indx].length,
			LINEHEADER,chval);
		  else
		    chval = from[line_hdr_map[indx].index];
		  put_indexed_hw_val(header,segy_line_hdr_map[indx]->format,
			segy_line_hdr_map[indx]->index,
			segy_line_hdr_map[indx]->length,
			SEGYLINEHEADER,chval);
		    break;
		case (SAVE_SHORT_DEF):
		  if (line_hdr_map[indx].length != -1) 
		    get_indexed_hw_val(buffer,line_hdr_map[indx].format,
			line_hdr_map[indx].index,
			line_hdr_map[indx].length,
			LINEHEADER,&sval);
		  else {
		    sval = atoi(line_hdr_map[indx].tag);
		    if ((sval == 0) && (errno != 0)) {
			fprintf(stderr,"Invalid constant specification %s=%s\n",
				segy_line_hdr_map[indx]->tag,
				line_hdr_map[indx].tag);
			}
		    }
#if ( BYTE_ORDER == LITTLE_ENDIAN )
	            if (strncmp(segy_line_hdr_map[indx]->tag,"Spare",5) == 0) {
			HTOCS(&sval,segy_line_hdr_map[indx]->length);
			}
#endif
		  put_indexed_hw_val(header,segy_line_hdr_map[indx]->format,
			segy_line_hdr_map[indx]->index,
			segy_line_hdr_map[indx]->length,
			SEGYLINEHEADER,sval);
		  break;
		case (SAVE_LONG_DEF):
		  if (line_hdr_map[indx].length != -1) 
		    get_indexed_hw_val(buffer,line_hdr_map[indx].format,
			line_hdr_map[indx].index,
			line_hdr_map[indx].length,
			LINEHEADER,&lval);
		  else {
		    lval = atol(line_hdr_map[indx].tag);
		    if ((lval == 0) && (errno != 0)) {
			fprintf(stderr,"Invalid constant specification %s=%s\n",
				segy_line_hdr_map[indx]->tag,
				line_hdr_map[indx].tag);
			}
		    }
#if ( BYTE_ORDER == LITTLE_ENDIAN )
	         if (strncmp(segy_line_hdr_map[indx]->tag,"Spare",5) == 0) {
			HTOCL(&lval,segy_line_hdr_map[indx]->length);
			}
#endif
		  put_indexed_hw_val(header,segy_line_hdr_map[indx]->format,
			segy_line_hdr_map[indx]->index,
			segy_line_hdr_map[indx]->length,
			SEGYLINEHEADER,lval);
		  break;
		case (SAVE_FLOAT_DEF):
                case (SAVE_FKFLT_DEF):
		  if (line_hdr_map[indx].length != -1) 
		    get_indexed_hw_val(buffer,line_hdr_map[indx].format,
			line_hdr_map[indx].index,
			line_hdr_map[indx].length,
			LINEHEADER,&rval);
		  else {
		    rval = atof(line_hdr_map[indx].tag);
		    if ((rval == 0.) && (errno != 0)) {
			fprintf(stderr,"Invalid constant specification %s=%s\n",
				segy_line_hdr_map[indx]->tag,
				line_hdr_map[indx].tag);
			}
		    }
#if ( BYTE_ORDER == LITTLE_ENDIAN )
	         if (strncmp(segy_line_hdr_map[indx]->tag,"Spare",5) == 0) {
			HTOCL(&rval,segy_line_hdr_map[indx]->length);
			}
#endif
		  put_indexed_hw_val(header,segy_line_hdr_map[indx]->format,
			segy_line_hdr_map[indx]->index,
			segy_line_hdr_map[indx]->length,
			SEGYLINEHEADER,rval);
		  break;
		    }
		}

/* If necessary, we need to do byte rotations */

#if ( BYTE_ORDER == LITTLE_ENDIAN )
	if (native_line_header != 1) {
	  HTOCL(header,3);
	  C_SAVELU("NumTrc",&format,&index,&length,SEGYLINEHEADER);
	  HTOCS(header+(index*sizeof(short)),25);
	  }
#endif

	bytes = fwrite(header,1,SEGYLINEHEADERBYTES,output);
	if (bytes == 0) {
	  fprintf(stderr,"%s: error writing header (%d bytes attempted)\n",
		argv[0],SEGYLINEHEADERBYTES);
	  exit(1);
	  }
	  
	free(header);
	free(buffer);

	linetrcnum = 0;

	if ((buffer = (char *)malloc(SZTRHD+(numsmp*SZSMPD))) == NULL) {
	  fprintf(stderr,"%s: failure mallocing %ld bytes of memory for USP traces\n",
		argv[0],SZTRHD+(numsmp*SZSMPD));
	  exit(1);
	  }

	databytes = numsmp * SZSMPD;

	if ((header = (char *)malloc(SEGYTRACEHEADERBYTES+databytes)) == NULL) {
	  fprintf(stderr,"%s: failure mallocing %d bytes of memory\n",
		argv[0],SEGYTRACEHEADERBYTES);
	  exit(1);
	  }

	memset(header,0,SEGYTRACEHEADERBYTES+databytes);

	if (verbose >= 2) {
	    fprintf(prtfile,"\n\n");
	    fprintf(prtfile," trace       field      field ");
	    fprintf(prtfile,"      trace         number      sample\n");

	    fprintf(prtfile,"sequence     record     trace ");
	    fprintf(prtfile,"  identification      of       interval\n");

	    fprintf(prtfile," number      number     number");
	    fprintf(prtfile,"      code         samples    (microsecs)\n");

	    fprintf(prtfile,"--------     ------     ------");
	    fprintf(prtfile,"  --------------   -------    -----------\n");

	    fprintf(prtfile,"\n\n");
	    }

/* look up indexes to speed things up in trace loop */

	C_SAVELU("TrcNumSmp",&TrcNumSmp_format,&TrcNumSmp_index,
		&TrcNumSmp_length,SEGYTRACEHEADER);
	C_SAVELU("TrcIdCode",&TrcIdCode_format,&TrcIdCode_index,
		&TrcIdCode_length,SEGYTRACEHEADER);
	C_SAVELU("RecNum", &RecNum_format, &RecNum_index,
		&RecNum_length, TRACEHEADER);
	C_SAVELU("TrcNum", &TrcNum_format, &TrcNum_index,
		&TrcNum_length, TRACEHEADER);
	C_SAVELU("SrPtXC", &SrPtXC_format, &SrPtXC_index,
		&SrPtXC_length, TRACEHEADER);
	C_SAVELU("SrPtYC", &SrPtYC_format, &SrPtYC_index,
		&SrPtYC_length, TRACEHEADER);
	C_SAVELU("RcPtXC", &RcPtXC_format, &RcPtXC_index,
		&RcPtXC_length, TRACEHEADER);
	C_SAVELU("RcPtYC", &RcPtYC_format, &RcPtYC_index,
		&RcPtYC_length, TRACEHEADER);
	C_SAVELU("DphInd", &DphInd_format, &DphInd_index,
		&DphInd_length, TRACEHEADER);
	C_SAVELU("PrRcNm", &PrRcNm_format, &PrRcNm_index,
		&PrRcNm_length, TRACEHEADER);
	C_SAVELU("PrTrNm", &PrTrNm_format, &PrTrNm_index,
		&PrTrNm_length, TRACEHEADER);
	C_SAVELU("SrcDepth", &SrcDepth_format, &SrcDepth_index,
			&SrcDepth_length, SEGYTRACEHEADER);
	C_SAVELU("FieldRecNum", &FieldRecNum_format, &FieldRecNum_index,
			&FieldRecNum_length, SEGYTRACEHEADER);
	C_SAVELU("FieldTrcNum", &FieldTrcNum_format, &FieldTrcNum_index,
			&FieldTrcNum_length, SEGYTRACEHEADER);
	C_SAVELU("LineTrcNum", &LineTrcNum_format, &LineTrcNum_index,
			&LineTrcNum_length, SEGYTRACEHEADER);
	C_SAVELU("TrcSmpInt", &TrcSmpInt_format, &TrcSmpInt_index,
			&TrcSmpInt_length, SEGYTRACEHEADER);
	C_SAVELU("CdpNum", &CdpNum_format, &CdpNum_index,
			&CdpNum_length, SEGYTRACEHEADER);
	C_SAVELU("CdpTrcNum", &CdpTrcNum_format, &CdpTrcNum_index,
			&CdpTrcNum_length, SEGYTRACEHEADER);
/*
   Set TrcNumSmp and TrcSmpInt to USP line header values as default
*/
	put_indexed_hw_val(header, TrcNumSmp_format, TrcNumSmp_index,
		TrcNumSmp_length, SEGYTRACEHEADER, numsmp);

	put_indexed_hw_val(header, TrcSmpInt_format, TrcSmpInt_index,
		TrcSmpInt_length, SEGYTRACEHEADER, segysmpint);

	trcknt = 0;

	while (1) {
	  C_RTAPE(luin,buffer,&bytes);
	  if (bytes == 0) { 			/* normal exit */
	    if (verbose == 1) fprintf(prtfile,"%d traces processed\n",trcknt);
	    fclose(output);
	    C_LBCLOS(luin);
	    exit(0);
	    }
	  trcknt++;

/* - perhaps make this a command line option - or the default?
	  linetrcnum++;
	  put_indexed_hw_val(header, LineTrcNum_format, LineTrcNum_index,
		LineTrcNum_length, SEGYTRACEHEADER, linetrcnum);
*/

/*
   Take care of the specified trace header mappings
*/
	for (indx=0;indx<trace_hdr_indx;indx++) {
	    switch( trace_hdr_map[indx].format ) {
		case (SAVE_DUMMY_DEF):
		  if (trace_hdr_map[indx].length != -1) 
		    get_indexed_hw_val(buffer,trace_hdr_map[indx].format,
			trace_hdr_map[indx].index,trace_hdr_map[indx].length,
			LINEHEADER,&sval);
		  else {
		    sval = atoi(trace_hdr_map[indx].tag);
		    if ((sval == 0) && (errno != 0)) {
			fprintf(stderr,"Invalid constant specification %s=%s\n",
				segy_trace_hdr_map[indx]->tag,
				trace_hdr_map[indx].tag);
			}
		    }
		  put_indexed_hw_val(header,segy_trace_hdr_map[indx]->format,
			segy_trace_hdr_map[indx]->index,
			segy_trace_hdr_map[indx]->length,
			SEGYLINEHEADER,sval);
		  break;
		case (SAVE_CHAR_DEF):
		  if (trace_hdr_map[indx].length != -1) 
		    get_indexed_hw_val(buffer,trace_hdr_map[indx].format,
			trace_hdr_map[indx].index,trace_hdr_map[indx].length,
			LINEHEADER,chval);
		  else
		    chval=from[trace_hdr_map[indx].index];
		  put_indexed_hw_val(header,segy_trace_hdr_map[indx]->format,
			segy_trace_hdr_map[indx]->index,
			segy_trace_hdr_map[indx]->length,
			SEGYLINEHEADER,chval);
		    break;
		case (SAVE_SHORT_DEF):
		  if (trace_hdr_map[indx].length != -1) 
		    get_indexed_hw_val(buffer,trace_hdr_map[indx].format,
			trace_hdr_map[indx].index,
			trace_hdr_map[indx].length,
			LINEHEADER,&sval);
		  else {
		    sval = atoi(trace_hdr_map[indx].tag);
		    if ((sval == 0) && (errno != 0)) {
			fprintf(stderr,"Invalid constant specification %s=%s\n",
				segy_trace_hdr_map[indx]->tag,
				trace_hdr_map[indx].tag);
			}
		    }
#if ( BYTE_ORDER == LITTLE_ENDIAN )
	         if (strncmp(segy_trace_hdr_map[indx]->tag,"Spare",5) == 0) {
			HTOCS(&sval,segy_trace_hdr_map[indx]->length);
			}
#endif
		  put_indexed_hw_val(header,segy_trace_hdr_map[indx]->format,
			segy_trace_hdr_map[indx]->index,
			segy_trace_hdr_map[indx]->length,
			SEGYLINEHEADER,sval);
		  break;
		case (SAVE_LONG_DEF):
		  if (trace_hdr_map[indx].length != -1) 
		    get_indexed_hw_val(buffer,trace_hdr_map[indx].format,
			trace_hdr_map[indx].index,
			trace_hdr_map[indx].length,
			LINEHEADER,&lval);
		  else {
		    lval = atol(trace_hdr_map[indx].tag);
		    if ((lval == 0) && (errno != 0)) {
			fprintf(stderr,"Invalid constant specification %s=%s\n",
				segy_trace_hdr_map[indx]->tag,
				trace_hdr_map[indx].tag);
			}
		    }
#if ( BYTE_ORDER == LITTLE_ENDIAN )
	         if (strncmp(segy_trace_hdr_map[indx]->tag,"Spare",5) == 0) {
			HTOCL(&lval,segy_trace_hdr_map[indx]->length);
			}
#endif
		  put_indexed_hw_val(header,segy_trace_hdr_map[indx]->format,
			segy_trace_hdr_map[indx]->index,
			segy_trace_hdr_map[indx]->length,
			SEGYLINEHEADER,lval);
		  break;
		case (SAVE_FLOAT_DEF):
                case (SAVE_FKFLT_DEF):
		  if (trace_hdr_map[indx].length != -1) 
		    get_indexed_hw_val(buffer,trace_hdr_map[indx].format,
			trace_hdr_map[indx].index,
			trace_hdr_map[indx].length,
			LINEHEADER,&rval);
		  else {
		    rval = atof(trace_hdr_map[indx].tag);
		    if ((rval == 0.) && (errno !=0 )) {
			fprintf(stderr,"Invalid constant specification %s=%s\n",
				segy_trace_hdr_map[indx]->tag,
				trace_hdr_map[indx].tag);
			}
		    }
#if ( BYTE_ORDER == LITTLE_ENDIAN )
	         if (strncmp(segy_trace_hdr_map[indx]->tag,"Spare",5) == 0) {
			HTOCL(&rval,segy_trace_hdr_map[indx]->length);
			}
#endif
		  put_indexed_hw_val(header,segy_trace_hdr_map[indx]->format,
			segy_trace_hdr_map[indx]->index,
			segy_trace_hdr_map[indx]->length,
			SEGYLINEHEADER,rval);
		  break;
		    }
		}


	  if (verbose >= 2) {
	    get_indexed_hw_val(header, LineTrcNum_format, LineTrcNum_index,
		LineTrcNum_length, SEGYTRACEHEADER, &linetrcnum);
	    get_indexed_hw_val(header,TrcIdCode_format,TrcIdCode_index,
		TrcIdCode_length,SEGYTRACEHEADER,&trid);
	    get_indexed_hw_val(header, FieldRecNum_format, FieldRecNum_index,
		FieldRecNum_length, SEGYTRACEHEADER, &segy_prrcnm);
	    get_indexed_hw_val(header, FieldTrcNum_format, FieldTrcNum_index,
		FieldTrcNum_length, SEGYTRACEHEADER, &segy_prtrnm);
	    get_indexed_hw_val(header, TrcNumSmp_format, TrcNumSmp_index,
		TrcNumSmp_length, SEGYTRACEHEADER, &trcnumsmp);
	    get_indexed_hw_val(header, TrcSmpInt_format, TrcSmpInt_index,
		TrcSmpInt_length, SEGYTRACEHEADER, &segysmpint);
	    get_indexed_hw_val(header, CdpNum_format, CdpNum_index,
		CdpNum_length, SEGYTRACEHEADER, &cdpnum);
	    get_indexed_hw_val(header, CdpTrcNum_format, CdpTrcNum_index,
		CdpTrcNum_length, SEGYTRACEHEADER, &cdptrcnum);

	    fprintf(prtfile," %5d       %5d      %5d ",linetrcnum,segy_prrcnm,segy_prtrnm);
/*
	    fprintf(prtfile,"        %1d           %5d      %5d     %5d     %5d\n",
	    trid, trcnumsmp, segysmpint, cdpnum, cdptrcnum);
*/
	    fprintf(prtfile,"        %1d           %5d      %5d\n",
	    trid, trcnumsmp, segysmpint);
	    }


/*
	  for (j=0; j<numsmp; j++) 
	      ieeeibm( buffer+SZTRHD+(j*sizeof(float)),
		header+SEGYTRACEHEADERBYTES+(j*sizeof(float)));
*/
#if ( BYTE_ORDER == LITTLE_ENDIAN )
	  float_to_ibm(buffer+SZTRHD, header+SEGYTRACEHEADERBYTES, numsmp, native_trace_data);
	  HTOCL(buffer+SZTRHD,numsmp);
#else
	  float_to_ibm(buffer+SZTRHD, header+SEGYTRACEHEADERBYTES, numsmp, 1);
#endif


#if ( BYTE_ORDER == LITTLE_ENDIAN )
	  if (native_trace_header != 1) {
	    HTOCL(header,7);
	    C_SAVELU("TrcIdCode",&format,&index,&length,SEGYTRACEHEADER);
	    HTOCS(header+(index*sizeof(short)),4);
	    C_SAVELU("DstSgn",&format,&index,&length,SEGYTRACEHEADER);
	    HTOCL(header+(index*sizeof(long)),8);
	    C_SAVELU("ElevScaler",&format,&index,&length,SEGYTRACEHEADER);
	    HTOCS(header+(index*sizeof(short)),2);
	    C_SAVELU("SrcX",&format,&index,&length,SEGYTRACEHEADER);
	    HTOCL(header+(index*sizeof(long)),4);
	    C_SAVELU("XYUnits",&format,&index,&length,SEGYTRACEHEADER);
	    HTOCS(header+(index*sizeof(short)),46);
	    }
#endif
	  bytes = fwrite(header,1,SEGYTRACEHEADERBYTES+databytes,output);
	  }
}
int read_map_file(map_file,indx,to,from)
char *map_file;
char **from,**to;
int indx;
{
	int indx2;
	int i,nelem;
	FILE *map_unit;
	char value[48];
	
	indx2 = 0;
	if (strlen(map_file) > 0) {
	  map_unit = fopen(map_file,"r");
	  if (map_unit == NULL) {
	    fprintf(stderr,"USP2SEGY ERROR: Unable to open map file %s; aborting\n",
		map_file);
	    if (verbose != 0)
	     fprintf(prtfile,"USP2SEGY ERROR: Unable to open map file %s; aborting\n",
		map_file);
	    exit(1);
	    }
	  else {
	    do {
		nelem = fscanf(map_unit,"%s\n",value);
		if (nelem > 0) {
		  indx++;
		  indx2++;
	          to[indx] = (char *)strdup(value);
	          from[indx] = (char *)strchr(to[indx],'=')+1;
	          to[indx][from[indx]-to[indx]-1] = '\0';
/*
   if we find an override, put it in the map at the location of the 
   previous specification
*/
		  for (i=0; i<indx; i++) {
		    if (strcmp(to[i],to[indx]) == 0) {
		      fprintf(stderr,"USP2SEGY: Duplicate specifications for mnemonic %s;\n          %s=%s overrides previous entry of %s=%s\n",to[indx],to[indx],from[indx],to[i],from[i]);
		      if (verbose != 0) fprintf(prtfile," USP2SEGY: Duplicate specifications for mnemonic %s;\n          %s=%s overrides previous entry of %s=%s\n",to[indx],to[indx],from[indx],to[i],from[i]);
		      from[i] = from[indx];
		      to[i] = to[indx];
		      indx--;
		      break;
		      }
		    }
		  }
		} while (nelem >= 0);
	  }
	}
	else {
	  strcpy(map_file,"N/A");
	}

	if (verbose != 0)
	  fprintf(prtfile," number of items in %s = %d\n",map_file,indx2);
	return(indx);
}
