C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      program vaplot
c-----
c
c     program module plot
c
c-----
c
c plot reads seismic trace data from an input file,
c and plots a va plot on the lp.
c
c subroutine calls: rtape, hlh,  save, begplt, endplt, rlplot
c
c-----
c
c     declare variables
c
#include <localsys.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h> 

      integer itr (SZLNHD)
      integer     luin, luat, lbytes, nbytes
      integer     nsamp, nsi, ntrc, nrec, iform
      integer     jstrt, jstop, npt
      integer     ns, ne, rs, re, ispace, td, istrt, istop
      integer     RecNum, ifmt_RecNum, l_RecNum, ln_Recnum
      integer     TrcNum, ifmt_TrcNum, l_TrcNum, ln_TrcNum
      integer     argis, shde

      real        tri (SZLNHD)
      real        tstart, xdis, fs, delta, ydis, xscale
      real        tmscl, trscl, fullsc, atmax, atmin, width

      character   ntap*255, atap*255, stdout*6, name*6

      logical     verbos, dwntop, atrrev, trce, atrlgn
      logical     query
 
c initialize variables

      data nbytes / 0 /
      data lbytes / 0 /
      data stdout/'stdout'/
      data name/'VAPLOT'/

c-----
c      read program parameters from command line 
c-----
      query = ( argis ( '-?' ) .gt. 0 .or. argis ( '-h' ) .gt. 0)
      if ( query ) then
            call help()
            stop
      endif
c-----
c      open printout file
c-----
#include <f77/open.h>
c-----
c      parse command line arguments
c-----
      call gcmdln(tmscl, trscl, fullsc, istrt, istop, atmax,
     1 atmin, ns,ne,rs,re, ispace, td, ntap, atap, shde, verbos,
     2 dwntop, atrrev, trce, atrlgn, width)
c-----
c      get logical unit numbers for input (s)
c-----
      call getln(luin, ntap, 'r', 0 )
      call getln(luat, atap, 'r', 1 )
c-----
c      read line header of input
c      save certain parameters
c-----

      if(luat .gt. 1)call rtape(luat, itr, lbytes)

      call rtape4(luin, itr, lbyte,lbytes)
      call hlhprt (itr, lbyte, name, 6, LERR)

#include <f77/saveh.h>
      if (nsi .gt. 32) then
          deltt = nsi/1000.
      else
          deltt = nsi
      endif
c-----
c      ensure that command line values are compatible with data set
c-----
      call cmdchk(ns,ne,rs,re,ntrc,nrec)
      tstart = real ( istrt/1000.0 )
      xdis = 1./ trscl
      fs = fullsc * xdis
      delta = 1./tmscl
      ydis = (0.001 / delta ) * deltt
      xscale = fs/ 2047.0
      jstrt = ( istrt/ deltt ) + 1
      jstop = ( istop/ deltt ) + 1
      if(jstrt .lt. 1 .or. jstrt.gt.nsamp)jstrt = 1
      if(jstop .le. jstrt .or. jstop.gt.nsamp)jstop=nsamp
      npt = jstop - jstrt + 1
c-----
c      verbose output of all pertinent information before 
c      processing begins
c-----
      if(verbos) then
         call verbal(nsamp, nsi, ntrc, nrec, iform, ntap, atap,
     1        ns, ne, rs, re, ispace, td, istrt, istop, shde, verbos,
     2        dwntop, atrrev, atmax, atmin , tstart, xdis, fs, delta, 
     3        ydis, xscale, jstrt, jstop, npt, trce, atrlgn, width,
     4        luin,luat)
      endif

c set up pointers to trace header entries

      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)

c-----
c      BEGIN PROCESSING
c      read trace, plot
c-----
c-----
c     skip unwanted records
c-----
      if(luat .gt. 1)   call recskp ( 1, irs-1, luat, ntrc, itr )
      call recskp ( 1, irs-1, luin, ntrc, itr )
c-----
c     process desired trace records
c-----
      trclen = npt*ydis + 0.001
      if(dwntop)then
            y0 = 1.0
      else
            y0 = width - 1.0
      endif
      call pinitf(stdout)
      if(luat.gt.1 .and. atrlgn)call
     1      graysc(y0,atmin,atmax,atrrev,trclen,dwntop,1005,1100)
      call begplt(y0, trclen, fs, delta, tstart, dwntop)
      do 1000 jj = rs, re
         call plot(1.0,0.0,-3)
         if(luat.gt.1) call trcskp ( JJ, 1, ns-1, luat, ntrc, itr )
         call trcskp ( JJ, 1, ns-1, luin, ntrc, itr )

         k = 0
         do 1001 kk=ns,ne
            if(k.eq.ispace)then
               call plot(xdis*td,0.0,-3)
               k = 1
            else
               call plot(xdis, 0.0, -3)
               k = k + 1
            endif

            if(luat .gt. 1)then
               nbytes = 0
               call rtape( luat, itr, nbytes)
               if(nbytes .eq. 0) then
                  write(LERR,*)'Premature EOF on attribute file at:'
                  write(LERR,*)'  rec= ',JJ,'  trace= ',KK
                  go to 999
               endif
               call vmov( itr(ITHWP1), 1, tri, 1, nsamp )
               
               call shdatr(0.0,y0,tri(jstrt),npt,atmax,atmin
     1              ,ydis,xdis,atrrev,dwntop,1005,1100)
            endif
            
            nbytes = 0
            call rtape(luin, itr, nbytes)
            if(nbytes .eq. 0) then
               write(LERR,*)'Premature EOF on input at:'
               write(LERR,*)'  rec= ',JJ,'  trace= ',KK
               go to 999
            endif
            call vmov ( itr(ITHWP1), 1, tri, 1, nsamp )

            tri(jstrt) = 0.
            tri(jstrt+npt-1) = 0.
            call scal1 ( -1.0, npt, tri(jstrt) )
            if(trce) then
               call maxsn(npt,tri(jstrt),xmax,jndex)
               if(xmax .eq. 0.0)xmax = 1.0
               xscal = 2047. * xscale/xmax
            else
               xmax=1.
               xscal =  xscale/xmax
            endif
            if (verbos) then
               call saver2( itr, ifmt_RecNum, l_RecNum, ln_RecNum, 
     :              RecNum, TRACEHEADER )
               call saver2( itr, ifmt_TrcNum, l_TrcNum, ln_TrcNum, 
     :              TrcNum, TRACEHEADER )
               write(LERR,*)'RecNum = ',RecNum,' TrcNum = ',TrcNum
               write(LERR,*)'scale factor=  ',xscal
            endif
            if(dwntop)then
               xscall = +xscal
               ishd = 1
            else
               xscall = -xscal
               ishd = 0
            endif
            
            if (iabs(shde) .le. 1) then
               call shdsei(0.0,y0,1,1,shde)
            endif
            
            call trcplt ( 0.0, y0, tri(jstrt),npt,xscall,
     1           ydis,fs, dwntop)

            if (iabs(shde) .le. 1) then
               call shdsei(0.0,y0,1,0,shde)
            endif

 1001    continue
         if(luat .gt. 1)call
     1        skptrc(jj,ne+1,ntrc,luat,nsamp,ntrc,itr,
     2        lbytes,nbytes,iform)
         call skptrc(jj,ne+1,ntrc,luin,nsamp,ntrc,itr,
     1        lbytes,nbytes,iform)
         call plot(-1.0,0.0,-3)
         if(jj.ne.re)call frame()
 1000 continue
      call plot(1.0,0.0,-3)
      call endplt(y0, trclen, fs, delta, tstart, dwntop, xdis)
c-----
c     close data files
c-----

 999  continue

      call lbclos ( luin )
      if(luat .gt. 1) call lbclos ( luat )
      if(verbos) then
         write(LERR,*)'end of vaplot, processed',nrec,' record(s)',
     1        ' with ',ntrc, ' traces'
      endif
      stop
      end
c-----
c subroutines
c-----
      subroutine begplt (y0, trclen, fs, delta, tstart, dwntop)
      real    * 4 trclen, fs, tstart, delta
      logical dwntop
      character    blk * 28
      data blk  /'2-WAY TRAVEL TIME IN SECONDS'/
c-----
c     plot time axis at beginning of plot
c
c
c     y0     - R*4 position of start of axis
c     trclen - R*4 length of axis in inches
c     fs     - R*4 trace spacing in inches
c     delta  - R*4 units per inch
c     tstart - R*4 time of first sample
c     dwntop - L   if true time increase upward
c
c-----
            if(dwntop)then
                  ang = 90.0
                  nchar = 28
            else
                  ang = -90.0
                  nchar = -28
            endif
            call plot(1.0,0.0,-3)
            call axis ( 0.0, y0, blk, nchar, trclen,
     1             ang, tstart, delta )
            call plot(-1.0,0.0,-3)
            call plot ( fs       , 0.0, -3 )
      return
      end

      subroutine endplt (y0, trclen, fs, delta, tstart, dwntop, xdis)
      real    * 4 trclen, fs, tstart, delta, xdis
      logical dwntop
      character    blk * 28
      data blk  /'2-WAY TRAVEL TIME IN SECONDS'/
c-----
c     plot time axis at end of plot
c
c
c     y0     - R*4 position of start of axis
c     trclen - R*4 length of axis in inches
c     fs     - R*4 trace spacing in inches
c     delta  - R*4 units per inch
c     tstart - R*4 time of first sample
c     dwntop - L   if true time increase upward
c     xdis   - R*4 trace separation in inches
c
c-----
            if(dwntop)then
                  ang = 90.0
                  nchar = -28
            else
                  ang = -90.0
                  nchar = +28
            endif
            call plot(2.0*fs - xdis,0.0,-3)
            call axis ( 0.0, y0, blk, nchar, trclen,
     1             ang, tstart, delta )
            call plot(-1.0,0.0,-3)
            call plot ( fs       , 0.0, -3 )
            call pend()
      return
      end

      subroutine trcplt(x0,y0,v,n,scalev,dy,clip,dwntop)
c-----
c      plot seismic trace
c
c     x0    - R*4 trace origin
c     y0    - R*4 trace origin
c     v     - R*4 array of values to be plotted
c     n     - R*4 number of points to be plotted
c     scalev- R*4 convert trace v to inches
c     dy    - R*4 time increment in inches
c     clip  - R*4 peak value of amplitude in inches
c     dwntop- L   false (top->down plot)
c
c-----
      real*4 x0, v(1), scalev, dy, clip
      integer*4 n
      logical dwntop

            ipen = 3
            yy = y0
            do 100 i=1,n
                    val = scalev * v(i)
                    xx = x0 + sign(amin1(abs(val),clip), val)
                    call plot(xx,yy,ipen)
                    ipen = 2
                    if(dwntop)then
                          yy = yy + dy
                    else
                          yy = yy - dy
                    endif
  100       continue
      return
      end

      subroutine graysc(y0,atmin,atmax,atrrev,trclen,dwntop,
     1          ipen0,ipen1)
c-----
c      plot gray/color attribute scale
c
c      y0      - R*4 y-axis position of top of scale
c      atmin   h{/+m clipping level
c      atmax   - R*4 maximum clipping level
c      atrrev  - L   (false) max -> dark/red
c                    (true)  min -> dark/red
c      dwntop  - L   (true) bottom -> top plot
c                    (false) top -> bottom plot
c      trclen  - R*4 maximum trace length in inches
c      ipen0   - I*4 minimnum ipen value
c      ipen1   - I*4 maximum ipen value
c
c-----
      real*4 y0, atmin, atmax, trclen
      logical atrrev, dwntop
      integer*4 ipen0, ipen1
      integer*4 NGRY
            NGRY = ipen1 - ipen0
            if(NGRY.lt.1)NGRY=1
            if(dwntop)then
                  ylw = y0
                  yup = y0 + trclen
                  dy = trclen/real(NGRY+1)
            else
                  ylw = y0 - trclen
                  yup = y0 
                  dy = trclen/real(NGRY+1)
            endif
            dx = 0.15
            call plot(1.0,0.0,-3)
c-----
c      draw border
c-----
            call plot(-dx,ylw,3)
            call plot(+dx,ylw,2)
            call plot(+dx,yup,2)
            call plot(-dx,yup,2)
            call plot(-dx,ylw,2)
c-----
c      fill in shading
c-----
            do 100 i = 0, NGRY
                  if(atrrev)then
                        ipen = ipen0 + NGRY - i
                  else
                        ipen = ipen0 + i
                  endif
                  yl = yup -  i   *dy
                  yh = yup - (i+1)*dy
                  ipatx = 0
                  ipaty = 0
                  xlen = 0.02
                  ylen = 0.02
                  call newpen(ipen)
                  call shader(-dx,yl,dx,yh,ipatx,ipaty,xlen,ylen)
  100 continue
c-----
c      turn off shading
c-----
            call newpen(1)
c-----
c      out in extreme values
c-----
            call number(-dx,ylw-0.20,0.10,atmin,0.0,2)
            call number(-dx,yup+0.10,0.10,atmax,0.0,2)
      return
      end

      subroutine shdatr(x0,y0,atr,n,atmax,atmin,dy,dx,atrrev,
     1       dwntop,ipen0,ipen1)
c-----
c      general routine to shade (color) trace background according
c      to an attribute which 1-1 maps each trace time point
c       for all records
c
c     x0     - R*4 x-axis origin
c     y0     - R*4 y-axis origin
c     atr    - R*4 attribute array
c     n      - R*4 number of points to plot in attribute array
c     atmax   - R*4 maximum value of attribute to use
c     atmin   - R*4 minimum value of attribute to use (clipping)
c     dy     - R*4 time increment in  inches
c     dx     - R*4 width of shading area centered on origin
c     atrrev - L   (true atmax -> ipen=1000, else atmin -> ipen 1000)
c     dwntop - L   (true time up from bottom )
c     ipen0   - I*4 minimnum ipen value
c     ipen1   - I*4 maximum ipen value
c
c-----
      real*4 x0, y0, atr(1), atmax, atmin, dy, dx
      integer*4 n
      logical atrrev, dwntop
      integer*4 ipen0, ipen1
      integer*4 NGRY
            NGRY = ipen1 - ipen0
            if(NGRY.lt.1)NGRY=1
            xl = -dx/2.
            xh =  dx/2.
            yy = y0
c-----
c     take value over a 0.05 inch range
c-----
            nskip = 0.05/dy
            if(nskip.lt.1)nskip = 1
            do 300 i=nskip+1,n,nskip
                  if(dwntop)then
                        yh = yy + dy*nskip
                        yl = yy
                        yy = yy + dy*nskip
                  else
                        yh = yy
                        yl = yy - dy*nskip
                        yy = yy - dy*nskip
                  endif
                  atrv=0.0
                  do 301 j=i-nskip,i
                        atrv = atrv + atr(j)
  301             continue
                  atrv = atrv/(nskip + 1)
                  if(atrrev)then
                        xcol = (atrv - atmin)/(atmax - atmin)
                  else
                        xcol = (atmax - atrv)/(atmax - atmin)
                  endif
                  if(xcol .lt. 0.0)xcol = 0.0
                  if(xcol .gt. 1.0)xcol = 1.0
                  xcol = real(NGRY) * xcol
                  ipen = ipen0 + xcol
                  if(ipen .lt. ipen0)ipen = ipen0
                  if(ipen .gt. ipen1)ipen = ipen1
                  ipatx = 0
                  ipaty = 0
                  xlen = 0.02
                  ylen = 0.02
                  call newpen(ipen)
                  call shader(xl,yl,xh,yh,ipatx,ipaty,xlen,ylen)
  300 continue
c-----
c      undo special shading
c-----
      call newpen(1)
      return
      end


      subroutine scal1(s, lx, x)
c-----
c      this subroutine scales a vector x by multiplying each of the
c      lx elements by the scale factor s
c
c      s      - R*4 scale factor
c      lx     - I*4 array length
c      x      - R*4 array to be scaled
c-----
      real*4 s, x(1)
      integer*4 lx
            do 100 i=1,lx
                  x(i)=x(i)*s
  100       continue
      return
      end
      subroutine help
#include <f77/iounit.h>
      write(LER,*)
     1'***************************************************************'
      write(LER,*)
      write(LER,*)
     1'Execute vaplot by typing vaplot with the following arguments'
      write(LER,*)
     1' -N [ntap]    (default stdin)           : Input data file name'
      write(LER,*)' '
      write(LER,*)
     1' -tmsc [tmscl]      (default=2.5)    : Time Scale (in/sec)'
      write(LER,*)
     1' -trsc [trscl]      (default=12)     : Trace Scale (tr/in)'
      write(LER,*)
     1' -amp [fullsc] (default=1.33) Full scale amp in units of trace '
     1,'width'
      write(LER,*)
     1' -tmin [start] (default = 0 ms)     :  Start time in ms'
      write(LER,*)
     1' -tmax [stop]  (default = full trace)     : Stop time in ms'
      write(LER,*)
     1' -sp [ispace], (default=none) insert blank after ispace traces'
      write(LER,*)
     1' -td [itd],    (default=5)      : blank space width in traces'
      write(LER,*)' '
      write(LER,*)
     1' -rs [ir],    (default=1)         : beginning record number'
      write(LER,*)
     1' -re [re],    (default=last)      : ending record number'
      write(LER,*)
     1' -ns [ns],    (default=1)          : beginning trace number'
      write(LER,*)
     1' -ne [ne],    (default=last)       : ending trace number'
      write(LER,*)' '
      write(LER,*)
     1' -S [shde]   (default=no fill) : 0 = pos fill; 1 = neg fill'
      write(LER,*)
     1' -R           (default top->bottom time plot)'
      write(LER,*)
     1' -T (default off ) force trace scaling * fullsc'
      write(LER,*)
     1' -G (default off ) If on, do not plot attribute legend'
      write(LER,*)
     1' -W [width] (paer width default = 7.5)'
      write(LER,*)
     1' -AT [attribute file] (default no auxiliary shading)'
      write(LER,*)
     1' -AMX [ atmax] (max value of attribute for saturated shading)'
      write(LER,*)
     1' -AMN [ atmin] (min value of attribute for minimal shading)'
      write(LER,*)
     1' -AR  (default max value is darkest/reddest.This reverses)'
      write(LER,*)' '
      write(LER,*)
     1'Usage: vaplot -N[ntap] -tmsc[tmscl] -trsc[trscl] -amp[fullsc] '
     2,'-tmin[start] -tmax[stop]  -sp[ispace] -td[itd] '
     3,'-rs[ir], -re[re] -S[shde] '
     4,'-R -T -G -W[width] '
     5,'-ns[ns] -ne[ne] -AR -AMX[atmax] -AMN[atmin] '
     6,'-AT[attribute file] '
      write(LER,*)
     1'***************************************************************'
      return
      end
      subroutine gcmdln(tmscl, trscl, fullsc, istrt, istop, atmax,
     1 atmin, ns,ne,rs,re, ispace, td, ntap, atap, shde, verbos,
     2 dwntop, atrrev, trce, atrlgn, width)
      real*4 tmscl, trscl, fullsc, atmax, atmin, width
      integer*4 ns, ne, rs, re, ispace, td, istrt, istop
      character ntap*(*), atap*(*)
      integer argis, shde
      logical verbos, dwntop, atrrev, trce, atrlgn
            call argstr('-N', ntap, ' ', ' ' )
            call argstr('-AT',atap, ' ', ' ' )
            call argr4 ('-tmsc', tmscl, 2.5, 2.5 )
            call argr4 ('-trsc', trscl, 12.0, 12.0 )
            call argr4 ('-amp' , fullsc, 1.33, 1.33 )
            call argr4 ('-W'   , width , 7.5 , 7.5  )
            call argi4 ('-tmin', istrt, 0, 0 )
            call argi4 ('-tmax', istop , 0 , 0)
            call argi4 ('-ns' , ns, 0, 0)
            call argi4 ('-ne' , ne, 0, 0)
            call argi4 ('-sp' ,ispace,99999,99999)
            call argi4 ('-td',td,5,5)
            call argi4 ('-rs',rs,1,1)
            call argi4 ('-re',re,0,0)
            call argi4 ('-S',shde,0,2)
            trce = ( argis ('-T') .gt. 0 )
            atrlgn = ( argis ('-G') .eq. 0 )
            verbos = ( argis ('-V') .gt. 0 )
            call argr4('-AMX', atmax,  99999.,  99999.)
            call argr4('-AMN', atmin, -99999., -99999.)
            atrrev = ( argis ('-AR') .gt. 0)
            dwntop = (argis ('-R') .gt. 0 )
      return
      end

      subroutine verbal(nsamp, nsi, ntrc, nrec, iform, ntap, atap,
     1 ns, ne, rs, re, ispace, td, istrt, istop, shde, verbos,
     2 dwntop, atrrev, atmax, atmin , tstart, xdis, fs, delta, 
     3 ydis, xscale, jstrt, jstop, npt, trce, atrlgn, width,
     4 luin, luat)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4 number of samples in trace
c     nsi   - I*4 sample interval in ms
c     ntrc  - I*4 traces per record
c     nrec  - I*4 number of records per line
c     iform - I*4 format of data
c     ntap  - C*255     input file name
c     atap  - C*255     attribute file name
c     ns    - I*4 starting trace
c     ne    - I*4 ending trace in each record
c     rs    - I*4 starting record
c     re    - I*4 ending record
c     ispace- I*4 put gap every ispace traces
c     td    - I*4 gap width in spaces
c     istrt - I*4 start time in ms
c     istop - I*4 end time in ms
c     shde  - I*4 pos/neg/no fill
c     verbos- L   verbose information
c     dwntop- L   trace is from down to top increasing time
c     atrrev- L   reverse meaning of shading attribute
c     atmax  - R*4 max shading for this value of attribute
c     atmin  - R*4 min shading for this value of attribute
c     tstart- R*4 start time in seconds
c     xdis  - R*4 trace separation in inches
c     fs    - R*4 full scale amplitude in inches
c     delta - R*4 time scale in sec/inch
c     ydis  - R*4 distance between time samples in inches
c     ydis  - R*4 length of time sample in inches
c     xscale- R*4 
c     jstrt - I*4 index of start point
c     jstop - I*4 index of end point
c     npt   - I*4 number of points to plot
c     trce  - L   force trace to trace scaling * fullsc
c     atrlgn- L   plot attribute legend
c     width - R*4 printer paper width
c     luin  - I*4 unit for input
c     luat  - I*4 unit for attribute
c-----
#include <f77/iounit.h>
      integer*4 nsamp, nsi, ntrc, nrec, iform
      integer*4 ns, ne, rs, re, ispace, td, istrt, istop
      integer*4 jstrt, jstop, npt, shde
      integer*4 lenstr

      real*4 atmax, atmin, width
      real*4 tstart, xdis, fs, delta, ydis, xscale

      character ntap*(*), atap*(*)

      logical verbos, dwntop, atrrev, trce, atrlgn

            ln = lenstr(ntap)
            la = lenstr(atap)
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace =  ', nsamp
            write(LERR,*) ' sample interval    =  ', nsi
            write(LERR,*) ' traces per record  =  ', ntrc
            write(LERR,*) ' records per line   =  ', nrec
            write(LERR,*) ' format of data     =  ', iform
            write(LERR,*) ' luin               =  ', luin
            write(LERR,*) ' input data set name =  ', ntap(1:ln)
            write(LERR,*) ' luat               =  ', luat
            write(LERR,*) ' attribute data set name=  ', atap(1:la)
            write(LERR,*) ' ns (starting trace)    =  ',ns
            write(LERR,*) ' ne (ending trace  )    =  ',ne
            write(LERR,*) ' rs (starting record)   =  ',rs
            write(LERR,*) ' re (ending record)     =  ',re
            write(LERR,*) ' ispace (gap every )    =  ',ispace
            write(LERR,*) ' td (gap width in traces=  ',td
            write(LERR,*) ' istrt (start time in ms=  ',istrt
            write(LERR,*) ' istop (stop  time in ms=  ',istop
            write(LERR,*) ' shading switch (0=+fill;1=-fill;else no fill
     1) = ',shde
            write(LERR,*) ' verbose output         =  ',verbos
            write(LERR,*) ' dwntop                 =  ',dwntop
            write(LERR,*) ' atrrev                 =  ',atrrev
            write(LERR,*) ' atmax - MAX attribute   =  ',atmax
            write(LERR,*) ' atmin - MIN attribute   =  ',atmin
            write(LERR,*) ' tstart (sec)           =  ',tstart
            write(LERR,*) ' xdis (inches)          =  ',xdis
            write(LERR,*) ' fs   (inches)          =  ',fs
            write(LERR,*) ' delta (sec/inch)       =  ',delta
            write(LERR,*) ' ydis  (inches)         =  ',ydis
            write(LERR,*) ' xscale                 =  ',xscale
            write(LERR,*) ' jstrt                  =  ',jstrt
            write(LERR,*) ' jstop                  =  ',jstop
            write(LERR,*) ' npt (points plotted )  =  ',npt
            write(LERR,*) ' trce (tr-tr scaling)   =  ',trce
            write(LERR,*) ' Plot attribute legend  =  ',atrlgn
            write(LERR,*) ' paper width inch       =  ',width
            write(LERR,*)' '
      return
      end

      function lenstr(str)
c-----
c     determine length of a string. Note f77 len gives declaration
c     we want length up to last non blank
c-----
      integer*4 lenstr
      character str*(*)
      l = len(str)
      do 100 i=l,1,-1
            lenstr = i
            if(str(i:i) .ne. ' ')return
  100 continue
      return
      end



