C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
       subroutine BuildIntervalVelocity(rt,rv,nsamp,nsi,nn,tri,sout)

c routine to interpolate an array tri(nsamp) from an array rv(nn)
c assuming a sample interval for tri() of nsi and times for rv()
c stored in rt()

       integer nn, nsamp, nsi

       real rt(*), rv(*), tri(*), getvel, Time, dt

       character sout*(*)

c check for microsecond output

       IF(sout.eq.'T')then
          if (nsi .le. 32) then
              dt = real (nsi)/1000.
          else
              dt = real (nsi)/1000000.
          endif
       ELSE
          dt = nsi
       ENDIF

c get a value for all tri(nsamp)
    
       DO i = 1,nsamp

c assign time starting with first sample = time zero to be compatible
c with ProMax, CogniSeis, MBS, ILIS and PPRED people
          
          Time  = dt * float(i-1)

          if( Time .le. rt(1) )then

c use rv(1) down to and including rt(1) [first velocity used from start
c of trace down to and including sample at first time in function

             getvel = rv(1)
             goto 1002
          elseif( Time .ge. rt(nn) )then

c use rv(nn) after and including rt(nn) [last velocity will be used to end
c of trace if not specified.

             getvel = rv(nn)
             goto 1002
          else

c use rv(j) down to and including rt(j) assigning the interval velocity
c in the function to the bottom of the interval.  So for a value [ti,vi]
c vi will be used from ti-1 down to and including ti.

             do j = 2 , nn
                if ( Time .ge. rt(j-1) .and. Time .le. rt(j) ) then
                   getvel = rv(j)
                   go to 1002
                endif
             enddo

          endif

 1002     continue

          tri(i) = getvel
       ENDDO

c done return to calling routine

       return
       end


