C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine FifthOrderPolyApprox ( rt, rv, nn, nsamp, nsi, tri, 
     :     sout )
#include <f77/lhdrsz.h>

c declare arguments passed from calling routine
 
      integer    nsamp, nsi, nn
      
      real       rt(*), rv(*), tri(*), dt

      character  sout*(*)

c declare variables used in subroutine

      real      SIG(SZLNHD), coefficients(SZLNHD), U(SZLNHD,6)
      real      V(10,10), W(10) ,B(SZLNHD), AFUNC(10), CHISQ
      real      time(SZLNHD)

c initialize memory

      call vclr ( SIG, 1, SZLNHD )
      call vclr ( coefficients, 1, SZLNHD )
      call vclr ( U, 1, SZLNHD*6 )
      call vclr ( V, 1, 100 )
      call vclr ( W, 1, 10 )
      call vclr ( B, 1, SZLNHD )
      call vclr ( AFUNC, 1, 10 )
      call vclr ( time, 1, SZLNHD )
      call vclr ( tri, 1, SZLNHD )

c build time/depth axis [should be done here because you never know
c                        in advance what the nsi will be]

      if ( sout .eq. 'T' ) then
         if ( nsi .le. 32 ) then
              dt = real (nsi)/1000.
          else
              dt = real (nsi)/1000000.
          endif
      else
         dt = nsi
      endif

      do i = 1, nsamp
         time(i) = float(i-1) * dt
      enddo
      
c perform 5th order polynomial approximation of rt and rv and load output to tri

      npol = 6
      call svdfit ( rt, rv, SIG, nn, coefficients, npol, U, V, W, nn, 
     :     npol, CHISQ, B, AFUNC )
      call polev ( time, nsamp, coefficients, npol, tri )

      return
      end

c The subroutines included in this subroutine are ported from the Ilis System.
c I got them from David Ford and Mike Kelly.  They got them from Angst which is
c I believe written by Richard Crider.

      SUBROUTINE SVDFIT(rt,rv,SIG,NDATA,A,MA,U,V,W,MP,NP,CHISQ,B,AFUNC)
      PARAMETER(TOL=1.E-6)
      DIMENSION rt(*),rv(*),SIG(*),A(*),V(NP,NP),
     *    U(MP,NP),W(NP),B(*),AFUNC(*)

c
c  In this application svdfit will return a fifth order
c  approximation to the input velocity function
c
C  rt() is time
c  rv() is velocity
c  ndata is #pts in rv()
c  sig() must be size of Ndata
c  A() is coefs
c  MA number of points in A()
c  U,V,W are work arrays sized as follows:
c
c  U(MP,NP)
c  V(NP,NP)
c  W(NP)
c
c  CHISQ is exactly what it sounds like
c  fpoly

      DO 12 I=1,NDATA
        CALL FPOLY(rt(I),AFUNC,MA)
        if(sig(i).eq.0.0)sig(i) = 1.
        TMP=1./SIG(I)
        DO 11 J=1,MA
          U(I,J)=AFUNC(J)*TMP
11      CONTINUE
        B(I)=rv(I)*TMP
12    CONTINUE
      CALL SVDCMP(U,NDATA,MA,MP,NP,W,V)
      WMAX=0.
      DO 13 J=1,MA
        IF(W(J).GT.WMAX)WMAX=W(J)
13    CONTINUE
      THRESH=TOL*WMAX
      DO 14 J=1,MA
        IF(W(J).LT.THRESH)W(J)=0.
14    CONTINUE
      CALL SVBKSB(U,W,V,NDATA,MA,MP,NP,B,A)
      CHISQ=0.
*     DO 16 I=1,NDATA
*       CALL FPOLY(rt(I),AFUNC,MA)
*       SUM=0.
*       DO 15 J=1,MA
*         SUM=SUM+A(J)*AFUNC(J)
*15      CONTINUE
*        CHISQ=CHISQ+((rv(I)-SUM)/SIG(I))**2
*16    CONTINUE
      RETURN
      END

      SUBROUTINE SVBKSB(U,W,V,M,N,MP,NP,B,A)
      PARAMETER (NMAX=100)
      DIMENSION U(MP,NP),W(NP),V(NP,NP),B(MP),A(NP),TMP(NMAX)
      DO 12 J=1,N
        S=0.
        IF(W(J).NE.0.)THEN
          DO 11 I=1,M
            S=S+U(I,J)*B(I)
11        CONTINUE
          S=S/W(J)
        ENDIF
        TMP(J)=S
12    CONTINUE
      DO 14 J=1,N
        S=0.
        DO 13 JJ=1,N
          S=S+V(J,JJ)*TMP(JJ)
13      CONTINUE
        A(J)=S
14    CONTINUE
      RETURN
      END
      SUBROUTINE SVDCMP(U,M,N,MP,NP,W,V)
      PARAMETER (NMAX=100)
      DIMENSION U(MP,NP),W(NP),V(NP,NP),RV1(NMAX)
      G=0.0
      SCALE=0.0
      ANORM=0.0
      DO 25 I=1,N
        L=I+1
        RV1(I)=SCALE*G
        G=0.0
        S=0.0
        SCALE=0.0
        IF (I.LE.M) THEN
          DO 11 K=I,M
            SCALE=SCALE+ABS(U(K,I))
11        CONTINUE
          IF (SCALE.NE.0.0) THEN
            DO 12 K=I,M
              U(K,I)=U(K,I)/SCALE
              S=S+U(K,I)*U(K,I)
12          CONTINUE
            F=U(I,I)
            G=-SIGN(SQRT(S),F)
            H=F*G-S
            U(I,I)=F-G
            IF (I.NE.N) THEN
              DO 15 J=L,N
                S=0.0
                DO 13 K=I,M
                  S=S+U(K,I)*U(K,J)
13              CONTINUE
                F=S/H
                DO 14 K=I,M
                  U(K,J)=U(K,J)+F*U(K,I)
14              CONTINUE
15            CONTINUE
            ENDIF
            DO 16 K= I,M
              U(K,I)=SCALE*U(K,I)
16          CONTINUE
          ENDIF
        ENDIF
        W(I)=SCALE *G
        G=0.0
        S=0.0
        SCALE=0.0
        IF ((I.LE.M).AND.(I.NE.N)) THEN
          DO 17 K=L,N
            SCALE=SCALE+ABS(U(I,K))
17        CONTINUE
          IF (SCALE.NE.0.0) THEN
            DO 18 K=L,N
              U(I,K)=U(I,K)/SCALE
              S=S+U(I,K)*U(I,K)
18          CONTINUE
            F=U(I,L)
            G=-SIGN(SQRT(S),F)
            H=F*G-S
            U(I,L)=F-G
            DO 19 K=L,N
              RV1(K)=U(I,K)/H
19          CONTINUE
            IF (I.NE.M) THEN
              DO 23 J=L,M
                S=0.0
                DO 21 K=L,N
                  S=S+U(J,K)*U(I,K)
21              CONTINUE
                DO 22 K=L,N
                  U(J,K)=U(J,K)+S*RV1(K)
22              CONTINUE
23            CONTINUE
            ENDIF
            DO 24 K=L,N
              U(I,K)=SCALE*U(I,K)
24          CONTINUE
          ENDIF
        ENDIF
        ANORM=MAX(ANORM,(ABS(W(I))+ABS(RV1(I))))
25    CONTINUE
      DO 32 I=N,1,-1
        IF (I.LT.N) THEN
          IF (G.NE.0.0) THEN
            DO 26 J=L,N
              V(J,I)=(U(I,J)/U(I,L))/G
26          CONTINUE
            DO 29 J=L,N
              S=0.0
              DO 27 K=L,N
                S=S+U(I,K)*V(K,J)
27            CONTINUE
              DO 28 K=L,N
                V(K,J)=V(K,J)+S*V(K,I)
28            CONTINUE
29          CONTINUE
          ENDIF
          DO 31 J=L,N
            V(I,J)=0.0
            V(J,I)=0.0
31        CONTINUE
        ENDIF
        V(I,I)=1.0
        G=RV1(I)
        L=I
32    CONTINUE
      DO 39 I=N,1,-1
        L=I+1
        G=W(I)
        IF (I.LT.N) THEN
          DO 33 J=L,N
            U(I,J)=0.0
33        CONTINUE
        ENDIF
        IF (G.NE.0.0) THEN
          G=1.0/G
          IF (I.NE.N) THEN
            DO 36 J=L,N
              S=0.0
              DO 34 K=L,M
                S=S+U(K,I)*U(K,J)
34            CONTINUE
              F=(S/U(I,I))*G
              DO 35 K=I,M
                U(K,J)=U(K,J)+F*U(K,I)
35            CONTINUE
36          CONTINUE
          ENDIF
          DO 37 J=I,M
            U(J,I)=U(J,I)*G
37        CONTINUE
        ELSE
          DO 38 J= I,M
            U(J,I)=0.0
38        CONTINUE
        ENDIF
        U(I,I)=U(I,I)+1.0
39    CONTINUE
      DO 49 K=N,1,-1
        DO 48 ITS=1,30
          DO 41 L=K,1,-1
            NM=L-1
            IF ((ABS(RV1(L))+ANORM).EQ.ANORM)  GO TO 2
            IF ((ABS(W(NM))+ANORM).EQ.ANORM)  GO TO 1
41        CONTINUE
1         C=0.0
          S=1.0
          DO 43 I=L,K
            F=S*RV1(I)
            IF ((ABS(F)+ANORM).NE.ANORM) THEN
              G=W(I)
              H=SQRT(F*F+G*G)
              W(I)=H
              H=1.0/H
              C= (G*H)
              S=-(F*H)
              DO 42 J=1,M
                Y=U(J,NM)
                Z=U(J,I)
                U(J,NM)=(Y*C)+(Z*S)
                U(J,I)=-(Y*S)+(Z*C)
42            CONTINUE
            ENDIF
43        CONTINUE
2         Z=W(K)
          IF (L.EQ.K) THEN
            IF (Z.LT.0.0) THEN
              W(K)=-Z
              DO 44 J=1,N
                V(J,K)=-V(J,K)
44            CONTINUE
            ENDIF
            GO TO 3
          ENDIF
          IF (ITS.EQ.30) PAUSE 'No convergence in 30 iterations'
          X=W(L)
          NM=K-1
          Y=W(NM)
          G=RV1(NM)
          H=RV1(K)
          F=((Y-Z)*(Y+Z)+(G-H)*(G+H))/(2.0*H*Y)
          G=SQRT(F*F+1.0)
          F=((X-Z)*(X+Z)+H*((Y/(F+SIGN(G,F)))-H))/X
          C=1.0
          S=1.0
          DO 47 J=L,NM
            I=J+1
            G=RV1(I)
            Y=W(I)
            H=S*G
            G=C*G
            Z=SQRT(F*F+H*H)
            RV1(J)=Z
            C=F/Z
            S=H/Z
            F= (X*C)+(G*S)
            G=-(X*S)+(G*C)
            H=Y*S
            Y=Y*C
            DO 45 NM=1,N
              X=V(NM,J)
              Z=V(NM,I)
              V(NM,J)= (X*C)+(Z*S)
              V(NM,I)=-(X*S)+(Z*C)
45          CONTINUE
            Z=SQRT(F*F+H*H)
            W(J)=Z
            IF (Z.NE.0.0) THEN
              Z=1.0/Z
              C=F*Z
              S=H*Z
            ENDIF
            F= (C*G)+(S*Y)
            X=-(S*G)+(C*Y)
            DO 46 NM=1,M
              Y=U(NM,J)
              Z=U(NM,I)
              U(NM,J)= (Y*C)+(Z*S)
              U(NM,I)=-(Y*S)+(Z*C)
46          CONTINUE
47        CONTINUE
          RV1(L)=0.0
          RV1(K)=F
          W(K)=X
48      CONTINUE
3       CONTINUE
49    CONTINUE
      RETURN
      END

      SUBROUTINE FPOLY(X,P,NP)
C     SUBROUTINE FOR FITTING A SET OF WITH A POLYNOMIAL OF ORDER NP-1
      DIMENSION P(NP)
      P(1)=1.
      DO 11 J=2,NP
       P(J)=P(J-1)*X
  11  CONTINUE

       RETURN
       END

      SUBROUTINE FLEG(X,Pl,Nl)

c     fitting routine for an expansion with nl Legendre polynomials pl.

      dimension pl(nl)

      pl(1)=1.
      pl(2)=x
      if(nl.gt.2)then
        twox=2.*x
        f2=x
        d=1.

        do 11 j=3,nl
          f1=d
          f2=f2+twox
          d=d+1.
          pl(j)=(f2*pl(j-1)-f1*pl(j-2))/d
 11     continue
      endif

      return
      end

      subroutine polev(x,nx, co,nco,y)
      real x(*), co(*), y(*)
 
      do 200 i=1,nx
        y(i)=0.
        do 100 j=1,nco
          k = j-1
          y(i)=y(i)+(x(i)+.000001)**k*co(j)
  100   continue
  200 continue
      return
      end
