C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine  XSDRead(luvel, Record, Trace, Sample, 
     :     PicksPerSample, nLivePicks, 
     :     nsi, 
     :     EndFunctionReadFlag)

c XSDRead reads one velocity function from an attached pick file

#include <f77/iounit.h>
#include <f77/lhdrsz.h>

c declare variables passed from calling routine

      integer    luvel, PicksPerSample, nLivePicks, nsi

      real       Record(*), Trace(*), Sample(*) 

      logical    EndFunctionReadFlag

c declare variables used in subroutine

      integer     counter

      real        RecordIndexBuffer(SZSMPM), TraceIndexBuffer(SZSMPM)
      real        SampleIndexBuffer(SZSMPM)

      character   junk*1

c initialize memory

      call vclr(RecordIndexBuffer,1,SZSMPM)
      call vclr(TraceIndexBuffer,1,SZSMPM)
      call vclr(SampleIndexBuffer,1,SZSMPM)

      counter = 0

c read down to next horizon

      read(luvel,100,end=1001) junk
 100  format(a1)

      if(junk .ne. 'S') then
         write(LERR,*)'VELIN: Traces out of sync with picks'
         write(LERR,*)'       Check that pick file was based on '
         write(LERR,*)'       this input seismic dataset'
         write(LERR,*)'FATAL'
         stop
      endif

c read velocity function picks

      do k = 1, PicksPerSample
         read(luvel,200,end=1001)  RecordIndexBuffer(k), 
     :        TraceIndexBuffer(k), SampleIndexBuffer(k)

 200     format( f12.6,1x,f12.6,1x,f12.6)
      enddo

c build first output (record, velocity, Sample) entry

      counter = 1
      Trace(counter) = TraceIndexBuffer(counter)
      Record(counter) = RecordIndexBuffer(counter)
      Sample(counter) = SampleIndexBuffer(counter)

c POLICEMAN: watch out for duplicate picks in the pickfile

      do j = 2, PicksPerSample

         if ( RecordIndexBuffer(j) .eq. Record(j-1)
     :        .and.
     :        TraceIndexBuffer(j) .eq. TraceIndexBuffer(j-1)
     :        .and. 
     :        SampleIndexBuffer(j) .eq. Sample(j-1) ) then

            write(LERR,*)' '
            write(LERR,*)'Duplicate entry occurred in Pickfile'
            write(LERR,*)'at record & trace entries: '
     :           ,RecordIndexBuffer(j), TraceIndexBuffer(j)
            write(LERR,*)'Will fix by deleting 2nd occurrence'
            write(LERR,*)' '
            
         else

            counter = counter + 1
            Record(counter) = RecordIndexBuffer(j)
            Trace(counter) = TraceIndexBuffer(j)
            Sample(counter) = SampleIndexBuffer(j) 
            
         endif
      enddo

      nLivePicks = counter
      return

1001  continue

      nLivePicks = counter
      return
      end
