C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine canmo(x,v,offset,ns,y,R,psx,ier)
************************************************************************
*                                                                      *
*    SUBROUTINE TO PERFORM HYPERBOLIC MOVEOUT CORRECTION.              *
*      INPUTS ARE:                                                     *
*           X = DATA TO BE CORRECTED                                   *
*           V = SQURARED VELOCITY ARRAY                                *
*          PT = ARRAY TO TP's                                          *
*      OFFSET = OFFSET FOR X                                           *
*          NS = NUMBER SAMPLES PER TRACE                               *
*          SR = SAMPLE INTERVAL IN SECONDS                             *
*           Y = CORRECTED DATA                                         *
*          V0 = VELOCITY OF RECORDING MEDIUM FORM IMAGE POINT COMPS    *
*                                                                      *
************************************************************************
#include <f77/sisdef.h>
#include <f77/lhdrsz.h>
      real X(*),Y(*),v(*),psx(*)
      real work(1),temp(1),nu,sx
      POINTER (pw,work),(adrtemp,temp)
      logical R

      iget = (ns+3) * ISZBYT
      ierr = 0
      ner = 0
      call galloc(pw,iget,ierr,0)
      ner = ner+ierr
      call galloc(adrtemp,iget,ierr,0)
      ner = ner + ierr
      if(ner.ne.0)then
       ier = 1
       return
      endif
      if(.not.R)then
       work(1)=0.
       call vmov(x,1,work(2),1,ns)
      else
       do i=1,ns
        work(i)=x(i)
       end do
      endif
      work(ns+2)=0
      work(ns+3)=0.
      if(.not.R)then
       do i=1,ns
        q = i
        sx=psx(i)
        if(sx.lt.0)sx=1.
        ts = q*(1.- 1./sx)
        t0 = q/sx
        nu = sqrt(sx)*v(i)
        nu = nu*nu
        g = t0*t0+ offset/nu
        g = sqrt(g)
        t = ts + g
        shft = t - q
        if(shft.le.ns-2)then
          if(shft.gt.0)then
            tj = q + shft
            it=int(tj)
            if(it.eq.0)it=1
             f=tj-aint(tj)
             fs=f*f
             c1 = fs-f
             c2 = 2.0 - 2.0*fs
             c3 = fs+f
             y(i)=0.5 *(
     :           work(it)*c1 +
     :           work(it+1)*c2 +
     :           work(it+2)*c3
     :                 )
          else
            y(i)=work(i)
          endif
        else
          y(i)=0
        endif
       end do
      else
       do i=1,ns
        y(i)=0. 
       end do
       do i=1,ns
        sx = psx(i)
        if(sx.lt.0)sx=1.
        q = i
        ts = q*(1.- 1./sx)
        t0 = q/sx
        nu = sqrt(sx)*v(i)
        nu = nu*nu
        g = t0*t0+ offset/nu
        g = sqrt(g)
        t = ts + g
        shft = t - q
        if(sx.lt.0)shft=0.
        tj = q+shft
        it = int(tj)
        if(it.ge.0)then
         if(it.eq.0)it=1
         f=tj-aint(tj)
         fs=f*f
         c1 = fs-f
         c2 = 2.0 - 2.0*fs
         c3 = fs+f
         if(i.gt.1)then
         y(it) = 0.5 *   (
     :          work(i-1)*c3 +
     :          work(i)*c2 +
     :          work(i+1)*c1
     :                   )
        else
         y(it)=0.5 * (work(i)*c2+work(i+1)*c1*2)
        endif
        endif
       end do
      endif
      call gfree(pw)
      call gfree(adrtemp)
      RETURN
      END
