C ******************************************************************** C
C *                                                                  * C
C *       *****************************************************      * C
C *       ****                                             ****      * C
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C *       ****                                             ****      * C
C *       *****************************************************      * C
C *                                                                  * C
C *       VNMO - VECTOR-BASED NORMAL MOVEOUT CORRECTION.             * C
C *                                                                  * C
C *            PROGRAM TO PERFORM HYPERBOLIC MOVEOUT CORRECTION      * C
C *            ON THE 3090 VF.  SAMPLE SIZE IS 1 INSTEAD OF 48       * C
C *            AS IN ANMO.                                           * C
C *            READ INPUT DATA SET (UP TO 60 FOLD). GET VELOCITY     * C
C *            FUNCTION FROM CARDS. GET FIRST AND LAST RECORD TO     * C
C *            PROCESS FROM CARDS.                                   * C
C *                                                                  * C
C *            WRITTEN 09/89 BY R. CRIDER                            * C
C *                                                                  * C
C *                                                                  * C
C ******************************************************************** C
c
#include <localsys.h>
#include <f77/sisdef.h>
#include <f77/lhdrsz.h>
#include <f77/pid.h>
#include <f77/iounit.h>
#include <save_defs.h>
C     +------------------------------+
C     | DECLARE VARIABLES AND ARRAYS |
C     +------------------------------+
C
      INTEGER itr(10000),vbuf(10000),thd(1),error
      integer argis, rs,re,pipe
C
      REAL V(1),data(1),ritr(10000),vdata(SZLNHD)
      REAL WORK(1) ,dx(1),tarr(1),mu2(1),mu4(1),mu6(1),mu4sq(1),mu26(1)
      real mu25(1),sx(1),s(1),narr(1)
C
      CHARACTER NAME*4,TITLE(17)*4
      character ntap*256, otap*256, vtap*256
C
      LOGICAL OPEN, reverse,veltap
      logical query,dead(1)
C
      POINTER (pdata,data),(pwork,work),(pdx,dx),(ptarr,tarr),(psx,sx)
      POINTER (pthd,thd),(pv,v),(pmu2,mu2),(pmu4,mu4),(pmu6,mu6)
      POINTER (pmu4sq,mu4sq),(pmu26,mu26),(pmu25,mu25)
      POINTER (pdead,dead),(ps,s),(pnarr,narr)
C
      equivalence (itr(1),ritr(1))

      DATA NAME/'VNMO'/,ERROR/0/,pipe/3/
      DATA  TITLE /5*'    ','NORM','AL M','OVEO','UT C',
     &'ORRE','CTIO','N   ', 5*'    '/
      DATA IRIT/0/
C     +----------------------+
C     | INITIALIZE VARIABLES |
C     +----------------------+
      ithw=ITHWP1-1
      ntap = ' '
      otap = ' '
      vtap = ' '
      query = ((argis('-?').gt.0).or.(argis('-h').gt.0))
      if(query)then
        call help(LER)
        stop
      endif
#include <f77/open.h>
      v0 = 0
      call gcmdln(ntap,otap,vtap,rs, re, reverse)
      call gamoco(title,1,LERR)
C     +------------+
C     | OPEN TAPES |
C     +------------+
      call getln(luin,ntap,'r',0)
      call getln(luout,otap,'w',1)
      if (vtap .ne. ' ') then
          call getln(luv, vtap, 'r',-1)
      else
          write(LERR,*)'vnmo assumed to be running inside IKP'
          call sisfdfit (luv, pipe)
      endif
      if(luv.lt.0)then
       write(lerr,*)'vtap not accessible! Fatal!'
       call lbclos(luin)
       call lbclos(luout)
       stop
      endif

C     +------------------------+
C     | READ INPUT LINE HEADER |
C     +------------------------+
      nbyt = 0
      call rtape(luin,itr,nbyt)
      if (nbyt .eq.0)then
       write(LER,*)'EOF found trying to read line header. Fatal!'
       call lbclos(luin)
       stop
      endif
      n4 = 4
      call hlhprt(itr,nbyt,name,n4,LERR)
      call savelu('NumSmp',ifmt_NumSmp,l_NumSmp,ln_NumSmp,LINEHEADER)
      call savelu('SmpInt',ifmt_SmpInt,l_SmpInt,ln_SmpInt,LINEHEADER)
      call savelu('NumTrc',ifmt_NumTrc,l_NumTrc,ln_NumTrc,LINEHEADER)
      call savelu('NumRec',ifmt_NumRec,l_NumRec,ln_NumRec,LINEHEADER)
      call savelu('Format',ifmt_Format,l_Format,ln_Format,LINEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)

      call saver2(itr,ifmt_NumSmp,l_NumSmp,ln_NumSmp,nsamp,LINEHEADER)
      call saver2(itr,ifmt_SmpInt,l_SmpInt,ln_SmpInt,nsr,LINEHEADER)
      call saver2(itr,ifmt_NumTrc,l_NumTrc,ln_NumTrc,ntpr,LINEHEADER)
      call saver2(itr,ifmt_NumRec,l_NumRec,ln_NumRec,nrec,LINEHEADER)
      call saver(itr, 'UnitSc', unitsc, LINEHEADER)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINEHEADER)
      endif
      sr=nsr
      fsr = float(nsr)
c     if(nsr.le.16)then
       sr=sr * unitsc
c     else
c      sr=sr/1000000.
c     endif
C +==================+
C | Allocate storage |
C +==================+
      ier = 0
      iabort = 0
      ner = 0
      iget = nsamp*ISZBYT
      call galloc(pwork,iget,ier,iabort)
      ner = ner+ier
      call galloc(pv   ,iget,ier,iabort)
      ner = ner+ier
      call galloc(pmu2 ,iget,ier,iabort)
      ner = ner+ier
      call galloc(pmu4 ,iget,ier,iabort)
      ner = ner+ier
      call galloc(pmu6 ,iget,ier,iabort)
      ner = ner+ier
      call galloc(pmu4sq ,iget,ier,iabort)
      ner = ner+ier
      call galloc(pmu26,iget,ier,iabort)
      ner = ner+ier
      call galloc(pmu25,iget,ier,iabort)
      ner = ner+ier
      call galloc(ptarr,iget,ier,iabort)
      ner = ner+ier
      call galloc(pnarr,iget,ier,iabort)
      ner = ner+ier
      call galloc(psx  ,iget,ier,iabort)
      ner = ner+ier
      call galloc(ps   ,iget,ier,iabort)
      ner = ner+ier

      iget = nsamp*ntpr*ISZBYT
      call galloc(pdata,iget,ier,iabort)
      ner = ner+ier
    
      iget = ntpr*ISZBYT
      call galloc(pdx  ,iget,ier,iabort)
      ner = ner+ier
      call galloc(pdead,iget,ier,iabort)
      ner = ner+ier

      iget = ITRWRD*ntpr*ISZBYT
      call galloc(pthd ,iget,ier,iabort)
      ner = ner+ier

      if(ner.gt.0)then
        write(LERR,*)' Unable to allocate memory. FATAL.'
        call lbclos(luin)
        stop
      endif
 
      do i=1,nsamp
       tarr(i)=(i-1)*sr
       narr(i)= i
      end do
C     +---------------------------------------------+
C     | READ THE INPUT DATA CARD, CHECK HEADER INFO |
C     +---------------------------------------------+
      IF(re.EQ.0)re=32767
      IF(rs.EQ.0)rs=1
      iobyt = nsamp * ISZBYT + SZTRHD
C     +--------------------------+
C     | WRITE OUTPUT LINE HEADER |
C     +--------------------------+
      if(re.gt.0.and.re.lt.32767)then
        nreco = re-rs+1
        call savew2(itr,ifmt_NumRec,l_NumRec,ln_NumRec,nreco,
     :       LINEHEADER)
      endif
      lby = nbyt
      call savhlh(itr,lby,nbyt)
      call wrtape (luout,itr,nbyt)
      mbyt = 0
      call rtape(luv,vbuf,mbyt)
      if(mbyt.eq.0)then
       write(IPR,*)' No lineheader on vtap ',vtap(1:50)
       call lbclos(luin)
       call lbclos(luout)
       call lbclos(luv)
       stop
      endif
      call saver2(vbuf,ifmt_NumTrc,l_NumTrc,ln_NumTrc,ntprv,
     :    LINEHEADER)
      call saver2(vbuf,ifmt_NumRec,l_NumRec,ln_NumRec,nrecv,
     :   LINEHEADER)
      call saver2(vbuf,ifmt_NumSmp,l_NumSmp,ln_NumSmp,nsv,
     :    LINEHEADER)
      call saver2(vbuf,ifmt_SmpInt,l_SmpInt,ln_SmpInt,nsrv,
     :    LINEHEADER)
      srv = nsrv
c     if(srv.le.16)then
        srv = srv * unitsc
c     else
c       srv = srv/1000000.
c     endif
      if(nsv.ne.nsamp.or.nrecv.ne.nrec.or.srv.ne.sr)then
       write(LERR,*)' Input and vtap are not compatible. FATAL.'
       write(LER ,*)' Input and vtap are not compatible. FATAL.'
       call lbclos(luin)
       call lbclos(luout)
       call lbclos(luv)
       stop
      endif
C     +-------------------------+
C     | GO FIND DATA TO PROCESS |
C     +-------------------------+
      if(rs.gt.1)then
       do i=1,rs-1
        do j=1,ntpr
         nit=0
         call rtape(luin,itr,nit)
         if(nit.eq.0)then
          write(LERR,*)'EOF found on ntap looking for record ',rs
          write(LER ,*)'EOF found on ntap looking for record ',rs
          call lbclos(luin)
          call lbclos(luout)
          call lbclos(luv)
          stop
         endif
        end do
        nit = 0
        call rtape(luv,vbuf,nit)
        if(nit.eq.0)then
         write(LERR,*)'EOF found on vtap looking for record ',rs
         write(LER ,*)'EOF found on vtap looking for record ',rs
         call lbclos(luin)
         call lbclos(luout)
         call lbclos(luv)
         stop
        endif
       end do
      endif
      Do while(rs.le.re)
      do i=1,ntpr
        nit=0
        call rtape(luin,itr,nit)
        if(nit.eq.0)then
         call lbclos(luin)
         call lbclos(luout)
         call lbclos(luv)
         stop
        endif
        mdx = (i-1)*ITRWRD
        do j=1,ITRWRD
         thd(mdx+j)=itr(j)
        end do
        call saver2(itr,ifmt_StaCor,l_StaCor,ln_StaCor,istat,
     :    TRACEHEADER)
        call saver2(itr,ifmt_DstSgn,l_DstSgn,ln_DstSgn,idist,
     :    TRACEHEADER)
        dx(i)=idist
        ndx = (i-1)*nsamp
        if(istat.lt.30000)then
         dead(i)=.false.
         do j=1,nsamp
          data(ndx+j)=ritr(ithw+j)
         end do
        else
         dead(i)=.true.
         do j=1,nsamp
          data(ndx+j)=0.
         end do
        endif
      end do
C     +--------------------------+
C     | GO DO MOVEOUT CORRECTION |
C     +--------------------------+
      mbyt = 0
      call rtape(luv,vbuf,mbyt)
      if(mbyt.eq.0)then
       write(LERR,*)'EOF on vtap. FATAL!'
       write(LER ,*)'EOF on vtap. FATAL!'
       call lbclos(luin)
       call lbclos(luout)
       call lbclos(luv)
       stop
      endif
c +======================================+
c | convert rms to interval then convert |
c | x/t to x/sample                      |
c +======================================+
      call vmov(vbuf(ITHWP1),1,vdata,1,nsamp)
      call rmsint(vdata,tarr,nsamp,v)
      do i=1,nsamp
       v(i)=v(i)*sr
       vdata(i)=vdata(i)*sr
      end do
c +=======================================+
c | create the (interval) velocity norms  |
c | for the function                      |
c +=======================================+
      mu2(1)=v(1)*v(1)
      mu4(1)=mu2(1)*mu2(1)
      mu6(1)=mu4(1)*mu2(1)
      do i=2,nsamp
       a =  v(i)
       a2 = a*a
       a4 = a2*a2
       a6 = a2*a4
       mu2(i)=mu2(i-1)+a2
       mu4(i)=mu4(i-1)+a4
       mu6(i)=mu6(i-1)+a6
      end do
      do i=1,nsamp
       mu2(i)=mu2(i)/narr(i)
       mu4(i)=mu4(i)/narr(i)
       mu6(i)=mu6(i)/narr(i)
       mu26(i)=mu2(i)*mu6(i)
       mu4sq(i)=mu4(i)*mu4(i)
       g = mu2(i)
       g2 = g*g
       g4 = g2*g2
       mu25(i)= g*g4
       s(i)=mu4(i)/g2
      end do
      do i=1,ntpr
       offset = dx(i)
       offset = offset*offset
       ndx = (i-1)*nsamp+1
       do j=1,nsamp
        x = j
        r = j
        x = x*x
        a1 = (mu26(j)-2.*mu4sq(j))/(2.*mu25(j)*x)
        a2 = -0.5*(s(j)/(x*mu2(j)))
        sx(j)=(s(j)+a1*offset)/(1.+a2*offset)
       end do
       if(.not.dead(i))then
        call canmo(data(ndx),vdata,offset,nsamp,work,reverse,
     :    sx,ier)
        if(ier.ne.0)then
         write(LER,*)'Unable to allocate work space. Fatal!'
         call lbclos(luin)
         call lbclos(luout)
         if(veltap)call lbclos(luv)
         stop
        endif
       else
        do ii=1,nsamp
         work(ii)=0.
        end do
       endif
C     +----------------------------+
C     | WRITE TRACE TO OUTPUT TAPE |
C     +----------------------------+
       call vmov(work,1,itr(ITHWP1),1,nsamp)
       mdx = (i-1)*ITRWRD + 1
       call vmov(thd(mdx),1,itr,1,ITRWRD)
       call wrtape(luout,itr,IOBYT)
      end do
      rs = rs +1
      End do
      call lbclos(luin)
      call lbclos(luout)
      call lbclos(luv)
      stop
      END

      subroutine gcmdln ( ntap, otap,  vtap,ifr, ilr, invers)
c                                                               
      character ntap*(*), otap*(*), vtap*(*)
      logical   invers
      integer argis
C                                                         
      invers = .false.                                   
C                                                       
      invers = (argis('-R').gt.0)
      if(invers)then
        write(LERR,*)' Inverse nmo requested'
      endif
	  ntap = ' '
      call argstr ('-N',ntap,' ',' ')          
      vtap = ' '
      call argstr('-v',vtap,' ',' ')
	  otap = ' '
      call argstr ('-O',otap,' ',' ')            
      call argi4('-rs',ifr,0,0)
      call argi4('-re',ilr,0,0)
      if(vtap.eq.' ')then
        write(LER,*)' Must have velocity file. FATAL! '
        stop
      endif
      return                                                  
      end

      subroutine help(LER)
          write(LER,*)  
     :'***************************************************************'
         write(LER,*)'PROGRAM VNMO...........Normal Moveout Correction'
         write(LER,*)' '                                             
         write(LER,*)                                               
     :' -N [ntap]      (may be pipe)     : Input data file name'   
         write(LER,*)                                             
     :' -O [otap]      (may be pipe)     : Output data file name'
         write(LER,*)                                             
     :' -v [vtap]      (required)        : Velocity data set name'
         write(LER,*)                                           
     :' -rs [rs]       (default = first) : First record to process'
         write(LER,*)                                           
     :' -re [re]       (default = last)  : Last record to process'
         write(LER,*)                                           
     :' -R [mode]      (default=no)      : If present, apply inverse'
         write(LER,*)                                        
     :'                                    NMO correction.'  
       write(LER,*)                                        
     :'Usage:  ',                                         
     :' vnmo -N[ntap] -O[otap] -v[vtap] -rs[First record],'
     :,' -re[Last record] -R '
       write(LER,*)                                     
     :'***************************************************************'
      return                                                          
      end                                                            
cmam  subroutine vmov(x,ix,y,iy,n)
cmam  real x(*),y(*)
cmam  do i=1,n
cmam   y(i)=x(i)
cmam  end do
cmam  return
cmam  end
