C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
       subroutine BuildOtherVelocity ( rt, rv, nsamp, nsi, N, itr, sout,
     :     UnitSc )
 
#include <f77/lhdrsz.h>
 
c subroutine to build a velocity trace v(nsamp) from an input
c velocity function rv(N) with input times at rt(N).  The
c type of velocity is either RMS or AVERAGE.  INTERVAL velocity
c is handled by BuildIntervalVelocity().  The first velocity is
c used from time zero to rt(1), the last velocity is used from
c time rt(N) to the end of trace.  Linear interpolation is done
c in between.
 
 
       integer N, nsamp, itr(SZLNHD), nsi
 
       real rt(N), rv(N), v(SZLNHD), getvel, Time, dt, fac, UnitSc
 
       character sout*1
 
c initialize variables
 
       call vclr(v,1,SZLNHD)
 
c handle microsecond output
 
       if( sout .eq. 'T' ) then

          dt = float(nsi) * UnitSc

       else
          dt = nsi
       endif
 
       DO i = 1,nsamp
 
c assign time from 1st sample at Time = zero to be compatible with
c ProMax, CogniSeis, Ilis, MBS, PPRED etc.
 
          Time  = dt * float(i-1)
 
          if ( (Time - rt(1)) .le. 1.e-4 ) then
 
c first velocity will be used from time zero down to and including
c first function time
 
             getvel = rv(1)
          elseif ( (Time - rt(N)) .ge. 1.e-4 ) then
 
c last velocity will be used from last function time to end of trace
c if not specified
 
             getvel = rv(N)
          else
 
c do linear interpolation of velocity such that a given velocity will
c only appear at the time specified in the function.
 
             do j=2,N
 
                if( ( Time - rt(j-1)) .ge. 1.e-4
     :               .and. (Time - rt(j)) .le. 1.e-4 ) then
                   fac = (Time - rt(j-1)) / (rt(j) - rt(j-1))
                   getvel = rv(j-1) + fac * (rv(j) - rv(j-1))
                   go to 1002
                endif
 
             enddo
 
          endif
 
 1002     continue
 
          v(i) = getvel
       ENDDO
 
c make sure that the Unit[] back in the main increments in the sample
c interval of the output trace so that resampling doesn't get flagged
c when it is not required.  It doesn't matter that i = 1,2 as only
c the first two entries are checked in the resample logic.  Also the
c Unit[] array is NOT used for anything from here to trace output.  
c It is about to be wiped and reloaded on the next function read. 

       do i = 1,2
          rt(i) = dt * float ( i - 1 )
       enddo

       call vmov ( v, 1, itr(ITHWP1), 1, nsamp )
       return
       end
