C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine ConversionCheck( FormatIn, FormatOut )

c as vomit conversion grows it will be impossible to keep universal
c conversion going.  Not all formats are compatable with each other
c since some cater to 3D while others are strictly 2D.  As user
c requests come in, functionality will be added.  It is impractical
c to keep every request universally convertable.  I have not got the
c time, and the USP group does not have the manpower.  This routine
c will enable us to add specific functionality without causing grief
c for unsuspecting users who anticipate all I/O formats are compatable.

#include <f77/iounit.h>

      character FormatIn*20, FormatOut*20

      if ( FormatIn .eq. 'hgs' ) then

c this format added for Chris Asimakopoulos [Houston] to read ___
c format vel,time pairs and convert to USP format

	 if (FormatOut .eq. 'usp' ) then
		return
	 else
 
            write(LERR,*)' '
            write(LERR,*)'VOMIT: invalid output format specified.'
            write(LERR,*)' hgs input only allows usp output.'
            write(LERR,*)' Check spelling, etc., for -fo argument.'
            write(LERR,*)'FATAL'
            write(LER ,*)' '
            write(LER ,*)'VOMIT: invalid output format specified.'
            write(LER ,*)' hgs input only allows usp output.'
            write(LER ,*)' Check spelling, etc., for -fo argument.'
            write(LER,*)'FATAL'
            stop
         endif

      endif

      if ( FormatIn .eq. 'charisma' ) then

c this format added for Per G. Folstad [Norway] to read Charisma workstation
c format t/depth  pairs, and build an interval  velocity cube

	 if (FormatOut .eq. 'usp' ) then
		return
	 else
            write(LERR,*)'VOMIT: Requested format conversion not'
            write(LERR,*)'       currently available.  When using'
            write(LERR,*)'       charisma input format conversion'
            write(LERR,*)'       to: '
            write(LERR,*)'            usp'
            write(LERR,*)'       output format only is allowed'
            write(LERR,*)'FATAL'
            write(LER,*)'VOMIT: Requested format conversion not'
            write(LER,*)'       currently available.  When using'
            write(LER,*)'       charisma input format  conversion'
            write(LER,*)'       to: '
            write(LER,*)'            usp'
            write(LER,*)'       output format only is allowed'
            write(LER,*)'FATAL'
            stop
	 endif
      endif

      if ( Formatin .eq. 'western3d' ) then

c This format added for Jan Kommedal [STAT] read Western Geophysical
c 3D velocity format.

         if ( FormatOut .eq. 'usp' .or. FormatOut .eq. 'western3d') then
            return
         else
            write(LERR,*)'VOMIT: Requested format conversion not'
            write(LERR,*)'       currently available.  When using'
            write(LERR,*)'       western3d input format conversion'
            write(LERR,*)'       to: '
            write(LERR,*)'            usp'
            write(LERR,*)'       output format only is allowed'
            write(LERR,*)'FATAL'
            write(LER,*)'VOMIT: Requested format conversion not'
            write(LER,*)'       currently available.  When using'
            write(LER,*)'       western3d input format  conversion'
            write(LER,*)'       to: '
            write(LER,*)'            usp'
            write(LER,*)'       output format only is allowed'
            write(LER,*)'FATAL'
            stop
         endif
      endif

      if ( FormatOut .eq. 'western3d' .and. 
     :     (FormatIn .ne. 'western3d' .and. FormatIn .ne. 'usp' ) ) then
         write(LERR,*)'VOMIT: Requested format conversion not'
         write(LERR,*)'       currently available.  Western3d output'
         write(LERR,*)'       only allowed from either western3d or'
         write(LERR,*)'       usp input format'
         write(LERR,*)'FATAL'
         write(LER,*)' '
         write(LER,*)'VOMIT: Requested format conversion not'
         write(LER,*)'       currently available.  Western3d output'
         write(LER,*)'       only allowed from either western3d or'
         write(LER,*)'       usp input format'
         write(LER,*)'FATAL'
         stop
      endif

      if ( Formatin .eq. 'western3d1' ) then

c This format added for Jim Mika [UTG] to read another Western Geophysical
c 3D velocity format.

         if ( FormatOut .eq. 'usp' .or.
     :        FormatOut .eq. 'tdq' .or.
     :        FormatOut .eq. 'tdq2' .or.
     :        FormatOut .eq. 'zmap' ) then
            return
         else
            write(LERR,*)'VOMIT: Requested format conversion not'
            write(LERR,*)'       currently available.  When using'
            write(LERR,*)'       western3d1 input format conversion'
            write(LERR,*)'       to: '
            write(LERR,*)'            usp, tdq, tdq2 and zmap '
            write(LERR,*)'       output formats only are allowed'
            write(LERR,*)'FATAL'
            write(LER,*)'VOMIT: Requested format conversion not'
            write(LER,*)'       currently available.  When using'
            write(LER,*)'       western3d1 input format  conversion'
            write(LER,*)'       to: '
            write(LER,*)'            usp, tdq, tdq2 and zmap'
            write(LER,*)'       output formats only are allowed'
            write(LER,*)'FATAL'
            stop
         endif
      endif

      if ( Formatin .eq. 'ev3d' ) then

c This format added for Ron Day and Jim Mika [GUPCO] to read ascii
c grids of 3d velocity data exported from EarthVision 2 software
c right now they only want to build usp velocity datasets for use
c in post-stack migration.  If they ever want more I will add the
c capability then....Garossino

         if ( FormatOut .eq. 'usp' ) then
            return
         else
            write(LERR,*)'VOMIT: Requested format conversion not'
            write(LERR,*)'       currently available.  When using'
            write(LERR,*)'       ev3d input format conversion'
            write(LERR,*)'       to: '
            write(LERR,*)'            usp'
            write(LERR,*)'       output format only is allowed'
            write(LERR,*)'FATAL'
            write(LER,*)'VOMIT: Requested format conversion not'
            write(LER,*)'       currently available.  When using'
            write(LER,*)'       ev3d input format  conversion'
            write(LER,*)'       to: '
            write(LER,*)'            usp'
            write(LER,*)'       output format only are allowed'
            write(LER,*)'FATAL'
            stop
         endif
      endif

      if ( FormatOut .eq. 'ev3d' ) then
         write(LERR,*)'VOMIT: Requested format conversion not'
         write(LERR,*)'       currently available.  The only ev3d'
         write(LERR,*)'       option is input for conversion to '
         write(LERR,*)'       usp format output'
         write(LERR,*)'FATAL'
         write(LER,*)'VOMIT: Requested format conversion not'
         write(LER,*)'       currently available.  The only ev3d'
         write(LER,*)'       option is input for conversion to '
         write(LER,*)'       usp format output'
         write(LER,*)'FATAL'
         stop
      endif

      if ( Formatin .eq. 'fairfield' ) then

c This format added for Chris Asimakopoulos [West Shelf BU]
c to read fairfield 3D ascii velocity format 

         if ( FormatOut .eq. 'usp' ) then
            return
        else
            write(LERR,*)'VOMIT: Requested format conversion not'
            write(LERR,*)'       currently available.  When using'
            write(LERR,*)'       fairfield input format conversions'
            write(LERR,*)'       to: '
            write(LERR,*)'            usp'
            write(LERR,*)'       output format only is allowed'
            write(LERR,*)'FATAL'
            write(LER,*)'VOMIT: Requested format conversion not'
            write(LER,*)'       currently available.  When using'
            write(LER,*)'       fairfield input format  conversions'
            write(LER,*)'       to: '
            write(LER,*)'            usp'
            write(LER,*)'       output format only is allowed'
            write(LER,*)'FATAL'
            stop
         endif
      endif

      if ( Formatin .eq. 'flat3d1' ) then

c This format added for Steve Wigger [GUPCO] 

         if ( FormatOut .eq. 'vds3d' .or. 
     :        FormatOut .eq. 'usp' .or.
     :        FormatOut .eq. 'flat3d1' .or.
     :        FormatOut .eq. 'flat3d' ) then
            return
        else
            write(LERR,*)'VOMIT: Requested format conversion not'
            write(LERR,*)'       currently available.  When using'
            write(LERR,*)'       flat3d1 input format conversions'
            write(LERR,*)'       to: '
            write(LERR,*)'            usp, vds3d, and flat3d'
            write(LERR,*)'       output formats only are allowed'
            write(LERR,*)'FATAL'
            write(LER,*)'VOMIT: Requested format conversion not'
            write(LER,*)'       currently available.  When using'
            write(LER,*)'       flat3d1 input format  conversions'
            write(LER,*)'       to: '
            write(LER,*)'            usp, vds3d, and flat3d'
            write(LER,*)'       output formats only are allowed'
            write(LER,*)'FATAL'
            stop
         endif
      endif

      if ( Formatout .eq. 'flat3d1' ) then

c This format added for Steve Wigger [GUPCO] 

         if ( FormatIn .eq. 'vds3d' .or.
     :        FormatIn .eq. 'flat3d1' .or.
     :        FormatIn .eq. 'usp' .or.
     :        FormatIn .eq. 'flat3d'  ) then
            return
         else
            write(LERR,*)'VOMIT: Requested format conversion not'
            write(LERR,*)'       currently available.  When using'
            write(LERR,*)'       flat3d1 output format  conversions'
            write(LERR,*)'       from : '
            write(LERR,*)'            usp, vds3d, and flat3d'
            write(LERR,*)'       output formats only are allowed'
            write(LERR,*)'FATAL'
            write(LER,*)'VOMIT: Requested format conversion not'
            write(LER,*)'       currently available.  When using'
            write(LER,*)'       flat3d1 output format  conversions'
            write(LER,*)'       from: '
            write(LER,*)'            usp, vds3d, and flat3d'
            write(LER,*)'       output formats only are allowed'
            write(LER,*)'FATAL'
            stop
         endif
      endif

      if ( FormatIn .eq. 'vds3d' ) then

c This format added for Kurt Tollestrup [OBU] to do VDS interaction.  

         if ( FormatOut .eq. 'vds3d' .or. 
     :        FormatOut .eq. 'usp' .or.
     :        FormatOut .eq. 'ukooa' .or.
     :        FormatOut .eq. 'ukooa1' .or.
     :        FormatOut .eq. 'agip' .or.
     :        FormatOut .eq. 'flat3d' ) then
            return
        else
            write(LERR,*)'VOMIT: Requested format conversion not'
            write(LERR,*)'       currently available.  When using'
            write(LERR,*)'       vds3d input format  conversions'
            write(LERR,*)'       to: '
            write(LERR,*)'            usp, vds3d, ukooa, ukooa1,flat3d'
            write(LERR,*)'       output formats only are allowed'
            write(LERR,*)'FATAL'
            write(LER,*)'VOMIT: Requested format conversion not'
            write(LER,*)'       currently available.  When using'
            write(LER,*)'       vds3d input format  conversions'
            write(LER,*)'       to: '
            write(LER,*)'            usp, vds3d, ukooa, ukooa1, flat3d'
            write(LER,*)'       output formats only are allowed'
            write(LER,*)'FATAL'
            stop
         endif
      endif

      if ( FormatOut .eq. 'vds3d' ) then

c This format added for Kurt Tollestrup [OBU] to do VDS interaction.  

         if ( FormatIn .eq. 'vds3d' .or.
     :        FormatIn .eq. 'usp' .or.
     :        FormatIn .eq. 'ukooa' .or.
     :        FormatIn .eq. 'ukooa1' .or.
     :        FormatIn .eq. 'agip' .or.
     :        FormatIn .eq. 'flat3d'  ) then
            return
         else
            write(LERR,*)'VOMIT: Requested format conversion not'
            write(LERR,*)'       currently available.  When using'
            write(LERR,*)'       vds3d output format  conversions'
            write(LERR,*)'       from : '
            write(LERR,*)'            usp, vds3d, ukooa, ukooa1, flat3d'
            write(LERR,*)'       output formats only are allowed'
            write(LERR,*)'FATAL'
            write(LER,*)'VOMIT: Requested format conversion not'
            write(LER,*)'       currently available.  When using'
            write(LER,*)'       vds3d output format  conversions'
            write(LER,*)'       from: '
            write(LER,*)'            usp, vds3d, ukooa, ukooa1, flat3d'
            write(LER,*)'       output formats only are allowed'
            write(LER,*)'FATAL'
            stop
         endif
      endif

      if ( FormatIn .eq. 'vip' ) then

c This format added for Don Wagner to allow direct input of the VIP
c routine output functions.  

         if ( FormatOut .eq. 'vds3d' .or. 
     :        FormatOut .eq. 'usp' .or.
     :        FormatOut .eq. 'ukooa' .or.
     :        FormatOut .eq. 'ukooa1' .or.
     :        FormatOut .eq. 'agip' .or.
     :        FormatOut .eq. 'flat3d' ) then
            return
        else
            write(LERR,*)'VOMIT: Requested format conversion not'
            write(LERR,*)'       currently available.  When using'
            write(LERR,*)'       vip input format  conversions'
            write(LERR,*)'       to: '
            write(LERR,*)'            usp, vds3d, ukooa, ukooa1,flat3d'
            write(LERR,*)'       output formats only are allowed'
            write(LERR,*)'FATAL'
            write(LER,*)'VOMIT: Requested format conversion not'
            write(LER,*)'       currently available.  When using'
            write(LER,*)'       vip input format  conversions'
            write(LER,*)'       to: '
            write(LER,*)'            usp, vds3d, ukooa, ukooa1, flat3d'
            write(LER,*)'       output formats only are allowed'
            write(LER,*)'FATAL'
            stop
         endif
      endif

      if ( FormatOut .eq. 'vip' ) then

            write(LERR,*)'VOMIT: Requested format conversion not'
            write(LERR,*)'       currently available.  '
            write(LERR,*)'FATAL'
            write(LER,*)'VOMIT: Requested format conversion not'
            write(LER,*)'       currently available.  '
            write(LER,*)'FATAL'
            stop
      endif

      if ( FormatIn .eq. 'flat3d' ) then

c This format added for Kurt Tollestrup [OBU] to do general 3D velocity manipulation  

         if ( FormatOut .eq. 'vds3d' .or. 
     :        FormatOut .eq. 'usp' .or.
     :        FormatOut .eq. 'flat3d' ) then
            return
        else
            write(LERR,*)'VOMIT: Requested format conversion not'
            write(LERR,*)'       currently available.  When using'
            write(LERR,*)'       flat3d input format  conversions'
            write(LERR,*)'       to: '
            write(LERR,*)'            usp, vds3d, and flat3d'
            write(LERR,*)'       output formats only are allowed'
            write(LERR,*)'FATAL'
            write(LER,*)'VOMIT: Requested format conversion not'
            write(LER,*)'       currently available.  When using'
            write(LER,*)'       flat3d input format  conversions'
            write(LER,*)'       to: '
            write(LER,*)'            usp, vds3d, and flat3d'
            write(LER,*)'       output formats only are allowed'
            write(LER,*)'FATAL'
            stop
         endif
      endif

      if ( FormatOut .eq. 'flat3d' ) then

c This format added for Kurt Tollestrup [OBU] to do VDS interaction.  

         if ( FormatIn .eq. 'vds3d' .or.
     :        FormatIn .eq. 'usp' .or.
     :        FormatIn .eq. 'kelman' .or.
     :        FormatIn .eq. 'landmark' .or.
     :        FormatIn .eq. 'landmark2' .or.
     :        FormatIn .eq. 'flat3d'  ) then
            return
         else
            write(LERR,*)'VOMIT: Requested format conversion not'
            write(LERR,*)'       currently available.  When using'
            write(LERR,*)'       flat3d output format  conversions'
            write(LERR,*)'       from : '
            write(LERR,*)'        usp, kelman, landmark, landmark2'
            write(LERR,*)'        vds3d, and flat3d'
            write(LERR,*)'       input formats only are allowed'
            write(LERR,*)'FATAL'
            write(LER,*)'VOMIT: Requested format conversion not'
            write(LER,*)'       currently available.  When using'
            write(LER,*)'       flat3d output format  conversions'
            write(LER,*)'       from: '
            write(LER,*)'        usp, kelman, landmark, landmark2'
            write(LER,*)'        vds3d, and flat3d'
            write(LER,*)'       input formats only are allowed'
            write(LER,*)'FATAL'
            stop
         endif
      endif

      if ( FormatIn .eq. 'landmark' .or.
     :     FormatIn .eq. 'landmark2' ) then

c These format added for Jim Mika [GUPCO] to allow Landmark velocity
c horizon data to be used to build 3D velocity cubes for use in
c post stack migration

         if ( FormatOut .eq. 'usp' .or.
     :        FormatOut .eq. 'flat3d' ) then
            return
         else
            write(LERR,*)'VOMIT: Requested format conversion not'
            write(LERR,*)'       currently available.  When using'
            write(LERR,*)'       landmark input format  conversions'
            write(LERR,*)'       to: '
            write(LERR,*)'            usp and flat3d'
            write(LERR,*)'       output formats only are allowed'
            write(LERR,*)'FATAL'
            write(LER,*)'VOMIT: Requested format conversion not'
            write(LER,*)'       currently available.  When using'
            write(LER,*)'       landmark  input format  conversions'
            write(LER,*)'       to: '
            write(LER,*)'            usp and flat3d'
            write(LER,*)'       output formats only are allowed'
            write(LER,*)'FATAL'
            stop
         endif
      endif

      if ( FormatOut .eq. 'landmark' .or.
     :     FormatOut .eq. 'landmark2' ) then

c This format added for Jim Mika [GUPCO] to allow Landmark velocity
c horizon data to be used to build 3D velocity cubes for use in
c post stack migration

         write(LERR,*)'VOMIT: Requested format conversion not'
         write(LERR,*)'       currently available.  No Landmark'
         write(LERR,*)'       output option exists at this time'
         write(LERR,*)'FATAL'
         write(LER,*)'VOMIT: Requested format conversion not'
         write(LER,*)'       currently available.  No landmark'
         write(LER,*)'       output format  option exists at this'
         write(LER,*)'       time.'
         write(LER,*)'FATAL'
         stop
      endif

      if ( FormatIn .eq. 'disco3d' ) then

c This format added for Hammouda Nada [Gupco] to handle velocity functions
c from Tensor Geophysical  

         if ( FormatOut .eq. 'disco3d' .or. 
     :        FormatOut .eq. 'usp' ) then
            return
        else
            write(LERR,*)'VOMIT: Requested format conversion not'
            write(LERR,*)'       currently available.  When using'
            write(LERR,*)'       disco3d input format  conversions'
            write(LERR,*)'       to: '
            write(LERR,*)'            usp and disco3d'
            write(LERR,*)'       output formats only are allowed'
            write(LERR,*)'FATAL'
            write(LER,*)'VOMIT: Requested format conversion not'
            write(LER,*)'       currently available.  When using'
            write(LER,*)'       disco3d input format  conversions'
            write(LER,*)'       to: '
            write(LER,*)'            usp and disco3d'
            write(LER,*)'       output formats only are allowed'
            write(LER,*)'FATAL'
            stop
         endif
      endif

      if ( FormatOut .eq. 'disco3d' ) then

c This format added for Hammouda Nada [Gupco] to handle velocity functions
c from Tensor Geophysical  

         if ( FormatIn .eq. 'usp' .or.
     :        FormatIn .eq. 'disco3d' ) then
            return
         else
            write(LERR,*)'VOMIT: Requested format conversion not'
            write(LERR,*)'       currently available.  When using'
            write(LERR,*)'       disco3d output format  conversions'
            write(LERR,*)'       from : '
            write(LERR,*)'            usp and disco3d'
            write(LERR,*)'       input formats only are allowed'
            write(LERR,*)'FATAL'
            write(LER,*)'VOMIT: Requested format conversion not'
            write(LER,*)'       currently available.  When using'
            write(LER,*)'       disco3d output format  conversions'
            write(LER,*)'       from: '
            write(LER,*)'            usp and disco3d'
            write(LER,*)'       input formats only are allowed'
            write(LER,*)'FATAL'
            stop
         endif
      endif

      if ( FormatIn .eq. 'disco3d1' ) then

c This format added for Jan Kommedal [Sunbury] to handle data coming in from CGG

         if ( FormatOut .eq. 'usp' ) then
            return
        else
            write(LERR,*)'VOMIT: Requested format conversion not'
            write(LERR,*)'       currently available.  When using'
            write(LERR,*)'       disco3d1 input format  conversions'
            write(LERR,*)'       to: '
            write(LERR,*)'            usp '
            write(LERR,*)'       output formats only are allowed'
            write(LERR,*)'FATAL'
            write(LER,*)'VOMIT: Requested format conversion not'
            write(LER,*)'       currently available.  When using'
            write(LER,*)'       disco3d1 input format  conversions'
            write(LER,*)'       to: '
            write(LER,*)'            usp'
            write(LER,*)'       output formats only are allowed'
            write(LER,*)'FATAL'
            stop
         endif
      endif

      if ( FormatIn .eq. 'disco3d3' ) then

c This format added for Alan Poole [UTG] to handle data coming in from Trinidad

         if ( FormatOut .eq. 'usp' ) then
            return
        else
            write(LERR,*)'VOMIT: Requested format conversion not'
            write(LERR,*)'       currently available.  When using'
            write(LERR,*)'       disco3d3 input format  conversions'
            write(LERR,*)'       to: '
            write(LERR,*)'            usp '
            write(LERR,*)'       output formats only are allowed'
            write(LERR,*)'FATAL'
            write(LER,*)'VOMIT: Requested format conversion not'
            write(LER,*)'       currently available.  When using'
            write(LER,*)'       disco3d3 input format  conversions'
            write(LER,*)'       to: '
            write(LER,*)'            usp'
            write(LER,*)'       output formats only are allowed'
            write(LER,*)'FATAL'
            stop
         endif
      endif

      if ( FormatIn .eq. 'disco3dxy' ) then

c This format added for Alan Poole [UTG Houston] to handle HANDVEL data
c with floating point x,y information included

         if ( FormatOut .eq. 'usp' ) then
            return
        else
            write(LERR,*)'VOMIT: Requested format conversion not'
            write(LERR,*)'       currently available.  When using'
            write(LERR,*)'       disco3dxy input format  conversions'
            write(LERR,*)'       to: '
            write(LERR,*)'            usp '
            write(LERR,*)'       output format only is allowed'
            write(LERR,*)'FATAL'
            write(LER,*)'VOMIT: Requested format conversion not'
            write(LER,*)'       currently available.  When using'
            write(LER,*)'       disco3dxy input format  conversions'
            write(LER,*)'       to: '
            write(LER,*)'            usp'
            write(LER,*)'       output format only is allowed'
            write(LER,*)'FATAL'
            stop
         endif
      endif

      if ( FormatIn .eq. 'ukooa' .or. FormatIn .eq. 'ukooa1') then

c This format added for Ron Scheet in conjunction with the Tringas
c 3D project.  Later upgraded for tdfn and vds3d for Richard Crider.

         if ( FormatOut .eq. 'ukooa' .or.
     :        FormatOut .eq. 'ukooa1' .or.
     :        FormatOut .eq. 'flat' .or.
     :        FormatOut .eq. 'tdfn' .or.
     :        FormatOut .eq. 'tdq' .or.
     :        FormatOut .eq. 'tdq2' .or.
     :        FormatOut .eq. 'vds3d' .or.
     :        FormatOut .eq. 'agip' .or.
     :        FormatOut .eq. 'usp' .or.
     :        FormatOut .eq. 'zmap' ) then
            return
        else
            write(LERR,*)'VOMIT: Requested format conversion not'
            write(LERR,*)'       currently available.  When using'
            write(LERR,*)'       ukooa or ukooa1 input format'
            write(LERR,*)'       conversions to: '
            write(LERR,*)'            usp, flat, tdfn, vds3d, ukooa'
            write(LERR,*)'            ukooa1, tdq, tdq2 or zmap'
            write(LERR,*)'       output formats only are allowed'
            write(LERR,*)'FATAL'
            write(LER,*)'VOMIT: Requested format conversion not'
            write(LER,*)'       currently available.  When using'
            write(LER,*)'       ukooa or ukooa1 input format  '
            write(LER,*)'       conversions to: '
            write(LER,*)'            usp, flat, tdfn, vds3d, ukooa'
            write(LER,*)'            ukooa1, tdq, tdq2 or zmap'
            write(LER,*)'       output formats only are allowed'
            write(LER,*)'FATAL'
            stop
         endif
      endif

      if ( FormatOut .eq. 'ukooa' .or. FormatOut .eq. 'ukooa1') then

c This format added for Ron Scheet in conjunction with the Tringas
c 3D project.

         if ( FormatIn .eq. 'usp' .or.
     :        FormatIn .eq. 'tdfn' .or.
     :        FormatIn .eq. 'vds3d' .or.
     :        FormatIn .eq. 'agip' .or.
     :        FormatIn .eq. 'ukooa1' .or.
     :        FormatIn .eq. 'ukooa'  ) then
            return
         else
            write(LERR,*)'VOMIT: Requested format conversion not'
            write(LERR,*)'       currently available.  When using'
            write(LERR,*)'       ukooa or ukooa1 output format'  
            write(LERR,*)'       conversions from : '
            write(LERR,*)'            usp, tdfn, vds3d, ukooa'
            write(LERR,*)'            ukooa1'
            write(LERR,*)'       input formats only are allowed'
            write(LERR,*)'FATAL'
            write(LER,*)'VOMIT: Requested format conversion not'
            write(LER,*)'       currently available.  When using'
            write(LER,*)'       ukooa or ukooa1 output format  '
            write(LER,*)'       conversions from: '
            write(LER,*)'            usp, tdfn, vds3d and ukooa'
            write(LER,*)'            ukooa1'
            write(LER,*)'       input formats only are allowed'
            write(LER,*)'FATAL'
            stop
         endif
      endif

      if ( FormatIn .eq. 'geco' ) then

c This format added for Sam Gray

         if ( FormatOut .eq. 'geco' .or.
     :        FormatOut .eq. 'usp' ) then
            return
        else
            write(LERR,*)'VOMIT: Requested format conversion not'
            write(LERR,*)'       currently available.  When using'
            write(LERR,*)'       geco input format  conversions'
            write(LERR,*)'       to: '
            write(LERR,*)'            usp and geco'
            write(LERR,*)'       output formats only are allowed'
            write(LERR,*)'FATAL'
            write(LER,*)'VOMIT: Requested format conversion not'
            write(LER,*)'       currently available.  When using'
            write(LER,*)'       geco input format  conversions'
            write(LER,*)'       to: '
            write(LER,*)'            usp and geco'
            write(LER,*)'       output formats only are allowed'
            write(LER,*)'FATAL'
            stop
         endif
      endif

      if ( FormatOut .eq. 'geco' ) then

c This format added for Ron Scheet in conjunction with the Tringas
c 3D project.

         if ( FormatIn .eq. 'usp' .or.
     :        FormatIn .eq. 'geco') then
            return
         else
            write(LERR,*)'VOMIT: Requested format conversion not'
            write(LERR,*)'       currently available.  When using'
            write(LERR,*)'       geco output format  conversions'
            write(LERR,*)'       from : '
            write(LERR,*)'            usp and geco'
            write(LERR,*)'       input formats only are allowed'
            write(LERR,*)'FATAL'
            write(LER,*)'VOMIT: Requested format conversion not'
            write(LER,*)'       currently available.  When using'
            write(LER,*)'       geco output format  conversions'
            write(LER,*)'       from: '
            write(LER,*)'            usp and geco'
            write(LER,*)'       input formats only are allowed'
            write(LER,*)'FATAL'
            stop
         endif
      endif

cmam added agip format
      if ( FormatIn .eq. 'agip' ) then
 
         if ( FormatOut .eq. 'usp' .or.
     :        FormatOut .eq. 'vds3d' .or.
     :        FormatOut .eq. 'ukooa1' .or.
     :        FormatOut .eq. 'ukooa' ) then
            return
         else
            write(LERR,*)'VOMIT: Requested format conversion not'
            write(LERR,*)'       currently available.  When using'
            write(LERR,*)'       agip input format  conversions'
            write(LERR,*)'       to : '
            write(LERR,*)'            usp, vds3d, ukooa, ukooa1'
            write(LERR,*)'       output formats only are allowed'
            write(LERR,*)'FATAL'
            write(LER,*)'VOMIT: Requested format conversion not'
            write(LER,*)'       currently available.  When using'
            write(LER,*)'       agip input format  conversions'
            write(LER,*)'       to : '
            write(LER,*)'            usp, vds3d, ukooa, ukooa1'
            write(LER,*)'       output formats only are allowed'
            write(LER,*)'FATAL'
            stop
         endif
      endif

cmam added agip format
      if ( FormatOut .eq. 'agip' ) then
 
         if ( FormatIn .eq. 'usp' .or.
     :        FormatIn .eq. 'vds3d' .or.
     :        FormatIn .eq. 'ukooa1' .or.
     :        FormatIn .eq. 'ukooa' ) then
            return
         else
            write(LERR,*)'VOMIT: Requested format conversion not'
            write(LERR,*)'       currently available.  When using'
            write(LERR,*)'       agip output format  conversions'
            write(LERR,*)'       from : '
            write(LERR,*)'            usp, vds3d, ukooa, ukooa1'
            write(LERR,*)'       input formats only are allowed'
            write(LERR,*)'FATAL'
            write(LER,*)'VOMIT: Requested format conversion not'
            write(LER,*)'       currently available.  When using'
            write(LER,*)'       agip output format  conversions'
            write(LER,*)'       from : '
            write(LER,*)'            usp, vds3d, ukooa, ukooa1'
            write(LER,*)'       input formats only are allowed'
            write(LER,*)'FATAL'
            stop
         endif
      endif

cmam added digicon format
      if ( FormatIn .eq. 'digicon' ) then
 
         if ( FormatOut .eq. 'usp' ) then
            return
         else
            write(LERR,*)'VOMIT: Requested format conversion not'
            write(LERR,*)'       currently available.  When using'
            write(LERR,*)'       digicon input format  conversions'
            write(LERR,*)'       to : '
            write(LERR,*)'            usp'
            write(LERR,*)'       output format only is allowed'
            write(LERR,*)'FATAL'
            write(LER,*)'VOMIT: Requested format conversion not'
            write(LER,*)'       currently available.  When using'
            write(LER,*)'       digicon input format  conversions'
            write(LER,*)'       to : '
            write(LER,*)'            usp'
            write(LER,*)'       output format only is allowed'
            write(LER,*)'FATAL'
            stop
         endif
      endif

cmam added essov2 format
      if ( FormatIn .eq. 'essov2' ) then
 
         if ( FormatOut .eq. 'usp' ) then
            return
         else
            write(LERR,*)'VOMIT: Requested format conversion not'
            write(LERR,*)'       currently available.  When using'
            write(LERR,*)'       essov2 input format  conversions'
            write(LERR,*)'       to : '
            write(LERR,*)'            usp'
            write(LERR,*)'       output format only are allowed'
            write(LERR,*)'FATAL'
            write(LER,*)'VOMIT: Requested format conversion not'
            write(LER,*)'       essov2 input format  conversions'
            write(LER,*)'       to : '
            write(LER,*)'            usp'
            write(LER,*)'       output format only are allowed'
            write(LER,*)'       currently available.  When using'
            write(LER,*)'FATAL'
            stop
         endif
      endif

cmam added omnivel format
      if ( FormatIn .eq. 'omnivel' ) then
 
         if ( FormatOut .eq. 'usp' ) then
            return
         else
            write(LERR,*)'VOMIT: Requested format conversion not'
            write(LERR,*)'       currently available.  When using'
            write(LERR,*)'       omnivel input format  conversions'
            write(LERR,*)'       to : '
            write(LERR,*)'            usp'
            write(LERR,*)'       output format only are allowed'
            write(LERR,*)'FATAL'
            write(LER,*)'VOMIT: Requested format conversion not'
            write(LER,*)'       currently available.  When using'
            write(LER,*)'       omnivel input format  conversions'
            write(LER,*)'       to : '
            write(LER,*)'            usp'
            write(LER,*)'       output format only are allowed'
            write(LER,*)'FATAL'
            stop
         endif
      endif

      if ( FormatOut .eq. 'tdq' .or. FormatOut .eq. 'tdq2' ) then

c This format added for Steve Wigger [Stavanger] to enable the load
c of velocity data to the Landmark TDQ time to depth conversion routine

         if ( FormatIn .eq. 'usp' .or.
     :        FormatIn .eq. 'ukooa' .or.
     :        FormatIn .eq. 'ukooa1' .or.
     :        FormatIn .eq. 'ukooa2' .or.
     :        FormatIn .eq. 'kelman' .or.
     :        FormatIn .eq. 'western3d1' ) then
            
            return
         else

            write(LERR,*)'VOMIT: Requested format conversion not'
            write(LERR,*)'       currently available.  Only '
            write(LERR,*)'       usp, ukooa, ukooa1, ukooa2,  '
            write(LERR,*)'       western3d1, or kelman   '
            write(LERR,*)'       input allowed for this option'
            write(LERR,*)'FATAL'
            write(LER,*)'VOMIT: Requested format conversion not'
            write(LER,*)'       currently available.  Only '
            write(LER,*)'       usp, ukooa, ukooa1, ukooa2,  '
            write(LER,*)'       western3d1, or kelman   '
            write(LER,*)'       input allowed for this option'
            write(LER,*)'FATAL'
            stop
         endif
      endif

      if ( FormatIn .eq. 'ukooa2' ) then

c This format added for Leendert Padmos [Dyce]

         if ( FormatOut .eq. 'usp' .or.
     :        FormatOut .eq. 'disco3d1' .or. 
     :        FormatOut .eq. 'disco3d2' .or. 
     :        FormatOut .eq. 'tdq'.or. 
     :        FormatOut .eq. 'tdq2'.or. 
     :        FormatOut .eq. 'zmap') then
            return
        else
            write(LERR,*)'VOMIT: Requested format conversion not'
            write(LERR,*)'       currently available.  When using'
            write(LERR,*)'       ukooa2 input format  conversions'
            write(LERR,*)'       to: '
            write(LERR,*)'  usp, essov2, disco3d1, disco3d2, tdq, '
            write(LERR,*)'  tdq2 and zmap'
            write(LERR,*)'       output formats only are allowed'
            write(LERR,*)'FATAL'
            write(LER,*)'VOMIT: Requested format conversion not'
            write(LER,*)'       currently available.  When using'
            write(LER,*)'       ukooa2 input format  conversions'
            write(LER,*)'       to: '
            write(LER,*)'  usp, essov2, disco3d1, disco3d2, tdq, '
            write(LER,*)'  tdq2 and zmap'
            write(LER,*)'       output formats only are allowed'
            write(LER,*)'FATAL'
            stop
         endif
      endif

      if ( FormatOut .eq. 'disco3d2' ) then

c This format added for Leendert Padmos [Stavanger] to prepare velocity 
c functions for input to GeoDepth

         if ( FormatIn .eq. 'usp' .or.
     :        FormatIn .eq. 'disco3d1' .or.
     :        FormatIn .eq. 'ukooa2' ) then
            return
         else
            write(LERR,*)'VOMIT: Requested format conversion not'
            write(LERR,*)'       currently available.  When using'
            write(LERR,*)'       disco3d output format  conversions'
            write(LERR,*)'       from : '
            write(LERR,*)'            usp, disco3d1 and ukooa2'
            write(LERR,*)'       input formats only are allowed'
            write(LERR,*)'FATAL'
            write(LER,*)'VOMIT: Requested format conversion not'
            write(LER,*)'       currently available.  When using'
            write(LER,*)'       disco3d output format  conversions'
            write(LER,*)'       from: '
            write(LER,*)'            usp, disco3d1 and ukooa2'
            write(LER,*)'       input formats only are allowed'
            write(LER,*)'FATAL'
            stop
         endif
      endif

      if ( FormatIn .eq. 'kelman' ) then

c This format added for Frank Mixon [Red Oak]

         if ( FormatOut .eq. 'usp' .or.
     :        FormatOut .eq. 'flat3d' .or. 
     :        FormatOut .eq. 'tdq'.or. 
     :        FormatOut .eq. 'tdq2'.or. 
     :        FormatOut .eq. 'zmap') then
            return
        else
            write(LERR,*)'VOMIT: Requested format conversion not'
            write(LERR,*)'       currently available.  When using'
            write(LERR,*)'       kelman input format  conversions'
            write(LERR,*)'       to: '
            write(LERR,*)'       usp, flat3d, tdq, tdq2 and zmap '
            write(LERR,*)'       output formats only are allowed'
            write(LERR,*)'FATAL'
            write(LER,*)'VOMIT: Requested format conversion not'
            write(LER,*)'       currently available.  When using'
            write(LER,*)'       kelman input format  conversions'
            write(LER,*)'       to: '
            write(LER,*)'       usp, flat3d, tdq, tdq2 and zmap '
            write(LER,*)'       output formats only are allowed'
            write(LER,*)'FATAL'
            stop
         endif
      endif

      if ( FormatIn .eq. 'promax' ) then

c This format added for Ganyuan Xia [UTG:USP] and handles promax
c ascii functions for a 2D line [i.e. only a single index]

         if ( FormatOut .eq. 'usp' .or.
     :        FormatOut .eq. 'flat' ) then
            return
        else
            write(LERR,*)'VOMIT: Requested format conversion not'
            write(LERR,*)'       currently available.  When using'
            write(LERR,*)'       promax input format  conversions'
            write(LERR,*)'       to: '
            write(LERR,*)'       usp and flat '
            write(LERR,*)'       output formats only are allowed'
            write(LERR,*)'FATAL'
            write(LER,*)'VOMIT: Requested format conversion not'
            write(LER,*)'       currently available.  When using'
            write(LER,*)'       promax input format  conversions'
            write(LER,*)'       to: '
            write(LER,*)'       usp and flat '
            write(LER,*)'       output formats only are allowed'
            write(LER,*)'FATAL'
            stop
         endif
      endif

      if ( FormatIn .eq. 'promax3d' ) then

c This format added for Sandy Rothe [UTG:GM] and handles promax
c ascii functions for a 3D line [i.e. only a single index]

         if ( FormatOut .eq. 'usp' .or.
     :        FormatOut .eq. 'flat' ) then
            return
        else
            write(LERR,*)'VOMIT: Requested format conversion not'
            write(LERR,*)'       currently available.  When using'
            write(LERR,*)'       promax3d input format  conversions'
            write(LERR,*)'       to: '
            write(LERR,*)'       usp and flat '
            write(LERR,*)'       output formats only are allowed'
            write(LERR,*)'FATAL'
            write(LER,*)'VOMIT: Requested format conversion not'
            write(LER,*)'       currently available.  When using'
            write(LER,*)'       promax3d input format  conversions'
            write(LER,*)'       to: '
            write(LER,*)'       usp and flat '
            write(LER,*)'       output formats only are allowed'
            write(LER,*)'FATAL'
            stop
         endif
      endif


      if ( FormatOut .eq. 'zmap' ) then

c This format added for Odd Fogelstad [Stavanger] to enable the load
c of velocity data to the zmap system

         if ( FormatIn .eq. 'usp' .or.
     :        FormatIn .eq. 'ukooa' .or.
     :        FormatIn .eq. 'ukooa1' .or.
     :        FormatIn .eq. 'ukooa2' .or.
     :        FormatIn .eq. 'kelman' .or.
     :        FormatIn .eq. 'western3d1' ) then
            
            return
         else

            write(LERR,*)'VOMIT: Requested format conversion not'
            write(LERR,*)'       currently available.  Only '
            write(LERR,*)'       usp, ukooa, ukooa1, ukooa2,  '
            write(LERR,*)'       western3d1, or kelman   '
            write(LERR,*)'       input allowed for this option'
            write(LERR,*)'FATAL'
            write(LER,*)'VOMIT: Requested format conversion not'
            write(LER,*)'       currently available.  Only '
            write(LER,*)'       usp, ukooa, ukooa1, ukooa2,  '
            write(LER,*)'       western3d1, or kelman   '
            write(LER,*)'       input allowed for this option'
            write(LER,*)'FATAL'
            stop
         endif
      endif

      end

