C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine Kelman_redatum ( Unit, Velocity, N, Kelman_vref, 
     :     SlopeAdjustmentFactor, Force, JJ, MaxTime, nsi, verbos )

      implicit none

c declare variables passed from calling routine

      integer N, JJ, nsi

      real Unit(N), Velocity(N), Kelman_vref
      real SlopeAdjustmentFactor, MaxTime

      logical Force, verbos

c declare local variables

      integer i, zero_index, count

      real datum

      logical tape, vflag, done

c initialize variables

      tape = .false.
      vflag = .false.
      done = .false.


c 1. determine datum thickness [if initial time is negative then datum is below
c    reference surface, if positive then above.  In the first case we need to 
c    push function down in later case we need to pull function up]

      datum =  Kelman_vref * Unit(1) / 2.0

c 2. convert function to interval velocity 

      call tr2ti( Unit, Velocity, N, tape, SlopeAdjustmentFactor, vflag, 
     :     Force, JJ )
      call t2d ( Unit, Velocity, N )

c 3. push/pull to new times

      do i = 1, N
         if ( datum .lt. 0.0 ) then
            Unit(i) = Unit(i) + abs (datum)
         elseif ( datum .gt. 0.0 ) then
            Unit(i) = Unit(i) - datum
         endif
      enddo

c 4. convert function back to rms velocity and get on with life.  First sample now
c    at zero.

      call d2t ( Unit, Velocity, N )

c 5. check for residual negative start times.  If found then set first occurance 
c    [checking from bottom up] to zero and drop any additional negative entries.
c    We have found for the development datasets that due to estimating the vref we
c    are sometimes off a few samples which may go negative if we are moving the start
c    time up.  

      zero_index = 1

      do i = N,1,-1
         if ( Unit(i) .le. 0.0 .and. .not. done ) then
            zero_index = i
            Unit(i) = 0.0
            done = .true.
         endif
      enddo

      if ( zero_index .ne. 1 ) then
         count = 1
         do i = zero_index, N
            Unit(count) = Unit(i)
            Velocity(count) = Velocity(i)
            count = count + 1
         enddo

         N = N - zero_index + 1
      endif
            
      call ti2tr ( Unit, Velocity, N, MaxTime, nsi, Velocity(1) )

      return
      end
