C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine Memory ( luin, ntap, FormatIn, NumFcns, 
     :     NumEntries, 
c xsd specifics
     :     Xsd_RecUnit, Xsd_VelUnit, Xsd_SmpUnit, 
     :     Xsd_RecOffset, Xsd_VelOffset, Xsd_SmpOffset,
c vxos specifics
     :     Vxos_NumPicks,
c landmark specifics
     :     Landmark_nhor, Usp_SmpIntOverride,
c usp specifics
     :     itr, lbytes, nsamp, nsi, ntrc, nrec, UnitSc_override,
     :     iwd, ifmt_iwd, l_iwd, ln_iwd, obytes, nsampo, UnitSc,
     :     Usp_Depth2Time_MaxTime, Usp_Time2Depth_MaxDepth,
c vds3d specifics
     :     Vds_StaticsMode, Vds_JobConstantStatic, Vds_MutePercent, 
     :     Vds_WaterBottom, Vds_MinLI, Vds_MaxLI, Vds_MinDI, Vds_MaxDI,
     :     Vds_LIinc, Vds_DIinc, Vds_InterpRadius, Vds_PrtWgtFlag, 
     :     Vds_BinsizeLI, Vds_BinsizeDI, Vds_NumScheme, Vds_DipAzimFlag,  
     :     Vds_OacLine, Vds_VelPrtInc, 
c flat3d1 specifics
     :     Flat3d1_Nelem,  
c earth vision specifics
     :     Earth_NumX, Earth_NumY, Earth_NumZ,
c omnivel specifics
     :     OAC,LineID,JobNum,DatTyp,PrcNam,APIWNo,CDPFLD,PrcDat,
     :     WatVel,
     :     verbos ) 

c determine memory requirements of input velocity data,  in the case
c of usp data also pick up any line header entries required. 

      implicit none

#include <f77/iounit.h>
#include <save_defs.h>
#include <f77/sisdef.h>
#include <f77/lhdrsz.h>

c declare variables passed from calling routine

      integer     luin, nsi, nsamp, nsampo, NumFcns, NumEntries
      integer     itr(SZLNHD), lbytes, obytes
      integer     nrec, ntrc
      integer     ifmt_iwd, l_iwd, ln_iwd
      integer     Vxos_NumPicks(SZLNHD)
      integer     Landmark_nhor, Usp_SmpIntOverride
      integer     Vds_StaticsMode, Vds_JobConstantStatic
      integer     Vds_MutePercent, Vds_WaterBottom
      integer     Vds_MinDI, Vds_MaxDI, Vds_MinLI, Vds_MaxLI
      integer     Vds_LIinc, Vds_DIinc, Vds_InterpRadius
      integer     Vds_NumScheme, Vds_DipAzimFlag, Vds_VelPrtInc
      integer     Vds_PrtWgtFlag
      integer     Flat3d1_Nelem
      integer     Earth_NumX, Earth_NumY, Earth_NumZ

      real        Xsd_RecUnit, Xsd_VelUnit, Xsd_SmpUnit
      real        Xsd_RecOffset, Xsd_VelOffset, Xsd_SmpOffset
      real        Vds_BinsizeDI, Vds_BinsizeLI
      real        Usp_Depth2Time_MaxTime, Usp_Time2Depth_MaxDepth
      real        UnitSc, UnitSc_override
      real        Flat3d1_LI, Flat3d1_DI

      character   ntap*(*), FormatIn*(*), iwd*6
      character   Vds_OacLine*7
      character   ahd*10

      logical    verbos

      character SrcPtA*1, SurvID*8
      character OAC*8, LineID*8, JobNum*8, DatTyp*1, PrcNam*10,
     :          APIWNo*12, PrcDat*8
      integer*2 CDPFLD
      integer WatVel


c declare variables unique to subroutine
      
      integer    MaxEntries, length, lenth, imax, numtv, inum, maxcnt
      integer    ijunk, ijunk1, ijunk2, LI, DI, inLine, Xline
      integer    ixlst, iylst, nline, ixline, icx, icy, itime, ivel
      integer    SrcPnt, CDP
      integer    This_LI, This_DI
      integer    ifmt_MnLnIn, l_MnLnIn, ln_MnLnIn
      integer    ifmt_MxLnIN, l_MxLnIN, ln_MxLnIN
      integer    ifmt_MnDpIn, l_MnDpIn, ln_MnDpIn
      integer    ifmt_MxDpIn, l_MxDpIn, ln_MxDpIn

      real       Flat3d_LI, Flat3d_DI, time, vel
      real       rjunk, rjunk1, rjunk2, value

      character  junker*8, key*10, card*80, Vds_card*5, Earth_Line*150
      character  junker1*10, junker2*1, Vds_test*5, Vds_temp_oacline*7
      character  ukooa_end*3, c_junk4*4

      logical Vds_MC3D, Vds_dummy, done
      logical first0, first1, first2

c initialize variables

      NumFcns = 0
      NumEntries = 0
      MaxEntries = 0
      Vds_test = '1MC3D'
      Vds_MC3D = .true.
      Vds_dummy = .false.
      first0 = .true.
      first1 = .true.
      first2 = .true.
      done = .false.

c determine input format and act appropriately

      IF ( FormatIn .eq. 'xsd' ) then

c read pick file header assuming new XSD format.

         read ( luin, 10, err = 900 , end = 901 ) Xsd_RecUnit, 
     :        Xsd_VelUnit, Xsd_SmpUnit, nrec, ntrc, nsamp, 
     :        Xsd_RecOffset, Xsd_VelOffset, Xsd_SmpOffset, NumFcns, 
     :        NumEntries
 10      format ( 6x, f12.6, 1x, f12.6, 1x, f12.6, 1x, i5, 1x, i5, 1x, 
     :        i5, 7x, f12.6, 1x, f12.6, 1x, f12.6, 8x, i5, 1x, i5 )

         return
       
      ELSEIF ( FormatIn .eq. 'xsdheader' ) then

c read file header

         do while ( 1 .eq. 1 )

            read ( luin, '(a10,1x,f17.6)', err=900, end=901 ) 
     :           key, value

            if (key.EQ.'No_Seg') NumFcns = nint(value)
            if (key.EQ.'Max_Pick') NumEntries = nint(value)
            if (key.EQ.'UnitRec') Xsd_RecUnit = value
            if (key.EQ.'UnitTrc') Xsd_VelUnit = value
            if (key.EQ.'UnitSmp') Xsd_SmpUnit = value
            if (key.EQ.'OffsetRec') Xsd_RecOffset = value
            if (key.EQ.'OffsetTrc') Xsd_VelOffset = value
            if (key.EQ.'OffsetSmp') Xsd_SmpOffset = value
            if (key.EQ.'NumRec') nrec = nint(value)
            if (key.EQ.'NumTrc') ntrc = nint(value)
            if (key.EQ.'NumSmp') nsamp = nint(value)
            if (key.EQ.'NumSmp') return
         enddo

      ELSEIF ( FormatIn .eq. 'tdfn' ) then

c count number of functions and determine number of entries in largest

         do while ( 1 .eq. 1 )
            read ( luin, '( i1 )', err = 900, end = 20 ) ijunk
            if ( ijunk .eq. 9 ) then
               NumFcns = NumFcns + 1
cmam......added here....
               if (NumFcns.eq.1 .and. NumEntries.eq.0) NumEntries = 7
               if ( NumEntries .gt. MaxEntries ) MaxEntries = NumEntries
               NumEntries = 0
            else
               NumEntries = NumEntries + 7
cmam           NumEntries = NumEntries + 8
            endif
         enddo

 20      continue
         if ( NumFcns .eq. 0 ) goto 901
         NumEntries = MaxEntries
         rewind luin
         return

      ELSEIF ( FormatIn .eq. 'vds3d' ) then

c determine if mc3d card is there, if it is then use it, if not then
c ignore it

         read ( luin, '(a80)', err=900, end=901 ) card
         if ( card(1:5) .ne. Vds_test ) Vds_MC3D = .false.

c----
c   check to see if we have a bogus unfilled out MC3D card. If we do
c   then we attempt to declare it "dummy" and rely on cmd line arg
c   input. Note that no "gamma" function input will ever have such a
c   bogus card but we can utilize the gamma "read over tag" logic to
c   bypass the bogus card in the non-gamma case
c----
         if ( Vds_MC3D ) then

            if ( card(21:25).eq.'Maxli' .AND. 
     :           card(31:35).eq.'Maxdi' .AND.
     :           card(46:50).eq.'Radus' .AND. 
     :           card(57:66).eq.'CldimIldim'
     :           ) then

            write (LERR,*)' '
            write (LERR,*)'WARNING from vomit:'
            write (LERR,*)'Detected dummy 1MC3D card at top of input'
            write (LERR,*)'file.'
            Vds_MC3D  = .false.
            Vds_dummy = .true.
            endif
         endif

         rewind (luin)
         
         if ( Vds_MC3D ) then
      

c read header card

            read ( luin, 21 ) Vds_card, Vds_StaticsMode,  
     :           Vds_JobConstantStatic, Vds_MutePercent, Vds_WaterBottom 
     :           ,Vds_MinLI, Vds_MaxLI, Vds_MinDI, Vds_MaxDI, Vds_LIinc, 
     :           Vds_DIinc, Vds_InterpRadius, Vds_VelPrtInc,
     :           Vds_PrtWgtFlag, Vds_BinsizeLI, Vds_BinsizeDI, 
     :           Vds_NumScheme, Vds_DipAzimFlag, Vds_temp_oacline, 
     :           Vds_VelPrtInc
 21         format(a5,i1,i5,i3,i1,8i5,i1,2f5.0,2i1,a7,i5)

            if ( Vds_Oacline .eq. ' ' ) Vds_Oacline = Vds_temp_oacline

         elseif ( Vds_dummy ) then
            
            read (luin, '(a80)' ) card

         endif

c count number of functions and determine number of entries in largest

         do while ( 1 .eq. 1 )
            read ( luin, '( i1 )', err = 900, end = 25 ) ijunk
            if ( ijunk .eq. 9 ) then
               NumFcns = NumFcns + 1
               NumEntries = NumEntries + 8
               if ( NumEntries .gt. MaxEntries ) MaxEntries = NumEntries
               NumEntries = 0
            elseif ( ijunk .ne. 0 ) then
               NumEntries = NumEntries + 8
            endif
         enddo

 25      continue
         if ( NumFcns .eq. 0 ) goto 901
         NumEntries = MaxEntries

c rewind the input file and read past the 1MC3D card if required

         rewind luin
         if ( Vds_MC3D .or. Vds_dummy ) read(luin,'(a5)') Vds_card
         return


      ELSEIF ( FormatIn .eq. 'vip' ) then

c read past 5 card header 

         read ( luin, '(a5)', err = 900 , end = 901 ) Vds_card
         read ( luin, '(a5)', err = 900 , end = 901 ) Vds_card
         read ( luin, '(a5)', err = 900 , end = 901 ) Vds_card
         read ( luin, '(a5)', err = 900 , end = 901 ) Vds_card
         read ( luin, '(a5)', err = 900 , end = 901 ) Vds_card

c count number of functions and keep track of largest number of entries

         do while ( 1 .eq. 1 ) 
           
            read( luin, '(a8)', err=900, end=96 ) junker
            if(junker(1:8).eq.'**locati')then
               NumFcns = NumFcns + 1
               if ( NumEntries .gt. MaxEntries ) MaxEntries = NumEntries
               NumEntries = 0

c read past bogus handvel card

               read(luin,'(a8)')junker
            else
               NumEntries = NumEntries + 4
            endif
         enddo

 96      continue
               
         if ( NumFcns .eq. 0 ) goto 901
         NumEntries = MaxEntries

c reposition file pointer for function read

         rewind luin
         do while ( 1 .eq. 1 ) 
            read( luin, '(a8)') junker
            if(junker(1:8).eq.'**locati')then
               backspace( luin )
               return
            endif
         enddo

      ELSEIF ( FormatIn .eq. 'flat' ) then

c count number of functions and determine number of entries in largest

         do while ( 1 .eq. 1 )
            read ( luin, *, err = 900, end = 30 ) rjunk, rjunk1, rjunk2 
            if ( rjunk .lt. 0. ) then
               NumFcns = NumFcns + 1
               if ( NumEntries .gt. MaxEntries ) MaxEntries = NumEntries
               NumEntries = 0
            else
               NumEntries = NumEntries + 1
            endif
         enddo

 30      continue
         if ( NumFcns .eq. 0 ) goto 901
         NumEntries = MaxEntries + 1
         rewind luin
         return

      ELSEIF ( FormatIn .eq. 'disco'  .or. 
     :        FormatIn .eq. 'disco3d' .or. 
     :        FormatIn .eq. 'disco3dxy' .or. 
     :        FormatIn .eq. 'disco3d1' .or. 
     :        FormatIn .eq. 'disco3d3' ) then

c count number of functions and determine number of entries in largest

         do while ( 1 .eq. 1 )
            read( luin, '(a8)', err=900, end=40 ) junker
            if ( junker(1:7) .eq. 'HANDVEL' ) then
               NumFcns = NumFcns + 1
               if ( NumEntries .gt. MaxEntries ) MaxEntries = NumEntries
               NumEntries = 0
            else
               NumEntries = NumEntries + 4
            endif
         enddo

 40      continue
         if ( NumFcns .eq. 0 ) goto 901
         NumEntries = MaxEntries

c reposition file pointer for function read

         rewind luin
         do while ( 1 .eq. 1 ) 
            read( luin, '(a8)') junker
            if(junker(1:7).eq.'HANDVEL')then
               backspace( luin )
               return
            endif
         enddo

      ELSEIF ( FormatIn .eq. 'usp' .or. 
     :        FormatIn .eq. 'charisma' ) then

c read usp line header

         lbytes = 0
         call rtape ( luin, itr, lbytes )
         if(lbytes .eq. 0) then
            length = lenth(ntap)
	    if (length .gt. 0) then
              write(LERR,*)'VOMIT: no line header read on ',
     :           ntap(1:length)
	    else
              write(LERR,*)'VOMIT: no line header read on stdin'
	    endif
            write(LERR,*)'FATAL'
            write(LER,*)' '
	    if (length .gt. 0) then
              write(LER,*)'VOMIT: no line header read on ',
     :           ntap(1:length)
	    else
              write(LER,*)'VOMIT: no line header read on stdin'
	    endif
            write(LER,*)'FATAL'
            write(LER,*)' '
            stop
         endif
         
c if a command line entry for nsamp was used with charisma input
c format then use it.

	if ( FormatIn .eq. 'charisma' .and. 
     :        nsamp .gt. 0 ) nsampo = nsamp

c load input standard usp variables 

         call saver ( itr, 'NumSmp', nsamp , LINHED )
         call saver ( itr, 'SmpInt', nsi   , LINHED )
         call saver ( itr, 'NumTrc', ntrc  , LINHED )
         call saver ( itr, 'NumRec', nrec  , LINHED )

         if ( UnitSc_override .ne. 0.0 ) then
            UnitSc = UnitSc_override
         else
            call saver ( itr, 'UnitSc', UnitSc  , LINHED )
            if ( UnitSc .eq. 0.0 ) UnitSc = 0.001
         endif

         call savelu ( iwd, ifmt_iwd, l_iwd, ln_iwd, TRACEHEADER )

c input velocity function constraints

         NumFcns = nrec * ntrc
         NumEntries = nsamp

c with charisma input the maximum number of input time,depth
c pairs is 21 as that is how many TVPT entries there are

	 if ( FormatIn .eq. 'charisma' ) NumEntries = 21

c default sample units is milliseconds

         if ( UnitSc .eq. 0.000 ) UnitSc = 0.001

c output constraints
         
         if ( abs(Usp_Depth2Time_MaxTime) .gt. 1.e-30 .or.
     :        abs(Usp_Time2Depth_MaxDepth) .gt. 1.e-30 ) then

c we are doing an axis conversion from t2d or d2t and the user wants
c to set the output axis maximum which will affect the number of output
c samples used.  If the -osi entry is filled out use it otherwise use nsi
c to calculate the new number of output samples

            if ( Usp_SmpIntOverride .gt. 0 ) then
               if ( abs(Usp_Depth2Time_MaxTime) .gt. 1.e-30 ) then
                  nsampo = nint ( Usp_Depth2Time_MaxTime / 
     :                 float ( Usp_SmpIntOverride ) )
               else
                  nsampo = nint ( Usp_Time2Depth_MaxDepth /
     :                 float ( Usp_SmpIntOverride ) )
               endif
            else
               if ( abs(Usp_Depth2Time_MaxTime) .gt. 1.e-30 ) then
                  nsampo = nint ( Usp_Depth2Time_MaxTime / 
     :                 float ( nsi ) )
               else
                  nsampo = nint ( Usp_Time2Depth_MaxDepth /
     :                 float ( nsi ) )
               endif
            endif

            obytes = SZTRHD + SZSMPD * nsampo

         else

            obytes = SZTRHD + SZSMPD * nsamp 

         endif

	if ( FormatIn .eq. 'charisma' ) then
	   if ( nsampo .eq. 0 ) nsampo = nsamp
             obytes = SZTRHD + SZSMPD * nsampo
	endif

c assign variables used with vds3d format

         call savelu ( 'MnLnIn', ifmt_MnLnIn, l_MnLnIn, ln_MnLnIn, 
     :        LINEHEADER )
         call saver2 ( itr, ifmt_MnLnIn, l_MnLnIn, ln_MnLnIn, Vds_MinLI, 
     :        LINEHEADER )

         call savelu ( 'MxLnIn', ifmt_MxLnIN, l_MxLnIN, ln_MxLnIN, 
     :        LINEHEADER )
         call saver2 ( itr, ifmt_MxLnIN, l_MxLnIN, ln_MxLnIN, Vds_MaxLI,
     :        LINEHEADER )
         
         call savelu ( 'MnDpIn', ifmt_MnDpIn, l_MnDpIn, ln_MnDpIn, 
     :        LINEHEADER )
         call saver2 ( itr, ifmt_MnDpIn, l_MnDpIn, ln_MnDpIn, Vds_MinDI,
     :        LINEHEADER )

         call savelu ( 'MxDpIn', ifmt_MxDpIn, l_MxDpIn, ln_MxDpIn, 
     :        LINEHEADER )
         call saver2 ( itr, ifmt_MxDpIn, l_MxDpIn, ln_MxDpIn, Vds_MaxDI,
     :        LINEHEADER )
        
         return
 
      ELSEIF ( FormatIn .eq. 'vxos' ) then

c the main difference between vxos and xsd pick formats is in the relationship
c between the header and the data.  Unlike xsd in vxos you can append to the
c pickfile often making the header incorrect.  For this reason we must count
c each segment and the number of entries in each segment for later use and
c for memory management

         call VXOSinitialize( luin, NumFcns, Vxos_NumPicks, Xsd_RecUnit,
     :        Xsd_SmpUnit, Xsd_VelUnit, Xsd_VelOffset, Xsd_SmpOffset, 
     :        Xsd_RecOffset, nsamp, ntrc, NumEntries)

         nrec = NumFcns
         return

      ELSEIF ( FormatIn .eq. 'landmark' .or. 
     :         FormatIn .eq. 'landmark2' ) then

c in the case of landmark horizon input ... this was written for Cairo where
c they have a set number of velocity horizons being fed in to create a 3D 
c velocity volume.  They have a function at every LI,DI consisting of nhor
c depth[or time], velocity pairs and require an output usp data set. The format 
c of each input line is :

c  LI   DI  K   D0   V0    z1  v1   z2   v2   z3   v3   z4   v4
c  82    2 1.65 570 1535  1001 2647 1462 3261 2036 3502 3113 4506

c which is read under free format read.  The difference between the formats
c are that in the case of landmark2 the initial layer is assumed to be 
c a water layer and the gradient is assigned to the layer immediately below
c the water bottom.  Of course the first function element is also the defining
c water bottom to which the gradient is hung.  In the case of landmark2 the water
c [layer 1] velocity is taken from the command line entry [-watvel].

         NumEntries = SZLNHD

         if ( nrec .eq. 0 .or. ntrc .eq. 0 ) then
            write(LERR,*)'VOMIT: landmark/landmark2 input data requires'
            write(LERR,*)'       both a -nrec and -ntrc  command'
            write(LERR,*)'       line entry.  One or  both were'
            write(LERR,*)'       missing.'
            write(LERR,*)'FATAL'
            write(LER,*)' '
            write(LER,*)'VOMIT: landmark/landmark2 input data requires'
            write(LER,*)'       both a -nrec and -ntrc  command'
            write(LER,*)'       line entry.  One or  both were'
            write(LER,*)'       missing.'
            write(LER,*)'FATAL'
            stop
         endif

         NumFcns = nrec * ntrc

         if ( Usp_SmpIntOverride .eq. 0 ) then
            write(LERR,*)'VOMIT: landmark/landmark2 input data requires'
            write(LERR,*)'       a -osi command line entry.  None'
            write(LERR,*)'       was found.  A -osi of 1 will be used'
            write(LERR,*)'WARNING'
            write(LER,*)' '
            write(LER,*)'VOMIT: landmark/landmark2 input data requires'
            write(LER,*)'       a -osi command line entry.  None'
            write(LER,*)'       was found.  A -osi of 1 will be used'
            write(LER,*)'WARNING'

            nsi = 1
            Usp_SmpIntOverride = 1
         else
            nsi = Usp_SmpIntOverride
         endif
         return

      ELSEIF ( FormatIn .eq. 'flat3d' ) then

         read ( luin, *, err= 900, end= 900 ) Flat3d_LI, Flat3d_DI
          do while ( 1 .eq. 1 )
             read (luin, *, err = 900, end = 50) rjunk, rjunk1
             NumEntries = NumEntries + 1
             if ( abs ( Flat3d_LI - rjunk ) .gt. 1.e-30 .or.
     :            abs ( Flat3d_DI - rjunk1 ) .gt. 1.e-30 ) then
                NumFcns = NumFcns + 1
                if ( NumEntries .gt. MaxEntries ) 
     :               MaxEntries = NumEntries
                Flat3d_LI = rjunk
                Flat3d_DI = rjunk1
                NumEntries = 1
             endif
          enddo

 50       continue
          if ( NumEntries .gt. MaxEntries ) 
     :         MaxEntries = NumEntries
          NumEntries = MaxEntries + 1
          NumFcns = NumFcns + 1
          rewind luin
          return

      ELSEIF ( FormatIn .eq. 'flat3d1' ) then

         if ( Flat3d1_Nelem .gt. 0 ) then
            NumEntries = Flat3d1_Nelem
         else
            write(LERR,*)' '
            write(LERR,*)'VOMIT: flat3d1 input format requires a -nelem'
            write(LERR,*)'       command line entry. Add the  ' 
            write(LERR,*)'       appropriate entry to your command line'
            write(LERR,*)'       and resubmit the job'
            write(LERR,*)'FATAL'
            write(LER,*)' '
            write(LER,*)'VOMIT: flat3d1 input format requires a -nelem'
            write(LER,*)'       command line entry. Add the  ' 
            write(LER,*)'       appropriate entry to your command line'
            write(LER,*)'       and resubmit the job'
            write(LER,*)'FATAL'
            stop
         endif

         do while ( 1 .eq. 1 )
            read ( luin, *, err= 900, end= 60 ) Flat3d1_LI, Flat3d1_DI
            NumFcns = NumFcns + 1
         enddo

 60      continue
         rewind luin
         return

      ELSEIF ( FormatIn .eq. 'ev3d' ) then

c need to read in the dimensions of the grid we are about to try to load
c to memory.  This is stored in the comment header area of the file.

         do while ( 1 .eq. 1 )

            read ( luin, '(a150)' ) Earth_Line
            call fsscnf(Earth_Line,'%s %s', junker1, key)
            if ( key .eq. 'Grid_size:' ) then
               call fsscnf(Earth_Line,'%s %s %d %s %d %s %d', junker1, 
     :              key,Earth_NumX, junker2,Earth_NumY, junker2, 
     :              Earth_NumZ)
               NumFcns = Earth_NumX * Earth_NumY
               NumEntries = Earth_NumZ
            endif
            if ( junker1(1:1) .ne. '#' ) then

c we may be at the start of data.  If we are then backspace one and return.
c If not then keep reading until we are
               
               call fsscnf ( Earth_Line, '%f %f %f %f %d %d %d', rjunk, 
     :              rjunk1, rjunk2, value, ijunk, ijunk1, ijunk2 )
               if ( ijunk .eq. 1 .or. ijunk1 .eq. 1 .or. ijunk2 .eq. 1 ) 
     :              then
                  backspace (luin)
                  return
               endif
            endif
          enddo

      ELSEIF ( FormatIn .eq. 'western3d' ) then

c read through input file and look for the largest function.  Will need this
c information for dynamic memory allocation.  This is straight forward for 
c in this format all the data for a given li,di is on a single line.  The
c number of time-velocity pairs is in card columns 57-60 as an I4 entry.

         do while ( 1 .eq. 1 )
            read (luin, '(56x,I4)', err=900 ,end=70 ) NumEntries
            NumFcns = NumFcns + 1
            if ( NumEntries .gt. MaxEntries ) 
     :           MaxEntries = NumEntries
         enddo

 70      continue
         NumEntries = MaxEntries

c fill out usp entries nrec,ntrc if it is not filled out on the command line

         if ( nrec .eq. 0 ) nrec = NumFcns
         if ( ntrc .eq. 0 ) ntrc = 1

c rewind the input file

         rewind luin
         return

      ELSEIF ( FormatIn .eq. 'western3d1' ) then

c read through input file and look for the largest function.  Will need this
c information for dynamic memory allocation.  First must read past  header
c lines

         do while ( c_junk4 .ne. 'SPNT' )
            read ( luin,'(a4)',err=900,end=901) c_junk4
         enddo
         
         backspace (luin)

         do while ( 1.eq.1 )
            read ( luin, '(a80)', err=900, end=97 ) Card
            if ( Card(1:4) .eq. 'SPNT' ) then
               NumFcns = NumFcns + 1
               if ( NumEntries .gt. MaxEntries ) MaxEntries = NumEntries
               NumEntries = 0
            else
               NumEntries = NumEntries + 5
            endif

         enddo
         

 97      continue

         if ( NumEntries .gt. MaxEntries ) MaxEntries = NumEntries
         NumEntries = MaxEntries

c reposition pointer for function read

         rewind luin
         c_junk4 = '  '
         do while ( c_junk4 .ne. 'SPNT' )
            read ( luin,'(a4)',err=900,end=901) c_junk4
         enddo
         
         backspace (luin)

         return

      ELSEIF ( FormatIn .eq. 'ukooa' .or. FormatIn .eq. 'ukooa1' ) then

c skip past 4 line header

         read(luin,'(///)',end=901, err=900)

c read each function and determine total number of input functions
c and the maximum number of elements in the functions included

         do while ( 1 .eq. 1 )

c read the function header

            read(luin,'(a80)',end=80, err=900) card

            if ( card(1:3) .eq. 'EOF') then
               NumEntries = MaxEntries

c rewind input file and read past header to position pointer at 
c first input velocity function

               rewind luin
               read(luin,'(///)')
               return
            endif

            NumFcns = NumFcns + 1
            NumEntries = 0
            ukooa_end = '   '
          
c read function and count elements in function
  
            do while ( ukooa_end .ne. 'END' )
               read(luin,'(a3)',end=901, err=900) ukooa_end
               NumEntries = NumEntries + 4
            enddo
            
c keep track of largest number of elements found in a function

            NumEntries = NumEntries - 4
            if ( NumEntries .gt. MaxEntries ) 
     :           MaxEntries = NumEntries

         enddo

 80      continue

c rewind input file and read past header to position pointer at 
c first input velocity function

         NumEntries = MaxEntries
         rewind luin
         read(luin,'(///)',end=901, err=900)
         return

      ELSEIF ( FormatIn .eq. 'ukooa2' ) then

c count the number of C entries in column 1 as each C entry is a function
c for each function count the number of U entries as each U entry is 3
c function values

            do while ( 1 .eq. 1)
               read(luin,'(a1)',end=100, err=900) ukooa_end
               
               if ( ukooa_end .eq. 'C' ) then
                  NumFcns = NumFcns + 1
                  NumEntries = 0
               elseif ( ukooa_end .eq. 'U' ) then
                  NumEntries = NumEntries + 3
                  if ( NumEntries .gt. MaxEntries ) 
     :                 MaxEntries = NumEntries
               endif
            enddo
            
 100        continue

c move pointer to start of input file

            rewind luin
            NumEntries = MaxEntries

c read past header and position pointer at first function

            do while ( .not. done )

               read(luin,'(a1)',end=100, err=900) ukooa_end

               if ( ukooa_end .eq. 'C' ) done = .true.
            enddo
            
            backspace(luin)

            return

      ELSEIF ( FormatIn .eq. 'geco' ) then

         do while ( 1 .eq. 1 )
            
            read (luin, '(a80)', err=900 , end=90 ) Card
c            call lister ( Card, '%s %d %d', key, LI, DI )
            call fsscnf ( Card, '%s %d %d', key, LI, DI )
            NumEntries = NumEntries + 1
            if ( NumEntries .eq. 1 ) then
               This_LI = LI
               This_DI = DI
            else
               if ( LI .ne. This_LI .or. DI .ne. This_DI ) then
                  NumFcns = NumFcns + 1
                  This_LI = LI
                  This_DI = DI
               endif
            endif
  
         enddo

 90      continue

         rewind(luin)
         return

      ELSEIF ( Formatin .eq. 'agip' ) then
c	 number = 80/SZSMPD
cmam get past header card
	 read (luin, '(a80)', err=900, end=92 ) card
cmam read and count functions and max entries in a function
	 imax = 0
	 numtv = 0
	 do while ( 1 .eq. 1 )
            read (luin, '(a80)', err=900, end=92 ) card
            if (card(80:80) .eq. '*' ) then
cmam header card for new function found..get number of pairs in this one
              NumFcns = NumFcns + 1
	      read(card,'(76x,i3,x)') numtv
	      if (numtv .gt. imax) imax = numtv
	    else
cmam not a function header card -- just count it
	      inum = inum + 1
            endif
         enddo
   92    continue

cmam end of file found
         NumEntries = imax
	 nsampo = nsamp

         rewind (luin)
cmam get past header card....info only....position for reading fcns
         read (luin, '(a80)', err=900, end=92 ) card
         return

      ELSEIF ( FormatIn .eq. 'digicon' ) then

         maxcnt = 0
         ixlst = 0
         iylst = 0
         numtv = 0
         NumFcns = 0

cmam.......     NumFcns = 1

         do while (1 .eq. 1)

cmam read next card
            read(luin,'(a80)', err=900, end=93 ) card

            call fsscnf (card,'%d %d %d %d %f %f',
     :           nline,ixline,ICX, ICY, time, vel )

            if ( ICX .ne. ixlst .OR. ICY .ne. iylst) then

cmam X and/or Y different, therefore a new function

               NumFcns = NumFcns + 1
               if (numtv .gt. maxcnt) maxcnt = numtv
               numtv = 0
               ixlst = ICX
               iylst = ICY

            endif

            numtv = numtv + 1

         enddo

cmam end of file found

 93      continue

         if (numtv .gt. 0) then
            if (numtv .gt. maxcnt) maxcnt = numtv
         endif

         NumEntries = maxcnt
         rewind (luin)
c fill out usp entries nrec,ntrc if it is not filled out on the command line
 
         if ( nrec .eq. 0 ) nrec = NumFcns
         if ( ntrc .eq. 0 ) ntrc = 1
         if ( nsampo .eq. 0 ) nsampo = nsamp

      ELSEIF ( FormatIn .eq. 'essov2' ) then
 
         maxcnt = 0
         ixlst = 0
         iylst = 0
         numtv = 0
         NumFcns = 0
         do while (1 .eq. 1)
cmam read next card
            read(luin,'(a80)', err=900, end=94 ) card
            call fsscnf (card,'%s %d %d %d %d',
     :           ahd, nline, ixline, itime, ivel)
            if ( nline .ne. ixlst .OR. ixline .ne. iylst) then
cmam  LI and/or DI different, therefore a new function
               NumFcns = NumFcns + 1
               if (numtv .gt. maxcnt) maxcnt = numtv
               numtv = 0
               ixlst = nline
               iylst = ixline
            endif
            numtv = numtv + 1
         enddo
cmam end of file found
   94    continue
         if (numtv .gt. 0) then
            if (numtv .gt. maxcnt) maxcnt = numtv
         endif
         NumEntries = maxcnt
         rewind (luin)
 
c fill out usp entries nrec,ntrc if it is not filled out on the command line
         if ( nrec .eq. 0 ) nrec = NumFcns
         if ( ntrc .eq. 0 ) ntrc = 1
         if ( nsampo .eq. 0 ) nsampo = nsamp

      ELSEIF ( FormatIn .eq. 'fairfield' ) then

         maxcnt = 0
         ixlst = 0
         iylst = 0
         numtv = 0
         NumFcns = 0

c read past first junk line in fairfield header and read next
c value with an asterisk at the start presumably

         read(luin,'(a4)') c_junk4
         read(luin,'(a4)') c_junk4

c from here, and until the first function element, all comment lines
c should start with an asterisk.  Watch for the first non - asterisk
c line then back up and start reading the function body.

         do while ( c_junk4(1:1) .eq. '*' )
            
            read(luin,'(a4)') c_junk4
            
         enddo

c now back up one and go for it

         backspace (luin)

         do while (1 .eq. 1)

c read function entry

            read(luin,'(a80)', err=900, end=98 ) card

c policeman to catch fairfield bastardized file end

            if ( card(1:4) .ne. "    " ) then
               write(LERR,*)' Format blowout in fairfield input'
               write(LERR,*)' last valid function was function ',NumFcns
               write(LERR,*)' '
               write(LERR,*)' last valid function element is '
               write(LERR,*)' ILINE = ',nline,' XLINE = ', ixline,
     :              ' TIME = ',time,' VELOCITY = ', vel
               write(LERR,*)' '
               write(LERR,*)' Ignoring rest of input file. '
               write(LERR,*)'WARNING '

               write(LER,*)'VOMIT: '
               write(LER,*)' Format blowout in fairfield input'
               write(LER,*)' last valid function was function ',NumFcns
               write(LER,*)' '
               write(LER,*)' last valid function element is '
               write(LER,*)' ILINE = ',nline,' XLINE = ', ixline,
     :              ' TIME = ',time,' VELOCITY = ', vel
               write(LER,*)' '
               write(LER,*)' Ignoring rest of input file. '
               write(LER,*)'WARNING '
               
               goto 98
            else

               call fsscnf (card,'%d %d %d %f %f %f %f',
     :              nline,ixline,CDP, rjunk1, rjunk2, time, vel )

               ICX = nint(rjunk1)
               ICY = nint(rjunk2)

               if ( ICX .ne. ixlst .OR. ICY .ne. iylst) then

c X and/or Y different, therefore a new function

                  NumFcns = NumFcns + 1
                  if (numtv .gt. maxcnt) maxcnt = numtv
                  numtv = 0
                  ixlst = ICX
                  iylst = ICY

               endif

               numtv = numtv + 1

            endif

         enddo

c end of file found

 98      continue

         if (numtv .gt. 0) then
            if (numtv .gt. maxcnt) maxcnt = numtv
         endif

         NumEntries = maxcnt

c rewind the dataset and get ready for operational read, including
c reading past old header

         rewind (luin)

c read past first junk line in fairfield header

         read(luin,'(a4)') c_junk4
         read(luin,'(a4)') c_junk4

c from here, and until the first function element, all comment lines
c should start with an asterisk.  Watch for the first non - asterisk
c line then back up and start reading the function body.

         do while ( c_junk4(1:1) .eq. '*' )
            
            read(luin,'(a4)') c_junk4
            
         enddo

c now back up one and go for it

         backspace (luin)

c fill out usp entries nrec,ntrc if it is not filled out on the command line
 
         if ( nrec .eq. 0 ) nrec = NumFcns
         if ( ntrc .eq. 0 ) ntrc = 1
         if ( nsampo .eq. 0 ) nsampo = nsamp


      ELSEIF ( FormatIn .eq. 'omnivel' ) then
	 maxcnt = 0
	 numtv = 0
	 NumFcns = 0

	 do while (1 .eq. 1)
cmam read next card
	    read(luin,'(a80)', err=900, end=95 ) card
            if (card(1:5) .eq. 'VLDB0' .and. first0) then
cmam first card of a new function
               read(card,123) OAC,LineID,SrcPnt,SrcptA,CDP,SurvID,
     :              InLine, XLine
  123 format(5x,a8,1x,a8,1x,i8,1x,a1,i6,1x,a8,1x,i6,1x,i6)
               first0 = .false.
cmam check if this is 2d or 3d function
cmam           if(SurvID.eq.'        ') then
cmam              write(LERR,*)' Omnivel Input Function is 2D'
cmam           else
cmam              write(LERR,*)' Omnivel Input Function is 3D'
cmam           endif

            endif
cmam        if (card(1:5) .eq. 'VLDB1' .and. first1) then
            if (card(1:5) .eq. 'VLDB1' ) then
                first1 = .false.
		NumFcns = NumFcns + 1
                numtv = 0
cmam		if (numtv .gt. maxcnt) maxcnt = numtv
cmam		numtv = 0
	    endif
            if (card(1:5) .eq. 'VLDB2' .and. first2 ) then
                first2 = .false.
                read(card,124) WatVel
  124 format(44x,i5)
            endif
	    if (card(1:5) .eq. 'VLDB6') then
cmam a card containing t/v pair
		numtv = numtv + 1
	   if (numtv .gt. 0 .and. numtv .gt. maxcnt) maxcnt = numtv
	    endif
	 enddo

   95	 continue
	 if (numtv .gt. 0 .and. numtv .gt. maxcnt) maxcnt = numtv
	 NumEntries = maxcnt
	 rewind (luin)
 
c fill out usp entries nrec,ntrc if it is not filled out on the command line
         if ( nrec .eq. 0 ) nrec = NumFcns
         if ( ntrc .eq. 0 ) ntrc = 1
         if ( nsampo .eq. 0 ) nsampo = nsamp

      ELSEIF ( FormatIn .eq. 'kelman' ) then

          do while ( 1 .eq. 1 )
             read ( luin, '(a6)', err= 900, end= 500 ) junker
             if ( junker .ne. 'INLINE' ) then
                NumEntries = NumEntries + 1
             else
                NumFcns = NumFcns + 1
                if ( NumEntries .gt. MaxEntries ) 
     :               MaxEntries = NumEntries
                NumEntries = 0
             endif
          enddo

 500      continue
          if ( NumEntries .gt. MaxEntries ) 
     :         MaxEntries = NumEntries
          NumEntries = MaxEntries
          rewind luin
          return

      ELSEIF ( FormatIn .eq. 'promax' ) then

c read past header

 200     read(luin,'(a4)') c_junk4
         
         if ( c_junk4 .ne. '----') goto 200

c count functions

         do while ( 1.eq.1)
            
            read(luin,'(f10.1)', err = 900, end = 201 ) value
            if ( value .ne. 0.0 ) then
               NumFcns = NumFcns + 1
               if ( NumEntries .gt. MaxEntries ) MaxEntries = NumEntries
               NumEntries = 0
            else
               NumEntries = NumEntries + 1
            endif

         enddo

 201     continue

c cover for the last function being the largest, or the case of a single
c function

         if ( NumEntries .gt. MaxEntries ) MaxEntries = NumEntries
         NumEntries = MaxEntries
         rewind luin
 202     read(luin,'(a4)') c_junk4
         if ( c_junk4 .ne. '----') goto 202

c file is rewound and positioned so that first function is ready for read

         return

      ELSEIF ( FormatIn .eq. 'promax3d' ) then

c read past header

 300     read(luin,'(a4)') c_junk4

         if ( c_junk4 .ne. '----') goto 300

c count functions

         do while ( 1.eq.1)
           
            read(luin,'(20x,f10.1)', err = 900, end = 301 ) value
            if ( value .ne. 0.0 ) then
               NumFcns = NumFcns + 1
               if ( NumEntries .gt. MaxEntries ) MaxEntries = NumEntries
               NumEntries = 0
            else
               NumEntries = NumEntries + 1
            endif

         enddo

 301     continue

         NumEntries = MaxEntries
         rewind luin
 302     read(luin,'(a4)') c_junk4
         if ( c_junk4 .ne. '----') goto 302

c file is rewound and positioned so that first function is ready for read

         return

      ELSEIF ( FormatIn .eq. 'hgs' ) then

         do while ( 1 .eq. 1 )

            read ( luin,'(a4)', err = 900, end = 401 ) c_junk4
            if ( c_junk4 .eq. 'VELS' ) then
               if (NumEntries .gt. MaxEntries ) MaxEntries = NumEntries
               NumFcns = NumFcns + 1
               NumEntries = 0
            elseif ( c_junk4 .eq. 'VEFF') then
               NumEntries = NumEntries + 6
            endif

         enddo

 401     continue

         NumEntries = MaxEntries
         nsampo = nsamp
         nrec = NumFcns
         rewind luin

 402     read ( luin,'(a4)') c_junk4

         if ( c_junk4 .ne. 'INFO' ) then
            backspace luin
            return
         else
            goto 402
         endif

      ENDIF

c velocity format determined and appropriate action taken to
c position file pointer to start of velocity data

      return

c error messages

 900  continue
      write(LERR,*)'VELIN: error reading velocity file'
      write(LERR,*)'FATAL'
      write(LER,*)' '
      write(LER,*)'VOMIT: error reading velocity file'
      write(LER,*)'FATAL'
      write(LER,*)' '
      stop

 901  continue
      write(LERR,*)' VOMIT: empty input velocity file'
      write(LERR,*)' FATAL '
      write(LER,*)' '
      write(LER,*)' VOMIT: empty input velocity file'
      write(LER,*)' FATAL '
      write(LER,*)' '
      stop

c vds3d mc3d card information from old SIS system
 
C 1MC3D CARD:   
c 
C Vds_StaticsMode 
c     STATIC APPLICATION MODE (CC 6) - 
C     1 - NMO ONLY
C     2 - STATICS BEFORE NMO
C     3 - STATICS AFTER NMO
C     NO DEFAULT IS ALLOWED
c
c Vds_JobConstantStatic
C     JOB CONSTANT STATIC (CC 7-11)
C     DEFAULT - NO STATIC
c
c Vds_MutePercent
C     MUTE PERCENT (CC 12-14)
C     DEFAULT - NO STRETCH MUTE
c
c Vds_WaterBottom
C     WATER BOTTOM FLAG (CC 15)
C     0 - DO NOT REFERENCE VELOCITY FUNCTION TO
C         WATER BOTTOM
C     1 - REFERENCE VELOCITY FUNCTION TO WATER
C         BOTTOM
C     DEFAULT - 0
c
c Vds_MinLI
C     MINIMUM LINE INDEX (CC 16-20)
C     DEFAULT - (MnLnIn), 1 IF MnLnIn IS ZERO
c
c Vds_MaxLI
C     MAXIMUM LINE INDEX (CC 21-25)
C     DEFAULT - (MxLnIn), 1 IF MxLnIn IS ZERO
c
c Vds_MinDI
C     MINIMUM DEPTH INDEX (CC 26-30)
C     DEFAULT - (MnDpIn), 1 IF MnDpIn IS ZERO
c
c Vds_MaxDI
C     MAXIMUM DEPTH INDEX (CC 31-25)
C     DEFAULT - (MxDpIn), ERROR IF MxDpIn IS ZERO
c
c Vds_LIinc
C     LINE INDEX INCREMENT (CC 36-40) (MACRO BIN)
C     DEFAULT - 1
c
c Vds_DIinc
C     DEPTH INDEX INCREMENT (CC 41-45) (MACRO BIN)
C     DEFAULT - 1
c
c Vds_InterpRadius
C     INTERPOLATION OR TOLERANCE RADIUS (CC 46-50)
C     NO DEFAULT
c
c Vds_VelPrtInc
C     VELOCITY FUNCTION PRINT INCREMENT (CC 51-55)
C     DEFAULT - 0 - NONE
c
c Vds_PrtWgtFlag
C     PRINT INTERPOLATION WEIGHTS FLAG (CC 56)
C     0 - DO NOT PRINT WEIGHTS
C     1 - PRINT WEIGHTS
C     DEFAULT - 0
c
c Vds_BinsizeLI
C     CROSS-LINE CELL INCREMENT (CC 57-61)
C     DEFAULT - (CLClIn), ERROR IF CLClIn IS ZERO
c
c Vds_BinsizeDI
C     IN-LINE CELL INCREMENT (CC 62-66)
C     DEFAULT - (ILClIn), ERROR IF ILClIn IS ZERO
c
c Vds_NumScheme
C     DEPTH POINT NUMBERING SCHEME (CC 67)
C     1 - 1-D CDP NUMBERS
C     2 - 2-D CDP NUMBERS
C     DEFAULT - 2
c
c Vds_DipAzimFlag
C     IGNORE DIP/DIP AZIMUTH DATA  (CC 68)
C     0 - USE IT
C     1 - LOSE IT
C     DEFAULT - 0
c
c Vds_VelPrtInc 
C     VELOCITY PRINT INCREMENT - LI (76-80)
C     DEFAULT - IGNORED


      end
