C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine ReadEv2d( lu_surface, Size, Earth_NumX, Earth_NumY,
     :        Earth_Surface )
 
#include <f77/iounit.h>
 
c routine to read Earth Vision 2D horizon files used to specify the
c horizons between which the ev3d velocity data is reliable.
 
c declare variables passed from the calling routine
 
      integer Size, Earth_NumX, Earth_NumY, lu_surface
 
      real Earth_Surface(Size)
 
c declare local variables
 
      real x,y
 
      character junk*1
 
c initialize variables
 
      junk = '#'
 
c read past file header
 
      do while ( junk .eq. '#' )
         read(lu_surface, '(a1)',end=990, err=991) junk
         if ( junk .ne. '#')backspace(lu_surface)
      enddo
 
c load horizon
 
      do i = 1, Earth_NumX * Earth_NumY
 
         read ( lu_surface, *, end=990, err=991 ) x, y, Earth_Surface(i)
 
      enddo
      return
 
 990  continue
 
      write(LERR,*)' '
      write(LERR,*)'VOMIT: Premature EOF on Earth Vision 2D surface '
      write(LERR,*)'       file attached to logical unit ',lu_surface
      write(LERR,*)'       Check file integrity and try again.'
      write(LERR,*)' '
      write(LER,*)' '
      write(LER,*)'VOMIT: Premature EOF on Earth Vision 2D surface '
      write(LER,*)'       file attached to logical unit ',lu_surface
      write(LER,*)'       Check file integrity and try again.'
      write(LER,*)' '
 
 
 991  continue
 
      write(LERR,*)' '
      write(LERR,*)'VOMIT: Error reading Earth Vision 2D surface '
      write(LERR,*)'       file attached to logical unit ',lu_surface
      write(LERR,*)'       Check file integrity and try again.'
      write(LERR,*)' '
      write(LER,*)' '
      write(LER,*)'VOMIT: Error reading Earth Vision 2D surface '
      write(LER,*)'       file attached to logical unit ',lu_surface
      write(LER,*)'       Check file integrity and try again.'
      write(LER,*)' '
 
      end
 
