C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine TdfnReadCards ( luvel, Record, Velocity, Unit, N,
     :     NumEntries )
 
c ReadTDFN read the next function assuming TDFN format input returning
 
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
 
c variables passed from calling routine
 
      integer luvel, N, NumEntries
 
      real Record(NumEntries), Velocity(NumEntries), Unit(NumEntries)
 
c local variables
 
      integer iunit(SZLNHD), ivelocity(SZLNHD), irec, count
      integer CardNumber, ThisRec
 
c initialize memory
 
      do i = 1, NumEntries
         iunit(i) = 0
         ivelocity(i) = 0
      enddo
 
c read velocity function data down to and including next 9TDFN card
 
      count = 0 - 6
 
      DO while (1 .eq. 1)
 
         count = count + 7
 
         read ( luvel, 10, end=999, err=990 ) CardNumber,
     :        (iunit(i),ivelocity(i), i = count , count + 6 ), irec
 10      format(i1,4x,7(I4,I5),7X,I5)
 
 
c POLICEMAN: if irec = 0 then you have a completely blank card in the file
c            or have forgotten to enter a function index on the TDFN card
c            the first is likely a blank card at the end of the file, the
c            last is a disaster
 
         if ( irec .eq. 0 ) then
            if ( iunit(1) .eq. 0 .and. ivelocity(1) .eq. 0 ) then
               write(LERR,*)' '
               write(LERR,*)'VOMIT: Have encountered a blank card in'
               write(LERR,*)'       your TDFN file.  Will ignore and'
               write(LERR,*)'       continue'
               write(LERR,*)'Warning'
               goto 999
            else
               write(LERR,*)'VOMIT: Have encountered a blank record'
               write(LERR,*)'       number entry in your TDFN file.'
               write(LERR,*)'FATAL'
               write(LER,*)' '
               write(LER,*)'VOMIT: Have encountered a blank record'
               write(LER,*)'       number entry in your TDFN file.'
               write(LER,*)'FATAL'
               stop
            endif
         endif
 
         if ( count .eq. 1 ) ThisRec = irec
 
         if ( CardNumber .ne. 9 ) then
 
            do i = count, count + 6
               Unit(i) = float( iunit(i) )
               Velocity(i) = float(ivelocity(i))
               Record(i) = float(irec)
            enddo
 
c POLICEMAN: watch for record number changes within a function
 
            if ( irec .ne. ThisRec ) then
               write(LERR,*)'VOMIT: The record number has changed'
               write(LERR,*)'       within a velocity function on'
               write(LERR,*)'       you TDFN cards at record number'
               write(LERR,*)'      ',ThisRec
               write(LERR,*)'FATAL'
               write(LER,*)'VOMIT: The record number has changed'
               write(LER,*)'       within a velocity function on'
               write(LER,*)'       you TDFN cards at record number'
               write(LER,*)'      ',ThisRec
               write(LER,*)'FATAL'
               stop
            endif
 
         else
 
c have reached the end of the input velocity function for this record
c load last remaining Unit,velocity pairs and return
 
            do i = count, count + 6
 
               if(iUnit(i) .ge. 0 .and. ivelocity(i) .gt. 0) then
 
c only add elements to velocity function if they exist
 
                  Unit(i) = float( iUnit(i) )
                  Velocity(i) = float(ivelocity(i))
                  Record(i) = irec
               else
                  N = i - 1
                  goto 1000
               endif
            enddo
 
            N = count + 6
            goto 1000
 
         endif
      ENDDO
 
 1000 continue
 
      do i = 2, N
 
c POLICEMAN: check for increasing Unit in function
 
         if ( ( Unit(i-1) - Unit(i) ) .ge. 1.e-32 ) then
            write(LERR,*)'VOMIT: Units decrease in your input TDFN '
            write(LERR,*)'       velocity function at record number '
            write(LERR,*)'       ',ThisRec,'. The Units involved'
            write(LERR,*)'       are ', Unit(i-1), ' and ',
     :           Unit(i)
            write(LERR,*)'FATAL'
            write(LER,*)'VOMIT: Units decrease in your input TDFN '
            write(LER,*)'       velocity function at record number '
            write(LER,*)'       ',ThisRec,'. The Units involved'
            write(LER,*)'       are ', Unit(i-1), ' and ',
     :           Unit(i)
            write(LER,*)'FATAL'
            stop
         endif
 
c POLICEMAN: check for zero velocity entry
 
         if ( Velocity(i-1) .lt. 1.e-32
     :        .or. Velocity(i) .lt. 1.e-32 ) then
            write(LERR,*)'VOMIT: you have a zero velocity entry in your'
            write(LERR,*)'       input velocity function at record'
            write(LERR,*)'       number ',ThisRec,'. The Units involved'
            write(LERR,*)'       are ', Unit(i-1), ' and ',
     :           Unit(i)
            write(LERR,*)'FATAL'
            write(LER,*)'VOMIT: you have a zero velocity entry in your'
            write(LER,*)'       input velocity function at record'
            write(LER,*)'       number ',ThisRec,'. The Units involved'
            write(LER,*)'       are ', Unit(i-1), ' and ',
     :           Unit(i)
            write(LER,*)'FATAL'
            stop
         endif
      enddo
 
c POLICEMAN: check to see if function exceeds trace length
c turning this off to test if it matters, actually would be
c better if this was not on then last sample would be adequately
c interpolated
 
      return
 
 990  continue
 
      write(LERR,*)'VOMIT: error reading TDFN velocity function'
      write(LERR,*)'       at input record',ThisRec
      write(LERR,*)'FATAL'
      write(LER,*)'VOMIT: error reading TDFN velocity function'
      write(LER,*)'       at input record',ThisRec
      write(LER,*)'FATAL'
      stop
 
 999        continue
 
      count = count - 7
      if ( count .lt. 0 ) return
      goto 1000
 
      end
