C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine VXOSInitialize ( luvel, NumFcns, Vxos_NumPicks,
     :     Xsd_RecUnit, Xsd_SmpUnit, Xsd_VelUnit, Xsd_VelOffset, 
     :     Xsd_SmpOffset, Xsd_RecOffset, nsamp, ntrc, NumEntries )
 
c routine to find number segments in VXOS pick file
c and to count the number of picks in each segment
 
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
 
c subroutine arguments from calling routine
 
      integer  luvel, NumFcns, NumEntries, Vxos_NumPicks(*)
      integer  nrec, ntrc, nsamp
 
      real     Xsd_RecUnit, Xsd_VelUnit, Xsd_SmpUnit
      real Xsd_RecOffset, Xsd_VelOffset, Xsd_SmpOffset
 
c internal subroutine variables
 
      integer  NumberOfPicks
 
      real     fac
 
      character junk*1
 
c read standard XSD style pick file header 
 
      read ( luvel, 10, err = 900 , end = 901 ) Xsd_RecUnit, 
     :     Xsd_VelUnit, Xsd_SmpUnit, nrec, ntrc, nsamp, 
     :     Xsd_RecOffset, Xsd_VelOffset, Xsd_SmpOffset

 10   format ( 6x, f12.6, 1x, f12.6, 1x, f12.6, 1x, i5, 1x, i5, 1x, 
     :     i5, 7x, f12.6, 1x, f12.6, 1x, f12.6 )
 
c count segments and number of picks in each segment which we have to do 
c since the user may have been appending to a file while picking
c velocities so that the header line may be wrong for number
c of segments and maximum number of picks per segment.
 
      NumFcns = 1
      NumberOfPicks = 0
      read(luvel, '(a1)', err=900, end = 910) junk
 
      do while ( 1 .eq. 1 )
 
         read(luvel, '(a1)', err=900, end = 910) junk
 
         if(junk .ne. 'S') then
            NumberOfPicks = NumberOfPicks + 1
         else
            Vxos_NumPicks(NumFcns) = NumberOfPicks
            NumFcns = NumFcns + 1
            NumberOfPicks = 0
         endif
 
      enddo
 
 910  continue
 
      Vxos_NumPicks(NumFcns) = NumberOfPicks
 
c POLICEMAN: If user has used vxos and not indicated new picks he may
c            output a pick file with nothing in the segment but with
c            a pick file header.  This check will catch this error.
 
      fac = 1.
      do i = 1, NumFcns
         fac = fac * float(Vxos_NumPicks(i))
         if ( Vxos_NumPicks(i) .gt. NumEntries )
     :        NumEntries = Vxos_NumPicks(i)
      enddo
 
      if(NumFcns .eq. 1 .and. fac .eq. 0.) then
         write(LERR,*)'VOMIT: VSOS pick file starts with an empty'
         write(LERR,*)'        segment. Fix this and rerun.'
         write(LERR,*)'FATAL'
         stop
      endif
 
c place file pointer at first segment
 
      rewind luvel
      read(luvel,'(a1)', err=900) junk
      return
 
c error messages
 
 900  continue
      write(LERR,*)'VOMIT: Error reading VXOS pick file'
      write(LERR,*)'       Fix pick file and rerun.'
      write(LERR,*)'FATAL'
      stop
 
 901  continue
      write(LERR,*)'VOMIT: Empty VXOS pick file '
      write(LERR,*)'FATAL'
      stop
      end
 
 
 
 
 
 
 
 
 
 
 
