C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine Vds3dReadCards( luvel, Velocity, Unit, N, NumEntries,
     :        Vds_OacLine, Vds_DI, Vds_LI )
 
c read VDS 3d velocity tdfn format functions.  it is assumed that the
c header card has been stripped off prior to calling this routine
 
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
 
c variables passed from calling routine
 
      integer luvel, N, NumEntries, Vds_DI, Vds_LI
 
      real Velocity(NumEntries), Unit(NumEntries)
 
      character Vds_OacLine*7
 
c declare local variables
 
      integer iunit(SZLNHD), ivelocity(SZLNHD), count
      integer CardNumber
 
      character test_oacline*7
 
c initialize memory
 
      do i = 1, NumEntries
         iunit(i) = 0
         ivelocity(i) = 0
      enddo
 
c read 0TDFN card for li,di entry
 
         read(luvel,'(i1,4x,2I5)', end=991, err=990)  CardNumber,
     :        Vds_LI, Vds_DI
 
         if ( CardNumber .ne. 0 ) then
            write(LERR,*)' '
            write(LERR,*)'VOMIT: something fishy with VDS input '
            write(LERR,*)'       file at DI ',Vds_DI, ' LI = ',Vds_LI
            write(LERR,*)'       Expecting a 0TDFN card, got a '
            write(LERR,*)'      ',CardNumber,'TDFN card'
            write(LERR,*)'FATAL'
            write(LER,*)' '
            write(LER,*)'VOMIT: something fishy with VDS input '
            write(LER,*)'       file at DI ',Vds_DI, ' LI = ',Vds_LI
            write(LER,*)'       Expecting a 0TDFN card, got a '
            write(LER,*)'      ',CardNumber,'TDFN card'
            write(LER,*)'FATAL'
            stop
         endif
 
c read velocity function data down to and including next 9TDFN card
 
      count = 0 - 6
 
      DO while (1 .eq. 1)
 
         count = count + 7
 
         read ( luvel, 10, end=999, err=990 ) CardNumber,
     :        (iunit(i),ivelocity(i), i = count , count + 6 ),
     :        test_oacline
 10      format(i1,4x,7(I4,I5),a7)
 
         if ( Vds_Oacline .eq. ' ' ) Vds_Oacline = test_oacline
 
         if ( CardNumber .ne. 9 ) then
 
            do i = count, count + 6
               Unit(i) = float( iunit(i) )
               Velocity(i) = float(ivelocity(i))
            enddo
 
         else
 
c have reached the end of the input velocity function for this record
c load last remaining Unit,velocity pairs and return
 
            do i = count, count + 6
 
               if(iUnit(i) .ge. 0 .and. ivelocity(i) .gt. 0) then
 
c only add elements to velocity function if they exist
 
                  Unit(i) = float( iUnit(i) )
                  Velocity(i) = float(ivelocity(i))
               else
                  N = i - 1
                  goto 1000
               endif
            enddo
 
            N = count + 6
            goto 1000
 
         endif
      ENDDO
 
 1000 continue
 
      do i = 2, N
 
c POLICEMAN: check for increasing Unit in function
 
         if ( ( Unit(i-1) - Unit(i) ) .ge. 1.e-32 ) then
            write(LERR,*)'VOMIT: Units decrease in your input TDFN '
            write(LERR,*)'       velocity function at DI ',Vds_DI
            write(LERR,*)'       LI ',Vds_LI,'. The Units involved'
            write(LERR,*)'       are ', Unit(i-1), ' and ',Unit(i)
            write(LERR,*)'FATAL'
            write(LER,*)'VOMIT: Units decrease in your input TDFN '
            write(LER,*)'       velocity function at DI ',Vds_DI
            write(LER,*)'       LI ',Vds_LI,'. The Units involved'
            write(LER,*)'       are ', Unit(i-1), ' and ',Unit(i)
            write(LER,*)'FATAL'
            stop
         endif
 
c POLICEMAN: check for zero velocity entry
 
         if ( Velocity(i-1) .lt. 1.e-32
     :        .or. Velocity(i) .lt. 1.e-32 ) then
            write(LERR,*)'VOMIT: you have a zero velocity entry in your'
            write(LERR,*)'       input velocity function at DI ',Vds_DI
            write(LERR,*)'       LI ',Vds_LI,'. The Units involved'
            write(LERR,*)'       are ', Unit(i-1), ' and ',Unit(i)
            write(LERR,*)'FATAL'
            write(LER,*)'VOMIT: you have a zero velocity entry in your'
            write(LER,*)'       input velocity function at DI ',Vds_DI
            write(LER,*)'       LI ',Vds_LI,'. The Units involved'
            write(LER,*)'       are ', Unit(i-1), ' and ',Unit(i)
            write(LER,*)'FATAL'
            stop
         endif
      enddo
 
      return
 
 990  continue
 
      write(LERR,*)'VOMIT: error reading TDFN velocity function'
      write(LERR,*)'       at input DI ',Vds_DI,' LI ',Vds_LI
      write(LERR,*)'FATAL'
      stop
 
 991  continue
 
      write(LERR,*) 'VOMIT: unexpected eof while trying to read '
      write(LERR,*) '       next function di li entries'
      write(LERR,*) 'FATAL for now until I debug this thing'
      stop
 
 999        continue
 
      count = count - 7
      if ( count .lt. 0 ) return
      goto 1000
 
      end
 
